# AdapterHub Notebooks

Here you can find a collection of notebooks for AdapterHub and the adapter-transformers library.

The table shows notebooks provided by AdapterHub and contained in this folder that show the different possibilities of working with adapters.

As adapter-transformers is fully compatible with HuggingFace's Transformers, you can also use the large collection of official and community notebooks there: [🤗 Transformers Notebooks](https://github.com/huggingface/transformers/tree/master/notebooks).


| Notebook        | Description          |   |
|:----------------|:---------------------|--:|
| [01: Training an Adapter](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/01_Adapter_Training.ipynb) | How to train a task adapter for a Transformer model | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/01_Adapter_Training.ipynb) |
| [02: Using Adapters for Inference](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/02_Adapter_Inference.ipynb) | How to download and use pre-trained adapters from AdapterHub | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/02_Adapter_Inference.ipynb) |
| [03: Adapter Fusion](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/03_Adapter_Fusion.ipynb) | How to combine multiple pre-trained adapters on a new task using AdapterFusion | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/03_Adapter_Fusion.ipynb) |
| [04: Cross-lingual Transfer](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/04_Cross_Lingual_Transfer.ipynb) | How to perform zero-shot cross-lingual transfer between tasks using the MAD-X setup | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/04_Cross_Lingual_Transfer.ipynb) |
| [05: Adapter Drop Training](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/05_Adapter_Drop_Training.ipynb) | How to train an adapter using AdapterDrop | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/05_Adapter_Drop_Training.ipynb) |
| [06: Text Generation](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/06_Text_Generation.ipynb) | How to train an adapter for language generation. | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/06_Text_Generation.ipynb) |
| [07a: Training example for id2label](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/07a_Adapter_train_NER_with_id2label.ipynb) | How to train an adapter on an NER task and configure the id2label parameter | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/07a_Adapter_train_NER_with_id2label.ipynb) |
| [07b: Inference example for id2label](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/07a_Adapter_train_NER_with_id2label.ipynb) | How to use the id2label dictionary for inference | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/07b_Adapter_id2label_inference.ipynb) |
| [08: NER on Wikiann](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/08_NER_Wikiann.ipynb) | Evaluating adapters on NER on the wikiann dataset | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/08_NER_Wikiann.ipynb) |
| [Parallel Adapter Inference](https://github.com/Adapter-Hub/adapter-transformers/blob/master/notebooks/Parallel_Adapter_Inference.ipynb) | Using the `Parallel` composition block for inference. | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/Adapter-Hub/adapter-transformers/blob/master/notebooks/Parallel_Adapter_Inference.ipynb) |
