# Fast Trainable Projection (FTP)
 In this repo, we provide code for the DomainNet experiments in the paper. Specifically, we use CLIP pre-trained ResNet50 and MoCoV3 pre-trained ResNet50.

## Create conda environment
- The environment uses Pytorch 1.7 supported on CUDA 11.x and python 3.8. 
```
cd FTP_demo
conda env create -f environment.yml
conda activate ftp
```

## Download DomainNet
 - The script downloads the two pre-trained models under the `/datasets/domainnet` directory. Please change `DATA_DIR` in `download.sh` if you wish to download the data to a different folder. 
```
. ./datasets/download.sh
```

## Download Pre-trained Models (CLIP-ResNet50 and MoCoV3-ResNet50)
- The script downloads the two pre-trained models under the `"./pre_trained/"` directory.  Please change `MODEL_DIR` in `download_models.sh` if you wish to download the models to a different folder.
```
. ./datasets/download_models.sh
```

## Launch Script
- Fine-tuning CLIP ResNet50 with SGDP (SGD + FTP) (100% data)
```
python main_finetune.py --arch clip_resnet50 --id FTP_clip --opt sgdp --lr 1e-2 --data_dir /datasets/domainnet --percent 100 --epoch 50 --gpu_per_node 4 --load_pretrained ./pre_trained/clip_resnet50_pretrain.pt --batch_size 64 
```

- Fine-tuning CLIP ResNet50 with SGDP (10% data)
```
python main_finetune.py --arch clip_resnet50 --id FTP_clip_10 --opt sgdp --lr 1e-1 --data_dir /datasets/domainnet --percent 10 --epoch 150 --gpu_per_node 4 --load_pretrained ./pre_trained/clip_resnet50_pretrain.pt --batch_size 64 
```

- Fine-tuning MoCoV3 ResNet50 with SGDP (100% data)
```
python main_finetune.py --arch resnet50 --id FTP_moco --opt sgdp --lr 1e-2 --data_dir /datasets/domainnet --percent 100 --epoch 50 --gpu_per_node 4 --load_pretrained ./pre_trained/mocov3_resnet50_pretrain.tar --batch_size 64 
```