#!/bin/bash
model_name="EleutherAI/gpt-neo-2.7B" 

model_name_split=$(echo "$model_name" | awk -F/ '{print $NF}')

k_range=(64)
k_range_str=$(printf "[%s]" "$(printf ", %s" "${k_range[@]}" | cut -c3-)")

seeds=(42 69 128)
seeds_str=$(printf "[%s]" "$(printf ", %s" "${seeds[@]}" | cut -c3-)")

epoch_range=(5 10 15 20 50)
epoch_range_str=$(printf "[%s]" "$(printf ", %s" "${epoch_range[@]}" | cut -c3-)")

run_id=$(echo "$path_to_adaptor" | awk -F/ '{print $NF}')
prefix=""

datasets=("ag_news_0")
key="text"

output_dir=./hpsearch_outputs
path_to_script=./baselines/hpsearch.py

for d in "${datasets[@]}"
do
  python $path_to_script \
    --model_name=$model_name \
    --k_range="$k_range_str" \
    --output_dir=$output_dir \
    --epoch_range="$epoch_range_str" \
    --dataset=$d \
    --eval_dataset=$d \
    --do_eval=True \
    --seeds="$seeds_str" \
    --do_hpsearch \
    --do_gd
done
    




