# Welcome to Compass!

## Introduction
This codebase contains the implementation of our method COMPASS (COMbinatorial optimization with 
Policy Adaptation using Latent Space Search) as well as three Combinatorial Optimization (CO) 
problems: traveling salesman problem (TSP), capacitated vehicle routing problem (CVRP), and 
jobshop scheduling problem (JSSP). 

## Usage
The `experiments` folder contains several files which can be executed:

- `train.py` which runs the training procedure for compass.
- `validate.py` which runs the evaluation of compass for the fast (small budget) setting.
- `slowrl_validate.py` which runs the full evaluation process for compass given the entire budget of rollouts.

By default, these scripts are executed for TSP, and by changing the `config-name` flag to 
either `config_exp_cvrp.yaml` for CVRP or `config_exp_jssp.yaml` for JSSP.

## Data and Checkpoints
The `data` folder contains the validation instances in the `validation` folder and the
the Compass checkpoints in the `v1_models` folder for all problems.