
data=/root/codespace/benchmark-it/benchmark_data/imagenet_val_5k.txt
gpu=0

##### sg #####
models=( "resnet101" "resnet152" "resnet50" "mobilenet" "vgg16" "vit_base" "vit_large" "vit_small" )
weights=( "/root/codespace/benchmark-it/training/results/result_ResNet101_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet152_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet50_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_mobilenet_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vgg16_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_base_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_large_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_small_yellow/model.pd" )
it=smoothgrad
for n in "${!models[@]}"; do
    model=${models[n]}
    model_weights=${weights[n]}
    CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it smoothgrad --it_configs "{\"noise_amount\": 0.001, \"n_samples\": 100}" --save_eval_result 1 >> output/eval-psg-${model}-${it}.log &
    pid[$n]=$!
    echo $gpu start: pid=$!
    gpu=$((gpu+1))
    if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

done


##### ig #####
models=( "resnet101" "resnet152" "resnet50" "mobilenet" "vgg16" "vit_base" "vit_large" "vit_small" )
weights=( "/root/codespace/benchmark-it/training/results/result_ResNet101_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet152_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet50_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_mobilenet_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vgg16_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_base_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_large_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_small_yellow/model.pd" )
it=intgrad
for n in "${!models[@]}"; do
    model=${models[n]}
    model_weights=${weights[n]}
    CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it intgrad --it_configs "{\"num_random_trials\": 5, \"baselines\": \"random\", \"steps\": 20}" --save_eval_result 1 >> output/eval-psg-${model}-${it}.log &
    pid[$n]=$!
    echo $gpu start: pid=$!
    gpu=$((gpu+1))
    if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

done



##### sg-sq #####
models=( "resnet101" "resnet152" "resnet50" "mobilenet" "vgg16" "vit_base" "vit_large" "vit_small" )
weights=( "/root/codespace/benchmark-it/training/results/result_ResNet101_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet152_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet50_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_mobilenet_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vgg16_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_base_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_large_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_small_yellow/model.pd" )
it=smoothgrad
for n in "${!models[@]}"; do
    model=${models[n]}
    model_weights=${weights[n]}
    CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --name 'smoothgrad-sq' --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it smoothgrad --it_configs "{\"noise_amount\": 0.001, \"n_samples\": 100}" --save_eval_result 1 >> output/eval-psg-${model}-${it}-sq.log &
    pid[$n]=$!
    echo $gpu start: pid=$!
    gpu=$((gpu+1))
    if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

done


##### ig-sq #####
models=( "resnet101" "resnet152" "resnet50" "mobilenet" "vgg16" "vit_base" "vit_large" "vit_small" )
weights=( "/root/codespace/benchmark-it/training/results/result_ResNet101_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet152_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_ResNet50_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_mobilenet_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vgg16_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_base_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_large_yellow/model.pd" "/root/codespace/benchmark-it/training/results/result_vit_small_yellow/model.pd" )
it=intgrad
for n in "${!models[@]}"; do
    model=${models[n]}
    model_weights=${weights[n]}
    CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --name 'intgrad-sq' --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it intgrad --it_configs "{\"num_random_trials\": 5, \"baselines\": \"random\", \"steps\": 20}" --save_eval_result 1 >> output/eval-psg-${model}-${it}-sq.log &
    pid[$n]=$!
    echo $gpu start: pid=$!
    gpu=$((gpu+1))
    if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

done
