# Create output directory
mkdir output

# PE - VECTOR
echo "#### PE-Maze-Smoothed ####"
python ./exp_pe_vector.py config_appendix_2_maze_smoothed.yaml ALL

echo "#### PE-Garnet-Smoothed ####"
python ./exp_pe_vector.py config_appendix_2_garnet_smoothed.yaml ALL

echo "#### PE-Cliffwalk-Smoothed ####"
python ./exp_pe_vector.py config_appendix_2_cliffwalk_smoothed.yaml ALL

echo "#### PE-Maze-Identity ####"
python ./exp_pe_vector.py config_appendix_2_maze_identity.yaml ALL

echo "#### PE-Garnet-Identity ####"
python ./exp_pe_vector.py config_appendix_2_garnet_identity.yaml ALL

echo "#### PE-Cliffwalk-Identity ####"
python ./exp_pe_vector.py config_appendix_2_cliffwalk_identity.yaml ALL



# Control - VECTOR
echo "#### Controll-Maze-Smoothed ####"
python ./exp_control_vector.py config_appendix_2_maze_smoothed.yaml ALL

echo "#### Controll-Garnet-Smoothed ####"
python ./exp_control_vector.py config_appendix_2_garnet_smoothed.yaml ALL

echo "#### Controll-Cliffwalk-Smoothed ####"
python ./exp_control_vector.py config_appendix_2_cliffwalk_smoothed.yaml ALL


echo "#### Controll-Maze-Identity ####"
python ./exp_control_vector.py config_appendix_2_maze_identity.yaml ALL

echo "#### Controll-Garnet-Identity ####"
python ./exp_control_vector.py config_appendix_2_garnet_identity.yaml ALL

echo "#### Controll-Cliffwalk-Identity ####"
python ./exp_control_vector.py config_appendix_2_cliffwalk_identity.yaml ALL


# PE - SAMPLE
echo "#### PE_SAMPLE_RESCALED ####"
python ./exp_pe_sample.py config_appendix_4_cliffwalk_rescaled_linear.yaml ALL --num_trials 20

echo "#### PE_SAMPLE_CONSTANT_DELAY ####"
python ./exp_pe_sample.py config_appendix_4_cliffwalk_constantdelay.yaml ALL --num_trials 20


# Control - SAMPLE
echo "#### CONTROL_SAMPLE_RESCALED ####"
python ./exp_control_sample.py config_appendix_4_cliffwalk_rescaled_linear.yaml ALL --num_trials 20 --plot_every 1

echo "#### CONTROL_SAMPLE_CONSTANT_DELAY ####"
python ./exp_control_sample.py config_appendix_4_cliffwalk_constantdelay.yaml ALL --num_trials 20 --plot_every 1


# Moving Data
mkdir output/vector_uniform_final
mkdir output/vector_identity_final
mkdir output/sample_pe_final
mkdir output/sample_control_final
mkdir output/main_control_final

cp -r output/db0e_maze33 output/vector_uniform_final/db0e_maze33
cp -r output/7511_garnet output/vector_uniform_final/7511_garnet
cp -r output/d0b2_cliffwalk output/vector_uniform_final/d0b2_cliffwalk

cp -r output/c0c1_maze33 output/vector_identity_final/c0c1_maze33
cp -r output/aeef_cliffwalk output/vector_identity_final/aeef_cliffwalk
cp -r output/1626_garnet output/vector_identity_final/1626_garnet

cp -r output/8071_cliffwalk/exp_pe_sample output/sample_pe_final/constant
cp -r output/8071_cliffwalk/exp_control_sample output/sample_control_final/constant_withdelay

cp -r output/a012_cliffwalk/exp_pe_sample output/sample_pe_final/rescaled_linear
cp -r output/a012_cliffwalk/exp_control_sample output/sample_control_final/rescaled_linear

cp -r output/d0b2_cliffwalk/exp_control_vector0 output/main_control_final/vector
cp -r output/8071_cliffwalk/exp_control_sample output/main_control_final/sample


#Plotting

#Figure 1
python ./plotter_appendix_2_fig1.py config_appendix_2_maze_smoothed.yaml config_appendix_2_garnet_smoothed.yaml config_appendix_2_cliffwalk_smoothed.yaml db0e_maze33 7511_garnet d0b2_cliffwalk --num_trials 20 --exp_dir=vector_uniform_final

#Figure 2
python ./plotter_appendix_2_fig2.py config_appendix_2_maze_smoothed.yaml config_appendix_2_garnet_smoothed.yaml config_appendix_2_cliffwalk_smoothed.yaml db0e_maze33 7511_garnet d0b2_cliffwalk --num_trials 20 --exp_dir=vector_uniform_final

#Figure 3
python ./plotter_appendix_3_fig3.py config_appendix_2_maze_smoothed.yaml config_appendix_2_garnet_smoothed.yaml config_appendix_2_cliffwalk_smoothed.yaml db0e_maze33 7511_garnet d0b2_cliffwalk --num_trials 20 --exp_dir=vector_uniform_final --output_file="OSVI-PE-VariedLambda-Smooth-Maze-Garnet(runs=100, S=50, A=4, bp=3, br=5)-ModifiedCliffwalk.pdf"
python ./plotter_appendix_3_fig3.py config_appendix_2_maze_identity.yaml config_appendix_2_garnet_identity.yaml config_appendix_2_cliffwalk_identity.yaml c0c1_maze33 1626_garnet aeef_cliffwalk --num_trials 20 --exp_dir=vector_identity_final --output_file="OSVI-PE-VariedLambda-SelfLoop-Maze-Garnet(runs=100, S=50, A=4, bp=3, br=5)-ModifedCliffwalk.pdf"

#Figure 4
python ./plotter_appendix_3_fig4.py config_appendix_2_maze_smoothed.yaml config_appendix_2_garnet_smoothed.yaml config_appendix_2_cliffwalk_smoothed.yaml db0e_maze33 7511_garnet d0b2_cliffwalk --num_trials 20 --exp_dir=vector_uniform_final --output_file="OSVI-Control-VariedLambda-Smooth-Maze-Garnet(runs=100, S=50, A=4, bp=3, br=5)-ModifiedCliffwalk.pdf"
python ./plotter_appendix_3_fig4.py config_appendix_2_maze_identity.yaml config_appendix_2_garnet_identity.yaml config_appendix_2_cliffwalk_identity.yaml c0c1_maze33 1626_garnet aeef_cliffwalk --num_trials 20 --exp_dir=vector_identity_final --output_file="OSVI-Control-VariedLambda-SelfLoop-Maze-Garnet(runs=100, S=50, A=4, bp=3, br=5)-ModifedCliffwalk.pdf"

#Figure 5
python ./plotter_appendix_4_pe.py config_appendix_4_cliffwalk_constantdelay.yaml config_appendix_4_cliffwalk_rescaled_linear.yaml constant rescaled_linear --num_trials 20 --exp_dir=sample_pe_final --plot_every=100
python ./plotter_appendix_4_control.py config_appendix_4_cliffwalk_constantdelay.yaml config_appendix_4_cliffwalk_rescaled_linear.yaml constant_withdelay rescaled_linear --num_trials 20 --plot_every 1000 --exp_dir=sample_control_final


# Main Plot
python ./plotter_main.py config_appendix_2_cliffwalk_smoothed.yaml config_appendix_4_cliffwalk_constantdelay.yaml vector sample --num_trials 20 --plot_every 1000 --exp_dir=main_control_final --num_alphas=3