/*
 * Decompiled with CFR 0.152.
 */
package levelGenerators.sampler;

import engine.core.MarioLevelGenerator;
import engine.core.MarioLevelModel;
import engine.core.MarioTimer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Random;

public class LevelGenerator
implements MarioLevelGenerator {
    private int sampleWidth = 10;
    private String folderName = "levels/original/";
    private Random rnd;

    public LevelGenerator() {
        this("levels/original/", 10);
    }

    public LevelGenerator(String string) {
        this(string, 10);
    }

    public LevelGenerator(String string, int n) {
        this.sampleWidth = n;
        this.folderName = string;
    }

    private String getRandomLevel() throws IOException {
        File[] fileArray = new File(this.folderName).listFiles();
        List<String> list = Files.readAllLines(fileArray[this.rnd.nextInt(fileArray.length)].toPath());
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            string = string + list.get(i) + "\n";
        }
        return string;
    }

    @Override
    public String getGeneratedLevel(MarioLevelModel marioLevelModel, MarioTimer marioTimer) {
        this.rnd = new Random();
        marioLevelModel.clearMap();
        for (int i = 0; i < marioLevelModel.getWidth() / this.sampleWidth; ++i) {
            try {
                marioLevelModel.copyFromString(i * this.sampleWidth, 0, i * this.sampleWidth, 0, this.sampleWidth, marioLevelModel.getHeight(), this.getRandomLevel());
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return marioLevelModel.getMap();
    }

    @Override
    public String getGeneratorName() {
        return "SamplerLevelGenerator";
    }
}

