import numpy as np


class LossQueue(object):
    def __init__(self, length=10):
        """

        :param length:  >= 1
        """
        self.__data = [-np.inf] * (length - 1)
        self.__data.append(np.inf)

    def UpdateQueue(self, new_ele):
        """
        Appends the new_ele to the end of the queue,
        and
        Deletes the element in the head of the queue
        :param new_ele:
        :return:
        """
        self.EnQueue(ele=new_ele)
        return self.DeQueue()

    def EnQueue(self, ele):
        """
        Appends an element to the end of the queue
        :param ele:
        :return:
        """
        self.__data.append(ele)

    def DeQueue(self):
        """
        Deletes the element in the head of the queue
        :return: the element in the head of the queue
        """
        ele = self.__data
        self.__data = self.__data[1: len(self.__data)]
        return ele

    def Max_minus_Min(self):
        """
        The largest element in the queue minus the smallest element
        :return:
        """
        return max(self.__data) - min(self.__data)

    def PrintSelf(self):
        print(self.__data)


class Tool(object):

    @staticmethod
    def ClassLabels2RelationMatrix(class_labels):
        """
        transform the class labels vector to the relation matrix\n
        :param class_labels: np.array, shape=[n], e.g. [-1, -1, 0, 0, 1, 2, 3]
        :return: relation_matrix: np.array, int{0, 1}, shape=[n, n],
        """
        one_hot_mat = np.mat(Tool.ClassLabels2OneHotMatrix(class_labels)['one-hot-mat'])
        relation_matrix = np.matmul(one_hot_mat, np.transpose(one_hot_mat))
        relation_matrix = np.array(relation_matrix)
        return relation_matrix

    @staticmethod
    def ClassLabels2OneHotMatrix(class_labels):
        """
        transform the class labels vector to the one-hot codding matrix\n
        :param class_labels:  np.array, shape=[n], e.g. [-1, -1, 0, 0, 1, 2, 3]
        :return: one-hot-mat: np.array, int, shape=[n, c],
                 class-space: np.array, int, np.int[c], the label of each class
                 class sample num: np.array, int, np.int[c], the number of sample in each class
        """
        sample_num = len(class_labels)
        class_space = np.unique(class_labels)
        class_num = len(class_space)
        A = np.mat(np.ones(shape=[sample_num, class_num], dtype=np.int))
        A = np.matmul(A, np.diag(class_space))
        A = np.array(A)
        B = np.mat(np.reshape(a=class_labels, newshape=[sample_num, 1]))
        B = np.matmul(B, np.mat(np.ones(shape=[1, class_num], dtype=np.int)))
        B = np.array(B)
        one_hot_mat = np.equal(A, B).astype(np.int)
        class_sam_num = np.array(np.sum(a=one_hot_mat, axis=0))
        return {'one-hot-mat': one_hot_mat, 'class-space': class_space, 'class sample num': class_sam_num}
