# Final script with best hyppar
cd ../../src


# Train all models with best hyppar
# Raw
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models_ner.py task_configs=conll2003_selective_paper.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 training.learning_rate\=5e-5 training.num_train_epochs\=11 training.per_device_train_batch_size\=4 +training.weight_decay\=1e-2' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[1,2,3] output_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw'
# Reg
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models_ner.py task_configs=conll2003_selective_paper.yaml args='do_ue_estimate\=False ue.use_selective\=True ue.lamb\=1e-3 data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 training.learning_rate\=5e-5 training.num_train_epochs\=12 training.per_device_train_batch_size\=16 +training.weight_decay\=1e-2' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[1,2,3] output_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg'
# Metric
#HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models_ner.py task_configs=conll2003_selective_paper.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.001 ue.margin\=1.0 training.learning_rate\=7e-5 training.num_train_epochs\=15 training.per_device_train_batch_size\=16 +training.weight_decay\=1e-2' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[1,2,3] output_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric'
# Same models, but with SN
# Raw
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models_ner.py task_configs=conll2003_selective_paper.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 +ue.use_spectralnorm\=True +spectralnorm_layer\=last training.learning_rate\=6e-5 training.num_train_epochs\=13 training.per_device_train_batch_size\=8 +training.weight_decay\=0' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[1,2,3] output_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw_sn'
# Reg
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models_ner.py task_configs=conll2003_selective_paper.yaml args='do_ue_estimate\=False ue.use_selective\=True ue.lamb\=3e-3 data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 +ue.use_spectralnorm\=True +spectralnorm_layer\=last training.learning_rate\=2e-5 training.num_train_epochs\=10 training.per_device_train_batch_size\=4 +training.weight_decay\=1e-1' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[1,2,3] output_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg_sn'
# Metric
#HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models_ner.py task_configs=conll2003_selective_paper.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.01 ue.margin\=5.0 +ue.use_spectralnorm\=True +spectralnorm_layer\=last training.learning_rate\=5e-5 training.num_train_epochs\=10 training.per_device_train_batch_size\=8 +training.weight_decay\=0' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[1,2,3] output_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric_sn'




# After run UE part
# Raw model - all, last, DPP 2, DPP with OOD, Maha, MC Maha
# Last
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/last'
# all
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/all'
# DPP 2, raw model
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw/models/conll2003_selective_paper/' args='ue.use_cache\=True do_ue_estimate\=True ue.dropout.is_reused_mask\=True ue.use_ood_sampling\=False ue.ue_type\=mc-dpp ue.dropout_type\=DPP +ue.dropout.use_ood_sampling\=False ue.calibrate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.committee_size\=100' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/dpp'
# DPP with ood, raw model
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw/models/conll2003_selective_paper/' args='ue.use_cache\=True do_ue_estimate\=True ue.dropout.is_reused_mask\=True ue.use_ood_sampling\=True ue.ue_type\=mc-dpp ue.dropout_type\=DPP +ue.dropout.use_ood_sampling\=True ue.calibrate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.committee_size\=100' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/dpp_with_ood'
# SMD - Maha and MC Maha in one run
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.ue_type\=mc_maha ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/maha_mc'

# Now Reg model
# Last
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=True ue.lamb\=1e-3' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/last'
# all
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=True ue.lamb\=1e-3' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/all'
# DPP 2, reg model
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg/models/conll2003_selective_paper/' args='ue.use_cache\=True do_ue_estimate\=True ue.dropout.is_reused_mask\=True ue.use_ood_sampling\=False ue.ue_type\=mc-dpp ue.dropout_type\=DPP +ue.dropout.use_ood_sampling\=False ue.calibrate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=True ue.lamb\=1e-3 ue.committee_size\=100' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/dpp'
# DPP with ood, reg model
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg/models/conll2003_selective_paper/' args='ue.use_cache\=True do_ue_estimate\=True ue.dropout.is_reused_mask\=True ue.use_ood_sampling\=True ue.ue_type\=mc-dpp ue.dropout_type\=DPP +ue.dropout.use_ood_sampling\=True ue.calibrate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=True ue.lamb\=1e-3 ue.committee_size\=100' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/dpp_with_ood'
# SMD - Maha and MC Maha in one run
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.ue_type\=mc_maha ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=True ue.lamb\=1e-3' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/maha_mc'

# Metric model
# Last
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.001 ue.margin\=1.0' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/last'
# all
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.001 ue.margin\=1.0' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/all'
# DPP 2, metric model
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric/models/conll2003_selective_paper/' args='ue.use_cache\=True do_ue_estimate\=True ue.dropout.is_reused_mask\=True ue.use_ood_sampling\=False ue.ue_type\=mc-dpp ue.dropout_type\=DPP +ue.dropout.use_ood_sampling\=False ue.calibrate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.001 ue.margin\=1.0 ue.committee_size\=100' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/dpp'
# DPP with ood, metric model
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric/models/conll2003_selective_paper/' args='ue.use_cache\=True do_ue_estimate\=True ue.dropout.is_reused_mask\=True ue.use_ood_sampling\=True ue.ue_type\=mc-dpp ue.dropout_type\=DPP +ue.dropout.use_ood_sampling\=True ue.calibrate\=True data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.001 ue.margin\=1.0 ue.committee_size\=100' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/dpp_with_ood'
# SMD - Maha and MC Maha in one run
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.ue_type\=mc_maha ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.001 ue.margin\=1.0' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/maha_mc'


# For sn models we need to calc only SMD
# Raw SN
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/raw_sn/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.ue_type\=mc_maha ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 +ue.use_spectralnorm\=True +spectralnorm_layer\=last' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw_sn/maha_mc'
# Reg SN
# SMD - Maha and MC Maha in one run
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/reg_sn/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.ue_type\=mc_maha ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=True ue.lamb\=1e-3 +ue.use_spectralnorm\=True +spectralnorm_layer\=last' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg_sn/maha_mc'
# Metric SN
# SMD - Maha and MC Maha in one run
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_selective_paper.yaml model_series_dir='../workdir/run_train_models/conll2003_electra_opt_hyp/metric_sn/models/conll2003_selective_paper/' args='ue.calibrate\=True ue.use_cache\=True do_ue_estimate\=True ue.ue_type\=mc_maha ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.reg_type\=metric ue.use_selective\=True ue.lamb\=0.001 ue.margin\=1.0 +ue.use_spectralnorm\=True +spectralnorm_layer\=last' cuda_devices=[1,2,3] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric_sn/maha_mc'


# Now calc metrics
# Raw
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/last/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/raw/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/all/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/raw/all'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/dpp/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/raw/dpp'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/dpp_with_ood/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/raw/dpp_with_ood'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw/maha_mc/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/raw/maha_mc'
# Reg
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/last/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/reg/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/all/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/reg/all'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/dpp/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/reg/dpp'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/dpp_with_ood/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/reg/dpp_with_ood'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg/maha_mc/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/reg/maha_mc'
# Metric
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/last/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/metric/last'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/all/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/metric/all'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/dpp/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/metric/dpp'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/dpp_with_ood/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/metric/dpp_with_ood'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric/maha_mc/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/metric/maha_mc'
# SN
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/raw_sn/maha_mc/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/raw_sn/maha_mc'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/reg_sn/maha_mc/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/reg_sn/maha_mc'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/conll2003_electra_opt_hyp/metric_sn/maha_mc/results' output_dir='../workdir/run_calc_ues_metrics/conll2003_electra_opt_hyp/metric_sn/maha_mc'
