cd ../../src
# Also add CoNLL-2003 - mixup

# Script for training all models on MRPC, COLA, SST2-10% and CoNLL-2003 for mixup
# train - metric loss, no SN
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False' task_configs=mrpc_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra/mrpc
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False' task_configs=cola_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra/cola
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False' task_configs=sst2_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra/sst2
# CONLL
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models_ner.py task_configs=conll2003_mixup.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[0,1,2] output_dir='../workdir/run_train_models/mixup_electra/conll'
# Script for training all models on 20ng for mixup
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False' task_configs=20ng_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra/20ng


# Test - make models with last/all MC dropout
# MC maha
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=last data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/last'

HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/all'
# 20ng
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0,1,2] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/20ng_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/20ng/models/20ng_mixup/ args='ue\=mc do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/20ng/mixup/all'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0,1,2] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/20ng_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/20ng/models/20ng_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/20ng/mixup/last'

# Finally, calc metrics
# mc maha
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/conll/mixup/all'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/20ng/mixup/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/20ng/mixup/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/20ng/mixup/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/20ng/mixup/last'