(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    336103,       7164]
NotebookOptionsPosition[    313598,       6807]
NotebookOutlinePosition[    314211,       6828]
CellTagsIndexPosition[    314168,       6825]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
We follow the derivation in Kolter (2011) with the aim of constructing a \
fixed-point counterexample with n=3 states and k=2 feature space, where w* is \
near [1, -1]
We achieve this by splitting the left state into two equal states.\
\>", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
  3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
  3.8489105216064568`*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "1.", ",", " ", "1.05"}], "}"}], "}"}], 
    "\[Transpose]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
      RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"epsilon", "=."}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Phi", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", 
         RowBox[{"0", "/", "100"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "100"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ")"}]}], "/", 
          "100"}]}], "}"}]}], "}"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", 
       RowBox[{"-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ",", " ", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ")"}]}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=."}], "\[IndentingNewLine]", 
 RowBox[{"Dm", " ", "=", " ", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "/", "2"}], ",", " ", 
     RowBox[{"p", "/", "2"}], ",", " ", 
     RowBox[{"1", "-", "p"}]}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936641725163*^9, {
   3.852099656777422*^9, 3.852099660756007*^9}, {3.8520998283982353`*^9, 
   3.8520998330051622`*^9}, {3.852100643443104*^9, 3.852100647045465*^9}, {
   3.857312621661829*^9, 3.857312691960071*^9}, {3.857316711815258*^9, 
   3.85731676509906*^9}, {3.85765391359242*^9, 3.857653919307899*^9}, 
   3.857653970095665*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["p", "2"], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["p", "2"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"1", "-", "p"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.857312693460146*^9, {3.8573167658336973`*^9, 3.857316785996234*^9}, 
   3.8574725492755213`*^9, {3.857472668054104*^9, 3.857472690605372*^9}, 
   3.857480399238554*^9, 3.857501083516141*^9, 3.8575168396802673`*^9, 
   3.857576041120261*^9, 3.857653929584393*^9, 3.857655534601179*^9, 
   3.858008081651411*^9, {3.8582777766941977`*^9, 3.8582777913951197`*^9}, 
   3.8588752997184057`*^9, 3.859316824046122*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"5104f187-4e19-4e7f-8d43-44b4fce29d91"]
}, Open  ]],

Cell[TextData[StyleBox["\[LineSeparator]Compute the correct value of w:", \
"Text"]], "Text",
 CellChangeTimes->{{3.848912947646468*^9, 3.848912977322949*^9}, {
   3.857312685079691*^9, 3.857312689669485*^9}, 
   3.858008087557022*^9},ExpressionUUID->"812d4f2f-d057-4141-99e9-\
0041d5ad4212"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"what", " ", "=", " ", 
  RowBox[{"LeastSquares", "[", 
   RowBox[{
    RowBox[{"Refine", "[", 
     RowBox[{"Phi", ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"epsilon", "==", "0.0001"}]}]}], "]"}], ",", "V"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.848912930225717*^9, 3.848912932374175*^9}, {
   3.848975619105205*^9, 3.84897563277147*^9}, 3.8489771939460287`*^9, {
   3.84898420159488*^9, 3.8489842062656384`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"faa6cd96-61f9-4282-9bec-90ba810909ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.9999323089227912`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.9999323089227916`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.84891293479537*^9, 3.848975353970648*^9, 3.848975600432143*^9, 
   3.848975633260996*^9, 3.848977194389077*^9, 3.848977233550077*^9, 
   3.8489842149307137`*^9, 3.8492232770607243`*^9, 3.849225288721259*^9, 
   3.8492254504490433`*^9, 3.8507013405636272`*^9, 3.851905008060597*^9, 
   3.851936652953374*^9, 3.85199126602636*^9, 3.852099767867387*^9, 
   3.852099839179511*^9, 3.852100225696459*^9, 3.852100651903283*^9, 
   3.852102743047978*^9, 3.856790499464142*^9, 3.8573060018555727`*^9, 
   3.857311946372805*^9, 3.857312696005724*^9, 3.857316786149321*^9, 
   3.857472549463909*^9, {3.857472668144248*^9, 3.857472690827436*^9}, 
   3.857480399353257*^9, 3.857501083646494*^9, 3.857516839755701*^9, 
   3.857576041189838*^9, 3.8576555346609917`*^9, 3.858008088793256*^9, {
   3.858277777589031*^9, 3.8582777914758863`*^9}, 3.858875301328967*^9, 
   3.859316824102845*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"4c1ab01e-852f-4478-88d3-657a44b89120"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the fixed point w_star:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.848570432944818*^9, 3.8485704485407467`*^9}, {
  3.848570915714424*^9, 
  3.848570984363884*^9}},ExpressionUUID->"0a5d41cb-08ef-4253-a74f-\
02384f62cb6a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sA", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sb", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sA", "]"}], ".", "sb"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.848570984364477*^9, 3.848571676353101*^9, {3.848913024643092*^9, 
   3.84891305207668*^9}, {3.848913722679961*^9, 3.848913736469101*^9}, {
   3.857312703508958*^9, 3.8573127254150143`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851991153216415*^9, 3.851991186354488*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVkmk0lQ0bhUuTUpKkjgZRx9RRCpUMu0LmKRRHGQuRoUNJSikzyStR5jrJ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       "]], LineBox[CompressedData["
1:eJwVk2k8lIsCxocUF3FJlK6KUkPRnO5JpY6naFFpsdw4HcRIyhWJihCJZuxj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       "]]},
     Annotation[#, "Charting`Private`Tag$1577292#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.041210946039941035`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.851991175596321*^9, 3.851991188156067*^9}, 
   3.852099769026505*^9, 3.852099840152269*^9, 3.852100226701511*^9, 
   3.8521006529204493`*^9, 3.852102744002846*^9, 3.856790500789186*^9, 
   3.857306002990883*^9, 3.857311947626852*^9, 3.857312736106235*^9, 
   3.85731678740065*^9, 3.857472550671721*^9, {3.857472669108161*^9, 
   3.857472692148705*^9}, 3.857480400691743*^9, 3.857501084918508*^9, 
   3.85751684082974*^9, 3.857576042248208*^9, 3.8576555356399508`*^9, 
   3.858008094574027*^9, {3.8582777871859407`*^9, 3.858277792462254*^9}, 
   3.8593168251313963`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"abeec288-9a8a-49d1-b4c5-f6e379dec4c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0.00001"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.857312764600555*^9, 3.857312798025824*^9}, {
  3.857312904046273*^9, 3.857312909765922*^9}, {3.857314189320052*^9, 
  3.85731421902691*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"bcd75a85-a5a4-42fd-9cb7-137e413fd55f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVlHk0lQsbxalMievqlo5crjGJyFAp7IrMMpSKzI6hMk9HyUWZUuEKiURF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       "]], 
      LineBox[CompressedData["
1:eJwVj2k4lQkDhokwkhwKkSmKqGhXIk8ik5yKEpL1lJSkbSqFwns2J9s5lkqS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       "]]},
     Annotation[#, "Charting`Private`Tag$1577349#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.023537303907315975`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.85731276580731*^9, 3.857312798760354*^9}, {
   3.857312905645731*^9, 3.8573129105997467`*^9}, {3.857314190561203*^9, 
   3.857314219643836*^9}, 3.857316789087225*^9, 3.857472551663485*^9, {
   3.857472670056479*^9, 3.8574726931827383`*^9}, 3.857480402298716*^9, 
   3.857501086819289*^9, 3.8575168419342613`*^9, 3.857576043308731*^9, 
   3.85765553659221*^9, 3.858008098868713*^9, 3.85827779345197*^9, 
   3.858875306144061*^9, 3.859316826067415*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"15e46176-b6c2-4e4d-9735-6e5ba7c554a6"]
}, Open  ]],

Cell["\<\
Write down wstar in terms of eta, p, and [1, -1]: This is the function g(eta, \
p) in the paper:\
\>", "Text",
 CellChangeTimes->{{3.85731816823575*^9, 3.857318189087056*^9}, {
  3.857318222662798*^9, 3.857318232132916*^9}, {3.857319636999324*^9, 
  3.857319653213993*^9}},ExpressionUUID->"b68473c4-7500-40f5-b4cd-\
595e5657a2dd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"wstar", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"epsilon", "->", "0."}], ",", 
     RowBox[{"p", "->", "0.7"}], ",", 
     RowBox[{"eta", "->", "0.00001"}]}], "}"}]}], "//", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.857321298307502*^9, 3.8573213218970613`*^9}, {
  3.857321473615327*^9, 3.8573215699151793`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"dc5f2a33-f75d-4a97-b344-9c8f80707cd0"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.9749608763690767`"},
     {
      RowBox[{"-", "0.9749608763690767`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.8573212994674273`*^9, 3.857321322201109*^9}, {
   3.857321479455783*^9, 3.857321570176592*^9}, 3.857472552186903*^9, {
   3.857472670569902*^9, 3.85747269371098*^9}, 3.857480402347685*^9, 
   3.857501086888152*^9, 3.857516842048324*^9, 3.857576043376605*^9, 
   3.857655536622014*^9, 3.858008101084505*^9, 3.8582777934931717`*^9, 
   3.8588753072012997`*^9, 3.8593168260920467`*^9},
 CellLabel->
  "Out[15]//TraditionalForm=",ExpressionUUID->"d21f7f3e-bde5-459c-83c1-\
e33c11085e6b"]
}, Open  ]],

Cell["\<\
We very carefully extract the part of wstar we want, taking care not to \
accidentally throw away a term:\
\>", "Text",
 CellChangeTimes->{{3.857496342078785*^9, 
  3.857496359678273*^9}},ExpressionUUID->"7033b8f7-5c56-45a1-9020-\
9cdc55035473"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"wstar", "/.", 
   RowBox[{"{", 
    RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "//", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.857496276575305*^9, 3.857496332351589*^9}, {
  3.857496363778653*^9, 3.857496364612603*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"5bdad5e4-c535-41d4-86e1-438f5689798c"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"0.12996225`", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
           RowBox[{"0.5251`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"0.2651755`", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "p"}], ")"}]}], "-", 
              RowBox[{"0.2475`", " ", "p"}], "+", "0.`"}], ")"}]}], "-", 
           RowBox[{"0.12375`", " ", "p"}], "+", "0.`"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"0.018509775000000003`", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
           RowBox[{"0.007375000000000076`", " ", "p"}], "+", "0.`"}], ")"}]}], 
        RowBox[{
         SuperscriptBox["eta", "2"], "+", 
         RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
         RowBox[{"0.0185628101`", " ", "eta"}], "-", 
         RowBox[{"0.012993655049999962`", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0.018509775000000003`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}], "-", 
           RowBox[{"0.007375000000000076`", " ", "p"}], "+", "0.`"}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{"eta", "-", 
           RowBox[{"0.12996225`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}], "-", 
           RowBox[{"0.5251`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"0.2651755`", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
              RowBox[{"0.2475`", " ", "p"}], "+", "0.`"}], ")"}]}], "+", 
           RowBox[{"0.37625`", " ", "p"}], "+", "0.`"}], ")"}]}], 
        RowBox[{
         SuperscriptBox["eta", "2"], "+", 
         RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
         RowBox[{"0.0185628101`", " ", "eta"}], "-", 
         RowBox[{"0.012993655049999962`", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}]]}]},
     {
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"0.12996225`", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "p"}], ")"}]}]}], "-", 
           RowBox[{"0.5251`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"0.2651755`", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
              RowBox[{"0.2475`", " ", "p"}], "+", "0.`"}], ")"}]}], "-", 
           RowBox[{"0.12375`", " ", "p"}], "+", "0.`"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0.018509775000000003`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}], "-", 
           RowBox[{"0.007375000000000076`", " ", "p"}], "+", "0.`"}], ")"}]}], 
        RowBox[{
         SuperscriptBox["eta", "2"], "+", 
         RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
         RowBox[{"0.0185628101`", " ", "eta"}], "-", 
         RowBox[{"0.012993655049999962`", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"0.018509775000000003`", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
           RowBox[{"0.007375000000000076`", " ", "p"}], "+", "0.`"}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{"eta", "-", 
           RowBox[{"0.12996225`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}], "+", 
           RowBox[{"0.5251`", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"0.2651755`", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "p"}], ")"}]}], "-", 
              RowBox[{"0.2475`", " ", "p"}], "+", "0.`"}], ")"}]}], "+", 
           RowBox[{"0.37625`", " ", "p"}], "+", "0.`"}], ")"}]}], 
        RowBox[{
         SuperscriptBox["eta", "2"], "+", 
         RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
         RowBox[{"0.0185628101`", " ", "eta"}], "-", 
         RowBox[{"0.012993655049999962`", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.8574962775613937`*^9, 3.8574963328381357`*^9}, 
   3.857496365370118*^9, 3.857501086947525*^9, 3.857516842121685*^9, 
   3.857576043427432*^9, 3.857655536665131*^9, 3.85800810390561*^9, 
   3.858277793625359*^9, 3.858875345148728*^9, 3.859316826129386*^9},
 CellLabel->
  "Out[16]//TraditionalForm=",ExpressionUUID->"11d09330-7b64-44ea-9fec-\
816e429b50a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"First", "[", "wstar", "]"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "//", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.85749638106003*^9, 3.857496400878908*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"cd232872-1c0d-44f6-aeee-561c0d321f77"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"0.12996225`", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
        RowBox[{"0.5251`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0.2651755`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}], "-", 
           RowBox[{"0.2475`", " ", "p"}], "+", "0.`"}], ")"}]}], "-", 
        RowBox[{"0.12375`", " ", "p"}], "+", "0.`"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"0.018509775000000003`", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
        RowBox[{"0.007375000000000076`", " ", "p"}], "+", "0.`"}], ")"}]}], 
     ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["eta", "2"], "+", 
      RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
      RowBox[{"0.0185628101`", " ", "eta"}], "-", 
      RowBox[{"0.012993655049999962`", " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"0.018509775000000003`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}], "-", 
        RowBox[{"0.007375000000000076`", " ", "p"}], "+", "0.`"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"eta", "-", 
        RowBox[{"0.12996225`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}], "-", 
        RowBox[{"0.5251`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"0.2651755`", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
           RowBox[{"0.2475`", " ", "p"}], "+", "0.`"}], ")"}]}], "+", 
        RowBox[{"0.37625`", " ", "p"}], "+", "0.`"}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["eta", "2"], "+", 
      RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
      RowBox[{"0.0185628101`", " ", "eta"}], "-", 
      RowBox[{"0.012993655049999962`", " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.857496389053911*^9, 3.857496401461887*^9}, 
   3.8575010869836483`*^9, 3.857516842153062*^9, 3.857576043460013*^9, 
   3.857655536741866*^9, 3.8580081157922707`*^9, 3.858277793655768*^9, 
   3.858875346215309*^9, 3.8593168261525927`*^9},
 CellLabel->
  "Out[17]//TraditionalForm=",ExpressionUUID->"e3a3b6eb-4c1a-4808-b9da-\
94ee36385de3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gcoeff", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"First", "[", "wstar", "]"}], "]"}], " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"gcoeff", " ", "//", "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{"cxp", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"gcoeff", "<=", "lb"}], " ", "&&", " ", 
    RowBox[{"lb", "<=", "0"}], "&&", 
    RowBox[{"p", ">", "0"}], "&&", 
    RowBox[{"p", "<", "1"}], "&&", 
    RowBox[{"eta", ">=", "0"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.857318233553306*^9, 3.85731829823104*^9}, {
   3.857318344803771*^9, 3.857318380174123*^9}, {3.857318732455453*^9, 
   3.857318765614354*^9}, {3.857319658999319*^9, 3.857319707678296*^9}, {
   3.857320283797141*^9, 3.857320297809057*^9}, 3.857320458275763*^9, 
   3.8573206009347754`*^9, 3.8573212587424173`*^9, 3.857321577072198*^9, 
   3.857321631078225*^9, {3.857321752979471*^9, 3.8573217577983828`*^9}, {
   3.8573218053824778`*^9, 3.8573218274030237`*^9}, {3.857322306689662*^9, 
   3.85732230872913*^9}, {3.857322343522623*^9, 3.857322394920723*^9}, {
   3.8573224538096313`*^9, 3.8573224788794107`*^9}, {3.8574964149172297`*^9, 
   3.85749642057437*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"ddc36145-3b67-4d74-862c-95c1485d4026"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"eta", " ", 
     RowBox[{"(", 
      RowBox[{"0.018509775000000003`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.02588477500000008`", " ", "p"}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["eta", "2"], "+", 
     RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
     RowBox[{"0.0185628101`", " ", "eta"}], "-", 
     RowBox[{"0.012993655049999962`", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}]], "-", 
   FractionBox[
    RowBox[{"0.012942387500000038`", " ", 
     SuperscriptBox["p", "2"]}], 
    RowBox[{
     SuperscriptBox["eta", "2"], "+", 
     RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
     RowBox[{"0.0185628101`", " ", "eta"}], "-", 
     RowBox[{"0.012993655049999962`", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}]], "+", 
   FractionBox[
    RowBox[{"0.0092548875`", " ", "p"}], 
    RowBox[{
     SuperscriptBox["eta", "2"], "+", 
     RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
     RowBox[{"0.0185628101`", " ", "eta"}], "-", 
     RowBox[{"0.012993655049999962`", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"0.009281405049999998`", " ", "p"}], "+", "0.`"}]], "+", "0.`"}],
   TraditionalForm]], "Output",
 CellChangeTimes->{
  3.857319736333818*^9, {3.8573202944470673`*^9, 3.857320298719286*^9}, 
   3.857320459230588*^9, {3.857320601371681*^9, 3.857320624283412*^9}, 
   3.85732126873704*^9, 3.8573215775259657`*^9, 3.857321631985642*^9, 
   3.8573217583624*^9, 3.8573218367093143`*^9, 3.857322309316762*^9, {
   3.8573223474070272`*^9, 3.85732239615307*^9}, 3.8573224796469717`*^9, 
   3.85747255270547*^9, {3.85747267075669*^9, 3.857472694260191*^9}, 
   3.8574804029839277`*^9, 3.85749642087691*^9, 3.857501087035705*^9, 
   3.857516842184363*^9, 3.857576043488544*^9, 3.857655536787944*^9, 
   3.858008118018948*^9, 3.8582777936862383`*^9, 3.858875352815323*^9, 
   3.859316826212655*^9},
 CellLabel->
  "Out[19]//TraditionalForm=",ExpressionUUID->"2fe555b3-bf64-408a-a4c4-\
1eb5b31b95d2"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 20, 32, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8573197363224916`*^9, {3.8573202944371567`*^9, 3.857320298709774*^9}, 
   3.857320459216981*^9, {3.857320601363097*^9, 3.857320624271948*^9}, 
   3.857321268728237*^9, 3.857321577514496*^9, 3.8573216319746113`*^9, 
   3.857321758352581*^9, 3.857321836700921*^9, 3.857322309306863*^9, {
   3.857322347397771*^9, 3.857322396143471*^9}, 3.857322479638267*^9, 
   3.857472552672192*^9, {3.857472670745811*^9, 3.857472694235365*^9}, 
   3.857480402946842*^9, 3.85749642103887*^9, 3.85750108759409*^9, 
   3.857516842367258*^9, 3.857576043652219*^9, 3.8576555369474707`*^9, 
   3.858008118202837*^9, 3.858277794234836*^9, 3.8588753530018053`*^9, 
   3.859316826379265*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"1c729c7c-ee46-4e58-83a7-f1d8ca12b4df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0.7143028666133495`", "<", "p", "<", "0.7150834805401997`"}], "&&", 
    RowBox[{"0", "\[LessEqual]", "eta", "<", 
     RowBox[{
      RowBox[{"4.210877539557953`*^-17", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2.20414983879449`*^14"}], "-", 
         RowBox[{"5.628431193344091`*^15", " ", "p"}]}], ")"}]}], "+", 
      RowBox[{"4.9478123627426486`*^-26", " ", 
       SqrtBox[
        RowBox[{"3.518852067481527`*^46", "-", 
         RowBox[{"1.9941717053006233`*^48", " ", "p"}], "+", 
         RowBox[{"2.825296939143401`*^49", " ", 
          SuperscriptBox["p", "2"]}]}]]}]}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2.026294027481102`*^57", " ", "eta"}], "+", 
        RowBox[{"1.0131470137405508`*^57", " ", "p"}], "-", 
        RowBox[{"2.8336468155443425`*^57", " ", "eta", " ", "p"}], "-", 
        RowBox[{"1.4168234077721712`*^57", " ", 
         SuperscriptBox["p", "2"]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2.032099862850622`*^57", " ", "eta"}], "+", 
        RowBox[{"1.094715644831502`*^59", " ", 
         SuperscriptBox["eta", "2"]}], "+", 
        RowBox[{"1.0160499314253108`*^57", " ", "p"}], "+", 
        RowBox[{"5.189091074821933`*^58", " ", "eta", " ", "p"}], "-", 
        RowBox[{"1.4224357466778812`*^57", " ", 
         SuperscriptBox["p", "2"]}]}], ")"}]}], "\[LessEqual]", "lb", 
     "\[LessEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0.7150834805401997`", "\[LessEqual]", "p", "<", "1.`"}], "&&", 
    RowBox[{"eta", ">", 
     RowBox[{
      RowBox[{"4.210877539557953`*^-17", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2.20414983879449`*^14"}], "-", 
         RowBox[{"5.628431193344091`*^15", " ", "p"}]}], ")"}]}], "+", 
      RowBox[{"4.9478123627426486`*^-26", " ", 
       SqrtBox[
        RowBox[{"3.518852067481527`*^46", "-", 
         RowBox[{"1.9941717053006233`*^48", " ", "p"}], "+", 
         RowBox[{"2.825296939143401`*^49", " ", 
          SuperscriptBox["p", "2"]}]}]]}]}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2.026294027481102`*^57", " ", "eta"}], "+", 
        RowBox[{"1.0131470137405508`*^57", " ", "p"}], "-", 
        RowBox[{"2.8336468155443425`*^57", " ", "eta", " ", "p"}], "-", 
        RowBox[{"1.4168234077721712`*^57", " ", 
         SuperscriptBox["p", "2"]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2.032099862850622`*^57", " ", "eta"}], "+", 
        RowBox[{"1.094715644831502`*^59", " ", 
         SuperscriptBox["eta", "2"]}], "+", 
        RowBox[{"1.0160499314253108`*^57", " ", "p"}], "+", 
        RowBox[{"5.189091074821933`*^58", " ", "eta", " ", "p"}], "-", 
        RowBox[{"1.4224357466778812`*^57", " ", 
         SuperscriptBox["p", "2"]}]}], ")"}]}], "\[LessEqual]", "lb", 
     "\[LessEqual]", "0"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.857319736333818*^9, {3.8573202944470673`*^9, 3.857320298719286*^9}, 
   3.857320459230588*^9, {3.857320601371681*^9, 3.857320624283412*^9}, 
   3.85732126873704*^9, 3.8573215775259657`*^9, 3.857321631985642*^9, 
   3.8573217583624*^9, 3.8573218367093143`*^9, 3.857322309316762*^9, {
   3.8573223474070272`*^9, 3.85732239615307*^9}, 3.8573224796469717`*^9, 
   3.85747255270547*^9, {3.85747267075669*^9, 3.857472694260191*^9}, 
   3.8574804029839277`*^9, 3.85749642087691*^9, 3.857501087035705*^9, 
   3.857516842184363*^9, 3.857576043488544*^9, 3.857655536787944*^9, 
   3.858008118018948*^9, 3.8582777936862383`*^9, 3.858875352815323*^9, 
   3.859316826394105*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"09a04cc5-4d22-4607-8112-d4072e364892"]
}, Open  ]],

Cell[TextData[{
 "Now cxp contains the conditions for the counterexample for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "."}], TraditionalForm]],ExpressionUUID->
  "97e03572-3736-4bf9-a8cb-65f422aa384b"],
 " We check the right boundary value:"
}], "Text",
 CellChangeTimes->{{3.857319712125432*^9, 3.8573197326710978`*^9}, {
  3.857319784924811*^9, 3.857319787945176*^9}, {3.857320056195169*^9, 
  3.8573200772562513`*^9}, {3.857320114379631*^9, 3.857320140256462*^9}, {
  3.857320368762991*^9, 3.857320407790707*^9}, {3.857323101918467*^9, 
  3.857323110486511*^9}},ExpressionUUID->"68c02927-8995-4ff2-92f1-\
c3cf67351e08"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"worstp", "=", 
   RowBox[{"{", 
    RowBox[{"p", "->", "0.7150834805401997"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"wstar", " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "->", "0.7150834805401997"}], ",", 
    RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.8573225997775917`*^9, 3.857322611774456*^9}, {
   3.8573226513199053`*^9, 3.857322683642605*^9}, {3.8573231845386744`*^9, 
   3.857323185658399*^9}, 3.857324252470594*^9, {3.857472722563406*^9, 
   3.857472737004385*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"98262dbf-eb8f-4284-aeb0-7c6af0f34498"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.`", "}"}], ",", 
   RowBox[{"{", "0.`", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.857322676490738*^9, 3.857322684006154*^9}, 
   3.857324256465926*^9, 3.857472552735161*^9, {3.857472670771287*^9, 
   3.857472694386808*^9}, {3.857472732770481*^9, 3.857472738180603*^9}, 
   3.857480403007245*^9, 3.857501087660734*^9, 3.8575168424056*^9, 
   3.8575760436953173`*^9, 3.8576555370104017`*^9, 3.858008121649083*^9, 
   3.858277794270586*^9, 3.858875354404552*^9, 3.8593168264108047`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"24f257ba-57b7-4f5b-825c-6089ae016a3e"]
}, Open  ]],

Cell["\<\
And that's our counterexample!
Be warned that since we\[CloseCurlyQuote]re studying the behaviour about a \
singularity, this is numerically unstable. We add the auxiliary variable lb \
to force the solver to give us the answer w.r.t. a symbolic lower bound.
This is exactly equal to the place where the error function meets the ||V||_2 \
line on the right of the singularity:\
\>", "Text",
 CellChangeTimes->{{3.8573231703901176`*^9, 3.857323181108965*^9}, {
  3.857323500294962*^9, 3.857323517877634*^9}, {3.857323561079515*^9, 
  3.857323607097026*^9}, {3.857323664799323*^9, 3.857323668929367*^9}, {
  3.857323711835115*^9, 3.857323788059984*^9}, {3.857323889935951*^9, 
  3.857323892775902*^9}, {3.8573239461365337`*^9, 3.85732395618816*^9}, {
  3.857324407803062*^9, 
  3.8573244313679323`*^9}},ExpressionUUID->"9372a6dc-d936-421c-a5b9-\
5b04ef5a2f28"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"gcoeff", "==", "0"}], "&&", 
   RowBox[{"p", ">", ".715"}], "&&", 
   RowBox[{"p", "<", "1"}], "&&", 
   RowBox[{"eta", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.857323248664797*^9, 3.857323306048255*^9}, {
  3.857323829102764*^9, 3.8573238721294403`*^9}, {3.8573239117418947`*^9, 
  3.857323929175473*^9}, {3.857323964511985*^9, 3.857323967764896*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"7a43fd6e-68fa-4ee0-ac0d-fd5668523f9b"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 23, 33, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.857323271328807*^9, 3.8573233067937317`*^9}, 
   3.857323829674336*^9, 3.857323872445662*^9, {3.857323912876903*^9, 
   3.8573239294186296`*^9}, 3.8573239680672913`*^9, 3.857472552755144*^9, {
   3.8574726708041058`*^9, 3.857472694417116*^9}, 3.8574804030372*^9, 
   3.857501087703835*^9, 3.857516842429625*^9, 3.8575760437216263`*^9, 
   3.857655537045738*^9, 3.858277794297091*^9, 3.858875356599124*^9, 
   3.859316826426592*^9},
 CellLabel->
  "During evaluation of \
In[23]:=",ExpressionUUID->"c822cd98-16a2-4322-8e19-d0c849e7a5c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "\[Equal]", "0.7150834805401997`"}], "&&", 
  RowBox[{"eta", "\[Equal]", "0"}]}]], "Output",
 CellChangeTimes->{{3.857323257675683*^9, 3.857323306804172*^9}, 
   3.857323829688705*^9, 3.857323872457406*^9, {3.8573239128891172`*^9, 
   3.857323929428444*^9}, 3.8573239680788393`*^9, 3.8574725527641172`*^9, {
   3.857472670829178*^9, 3.857472694425812*^9}, 3.857480403048464*^9, 
   3.857501087729476*^9, 3.857516842449448*^9, 3.857576043734494*^9, 
   3.857655537061804*^9, 3.858277794314777*^9, 3.858875356605023*^9, 
   3.859316826432498*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"987318d7-f790-4978-8b72-d33c1385f466"]
}, Open  ]],

Cell["\<\
We check to see that the denominator is well-behaved at the worst-p:\
\>", "Text",
 CellChangeTimes->{{3.8574860534503593`*^9, 3.857486068109561*^9}, {
  3.857486448788001*^9, 
  3.857486463610333*^9}},ExpressionUUID->"640ca592-4f91-4a0e-a020-\
a72d3c17f606"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gcoeff", " ", "//", "Together"}], "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Denominator", "[", 
   RowBox[{"First", "[", 
    RowBox[{"Rest", "[", "gcoeff", "]"}], "]"}], "]"}], " ", "/.", 
  "worstp"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"First", "[", 
    RowBox[{"Rest", "[", "gcoeff", "]"}], "]"}], "]"}], " ", "/.", 
  "worstp"}]}], "Input",
 CellChangeTimes->{{3.857486069267988*^9, 3.8574861287841473`*^9}, {
   3.857486396474327*^9, 3.857486435712861*^9}, {3.85748843824566*^9, 
   3.8574884431026783`*^9}, 3.8574887550475283`*^9, {3.8575016585964947`*^9, 
   3.857501661136627*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"9ef8b13c-0cc5-455d-85aa-c449a64815f3"],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"0.02588477500000008`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1.`", " ", "eta", " ", "p"}], "-", 
       RowBox[{"0.7150834805401997`", " ", "eta"}], "+", 
       RowBox[{"0.49999999999999994`", " ", 
        SuperscriptBox["p", "2"]}], "-", 
       RowBox[{"0.3575417402700998`", " ", "p"}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["eta", "2"], "+", 
     RowBox[{"0.47401268989999995`", " ", "eta", " ", "p"}], "+", 
     RowBox[{"0.0185628101`", " ", "eta"}], "-", 
     RowBox[{"0.012993655049999962`", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"0.009281405049999998`", " ", "p"}]}]]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.857486076830853*^9, 3.857486129294835*^9}, {
   3.857486398284802*^9, 3.857486436109684*^9}, 3.857488443468102*^9, 
   3.857488762883287*^9, 3.857501087756524*^9, 3.857501661489437*^9, 
   3.857516842472796*^9, 3.8575760437595797`*^9, 3.857655537108284*^9, 
   3.85827779433706*^9, 3.8588753577810593`*^9, 3.85931682644781*^9},
 CellLabel->
  "Out[24]//TraditionalForm=",ExpressionUUID->"434fa76b-1518-458d-b757-\
e9963d627c3e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7.253111831756129`*^-6"}], "+", 
  RowBox[{"0.3575214542139143`", " ", "eta"}], "+", 
  SuperscriptBox["eta", "2"]}]], "Output",
 CellChangeTimes->{{3.857486076830853*^9, 3.857486129294835*^9}, {
   3.857486398284802*^9, 3.857486436109684*^9}, 3.857488443468102*^9, 
   3.857488762883287*^9, 3.857501087756524*^9, 3.857501661489437*^9, 
   3.857516842472796*^9, 3.8575760437595797`*^9, 3.857655537108284*^9, 
   3.85827779433706*^9, 3.8588753577810593`*^9, 3.859316826449543*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"c49eb9d6-6618-40c5-b49f-a2f5a01cc6eb"],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.857486076830853*^9, 3.857486129294835*^9}, {
   3.857486398284802*^9, 3.857486436109684*^9}, 3.857488443468102*^9, 
   3.857488762883287*^9, 3.857501087756524*^9, 3.857501661489437*^9, 
   3.857516842472796*^9, 3.8575760437595797`*^9, 3.857655537108284*^9, 
   3.85827779433706*^9, 3.8588753577810593`*^9, 3.859316826451036*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"aa2c6828-a0a5-433a-8dde-eff140d5dcf4"]
}, Open  ]],

Cell["\<\
If you want a more satisfying answer, set the lower bound to higher numbers \
and make it smaller. This is equivalent to finding values of p for which the \
error is at least lb for all eta.\
\>", "Text",
 CellChangeTimes->{{3.8573238944856443`*^9, 3.857323897441819*^9}, {
  3.8573240000557404`*^9, 
  3.857324035979117*^9}},ExpressionUUID->"c5775ce9-1967-48e3-b4b7-\
1c3a68a8ead7"],

Cell["\<\
For reference, let\[CloseCurlyQuote]s plot the behaviour of the eta-V graph \
at some key values. First, at our counterexample value, we obtain a flat \
horizontal line at zero:\
\>", "Text",
 CellChangeTimes->{
  3.85732393872362*^9, {3.857472764315022*^9, 3.857472791884096*^9}, 
   3.857472829205048*^9, {3.857472936192807*^9, 3.857472938555172*^9}, {
   3.8574729869688168`*^9, 3.8574730116424828`*^9}, {3.857475495458831*^9, 
   3.8574754968129272`*^9}},ExpressionUUID->"42e9981b-fe7f-47ca-8f02-\
72f01b84a7a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gcoeff", " ", "/.", " ", "worstp"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{"eta", "->", 
      RowBox[{"10", "^", "etav"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etav", ",", " ", 
     RowBox[{"-", "5"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.857473012597253*^9, 3.857473106263015*^9}, {
   3.857475472419544*^9, 3.857475494069139*^9}, {3.857475627074226*^9, 
   3.8574756371925297`*^9}, 3.857484597120195*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"384975c1-82cb-4a73-ade9-f8ea171c33c5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJxFygtIk2EYBeDpr5WbiiULDW+L5YURwjSMBDe8Wy6bQ1vBTIyRIy1hOCjK
ygs4XW0ukWwsBWuFlqXmNFY2dTrGUrJFTLPUWUs3cTLXTLa1CvL9DhwODxxS
2eVCri8Oh2P87b99qOI5vd5QNe5/Yt6IKVMeZPnIYOl9F3LbqI8+eQu5Udve
wVtHrjDocg3zyMnWBJniFbLmgIXG4CNHHOZ+0sztAwd+2whj5yNH2RqkSvVe
MO8Z8QwtAflEiFK/LAsBc2OZzf2+yFkkK9ZuDAbb0ory/NRB4IDxl/EacSC4
UHKkVMUngBf9df55HDx4YYmZRUkMAAftds9nEveAn0plwQPLu8CSSUbv0JA/
uCuDpNjs8APHxllS6qswsJH1kZRf5At2mQcelR/0AU9m5iemWLxvd+xg8McJ
wx4wRm5oFha7wFWiWUwQuQ2+kMVii21OMF0/tMiUOsCC5ZLwOo4dHNGyRFDZ
beBSd4FcR7eCz4kyxIMLZnCMMnB1M9oETg1QZkeXfQZzVn5Q8H0fwASncDSp
YQzM0xF7iFeug8uptVp2/Bhtx/vpZE6tewY8Q7Z/Jw/PgbGLTQUtYSaw6UGb
nlpvBnuOTi3cOmlF//Z5earPBjgBk8i0VDu4spPN7b7rALN6vtZEvXOCX3Bp
r7nbv8AU1uAEVuwC5/auRCU1ecB5jw1MfCvy8c6R+iU5cr601SLuQ2YK6Mo1
I/LZtHsMRdxvcMV0zrXwCeRKLfX5xjTyJXWkSWtErurfzBGsIVe3dYQaQr3g
mpKtblEZ8o3Tpi/nK5BvnpoKSRUg16V3CVaFyI2xBenZfcjC6GPVkSrkprBD
TxwaZBHeFdRlRL6NmelXTch33O/5zDVkyU+VIt6J3LKumPV6kf8A3H5Fmg==

       "]]},
     Annotation[#, "Charting`Private`Tag$1577724#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 2}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.85747311010422*^9, {3.8574754750874023`*^9, 3.857475498475038*^9}, 
   3.857475637620953*^9, 3.857480403084696*^9, 3.857484598307375*^9, 
   3.8575010878494987`*^9, 3.857516842553343*^9, 3.857576043823739*^9, 
   3.857655537185596*^9, 3.858277794414689*^9, 3.8588753611075287`*^9, 
   3.859316826489244*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"46817831-7006-4e04-b7f9-66a1f146339d"]
}, Open  ]],

Cell["Now we plot the on-policy point:", "Text",
 CellChangeTimes->{{3.857475503602195*^9, 3.8574755056890087`*^9}, {
  3.8574755427126427`*^9, 
  3.857475567681538*^9}},ExpressionUUID->"fa7e48b4-31c0-4ef7-8927-\
a72b5e29cc3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"gcoeff", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "->", "0.5"}], ",", 
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etav"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etav", ",", " ", 
     RowBox[{"-", "5"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.857475568670506*^9, 3.857475605381328*^9}, {
   3.857475645878717*^9, 3.857475684470549*^9}, {3.857488323713628*^9, 
   3.857488350264681*^9}, 3.857491427729484*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"4fa96cd1-2514-44b9-bc6e-64062f085508"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV13c4lu8XAHB777dhj8hIRcoIOSqrMvJFqVRGyJZVSXbKzEpEUaRllr2e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       "]]},
     Annotation[#, "Charting`Private`Tag$1577776#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-4.999999857142857, 1.9999998571428572`}, {-1., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.857475662985589*^9, 3.857475684860888*^9}, 
   3.857480403131844*^9, {3.85748832447495*^9, 3.8574883509648533`*^9}, 
   3.857491428654936*^9, 3.857501088022285*^9, 3.857516842641724*^9, 
   3.857576043887424*^9, 3.857655537257989*^9, 3.858277794483265*^9, 
   3.85887536304673*^9, 3.859316826550323*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"57998cf1-acd1-4a2f-80b5-5a0cd8f6736e"]
}, Open  ]],

Cell[TextData[{
 "At the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "-"}], TraditionalForm]],ExpressionUUID->
  "0ab29eab-6b43-498c-99cd-31594b77b152"],
 "singularity, we see some weird behavior:"
}], "Text",
 CellChangeTimes->{{3.857491022682335*^9, 3.857491027674223*^9}, {
  3.857495639734899*^9, 
  3.8574956449189777`*^9}},ExpressionUUID->"0fce6435-269f-44f5-a0ab-\
dc5822fc0f10"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"psing", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"epsilon", "->", "0.0001"}], ",", 
         RowBox[{"eta", "->", "0"}]}], "}"}]}], ",", " ", "p"}], "]"}], "//", 
    "Rest"}], "//", "First"}]}], "\[IndentingNewLine]", 
 RowBox[{"etafixsing", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"gcoeff", "==", "1"}], " ", "/.", " ", "psing"}], " ", "/.", 
      " ", 
      RowBox[{"{", 
       RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ",", "eta"}], "]"}], " ",
    "//", " ", "First"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gcoeff", " ", "/.", " ", "psing"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etav"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etav", ",", " ", 
     RowBox[{"-", "7"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", " ", 
     "psing"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etav"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etav", ",", " ", 
     RowBox[{"-", "7"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "]"}], " ", "/.", 
     " ", 
     RowBox[{"{", 
      RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], " ", "/.", " ", 
    "etafixsing"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", 
     RowBox[{
      RowBox[{"p", "-", "0.001"}], "/.", "psing"}], ",", " ", 
     RowBox[{
      RowBox[{"p", "+", "0.001"}], "/.", "worstp"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "2"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"gcoeff", " ", "/.", " ", "etafixsing"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.857483715213924*^9, 3.857483751719596*^9}, {
   3.857483811264349*^9, 3.857483815913994*^9}, {3.857483936605452*^9, 
   3.85748393673228*^9}, 3.857483983368896*^9, {3.857484371137353*^9, 
   3.857484371684463*^9}, {3.857484405387293*^9, 3.857484425702636*^9}, 
   3.857484525625095*^9, {3.857484633593277*^9, 3.857484716218292*^9}, {
   3.85748830538913*^9, 3.857488311106648*^9}, {3.8574904894382067`*^9, 
   3.857490538012198*^9}, {3.857491037439302*^9, 3.857491135032785*^9}, {
   3.857492346026985*^9, 3.85749241484558*^9}, {3.857492785575719*^9, 
   3.857492812610484*^9}, {3.857492860880823*^9, 3.8574930823571243`*^9}, {
   3.857493143157963*^9, 3.857493147583433*^9}, {3.8574932078581753`*^9, 
   3.857493239981062*^9}, 3.8574932958717337`*^9, {3.857494449789022*^9, 
   3.857494457088767*^9}, 3.85749474476437*^9, {3.8574947791111917`*^9, 
   3.857494786085148*^9}, {3.857494825753113*^9, 3.8574948266404667`*^9}, {
   3.85749493310771*^9, 3.85749494147716*^9}, {3.857495077315086*^9, 
   3.857495146911352*^9}, {3.857495262435836*^9, 3.857495271279871*^9}, {
   3.8577326178978863`*^9, 3.8577326257412777`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"dcfc786d-e210-46d1-a6e2-b7e71e847257"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", "\[Rule]", "0.7143028666133495`"}], "}"}]], "Output",
 CellChangeTimes->{{3.857491042733714*^9, 3.857491084396595*^9}, {
   3.85749111822288*^9, 3.857491135347082*^9}, {3.857492380791843*^9, 
   3.857492415482142*^9}, 3.857492812902877*^9, {3.857492867414192*^9, 
   3.857493034992087*^9}, {3.857493067244094*^9, 3.857493082718203*^9}, 
   3.857493147869628*^9, {3.857493211988699*^9, 3.8574932405286093`*^9}, 
   3.857493296792553*^9, 3.857494457884199*^9, 3.857494745777073*^9, 
   3.8574947865018578`*^9, 3.857494827876423*^9, 3.857494941847362*^9, {
   3.857495081510744*^9, 3.857495147387414*^9}, 3.85749527341997*^9, 
   3.857501088078464*^9, 3.857516842681059*^9, 3.8575760439167957`*^9, 
   3.8576555373125353`*^9, 3.857732635698138*^9, 3.8582777945221357`*^9, 
   3.858875366555017*^9, 3.859316826575616*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"19e3e3c7-8189-42f1-9e1d-7e4de2356f6e"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "ratnz", 
   "\"Solve was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 30, 34, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.857492380910059*^9, 3.857492415500655*^9}, 
   3.8574928129084587`*^9, {3.857492867420031*^9, 3.857493034998353*^9}, {
   3.857493067248365*^9, 3.8574930827230453`*^9}, 3.857493147885356*^9, {
   3.857493211995178*^9, 3.857493240532915*^9}, 3.8574932967996197`*^9, 
   3.857494457892417*^9, 3.857494745784533*^9, 3.857494786510961*^9, 
   3.8574948278863297`*^9, 3.857494941854307*^9, {3.8574950815181837`*^9, 
   3.8574951473943253`*^9}, 3.8574952734291277`*^9, 3.8575010880983753`*^9, 
   3.85751684269088*^9, 3.8575760439257603`*^9, 3.857655537320631*^9, 
   3.857732635715761*^9, 3.8582777945313253`*^9, 3.858875366567504*^9, 
   3.859316826577381*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"92a4e997-a22d-4770-ad16-58986a8bc154"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"eta", "\[Rule]", "0.00002020601585838176`"}], "}"}]], "Output",
 CellChangeTimes->{{3.857491042733714*^9, 3.857491084396595*^9}, {
   3.85749111822288*^9, 3.857491135347082*^9}, {3.857492380791843*^9, 
   3.857492415482142*^9}, 3.857492812902877*^9, {3.857492867414192*^9, 
   3.857493034992087*^9}, {3.857493067244094*^9, 3.857493082718203*^9}, 
   3.857493147869628*^9, {3.857493211988699*^9, 3.8574932405286093`*^9}, 
   3.857493296792553*^9, 3.857494457884199*^9, 3.857494745777073*^9, 
   3.8574947865018578`*^9, 3.857494827876423*^9, 3.857494941847362*^9, {
   3.857495081510744*^9, 3.857495147387414*^9}, 3.85749527341997*^9, 
   3.857501088078464*^9, 3.857516842681059*^9, 3.8575760439167957`*^9, 
   3.8576555373125353`*^9, 3.857732635698138*^9, 3.8582777945221357`*^9, 
   3.858875366555017*^9, 3.8593168266281548`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"5529f149-df68-4f52-979f-00d8be1a36ac"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwdlGcgl////e0dbzNKGRFCEbLqer7JLpSEhHxUVlnZ0iArWWWLMiMrhIxy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       "]]},
     Annotation[#, "Charting`Private`Tag$1577843#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.999999816326531, 1.9999998163265307`}, {-1., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.857491042733714*^9, 3.857491084396595*^9}, {
   3.85749111822288*^9, 3.857491135347082*^9}, {3.857492380791843*^9, 
   3.857492415482142*^9}, 3.857492812902877*^9, {3.857492867414192*^9, 
   3.857493034992087*^9}, {3.857493067244094*^9, 3.857493082718203*^9}, 
   3.857493147869628*^9, {3.857493211988699*^9, 3.8574932405286093`*^9}, 
   3.857493296792553*^9, 3.857494457884199*^9, 3.857494745777073*^9, 
   3.8574947865018578`*^9, 3.857494827876423*^9, 3.857494941847362*^9, {
   3.857495081510744*^9, 3.857495147387414*^9}, 3.85749527341997*^9, 
   3.857501088078464*^9, 3.857516842681059*^9, 3.8575760439167957`*^9, 
   3.8576555373125353`*^9, 3.857732635698138*^9, 3.8582777945221357`*^9, 
   3.858875366555017*^9, 3.859316826690364*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"5f127c35-9a11-44fa-be37-160864e59197"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwd13c8Vf8bAHB7j+saUcooRUaSjNaDzEISkoYiGWVFUUSLEKmohArZkZlo
OB8ys8cXKbKy93bv5f7O+Z1/zuv9ep7ncz7neT3n83odKTt3cwcmBgaGYUYG
BuIud0/3gM49IcTw/4tDK2Qk3XHcRwhprz2c0VBh1xJVZLqme0wIJc6X3WCN
ZNbyLDPgcTEQQscUDLbNnGbW+mkZkRWpi8fXLy+pSDFr+QeITnUfEUJJW1r7
qwqZtPqalNw89wmhvKDmGv4+Rq3062c93orjjrUOyNBn0NIoLvRenRZEiTvQ
j6cJFNAZ1/RSmBREatRPPK8NKWAsjnleHBNE+77LBynNrYHt3Vq3mkFB9DP6
jd/60TUINux1iukSRErxnXyCsyvQ3sV+XqNcED1oGuw+f2kJ3Nds9HxfCCJ3
vjJTlDQLvvJ9R7OeCyKpt5VNLTazcP+8g05fpCBiFQn5YSU4Cy/L3MEwTBAl
HA8/4sE9A99CH2qKBgqi1wFPrUP/TgLX5o+KxU6CqKGrZqYldxRSDzCKrB4U
RHHHeHOuTffB50E19RkNPH8xVb7VrQ9qwq9ZD+8XRG+1TN/I9/2F8d7O2PY9
gmiGc2PDbrwH9jz4KJG3XRB97cyqkRLshuK6s3Iu3IJIpKe62LKgFWq9nx27
xCGIBs8HKQY3tkD31uqr1qx4vtIIRXeiGWjuKh/16WQUELwcX2neCNpCnPu2
L5DR1iw2swz3ajD/fsRi8ywZPcjaKmFTWgmXr3jfEJgiI/u1UJN1/goILv77
mT5MRk2DOqZs3xD8PFd06E83GRUOOm2Sdy2E36yT59s6ycjL60jEK408mPwo
FfiznYyO1gok7BXMgvXTpxPKWshIceBA4TGUAnyMEWXFjWRk+nx9U/PsW5DI
LB/IqSOj3T3bbRdvPgflU6vMaTVk5CPKHhBg7As6NEWZt5VktDJZqPhs3hdO
pdjrvygnoyyx/F13bjyHy6avHcMxMvLIc9c/8/ot3FxpDHnwjYyeNpMr+CxS
IMboQJ1nERl9iatzK0rMhT9TJDPTTDJikygyhVPfYOqlvqdeGhnd+5n9fEEF
gw3wf34omYy8vRuD29jKQPL5SPvut2SkdDNPdVP3D3BQKz3D/pyMJtR8HU7b
18J0wFV7dIuMds2bfd3L1AosZ9LvTtwko9+9eydE41thy75/b0S8yeilUjcX
2/42MBy50HXNjYx4b4p7rNq3Q9IJcxMxezL6paSZ6FzUAVaSmurXjcmIv7ii
s03pN3wvY+PeIUFGOprZp9a/9kN73FHZE+JkpD9e/b6M0g/jN+7q3RYjo+y5
/hUJzQEQ2U0JbBYko3HuX9rZhQPg8Xxq0Z+DjEIbcw+Ipw3CDvv23v/mBFD/
pe/mnbf+QThLUv6jCgHkQPehj3ePQqZl5PyNMgGkfTdO4Ap5DGpS/VUulwog
rkYXr0CjMWAxOp2vVSyAXP3+tUcWjYFfBE/+2gcBRH939YVm+Di4iPjkXY0S
QIlmOr7aOyfBUNY494SdAJq5d/n4NbEZuHJLc/awrQB66WNRMao3Aw9/7lRW
OIfnf68bFbk+A+gaYy6HlQBi8+U5G1Y7A+p5RTllRgLoKN8bW7cDs7DzgFTO
vr0C6JpffEZL7yywGC9nb2IQQOePfu+K4p2H1gPbjYXWSSh/UPeGiMQ8JMqZ
jZMoJGRjWFd/W3kejrBn7uRaJKG87TV3xsznwbf8/DvaCAlViQaFXX45D1Ma
lU/7m0iocCZBf33TAnTIRHt9eEdCQ346X9jZFyFZqEwgPZ6E7JNfP5cUXgQv
5umc5Nck9FHmCo/U9kUg9RtMvokioWO7Y8J/HVmE4/HUy08f4c87KW6keGMR
ENne6oY7CWFdIPqgZxEy6Hs1AUiIb3DTiaU3S+AvcaXN/RAJfTU6Ffw4fQnM
INY1QZOEjr9W+UAqWILVAKYkRlUSytBplB+tXgLDjVauClkSqo6+xtA0uwSj
NK8/hmQS6qXRZaNgGYwXr9KTf/KjnzdkA1JblmFxX/s+tkp+tC9nc5hx9zLE
ex1ycsT4kUh77fuhgWWYmOdpkSvkRwVBe2wmFpYhbC476eMbfpS5Og6WwitQ
Mz2jV+zBjxqVW/uzLVdAb8wrvE6EH4muXNrK3LACNJHDbAUkfhS76G2R1b4C
+bpsd2O5+FGluPlOwz8rIJkQ4+W8wYfO8MyvnJ5YAYrVdxv2YT4UfCu6q5tj
FXIr2OSOfuJD/E/3HLynvQqbE15XfjnFhwRr+QWGM1ahucEOkkz4kI4aLz9v
7io8osqXhBrwIaUcmeNyRauwaFWaZX2QD50o/1GjXb4KTbyDUcvSfKh/56m+
xV+r8NBPwU5lnhcF6Hcae7GvwbQVtpHxlBf9tHm3z+jsGuQMv/RYC+NFf7J6
2Ydt18DjptuAYRAvckoOs/C7vAYLL7ZWjdziRadyjoREuq7BartfhIw9L5Kc
s8yyDVwD5lMa4on7eVGb8zbtjMQ1ED2RpxnTzYOfL9zPlfvX4FdvyIeRdh4U
/GWmeX5oDWLdLm5Vb+JBW9+Tpj6OrsHWJ/yMHT940Blnzn9Cs2sg3eBaI5jN
gyrNjEZjNtZA4fju05GBPMg25OyH0M0U0DZ47x28gwddqNrmZ2pKAXLlb/lz
23gQ97f10XcnKTCgIzS4V5QH/XpY7TthQYH7R4JO9nDzoGXGsF2eZylQvt9R
SXWBG83Ytv1Vd6LA0R3yo/1l3Oh6srbn17sU0GMsOHvYlhvRSAp6PdkUEAmc
IAue4UbNBdeKg3IpMEzb/nPUnBtd0HXylSugQPBqtEa0Pjd6moHodsUUqJq5
KTyhyI0ab4gKvCungEHvgaYYGhdKNYzV0OmggNHXcp3F11wo4ovRW2cKBW57
3y4ajuJCr6acmu/SKJClqLL7VwQXOuxx/FL0BgVICYkCpfe4kB5bUHEuExU6
Ht7te+TMhSS1osdLuahgZ3okYIsmF9JIe5yutpkKt/tLSnS6OJHzjuymr2pU
yIr1VNzfyole3tqr76JBhZ5Tcom76jlR74xZi/ABKmhVxYTwIE5ksO2d5uXD
VGD74HO6I40T2ZK0enuPUuG59/4lZx9OdPM0VnLCjAqZ7HnKz0Q40d/F8+Ja
jlQYlvaJnyBxoiuNk4oPnKggfeQwhz43J3JdFFCtcKZCnHftXwqdAyVWnJHX
ukaF8P7+J5fHONBWuRNSkp5UcP1KnlL/xoG8/pNdun+bCsru3hm9lzhQUqL/
o7HHVLgWdkBY8xwHYqR57ZsLp0J6CsO9KCsOdDHjkOpKBBUk/4RbGx7nQCmr
vLARSQUBoxT2fFUOFP3ErGI1igrz0h0OQewcaIXbuj0xjgqfOtSlFbLZUX+y
wtX/MqjA0HehjSeNHaVe25NVmkkF47Ggh1MJ7Eh1LPpU6gcqDFDbhj9GsyMu
a9TnkU0FPimPD3v92VEgo4DOQi4VrlxNV1U/zo70Gd/653ymggiDmIHOGBvS
vaGPNlVQ4RKn1qr0IBuC1wZDrbizyI4ZzD1saJicioVXUkFH5hN3ZTMb2h7k
l0KrooLbsZPNBsVs6L/0nKsNtVSoig49Y/KIDS2zdVWpNlHhphzlqrUMGzI5
6rFF7hcV6qP3CCdKsKF4/WzzT7ilGRxKx8TYkILiynutbio0dDSR/PjYUEtm
VKzFbyrseJjy6c0KKzoo/4rheg8VWnrN6AO1rGhpzHTqQT8VFKLTnru6sSKS
CCfGO0aF+/Q/B4ucWJEZpe1fIO5OF/K/DTtWJH3B5eQcEde+o/70NCuifP5B
bRmnwq9p8z/5WqwopEG7NGySCsFGGzKrZFZ0g2+S1j1Dhf4Ni5L7n1nQsomt
0MYSFWJSOCVG81jQ+/iTe88sU8HMuPShSRYLehBU8bUAd+nrXWaiiSxo+k+X
uOMKFWJVKcPZYSyo54S0XPUqFcxd3gn9Oo/nnypQdqVSofy/Mfc9LCwIGvuG
rRhocMv/7X/RG8yI3ezvxUTcyttPHaSsMqMI2GY/gfutxze2yilmFGhzgTmA
kQa3uSPf2HQyo4mOzOo3TDTYp61aF5TJjHbo5jPWsNAgOStg5x8zZjQzNiZQ
z0EDF+3olupjzKjD31+UjxNfvyPDv0CXGdW3Tnw4gfsbvb01TIMZKYbe92/B
3WYuH6gpyYwirZS7m7howLTW2flyhgmdKVBRLuahwUW9vaEnnzChNWMho0Mk
Guzs1lc9HMKEPp5jPe2Je9Lt3F/Z+3h+oydHKm7fmEf7GW4yoV0i2tZ8AjSI
nOjp/3ieCfk1iH3vxl36LOwAjyITOuqsvt1ekAZbewcnquoYkfILf0c1ERpM
t7NHbq5iRFW8TioXcJfWyau4IUaE9j75FoT7YomXr/AnRhQevIfUjjspmpn1
8ltGtH5xB3LdhO/v+PZtjJ6MKD8oKe6FKA2Uiu3MDoowoleRZ4dLNtNg42Pw
whMSI9r5n491N+6mlMyXA1yMKE2p4gUFt0fU/J9QOgO6f1XX68AWGuS73Xfu
GmVA3yp2/fiMW10m6f6NrwyoIKdvI12cBlrP+wtzLjIgSRFvPqdtNJD0ufIm
1IYBPSnKKX6Im352IsjeArfCeeVE3KUyS1abDBnQ9STP0F+4D5ZwrAXsYUC3
6zdPGkjQ4BqyvR1Po2MlIUalWyRpYH2OFvZLnY7xPZhqTJSiwaadbOci5OkY
r0JzTTHujhl+RW0JOsaooBjbhPvUg+1N6Wx0TP+ZVwUNt2nmMUHf/zawLypD
RyylaaC7GhMn4rWBXSVbstNx743en3Xq4zpmt/fKR/Ud+Pu2H17WSlrHtvMq
/zDCrSqsr6X0ch070ZJZfBa3xkurdo6AdWwx8rF+IO4jMT607ybrmPRk80IF
7mPxJcayUzTswfBK2TEZGtglH56iydOwbz67H2nvpMHQkJ76uAQNKwy0EjLD
7SBjeq9TkIbRt5qFXMDtlHpBOJ9KxXxP28j44XZLDzzsWEfF9MbuaBTgvp1V
FtHiQsXkpzNGtu2iQVShnlJqBgVToF+5+w/37hIXJ/u3FCw3zNh1Fjf6Hpkk
GUXBbLofG1JxT1f9Eonzp2Cj70N/kmTx/f5ypUeeoGCnpqLpB3AzbLxovrW0
hmW8nNELx+1mMHzdRHsN4zZgo0rL0YDVmDubS20No2/hHZHHHW+mPFK9ew0L
08isUMX988ztszpCa9isLoulPm6Za3y66iOrWJ3Dl3on3H+eqglLRaxix13r
5T/gNuoO/rzYtYI92H3wyM7d+Hx+cfUvrV/Bmna77FDCnR9noR2CVrDauz9o
+3GLn5eu25K+gk1OWz7Uwz3993uvjs8Klj34Ys4e9/N/i6zPhFewL7a/rd/i
7p61s1A0X8bU63cvccrT4EmLkdiK3jL2POuRMQn30XzlXqS5jE1cqo0RwZ3l
teFoIbWMfVwxJG3HHbD82s9vdgnz2nryzkHc0rTmpNonS9iz7b9tXXC7sMOc
Q90ilhTL9APhVs3SSaVji5jO7sYHlbg3zPTPvi5cxP6Ntx36iftZrEll/ZtF
jFSOXrXhLlY893qfxyJ2/FXA/D/c7Ba3tBmFFzG5+SP6nAr4+ZZQ8Cz+wgJm
Xn2j+BhuN73P+mqnFjABlbRXprg1xr9QmwwWsCtfHniY467fV+7AvHcBO3HH
kd8G90JVs6YL8wL2/OkKkzNunampfvX0eYxMmasNwv1XU1albW4O22nRLPYV
9zXL3RdTh+ew6cxLe0txr3ooPLn1ew4roawfLcNNTlcel6icw4J1fGyqceuK
aCZdi5nDDLsNTNpwp88bkdlgDtuUJXhyHPf1D1fnNcJnsUyyD4uwIt6PKldJ
nnuzWMPJ/sebcD8ecDf9e2MWs0w+zL8Zd7KYd2aQ7SxGvjXMKYG785G/XavK
LDZ6KqtJFrdvzeaUzvwZbEH4QdJB3NwHLjgcNpnGDlopRV7AfVFuuIOmOo35
hMU2XMRdKOpm+E18Ghv4JsFhj/vCyh35g5NTmLLaU09H3LmFb+Y0Hk9hlu8q
RDxwW+zpuaNaO4k9alDKvYs7fse5l/J6E1iblP2xd7hnBYfYJxQmsOLgg6KJ
uPWYr93KFJrAKgpmB5JwT/f7nZMbGseClNndU3FrvYuT3vVgHKPJ+9ll4/4n
9vujdNkYdidJ6OsX3Er8NtVih0ex6cVRyzbc2cFbxG7tHMWeOVzPbcetsPHH
pYt/FJO9UsvRgVt+ypbv1cAIVmUxnd+FW7bOwVIoZATjtrw51YNb6pHnIF/b
MDbeELgxgluIHkJndv6H5dyzT6Pgjrp57KS9+T8s0E28nIqbPM39vvzgP6z5
DtdvGm6Bnif69/j+YZpJz9jpuPm+RkdsFAxhF0/EH2dWwufTJ2HL2sYgdueJ
yH1u3JTpz+rT0QMYt8TJr5txF25bf3vFfwBz0TX+tAW3u6kO21/7ASy0IDJb
HPdQdn17k8oA5hdIjdmGu/Fav2decz82IPblrDTupHGuLG+efky28lyUHO6X
9V+1ltn/YomPAnvVcHMr6POPdPRit1xoqeq47z5u7ulM6cWaUkTdNHC7HPt3
u+RoL7bQqrGqiftIDd8n/8AebLXdhnYI98iPS3LMK78xTzOlKh3cGl/ZyaTh
LuxMSKi7CW4medZEreIu7LT9Z1ZT3PWxTMqeYV0Y/eF0LOFLt9dNWpW6ML6Z
gPITuMM0F0KjfTqxEJIFmznuns+9jGKcHZh+ww47K9z3Cz/NSSm0YXcfh3lf
wG28o+Cu+UYr1u9WPk1YJDqX/0FzKxYQstfJFvcHrw+KQ96t2M8HX6wv4m5X
SXRO/d6Cndkdp2yHe1deeP/uE83Y2FzWNwfcMWerkxyHfmK7dK1Nr+E+Ovcp
JDrsJ/bOrCeH8HRwsluZ8k/sjGElyZWI5987sOVOLSY6WdZMeJrjUGujcA0W
YhJq5I5btyiXUc2gEruQLiNxHXeflGoZhwWGac7PXPTBrWYiEGGXUIpF73iX
S/ix77T1t8nvWB6tgf7/eFP6rHvQN2ygMzveF3e4/1bJzqISLDgovPkW0e9O
tsAUsULs7qyXlD9uabGCWw9LE7HDCeKud4l+LaQ712okYCLrnwsIV8UdLhC/
8gbTZu1aI2zEKuylfOIVVuaV8fAe7je5j/7l6ARjxuvp0fdxmzJ/35LvHQYJ
eU1vH+KujX32qGf1I+Ts3XIpBLdqX8NxY8gFkUOtrwmzLLS2yTHlwef9O1sJ
vxftGRx6lA8pGWnaobgH7OeYz0Z9gsvq28XDcNtSxHQNMr+CgtYT7DHu7Kj9
A/yTP+Dj4sOKJ8T80U7K0PUrYJKfZ4awrIOb03RiBbxtNRGLJOZbLW26/nQl
rAgwuxKO+SVKDf1RBR4ZWgJPifeXoAmyxNWC701Hk2e4rT+U660aNcEequar
KNzCQn9DRpKbwKpysIRwqz+1roPeBD2cln8I79y1OaPbphkkrkdKRuNOXDXf
U0JqAZ0c11TCL+MqDt70b4XM21vTX+C+159mMXvqP/D1jA16hdspRaluf9B/
8FlPLZmwmfMnbb+i/yCYPb6csORcuRKbWAcYt1RtEEYMvRzivR1QUvXeOwY3
g6TQdwOnLmh2rrN6TXyfF+7KvPP/DaS/KiuxxPrS7PFD2b9BxqyEP45YfziC
vPvvb2B2E5IlLOkWRy/U/gOf+42sCaM7Rb9+svXA5HBJEWGGN5MRy097YVfG
9NV4Iu6qQE1t7YM92lElb3ArDVyv6BjvA8ynt57wG6uSCDbmfnBS5+gjfBv0
Ja/s64cazVXWt8Q8CFzUk4nuB+vHZmaE0wqjIt9bDoCujOBfwk+olO0JXYPA
Qj41/A43zV17qml2EJLfdi0Rvjr0qIjOMQT6cJQ1Abdhg5CRreYQsPnUbCfM
9E7JbVvsEIjVvLIlfFPHrjj+7D+4Lu/ZSvh8aK3x695hyDPXTE3EnXCjY7/c
0jCYUP7mER66NLithHsElqu8vhO+dmB9tktjBIyN7NsJ+08ovxCNGgHLQw6M
SbhjTWJ6XhmMQtxTPmvCnQKObi9zxyBry9dVwps3vE7vrB6De3OHmd7jvjB+
V6uoZwzm7PK4CQ+Xx5I7uMZB0t9lG+Flr8YiYYdxOKkue5SwUMd+erTYBIg0
DIcSPhnL8jTq/iR4xpB4k3HbNEbYc8VNgp+anzBhO6ZN6vcKJuEDqXMr4esu
cr1uQ5Ow2GenRDj6gKnCMf0p0PnaYEq4q/tVDQPXNOzYxBZB+OIWeUa3ZzMQ
hVLphJ1OFLYPZcxAc70jWwpuzweH08+Wz0AtXZyX8P2JEyeMFmZgWuHyZsKt
57+YPt89C2L9jqqEFxX/xruGz4KvjNUVwhqNspo7zOZArs68nPCu5Ob8yLNz
4OlvV01Y5LavAvXKHOwYdK7/f71MjUTrnTngZb/YQTj3jiPb3Q9zUCkxMfb/
esXUtt9s85DPEsKfStSHb3eL+j4P3h37LAmz2tWNbNTMw9Vx8zOEF9W9Lrm0
z8Pa4avnCbcOlltoT8wDR/MjB8IRB+0OzogugEKL5w3CLBMJHMe9F6DiFTma
8ILRtvdM8otw6XBjPWHJjOr3qmqL8C5ctJmwMYdn8hXtReCJOt9GOLnqR8rP
04tgM9L5i7DFUef05w8XQSjmyTDhokOF2dK9izCoxU0n7LvnWLHOsyXwNPRV
SCPqnywUe8cvQe287B7CzVPxJalpSyB4/L+9hGWzZr5wlS6BhpSUOuFfsi++
t44vgcX2YG3CB6T7yu10l+Hb6ceWhNeFbjbcX1kGxx05twnzxJw/ms68Auvd
AncIb96iV9LAvwLZzh6BhNWkhFJEZVfAVEHqIWEPxXz/j9YrIMtnHkF4SG9a
vrtkBZjPrLwlXH/zSthe/1WINAzACHevmTCcDlmFBknnMsJj/vtv+kevwlqi
2Q/CbA9Y7KqzVsGiSLiasFZkkub5Hry+2reRcGFa72jIkTXQc0/7Qzi+y8qg
j4EC0et1y4RfvJJq2M9DATOVQ6uEn1hNmj/eRAFbUuYa4bvt9y6oKVEgozOA
RtihOetG+FkKdFN5mNKJ86uGKVmjiAJPG0t5CJd9/sjw7CoVrHieSRIu3K/L
c+g+FXxKRqQJpxb82jQSQwVKi5oM4bAclj2Hq6ggnVYqR9gizeb8GP4f/SbA
R4Xw8Eu2L9odNHjalKhDOGH+Q2bkDA1qPMt1CduYnozr4ViHQrvf+oQbWeP9
bx1ch/vvlo8RLvLeC3kJ63De5z9zwo/Mz1VIXt0AIdqxS4R1PjJ+cnu4Afxl
NDvCNM60lG9vNiDOIf0yYY+yuWDr5g3ITZlyJGyt/Mjo6X46ZNmouBEmhysc
6DWlwxGfT+6E60dadis40UFEfJ8nYa134jw1sXRwNNnmTZhCKaMJF9IhiiH8
xv/7Y+U4Zd9AB/fQxZuE3fJ5evOG6fCBctqXsCxffiOdToecK0W3CP8PdiZx
1A==
       "]]},
     Annotation[#, "Charting`Private`Tag$1577895#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.999999816326531, 1.9999998163265307`}, {-1., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.857491042733714*^9, 3.857491084396595*^9}, {
   3.85749111822288*^9, 3.857491135347082*^9}, {3.857492380791843*^9, 
   3.857492415482142*^9}, 3.857492812902877*^9, {3.857492867414192*^9, 
   3.857493034992087*^9}, {3.857493067244094*^9, 3.857493082718203*^9}, 
   3.857493147869628*^9, {3.857493211988699*^9, 3.8574932405286093`*^9}, 
   3.857493296792553*^9, 3.857494457884199*^9, 3.857494745777073*^9, 
   3.8574947865018578`*^9, 3.857494827876423*^9, 3.857494941847362*^9, {
   3.857495081510744*^9, 3.857495147387414*^9}, 3.85749527341997*^9, 
   3.857501088078464*^9, 3.857516842681059*^9, 3.8575760439167957`*^9, 
   3.8576555373125353`*^9, 3.857732635698138*^9, 3.8582777945221357`*^9, 
   3.858875366555017*^9, 3.859316830420246*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"7fdc8b23-e349-4166-8d03-d8bdb5c71519"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwl1nlUTd8XAPCiuTRSb+r1nkQDqUQkvVCkDEk0a9AkmqiQpDRrkKISmjWi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       "]], 
      LineBox[CompressedData["
1:eJwl1Qkw1W0XAPBrua7lLv6lkAp5s5UShRI34Svbq3iJlPChxVJ6S4VCCFHK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       "]]},
     Annotation[#, "Charting`Private`Tag$1577947#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.7133028666700983, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.7133028666700968, 0.7160834804834524}, {-10., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.857491042733714*^9, 3.857491084396595*^9}, {
   3.85749111822288*^9, 3.857491135347082*^9}, {3.857492380791843*^9, 
   3.857492415482142*^9}, 3.857492812902877*^9, {3.857492867414192*^9, 
   3.857493034992087*^9}, {3.857493067244094*^9, 3.857493082718203*^9}, 
   3.857493147869628*^9, {3.857493211988699*^9, 3.8574932405286093`*^9}, 
   3.857493296792553*^9, 3.857494457884199*^9, 3.857494745777073*^9, 
   3.8574947865018578`*^9, 3.857494827876423*^9, 3.857494941847362*^9, {
   3.857495081510744*^9, 3.857495147387414*^9}, 3.85749527341997*^9, 
   3.857501088078464*^9, 3.857516842681059*^9, 3.8575760439167957`*^9, 
   3.8576555373125353`*^9, 3.857732635698138*^9, 3.8582777945221357`*^9, 
   3.858875366555017*^9, 3.859316831415344*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"8278a118-a202-4b07-b015-8a929c58b094"],

Cell[BoxData[
 RowBox[{"0.`", "\[VeryThinSpace]", "+", 
  FractionBox["0.00002878395691942579`", 
   RowBox[{"0.000028897851827580984`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.7150399885311115`", " ", "p"}], "-", 
    RowBox[{"1.`", " ", 
     SuperscriptBox["p", "2"]}]}]], "+", 
  FractionBox[
   RowBox[{"0.7122218064289683`", " ", "p"}], 
   RowBox[{"0.000028897851827580984`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.7150399885311115`", " ", "p"}], "-", 
    RowBox[{"1.`", " ", 
     SuperscriptBox["p", "2"]}]}]], "-", 
  FractionBox[
   RowBox[{"0.9960544165746554`", " ", 
    SuperscriptBox["p", "2"]}], 
   RowBox[{"0.000028897851827580984`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.7150399885311115`", " ", "p"}], "-", 
    RowBox[{"1.`", " ", 
     SuperscriptBox["p", "2"]}]}]]}]], "Output",
 CellChangeTimes->{{3.857491042733714*^9, 3.857491084396595*^9}, {
   3.85749111822288*^9, 3.857491135347082*^9}, {3.857492380791843*^9, 
   3.857492415482142*^9}, 3.857492812902877*^9, {3.857492867414192*^9, 
   3.857493034992087*^9}, {3.857493067244094*^9, 3.857493082718203*^9}, 
   3.857493147869628*^9, {3.857493211988699*^9, 3.8574932405286093`*^9}, 
   3.857493296792553*^9, 3.857494457884199*^9, 3.857494745777073*^9, 
   3.8574947865018578`*^9, 3.857494827876423*^9, 3.857494941847362*^9, {
   3.857495081510744*^9, 3.857495147387414*^9}, 3.85749527341997*^9, 
   3.857501088078464*^9, 3.857516842681059*^9, 3.8575760439167957`*^9, 
   3.8576555373125353`*^9, 3.857732635698138*^9, 3.8582777945221357`*^9, 
   3.858875366555017*^9, 3.859316831423821*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"c40e0421-3b3a-4fd5-98fe-3b3f85a67122"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gcoeff", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], " ", "/.", "psing"}], " ", 
  "//", "Together"}]], "Input",
 CellChangeTimes->{{3.8575943909920807`*^9, 3.857594421265183*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"b8da7614-51a0-4295-877a-3330f052b662"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.00002020601585838236`", " ", 
   RowBox[{"(", 
    RowBox[{"0.35715143330666405`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", "eta"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"0.35715143330667465`", " ", "eta"}], "+", 
   SuperscriptBox["eta", "2"]}]]], "Output",
 CellChangeTimes->{{3.85759440065232*^9, 3.8575944216824408`*^9}, 
   3.8576555385389338`*^9, 3.8582777995167627`*^9, 3.858875564838191*^9, 
   3.859316831451136*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"4ae9b890-1bb6-4227-b81b-f532e9164e5b"]
}, Open  ]],

Cell["\<\
Observe how there is a counterexample at the singularity, but not at our \
counterexample point. To check that this is not the result of some numeric \
error:\
\>", "Text",
 CellChangeTimes->{{3.85749615096462*^9, 
  3.857496162657002*^9}},ExpressionUUID->"046262f0-01d2-4dcd-8f82-\
de4ad9c95510"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"sA", "/.", 
     RowBox[{"{", 
      RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "/.", "psing"}], " ", "/.",
    " ", "etafixsing"}], " ", "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"sA", ".", "what"}], "/.", 
     RowBox[{"{", 
      RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "/.", "psing"}], " ", "/.",
    " ", "etafixsing"}], "  ", "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sb", " ", "/.", 
    RowBox[{"{", 
     RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "/.", "psing"}], " ", "//",
   " ", "TraditionalForm"}]}], "Input",
 CellChangeTimes->{{3.857483715213924*^9, 3.857483751719596*^9}, {
   3.857483811264349*^9, 3.857483815913994*^9}, {3.857483936605452*^9, 
   3.85748393673228*^9}, 3.857483983368896*^9, {3.857484371137353*^9, 
   3.857484371684463*^9}, {3.857484405387293*^9, 3.857484425702636*^9}, 
   3.857484525625095*^9, {3.857484633593277*^9, 3.857484716218292*^9}, {
   3.85748830538913*^9, 3.857488311106648*^9}, {3.8574904894382067`*^9, 
   3.857490538012198*^9}, {3.857496177738144*^9, 3.857496205292828*^9}, {
   3.857496717532325*^9, 3.857496791038925*^9}, {3.857516853649611*^9, 
   3.857516876489874*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"b388b0a9-680b-416b-a4ee-21e7861e7fc7"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.17859592266919572`", "0.1785757166533374`"},
     {"0.1785757166533374`", "0.17859592266919572`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.857496186085299*^9, 3.85749620605611*^9}, {
   3.857496720166012*^9, 3.857496792124138*^9}, 3.857501089322782*^9, {
   3.8575168439952087`*^9, 3.8575168769951973`*^9}, 3.8575760451826077`*^9, 
   3.857655538581949*^9, 3.858277799551585*^9, 3.85887556659273*^9, 
   3.8593168314677057`*^9},
 CellLabel->
  "Out[36]//TraditionalForm=",ExpressionUUID->"fc407a8a-98c4-4a41-8c49-\
8a99cf14e0c0"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.000020204648091270982`"},
     {
      RowBox[{"-", "0.00002020464809140976`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.857496186085299*^9, 3.85749620605611*^9}, {
   3.857496720166012*^9, 3.857496792124138*^9}, 3.857501089322782*^9, {
   3.8575168439952087`*^9, 3.8575168769951973`*^9}, 3.8575760451826077`*^9, 
   3.857655538581949*^9, 3.858277799551585*^9, 3.85887556659273*^9, 
   3.859316831469836*^9},
 CellLabel->
  "Out[37]//TraditionalForm=",ExpressionUUID->"dda6527b-7506-4a59-b285-\
19745e5d1ab2"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.00002020601585838236`"},
     {
      RowBox[{"-", "0.00002020601585838236`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.857496186085299*^9, 3.85749620605611*^9}, {
   3.857496720166012*^9, 3.857496792124138*^9}, 3.857501089322782*^9, {
   3.8575168439952087`*^9, 3.8575168769951973`*^9}, 3.8575760451826077`*^9, 
   3.857655538581949*^9, 3.858277799551585*^9, 3.85887556659273*^9, 
   3.85931683147151*^9},
 CellLabel->
  "Out[38]//TraditionalForm=",ExpressionUUID->"9302b5c6-e50f-4396-8d57-\
f41e96c21e71"]
}, Open  ]],

Cell[TextData[{
 "Some distance after ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "-"}], TraditionalForm]],ExpressionUUID->
  "ca951b49-6812-4f3b-8349-5c025393a3f0"],
 "counterexample:"
}], "Text",
 CellChangeTimes->{{3.857488358703171*^9, 3.8574883816846323`*^9}, {
  3.857492335071707*^9, 3.857492337367968*^9}, {3.857496168406109*^9, 
  3.8574961711282787`*^9}, {3.857498053544693*^9, 
  3.857498057918989*^9}},ExpressionUUID->"82694172-691a-45ef-b3f2-\
050eb48b1aea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gcoeff", " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{"p", "->", "0.720"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etav"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etav", ",", " ", 
     RowBox[{"-", "7"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.857483715213924*^9, 3.857483751719596*^9}, {
   3.857483811264349*^9, 3.857483815913994*^9}, {3.857483936605452*^9, 
   3.85748393673228*^9}, 3.857483983368896*^9, {3.857484371137353*^9, 
   3.857484371684463*^9}, {3.857484405387293*^9, 3.857484425702636*^9}, 
   3.857484525625095*^9, {3.857484633593277*^9, 3.857484716218292*^9}, {
   3.85748830538913*^9, 3.857488311106648*^9}, {3.8574904894382067`*^9, 
   3.857490538012198*^9}, {3.8574971814623117`*^9, 3.857497224126031*^9}, {
   3.85749806175381*^9, 3.857498079844337*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"e2aeaa24-e9ec-4214-858a-b0cab089b336"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwd1Ak0Ve33B3BjpMG5ozsoiSSUUBFq36QoklRE1Gt8K0IpKZpUiJS8pUJR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       "]], LineBox[CompressedData["
1:eJwdl3c41v//xW/rdhsflY+ZlJktIlHpZYuQJA1aiqKiIjIalJHsFRkhI1LJ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       "]], 
      LineBox[{{-3.8325495013736752`, 3.}, {-3.832549352643673, -1.}}]},
     Annotation[#, "Charting`Private`Tag$1578014#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.999999816326531, 1.9999998163265307`}, {-1., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.8574837368002462`*^9, 3.857483752167248*^9}, {
   3.857483811637097*^9, 3.857483816325387*^9}, 3.857483937210361*^9, 
   3.8574839838893127`*^9, 3.8574843720847797`*^9, {3.857484407302814*^9, 
   3.857484426256513*^9}, 3.857484526347168*^9, {3.857484634437701*^9, 
   3.857484716796825*^9}, {3.857488307369711*^9, 3.857488311594643*^9}, 
   3.857490497739996*^9, 3.857490538963722*^9, {3.8574972048557243`*^9, 
   3.8574972245261507`*^9}, {3.857498063793075*^9, 3.857498080577977*^9}, 
   3.857501089422884*^9, 3.857516844098937*^9, 3.857576045285055*^9, 
   3.857655538690069*^9, 3.858277799655274*^9, 3.85887556794497*^9, 
   3.859316831549405*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"4bdae7db-50a2-4f39-b445-9b7f7b9ba4e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
     " ", 
     RowBox[{"{", 
      RowBox[{"p", "->", "0.715"}], "}"}]}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etav"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etav", ",", " ", 
     RowBox[{"-", "7"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.857489724849465*^9, {3.857490514715046*^9, 3.8574905457901287`*^9}, {
   3.857497199378948*^9, 3.857497231149685*^9}, {3.857498109827244*^9, 
   3.8574981159918623`*^9}, 3.858095863768449*^9, {3.858095926608924*^9, 
   3.8580959657166433`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"8ba7b55c-6bc5-42ff-941e-99eae180a407"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwd1nk0VtvfAPDzPMYrSZ3zzKIkXB6JSkLOTpSI0iRTg1KJCF3NhKKkQsUl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       "]], 
      LineBox[CompressedData["
1:eJwd1nk01F8UAHCMnZj5hlL9shTZQ8oWD9mjJJHSpkUkS2RLKmUtyZKshWxR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       "]]},
     Annotation[#, "Charting`Private`Tag$1578066#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.999999816326531, 1.9999998163265307`}, {-1., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8574884215395403`*^9, 3.8574897257336283`*^9, {3.8574905178500013`*^9, 
   3.857490546265142*^9}, 3.857497232506116*^9, {3.8574981124829817`*^9, 
   3.857498117355517*^9}, 3.857501089500329*^9, 3.857516844207552*^9, 
   3.857576045368918*^9, 3.857655538772191*^9, 3.858095871786249*^9, {
   3.858095931169643*^9, 3.858095971238655*^9}, 3.858277804077261*^9, 
   3.858875574327959*^9, 3.859316836031906*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"f2756c09-33ad-4bdb-85a1-7f471b8ad37b"]
}, Open  ]],

Cell["Lets investigate the latter:", "Text",
 CellChangeTimes->{{3.857498132070263*^9, 
  3.8574981401516447`*^9}},ExpressionUUID->"dceee5c9-9f4f-4425-9f9d-\
811608577820"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
     " ", 
     RowBox[{"{", 
      RowBox[{"p", "->", "0.9"}], "}"}]}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"eta", "->", 
       RowBox[{"10", "^", "etav"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etav", ",", " ", 
     RowBox[{"-", "7"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.857500187048477*^9, 3.8575002408002033`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"3185ff6b-1caf-43bf-83ee-f8c764f824c6"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwV13k4lN8XAHBm7FQzw9jLlhKyr4k7JHsI3xZaRUmyJ0kliiIppCyVbEmS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       "]]},
     Annotation[#, "Charting`Private`Tag$1578129#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, -8.721849571541634},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-7, 2}, {-8.721849571541634, 9.044960600174457}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{-6.907755278982137, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.001\"", ShowStringCharacters -> False], 0.001, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {
      2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}}, {-11.86960040890896, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.736069016284437`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.618285980628055`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.605170185988092, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.210340371976184, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.918390573078392`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.206072645530174`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{3.859316840420773*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"354c55fd-7890-4946-b82f-dc2e2d11d3e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Simplify", "[", 
  RowBox[{"sA", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
     RowBox[{"p", "->", "0.8"}], ",", " ", 
     RowBox[{"eta", "->", "0"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"sA", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"p", "->", "0.8"}], ",", " ", 
      RowBox[{"eta", "->", "0"}]}], "}"}]}], "]"}], " ", "//", 
  "PositiveSemidefiniteMatrixQ"}]}], "Input",
 CellChangeTimes->{{3.857484450701582*^9, 3.85748447002842*^9}, {
   3.8574845634028473`*^9, 3.857484580656431*^9}, 3.857498947986989*^9, {
   3.857655603860784*^9, 3.857655637022614*^9}, {3.857655669630444*^9, 
   3.8576557125684757`*^9}, {3.857664902263117*^9, 3.8576649340263653`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"913cd1ef-cd42-4142-a01a-9c5f5f9b0225"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.19888648101`", ",", "0.20111351899000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.20111351899000002`", ",", "0.19888648101`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.857484462664287*^9, 3.857484470335587*^9}, {
   3.8574845645249043`*^9, 3.857484580882286*^9}, 3.85749894860364*^9, 
   3.8575010940555153`*^9, 3.857516849224265*^9, 3.8575760503521*^9, 
   3.857655543263811*^9, {3.85765560694051*^9, 3.857655637504078*^9}, {
   3.857655684477521*^9, 3.857655712863339*^9}, {3.857664908335417*^9, 
   3.857664934435133*^9}, 3.8582778086010733`*^9, 3.858875584345381*^9, 
   3.85931684050559*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"38a6ebfc-04a7-410b-a06c-045d410a456a"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.857484462664287*^9, 3.857484470335587*^9}, {
   3.8574845645249043`*^9, 3.857484580882286*^9}, 3.85749894860364*^9, 
   3.8575010940555153`*^9, 3.857516849224265*^9, 3.8575760503521*^9, 
   3.857655543263811*^9, {3.85765560694051*^9, 3.857655637504078*^9}, {
   3.857655684477521*^9, 3.857655712863339*^9}, {3.857664908335417*^9, 
   3.857664934435133*^9}, 3.8582778086010733`*^9, 3.858875584345381*^9, 
   3.859316840507139*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"9ae23d40-57af-4659-8a8f-e2b61c5666ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"gex09", " ", "=", 
  RowBox[{
   RowBox[{"gcoeff", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{"p", "->", "0.9"}], "}"}]}], "//", 
   "Together"}]}], "\[IndentingNewLine]", 
 RowBox[{"Roots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Denominator", "[", "gex09", "]"}], "==", "0"}], ",", "eta"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.857499124888842*^9, 3.8574992420200157`*^9}, {
  3.857499420260585*^9, 3.857499429071212*^9}, {3.85749951857883*^9, 
  3.857499595577455*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"e64992ff-23f2-4c4c-8790-5bdcc40f629a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"0.004786522500000067`", " ", 
    RowBox[{"(", 
     RowBox[{"0.4500000000000004`", "\[VeryThinSpace]", "+", 
      RowBox[{"1.`", " ", "eta"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"-", "0.0021715960454999714`"}], "+", 
    RowBox[{"0.44517423101`", " ", "eta"}], "+", 
    SuperscriptBox["eta", "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.857499447156108*^9, {3.857499541771495*^9, 3.857499596276285*^9}, 
   3.857501094079465*^9, 3.8575168492555*^9, 3.857576050378467*^9, 
   3.857655543303301*^9, 3.8582778086358337`*^9, 3.8588755843932*^9, 
   3.8593168405200367`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"ed1f15a6-8195-4b70-a039-c4b9e9ea2c44"],

Cell[BoxData[
 RowBox[{
  RowBox[{"eta", "\[Equal]", 
   RowBox[{"-", "0.44999999999999996`"}]}], "||", 
  RowBox[{"eta", "\[Equal]", "0.004825768989999937`"}]}]], "Output",
 CellChangeTimes->{
  3.857499447156108*^9, {3.857499541771495*^9, 3.857499596276285*^9}, 
   3.857501094079465*^9, 3.8575168492555*^9, 3.857576050378467*^9, 
   3.857655543303301*^9, 3.8582778086358337`*^9, 3.8588755843932*^9, 
   3.859316840524427*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"319dfb53-fd23-42b7-89d4-ea19c9f4196f"]
}, Open  ]],

Cell["\<\
This happens because the matrix (sA+eta I) is not invertible at this point:\
\>", "Text",
 CellChangeTimes->{{3.857575985719288*^9, 
  3.857576005907587*^9}},ExpressionUUID->"b387144a-fa38-495a-84e7-\
0adea06e3cc1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Det", "[", "sA", "]"}], "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"epsilon", "->", "0.0001"}], ",", 
     RowBox[{"p", "->", "0.9"}]}], "}"}]}], " ", "//", " ", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Eigenvalues", "[", "sA", "]"}], "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"epsilon", "->", "0.0001"}], ",", 
     RowBox[{"p", "->", "0.9"}]}], "}"}]}], "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Det", "[", "sA", "]"}], " ", ">", "0"}], "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"p", "->", "0.9"}]}], "}"}]}], "]"}], " ", "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Det", "[", "sA", "]"}], " ", "/.", 
      RowBox[{"{", 
       RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ")"}], ">", "0"}], " ", "&&",
    " ", 
   RowBox[{"0", "<", "p"}], " ", "&&", 
   RowBox[{"p", "<", "1"}], "&&", 
   RowBox[{"0", "<", "eta"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.857500483464128*^9, 3.857500525798065*^9}, {
  3.857576009854075*^9, 3.8575761132479563`*^9}, {3.8575766775073347`*^9, 
  3.8575767143904753`*^9}, {3.857589413140317*^9, 3.857589418314827*^9}, {
  3.857590289677691*^9, 3.857590319094831*^9}, {3.857666800782816*^9, 
  3.8576669149471207`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"d7d198d5-3780-4b3a-8e6c-874468bcc587"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["eta", "2"], "+", 
   RowBox[{"0.44517423101`", " ", "eta"}], "-", "0.002171596045499968`"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.857589418760779*^9, {3.8575903026292763`*^9, 3.857590320709098*^9}, 
   3.857655543357787*^9, 3.85766681011434*^9, {3.857666866025782*^9, 
   3.857666915333062*^9}, 3.858277808702623*^9, 3.858875585959091*^9, 
   3.859316840538992*^9},
 CellLabel->
  "Out[46]//TraditionalForm=",ExpressionUUID->"8b1298a2-b676-489f-8f9e-\
9545aa3673d6"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "eta"}], "-", "0.009651537980000069`"}], ")"}]}], 
    ",", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "eta"}], "+", "0.9`"}], ")"}]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.857589418760779*^9, {3.8575903026292763`*^9, 3.857590320709098*^9}, 
   3.857655543357787*^9, 3.85766681011434*^9, {3.857666866025782*^9, 
   3.857666915333062*^9}, 3.858277808702623*^9, 3.858875585959091*^9, 
   3.859316840544129*^9},
 CellLabel->
  "Out[47]//TraditionalForm=",ExpressionUUID->"fc738786-9a49-4672-aeda-\
76771316cf53"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 48, 35, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.857589418771626*^9, {3.8575903026398153`*^9, 3.8575903207274647`*^9}, 
   3.85765554337475*^9, 3.857666810136628*^9, {3.857666866047879*^9, 
   3.857666915352881*^9}, 3.8582778087431707`*^9, 3.8588755859785357`*^9, 
   3.859316840546269*^9},
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"a41e32a8-85e8-44bd-a891-b5559025595c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"eta", "<", 
    RowBox[{"-", "0.4499999999999999`"}]}], "\[Or]", 
   RowBox[{"eta", ">", "0.00482576898999991`"}]}], TraditionalForm]], "Output",\

 CellChangeTimes->{
  3.857589418760779*^9, {3.8575903026292763`*^9, 3.857590320709098*^9}, 
   3.857655543357787*^9, 3.85766681011434*^9, {3.857666866025782*^9, 
   3.857666915333062*^9}, 3.858277808702623*^9, 3.858875585959091*^9, 
   3.859316840552864*^9},
 CellLabel->
  "Out[48]//TraditionalForm=",ExpressionUUID->"02de44f6-582c-41f4-aaad-\
731c1f6f4dd3"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 49, 36, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.857589418771626*^9, {3.8575903026398153`*^9, 3.8575903207274647`*^9}, 
   3.85765554337475*^9, 3.857666810136628*^9, {3.857666866047879*^9, 
   3.857666915352881*^9}, 3.8582778087431707`*^9, 3.8588755859785357`*^9, 
   3.859316840576373*^9},
 CellLabel->
  "During evaluation of \
In[46]:=",ExpressionUUID->"0792d6dc-d98e-4645-9d21-9bbace21cc99"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "eta", "\[LessEqual]", "0.007424499999999933`"}], "&&", 
    
    RowBox[{"0", "<", "p", "<", 
     RowBox[{
      RowBox[{"5.09209308413737`*^-16", " ", 
       RowBox[{"(", 
        RowBox[{"7.01384337256628`*^14", "+", 
         RowBox[{"3.5820554599838636`*^16", " ", "eta"}]}], ")"}]}], "+", 
      RowBox[{"1.5094176225676057`*^-24", " ", 
       SqrtBox[
        RowBox[{"5.598684086297191`*^46", "+", 
         RowBox[{"6.345670222960768`*^48", " ", "eta"}], "+", 
         RowBox[{"1.7980801362379938`*^50", " ", 
          SuperscriptBox["eta", "2"]}]}]]}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"eta", ">", "0.007424499999999933`"}], "&&", 
    RowBox[{"0", "<", "p", "<", "1.`"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.857589418760779*^9, {3.8575903026292763`*^9, 3.857590320709098*^9}, 
   3.857655543357787*^9, 3.85766681011434*^9, {3.857666866025782*^9, 
   3.857666915333062*^9}, 3.858277808702623*^9, 3.858875585959091*^9, 
   3.859316840585577*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"67a1e9f1-0a6e-4489-8b73-d3ce996ff3eb"]
}, Open  ]],

Cell["\<\
Something else, we search for vacuous examples as g(p, eta) < 0:\
\>", "Text",
 CellChangeTimes->{{3.857595232089984*^9, 
  3.8575952598251677`*^9}},ExpressionUUID->"daf54fcd-116a-4333-965b-\
bdf1a7aa5ce1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"gcoeff", " ", "<", "0"}], " ", ",", "p"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"eta", "->", "0.0001"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.857595264053051*^9, 3.857595401528695*^9}, {
  3.857595436612253*^9, 3.857595436918095*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"62276a82-738f-46df-8c9e-da238329b5bb"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 50, 37, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.857595300717753*^9, 3.857595401953537*^9}, 
   3.8575954375777407`*^9, 3.857655543543857*^9, 3.858277808926325*^9, 
   3.858875645186109*^9, 3.859316840727034*^9},
 CellLabel->
  "During evaluation of \
In[50]:=",ExpressionUUID->"d19e451b-9efc-48e1-b0e3-3522337ace75"],

Cell[BoxData[
 RowBox[{"0.7150834805401995`", "<", "p", "<", 
  "0.7181508985803057`"}]], "Output",
 CellChangeTimes->{{3.8575952670832853`*^9, 3.857595401971242*^9}, 
   3.8575954375918207`*^9, 3.8576555435560427`*^9, 3.858277808938974*^9, 
   3.858875645199546*^9, 3.85931684073295*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"47eea5e7-ac86-4783-b317-881e27df7216"]
}, Open  ]],

Cell["Our counterexample for large eta_0:", "Text",
 CellChangeTimes->{{3.858008132753146*^9, 
  3.858008152925029*^9}},ExpressionUUID->"72bb22e3-e21f-4252-a9c7-\
3dd94e5a6927"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"p", "->", "0.9"}]}], "}"}]}], ",", "eta"}], "]"}]], "Input",
 CellChangeTimes->{{3.858008156344545*^9, 3.858008258445261*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"defa34e2-02ba-46a6-81f1-574096315a82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.44999999999999996`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "0.0048257689899999295`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8580081654908323`*^9, 3.858008181348476*^9}, {
   3.858008221125334*^9, 3.858008258962029*^9}, 3.858277808966736*^9, 
   3.858875648160253*^9, 3.859316840745924*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"090ed8ae-bf3a-440d-a3ab-02cc965e8a46"]
}, Open  ]],

Cell[TextData[StyleBox["Why can\[CloseCurlyQuote]t we select a single \
eta_0:", "Subsection"]], "Text",
 CellChangeTimes->{{3.858278412179994*^9, 
  3.858278429678124*^9}},ExpressionUUID->"430e8ff4-2c04-4ca9-9dfa-\
ef23b9af9df1"],

Cell["eta_0 can be pushed arbitrarily high:", "Text",
 CellChangeTimes->{{3.858278861373939*^9, 
  3.858278862600947*^9}},ExpressionUUID->"26abb32c-0fc0-4bd3-9ca1-\
afc027ee4d50"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.8582784349807377`*^9, {3.858278466759612*^9, 3.858278563181534*^9}, {
   3.858278597477029*^9, 3.858278604587008*^9}, 3.8582787307662363`*^9, {
   3.858278838528247*^9, 3.8582789052968616`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"30533d03-ccdc-4c44-bf5b-838871dfa93d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"etanought", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
       RowBox[{"{", 
        RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ",", "eta"}], "]"}], "//",
     "Rest"}], "//", "First"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"gcoeff", " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
       RowBox[{"eta", "->", 
        RowBox[{"eta", "+", "0.001"}]}]}], "}"}]}], " ", "/.", "etanought"}], 
   " ", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.858278614831099*^9, 3.858278627210465*^9}, {
  3.858278676522255*^9, 3.858278720651424*^9}, {3.8582787520925627`*^9, 
  3.858278765205421*^9}, {3.858278805634687*^9, 3.858278830304904*^9}, {
  3.85827886724076*^9, 3.8582788676548347`*^9}, {3.8582789196513653`*^9, 
  3.858278938005761*^9}, {3.858279027121703*^9, 3.858279059364767*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"af416148-ef11-45ec-a84d-a81779c1b9e7"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "ratnz", 
   "\"Solve was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 53, 38, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.858278908173151*^9, 3.85827893840125*^9}, {
   3.858279027348442*^9, 3.8582790599036207`*^9}, 3.8593168407726297`*^9},
 CellLabel->
  "During evaluation of \
In[53]:=",ExpressionUUID->"19f0ff85-d76c-4011-800e-e30a8ea2f5f1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"eta", "\[Rule]", 
   RowBox[{"4.210877539557953`*^-17", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2.20414983879449`*^14"}], "-", 
      RowBox[{"5.628431193344091`*^15", " ", "p"}], "+", 
      RowBox[{"1.1750074221493644`*^-9", " ", 
       SqrtBox[
        RowBox[{"3.518852067481527`*^46", "-", 
         RowBox[{"1.9941717053006233`*^48", " ", "p"}], "+", 
         RowBox[{"2.825296939143401`*^49", " ", 
          SuperscriptBox["p", "2"]}]}]]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.858278685521635*^9, 3.8582787659339314`*^9}, {
   3.8582788089317217`*^9, 3.8582788434584417`*^9}, {3.8582789082354116`*^9, 
   3.858278938459901*^9}, {3.858279027405056*^9, 3.858279059960074*^9}, 
   3.859316840831687*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"a882a40b-899d-4b8b-bd81-03db13bfdc87"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVkHk01Psfxsc+lJ2yjZ2QbVRIue9P9pCbpSJMKi22mFQXaRkZyZ4r3AxZ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       "]]},
     Annotation[#, "Charting`Private`Tag$1578485#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {-7.374999471739703, 17.588576416234474`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.858278685521635*^9, 3.8582787659339314`*^9}, {
   3.8582788089317217`*^9, 3.8582788434584417`*^9}, {3.8582789082354116`*^9, 
   3.858278938459901*^9}, {3.858279027405056*^9, 3.858279059960074*^9}, 
   3.8593168408691397`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"8ea96b97-b5d9-4a13-ae66-62f95d3c4af2"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"93bbeacc-e1e6-4552-98f8-49e8c5b7ebc2"],

Cell[TextData[StyleBox["A nicer derivation of our counterexample:", \
"Subsection"]], "Text",
 CellChangeTimes->{{3.858278609223325*^9, 3.858278609952743*^9}, {
  3.858280263017058*^9, 
  3.8582802723285933`*^9}},ExpressionUUID->"49e5a37e-0169-45ff-a08f-\
72bee4e298bf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"der", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Together", "[", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"what", "\[Transpose]"}], ".", " ", "wstar"}], " ", "/.", 
         RowBox[{"{", 
          RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ",", " ", "eta"}], 
       "]"}], "]"}], " ", "//", " ", "First"}], " ", "//", " ", "First"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"der", "/.", 
  RowBox[{"{", 
   RowBox[{"eta", "->", "0."}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Factor", "[", 
  RowBox[{"der", "/.", 
   RowBox[{"{", 
    RowBox[{"eta", "->", "0."}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.858280282027277*^9, 3.858280356513308*^9}, {
  3.858280392552807*^9, 3.858280571485653*^9}, {3.858280603981255*^9, 
  3.8582806701834583`*^9}, {3.8582807094811087`*^9, 3.858280756441585*^9}, {
  3.858280790394053*^9, 3.858280820075824*^9}, {3.858280852136963*^9, 
  3.858280855056669*^9}, {3.858280936459827*^9, 3.858280936704118*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"84cf486f-8b3e-48ac-b439-2c66440e3cee"],

Cell[BoxData[
 FractionBox[
  RowBox[{"76.65179572227`", " ", 
   RowBox[{"(", 
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.1586399112736157`*^-17", " ", "p"}], "-", 
     RowBox[{"0.7150834805401997`", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["p", "3"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.7143028666133495`", " ", "p"}], "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["p", "2"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.858280283603717*^9, 3.8582803243353252`*^9}, 
   3.8582803571899347`*^9, {3.858280393938159*^9, 3.858280438793065*^9}, {
   3.858280470584817*^9, 3.8582805101177*^9}, {3.858280542722376*^9, 
   3.8582805717751713`*^9}, 3.858280614038213*^9, 3.8582806706650953`*^9, {
   3.858280711132427*^9, 3.858280756817101*^9}, {3.8582807909398613`*^9, 
   3.858280820680879*^9}, 3.858280877095996*^9, 3.858280937051455*^9, 
   3.859316840899892*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"06bfe972-b7df-4511-89b0-aad1890dc543"],

Cell[BoxData[
 FractionBox[
  RowBox[{"76.65179572227`", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.7150834805401997`"}], "+", 
     RowBox[{"1.`", " ", "p"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1.6202862222440624`*^-17", "+", 
     RowBox[{"1.`", " ", "p"}]}], ")"}]}], 
  RowBox[{"p", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.7143028666133495`"}], "+", 
      RowBox[{"1.`", " ", "p"}]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.858280283603717*^9, 3.8582803243353252`*^9}, 
   3.8582803571899347`*^9, {3.858280393938159*^9, 3.858280438793065*^9}, {
   3.858280470584817*^9, 3.8582805101177*^9}, {3.858280542722376*^9, 
   3.8582805717751713`*^9}, 3.858280614038213*^9, 3.8582806706650953`*^9, {
   3.858280711132427*^9, 3.858280756817101*^9}, {3.8582807909398613`*^9, 
   3.858280820680879*^9}, 3.858280877095996*^9, 3.858280937051455*^9, 
   3.859316840902113*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"53c767ca-96f7-432d-beb0-d92004ddff53"]
}, Open  ]],

Cell[TextData[StyleBox["Output for paper: Run this to dump output to home \
directory.", "Subsection"]], "Text",
 CellChangeTimes->{{3.8574803300250263`*^9, 
  3.857480366353117*^9}},ExpressionUUID->"ebccddd3-a133-4ec4-82ee-\
730372b879bf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"runp", "=", "0.715"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.",
       " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"eta", "->", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"etarun", "/", "10"}], ")"}]}]}], ",", " ", 
        RowBox[{"p", "->", "runp"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "7"}], "*", "10"}], ",", 
       RowBox[{"2", "*", "10"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<data_eta_\>\"", ",", 
     RowBox[{"ToString", "[", 
      RowBox[{"InputForm", "[", "runp", "]"}], "]"}], ",", "\"\<.dat\>\""}], 
    "]"}], ",", "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8567932065752087`*^9, 3.856793390227412*^9}, {
   3.8567934244787197`*^9, 3.8567934412047977`*^9}, {3.856793477784267*^9, 
   3.8567935288266478`*^9}, {3.856793713161681*^9, 3.856793714862821*^9}, {
   3.856793785858068*^9, 3.8567939554085627`*^9}, {3.856798635617424*^9, 
   3.856798670338073*^9}, 3.856798787839864*^9, {3.856798947947607*^9, 
   3.8567989530281487`*^9}, {3.8573072095756607`*^9, 3.857307360448542*^9}, {
   3.857309722477605*^9, 3.857309725558454*^9}, {3.857316111604631*^9, 
   3.857316114093762*^9}, {3.857320333534745*^9, 3.857320349748808*^9}, {
   3.858096014604982*^9, 3.8580960278971977`*^9}, 3.858111419856071*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"18227f70-8084-43ae-bd5c-abf6004faa64"],

Cell[BoxData["\<\"data_eta_0.715.dat\"\>"], "Output",
 CellChangeTimes->{
  3.856798676519*^9, 3.856798793480248*^9, 3.857306008444152*^9, {
   3.8573073244719048`*^9, 3.8573073614027367`*^9}, 3.857309726912533*^9, 
   3.8573119482771187`*^9, 3.857316115558291*^9, 3.8573167896614637`*^9, {
   3.8573203358597927`*^9, 3.8573203506267843`*^9}, 3.857472552143749*^9, {
   3.857472670525144*^9, 3.857472693684229*^9}, 3.857480403623097*^9, 
   3.857501094602757*^9, 3.857516849837927*^9, 3.857576050958548*^9, 
   3.85765554404078*^9, 3.858111421103096*^9, 3.8582778094854403`*^9, 
   3.859316841359947*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"d1adf2f1-6517-440d-b4e8-74843ebdd658"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 2: Breaking the Target Network", "Section",
 CellChangeTimes->{{3.850702730932063*^9, 
  3.850702746241844*^9}},ExpressionUUID->"24d22338-4f57-408e-9bc5-\
fd8119da790b"],

Cell["\<\
Now we examine the paper _Breaking The Target Network_ to see how that \
interacts with our example:\
\>", "Text",
 CellChangeTimes->{{3.849223622968721*^9, 
  3.849223658368297*^9}},ExpressionUUID->"3fd1be11-f9e6-48ba-b827-\
bfb37d630993"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDmag", "=", 
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"P", "\[Transpose]"}], ".", "Dm", ".", "P"}], "]"}], ",", " ", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"0", "<=", "p"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.849224975303862*^9, 3.849225088012713*^9}, {
  3.849225180213174*^9, 3.849225264836554*^9}, {3.849225678166271*^9, 
  3.849225697511403*^9}, {3.850703073751412*^9, 3.850703080171916*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"92b9c95a-053c-4f01-83dd-6c1a947d5ff7"],

Cell[BoxData["0.375`"], "Output",
 CellChangeTimes->{
  3.8492252651021137`*^9, {3.849225668537467*^9, 3.849225697918881*^9}, 
   3.849225740715497*^9, 3.850701372813501*^9, 3.850703094928441*^9, 
   3.851905043858343*^9, 3.851936714938511*^9, 3.8520997722854757`*^9, 
   3.852099844040324*^9, 3.852100230663466*^9, 3.852100655904739*^9, 
   3.852102746921331*^9, 3.856790504112846*^9, 3.857306011698489*^9, 
   3.857316792949563*^9, 3.8574725527873383`*^9, {3.8574726708708677`*^9, 
   3.857472694458878*^9}, 3.8574804037307568`*^9, 3.857501094626684*^9, 
   3.857516849869493*^9, 3.857576050980855*^9, 3.857655544082066*^9, 
   3.8582778095142717`*^9, 3.859316841376752*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"a984b11b-e8e6-4c02-a14d-c2633426321e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"xi", "=."}]], "Input",
 CellChangeTimes->{{3.849223660320115*^9, 3.849223688239686*^9}, {
  3.849224960786572*^9, 3.849224974118526*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"f9a538a1-0268-4d4c-8829-b1097f2db9f8"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["We set the constants C0 and C1 up : \
\[AliasDelimiter]", "Text"]], "Input",
 CellChangeTimes->{{3.849225876660479*^9, 3.8492259068323717`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"4d5b34d1-6cb7-4fca-95c6-9425240f2d62"],

Cell[BoxData[
 RowBox[{"and", " ", "C0", " ", "C1", " ", "constants", " ", "set", " ", 
  "the", " ", "We", " ", 
  RowBox[{"(", 
   RowBox[{"up", ":", "\[AliasDelimiter]"}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.852099772332583*^9, 3.852099844077873*^9, 3.852100230698292*^9, 
   3.852100655935305*^9, 3.852102746952993*^9, 3.856790504150497*^9, 
   3.857306011740036*^9, 3.857316792972705*^9, 3.8574725528159437`*^9, {
   3.857472670913013*^9, 3.857472694492626*^9}, 3.8574804037594547`*^9, 
   3.857501094655328*^9, 3.857516849912792*^9, 3.857576051021021*^9, 
   3.8576555441381083`*^9, 3.858277809642112*^9, 3.8593168414006863`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"8373b94f-1c31-4bbb-80d8-3f02e11437b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C0", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "xi"}], ")"}], "*", 
     RowBox[{"\[Sqrt]", "eta"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"gamma", " ", "*", " ", "PDmag"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.849223708053248*^9, 3.8492237739267*^9}, {
   3.849223846442931*^9, 3.849223853764793*^9}, 3.849226182585474*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"f70fc1ec-1064-4f8d-abc0-239fc9f6147e"],

Cell[BoxData[
 RowBox[{"5.3872053872053876`", " ", 
  SqrtBox["eta"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "xi"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.849223753053329*^9, 3.849223774687063*^9}, 
   3.849223854290183*^9, 3.84922574320051*^9, 3.850701375727846*^9, 
   3.851905047209949*^9, 3.851936721082013*^9, 3.852099772361622*^9, 
   3.852099844108412*^9, 3.8521002307360287`*^9, 3.8521006559626217`*^9, 
   3.852102746978696*^9, 3.856790504173339*^9, 3.85730601175943*^9, 
   3.8573167929904537`*^9, 3.857472552836114*^9, {3.857472670934044*^9, 
   3.857472694521986*^9}, 3.857480403780107*^9, 3.857501094677631*^9, 
   3.857516849943925*^9, 3.857576051044137*^9, 3.857655544177868*^9, 
   3.858277809669621*^9, 3.8593168414173393`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"fb89c733-b1c8-449e-94b4-11b660e4474c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", "R", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "*", "xi", "*", 
      RowBox[{"\[Sqrt]", "eta"}]}], ")"}]}], " ", "+", " ", "1"}]}]], "Input",\

 CellChangeTimes->{{3.849226186211618*^9, 3.849226186875786*^9}, {
  3.849226250144167*^9, 3.849226293458448*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"85ef7205-228e-415f-b9bf-18221a3da00d"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["0.020479791869059665`", 
   RowBox[{
    SqrtBox["eta"], " ", "xi"}]]}]], "Output",
 CellChangeTimes->{
  3.8492262940218143`*^9, 3.850701377522674*^9, 3.851905049139789*^9, 
   3.851936722133545*^9, 3.8520997723946323`*^9, 3.852099844143053*^9, 
   3.8521002307702217`*^9, 3.852100655992138*^9, 3.852102747009639*^9, 
   3.856790504205595*^9, 3.857306011766062*^9, 3.857316793006888*^9, 
   3.857472552852109*^9, {3.857472670961937*^9, 3.857472694552032*^9}, 
   3.8574804038061934`*^9, 3.857501094699827*^9, 3.85751684997482*^9, 
   3.857576051069744*^9, 3.857655544198162*^9, 3.8582778097079563`*^9, 
   3.85931684143606*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"e14845a8-9d56-4bb5-ba6d-62f626e52741"]
}, Open  ]],

Cell["\<\
According to the argument in the paper, the solution at convergence (using \
their update rule) is the same as wstar that we computed earlier. We observe \
how their bounds affect the solution we obtain.
We begin by characterizing the norm of Phi and checking if it is less than C0\
\
\>", "Text",
 CellChangeTimes->{{3.8492263073774*^9, 3.849226309560997*^9}, {
   3.849226482746068*^9, 3.849226512310842*^9}, {3.849226682428059*^9, 
   3.8492268044376593`*^9}, {3.849227356524188*^9, 3.8492274473147287`*^9}, 
   3.8492394646068707`*^9},ExpressionUUID->"5c884862-9353-4457-865d-\
a8ace985d6ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"normPhi", "=", 
  RowBox[{"Norm", "[", 
   RowBox[{"Phi", " ", "/.", 
    RowBox[{"epsilon", "->", " ", "0.0001"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.849227449431527*^9, 3.849227468915894*^9}, {
  3.849227699460227*^9, 3.849227706255477*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"b08801e0-da32-42f5-97da-a57412192e06"],

Cell[BoxData["1.2455761799263823`"], "Output",
 CellChangeTimes->{{3.849227452177429*^9, 3.849227469579544*^9}, 
   3.8492277069235287`*^9, 3.8507013792055902`*^9, 3.85190505083984*^9, 
   3.851936723710091*^9, 3.852099772428157*^9, 3.852099844179337*^9, 
   3.852100230804193*^9, 3.852100656019567*^9, 3.8521027470417433`*^9, 
   3.856790504239738*^9, 3.8573060117917347`*^9, 3.857316793023201*^9, 
   3.857472552871323*^9, {3.857472670981306*^9, 3.857472694580723*^9}, 
   3.8574804038312807`*^9, 3.857501094721839*^9, 3.8575168500059633`*^9, 
   3.8575760510918283`*^9, 3.857655544237101*^9, 3.858277809740168*^9, 
   3.859316841454454*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"33608974-900c-415b-9eab-8e1a797aafd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C0", " ", "/.", " ", "worstp"}], " ", "/.", 
  RowBox[{"{", 
   RowBox[{"epsilon", "->", "0.0001"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.84922757317408*^9, 3.84922765222927*^9}, 
   3.8492276856556787`*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"ef94ac2f-459e-4752-ad59-fb91f21b3fd6"],

Cell[BoxData[
 RowBox[{"5.3872053872053876`", " ", 
  SqrtBox["eta"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "xi"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.849227574214419*^9, 3.84922760166535*^9}, {
   3.849227632399194*^9, 3.849227652607373*^9}, 3.849227687134371*^9, 
   3.8507013824279757`*^9, 3.851905052531137*^9, 3.851936725075316*^9, 
   3.852099772459573*^9, 3.8520998442154913`*^9, 3.8521002308383217`*^9, 
   3.852100656048534*^9, 3.852102747073324*^9, 3.856790504273472*^9, 
   3.857306011810171*^9, 3.857316793044661*^9, 3.857472552936838*^9, {
   3.857472671010377*^9, 3.857472694675075*^9}, 3.857480403858707*^9, 
   3.857501094743841*^9, 3.857516850036542*^9, 3.857576051125143*^9, 
   3.857655544283999*^9, 3.858277809767963*^9, 3.859316841472259*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"bb8c812f-1896-4bd5-ba80-1a4b5aed7a3f"]
}, Open  ]],

Cell[TextData[{
 "This means that any value of xi imposes a ",
 StyleBox["minimum",
  FontSlant->"Italic"],
 " corresponding value of eta:"
}], "Text",
 CellChangeTimes->{{3.849227709613956*^9, 3.8492277264689283`*^9}, {
  3.849228097758119*^9, 3.849228107177833*^9}, {3.849228141877121*^9, 
  3.849228142364587*^9}},ExpressionUUID->"9f6f2e5f-2b8b-4c87-b438-\
bcc0dc6cdd25"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", " ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"C0", " ", "/.", " ", "worstp"}], " ", "/.", 
      RowBox[{"{", 
       RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ")"}], ">=", "normPhi"}],
    ",", " ", "eta"}], "]"}]], "Input",
 CellChangeTimes->{{3.849227729946102*^9, 3.8492279146950693`*^9}, {
  3.8492280130056543`*^9, 3.849228078520965*^9}, {3.849230157744372*^9, 
  3.84923020594226*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"d9ca7456-dafb-4375-8cb1-bef6d37ec507"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 69, 39, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.849227837661643*^9, 3.849227886843301*^9}, 
   3.849228078955652*^9, {3.8492301685488977`*^9, 3.849230206956881*^9}, 
   3.8519050551744833`*^9, 3.8519367269416227`*^9, 3.8520997728867073`*^9, 
   3.852099844251237*^9, 3.8521002308779087`*^9, 3.852100656080216*^9, 
   3.852102747104127*^9, 3.856790504638507*^9, 3.8573060118346157`*^9, 
   3.857316793479281*^9, 3.8574725529528637`*^9, {3.85747267102853*^9, 
   3.857472694707924*^9}, 3.857480403928329*^9, 3.857501094813635*^9, 
   3.85751685008246*^9, 3.8575760511740303`*^9, 3.857655544328252*^9, 
   3.8582778098251467`*^9, 3.859316841533719*^9},
 CellLabel->
  "During evaluation of \
In[69]:=",ExpressionUUID->"c7e2cb04-b7ea-4a36-9812-7e4cfc0b1edf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xi", "<", "1.`"}], "&&", 
  RowBox[{"eta", "\[GreaterEqual]", 
   FractionBox["3.874611272331307`*^20", 
    RowBox[{"7.247940436962634`*^21", "-", 
     RowBox[{"1.4495880873925268`*^22", " ", "xi"}], "+", 
     RowBox[{"7.247940436962634`*^21", " ", 
      SuperscriptBox["xi", "2"]}]}]]}]}]], "Output",
 CellChangeTimes->{{3.849227743505438*^9, 3.849227886857911*^9}, 
   3.849228078964304*^9, {3.84923016858206*^9, 3.849230206968162*^9}, 
   3.8519050551803427`*^9, 3.851936726947274*^9, 3.8520997728915*^9, 
   3.852099844261554*^9, 3.8521002308864107`*^9, 3.8521006560888853`*^9, 
   3.852102747113085*^9, 3.856790504644562*^9, 3.857306011841007*^9, 
   3.857316793487597*^9, 3.857472553027431*^9, {3.8574726710421352`*^9, 
   3.8574726947703543`*^9}, 3.857480403937771*^9, 3.857501094825633*^9, 
   3.857516850095557*^9, 3.857576051187708*^9, 3.857655544340873*^9, 
   3.8582778098372793`*^9, 3.859316841540921*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"fbfd1877-eaa5-4e3e-ba3e-458b07bf3bc4"]
}, Open  ]],

Cell["\<\
We select the smallest Rb1 and Rb2 that are consistent with Theorem 2:\
\>", "Text",
 CellChangeTimes->{{3.849228900057934*^9, 3.849228916362286*^9}, {
  3.849231137171465*^9, 
  3.849231144943844*^9}},ExpressionUUID->"dad3cd92-997e-4fbe-8efc-\
d56e1b0252c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rb1", "=", " ", "C1"}]], "Input",
 CellChangeTimes->{{3.8492288235256844`*^9, 3.849228829969809*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"219f834b-b303-4139-82f9-3921202d44db"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["0.020479791869059665`", 
   RowBox[{
    SqrtBox["eta"], " ", "xi"}]]}]], "Output",
 CellChangeTimes->{
  3.8492288304113092`*^9, 3.850701385968719*^9, 3.851905059820984*^9, 
   3.8519367285507307`*^9, 3.852099772920878*^9, 3.852099844268015*^9, 
   3.8521002309142237`*^9, 3.852100656114396*^9, 3.852102747138628*^9, 
   3.856790504667659*^9, 3.857306011860443*^9, 3.857316793506567*^9, 
   3.8574725530431013`*^9, {3.857472671058221*^9, 3.857472694796215*^9}, 
   3.857480403957632*^9, 3.857501094847803*^9, 3.8575168501263866`*^9, 
   3.857576051218335*^9, 3.857655544380146*^9, 3.858277809865609*^9, 
   3.85931684155716*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"cf8dfd67-f97c-4f6b-8a03-e9f480c86818"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rb2", " ", "=", " ", 
  RowBox[{"Rb1", "-", "xi"}]}]], "Input",
 CellChangeTimes->{{3.849228850940908*^9, 3.849228881117598*^9}, {
  3.8492311162320757`*^9, 3.849231116825885*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"b617c962-f870-4641-b9c3-42869806c20c"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["0.020479791869059665`", 
   RowBox[{
    SqrtBox["eta"], " ", "xi"}]], "-", "xi"}]], "Output",
 CellChangeTimes->{{3.849228871622588*^9, 3.8492288815175123`*^9}, 
   3.849231117914403*^9, 3.8492311500960073`*^9, 3.850701387114684*^9, 
   3.8519050613331223`*^9, 3.851936730077071*^9, 3.852099772957048*^9, 
   3.8520998443004932`*^9, 3.8521002309484873`*^9, 3.852100656141938*^9, 
   3.852102747169883*^9, 3.856790504686756*^9, 3.857306011886046*^9, 
   3.8573167935267143`*^9, 3.8574725530622473`*^9, {3.857472671077725*^9, 
   3.857472694825411*^9}, 3.857480403983822*^9, 3.857501094869968*^9, 
   3.8575168501569233`*^9, 3.8575760512487926`*^9, 3.8576555444215727`*^9, 
   3.858277809893696*^9, 3.859316841573344*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"1f7baee8-f016-4013-9334-8f3a05973f48"]
}, Open  ]],

Cell["Compute the error bounds offered by Theorem 2:", "Text",
 CellChangeTimes->{{3.849229136111692*^9, 
  3.849229155555345*^9}},ExpressionUUID->"c2177907-e778-4596-bdb2-\
268e3c25552e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"maxSVPhi", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"SingularValueList", "[", 
    RowBox[{"Phi", " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.849228925569405*^9, 3.849229018134386*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"1768a9d6-241b-40fd-8f7a-c2c99874b032"],

Cell[BoxData["1.2455761799263823`"], "Output",
 CellChangeTimes->{{3.849229003132715*^9, 3.84922901870242*^9}, 
   3.850701389451898*^9, 3.851905063783339*^9, 3.851936732078228*^9, 
   3.852099772992675*^9, 3.852099844331588*^9, 3.852100230982217*^9, 
   3.852100656172473*^9, 3.8521027471996813`*^9, 3.856790504723239*^9, 
   3.8573060119191217`*^9, 3.857316793546501*^9, 3.8574725530813837`*^9, {
   3.857472671097369*^9, 3.8574726948543367`*^9}, 3.857480404011506*^9, 
   3.857501094901369*^9, 3.8575168501775713`*^9, 3.8575760512796087`*^9, 
   3.857655544464883*^9, 3.858277809922344*^9, 3.859316841592664*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"949dec18-a5c6-409f-b8ba-461b4b456ddc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minSVPhi", " ", "=", " ", 
  RowBox[{"Last", "[", 
   RowBox[{"Rest", "[", 
    RowBox[{"SingularValueList", "[", 
     RowBox[{"Phi", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.849229020563274*^9, 3.849229057227251*^9}, {
  3.849229128700222*^9, 3.8492291291824293`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"a6fa4b06-5a3c-45cd-948d-e764a93beb88"],

Cell[BoxData["1.`"], "Output",
 CellChangeTimes->{
  3.849229058786516*^9, 3.849229129637862*^9, 3.850701390550042*^9, 
   3.851905065418401*^9, 3.851936734072872*^9, 3.8520997730309343`*^9, 
   3.852099844368185*^9, 3.852100231016223*^9, 3.852100656202784*^9, 
   3.852102747231771*^9, 3.8567905047456627`*^9, 3.8573060119458647`*^9, 
   3.8573167935658083`*^9, 3.857472553105345*^9, {3.857472671117222*^9, 
   3.8574726948830976`*^9}, 3.857480404041073*^9, 3.857501094925088*^9, 
   3.8575168502616158`*^9, 3.8575760513108797`*^9, 3.857655544507197*^9, 
   3.8582778099504766`*^9, 3.859316841608938*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"33febf6d-664c-4ab2-9ab3-41afbdf7deda"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minSVDm", "=", 
  RowBox[{"Last", "[", 
   RowBox[{"SingularValueList", "[", 
    RowBox[{
     RowBox[{"Dm", "/.", "worstp"}], "/.", 
     RowBox[{"{", 
      RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8492290718743057`*^9, 3.8492291252475033`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"4a28e982-bf4d-4b2f-b7a6-0d36ad56c406"],

Cell[BoxData["0.28491651945980034`"], "Output",
 CellChangeTimes->{{3.849229083986794*^9, 3.849229125659301*^9}, 
   3.850701391264164*^9, 3.8519050672126923`*^9, 3.851936735611312*^9, 
   3.8520997730676107`*^9, 3.852099844404442*^9, 3.852100231050283*^9, 
   3.852100656233265*^9, 3.852102747239153*^9, 3.856790504779299*^9, 
   3.8573060119652643`*^9, 3.857316793585273*^9, 3.857472553133648*^9, {
   3.857472671145753*^9, 3.8574726949230003`*^9}, 3.857480404068763*^9, 
   3.857501094947404*^9, 3.857516850284604*^9, 3.857576051360557*^9, 
   3.857655544551165*^9, 3.858277809978446*^9, 3.859316841625333*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"0d083e57-500c-40a2-9ad3-a3b686463da3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"projV", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Phi", ".", 
     RowBox[{"Inverse", "[", 
      RowBox[{
       RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], "]"}], ".", 
     RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "V"}], "/.", "worstp"}],
    " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{"epsilon", "->", "0.0001"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.849229438081505*^9, 3.8492296017918673`*^9}, {
   3.849229710050251*^9, 3.8492298472007713`*^9}, 3.852100636003827*^9, 
   3.8521027350904408`*^9},
 CellLabel->"In[75]:=",ExpressionUUID->"55b3056c-0c14-4d51-addf-f6aa92e23008"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.999941860980736`", "}"}], ",", 
   RowBox[{"{", "0.9999418609807359`", "}"}], ",", 
   RowBox[{"{", "1.050138942401969`", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.849229496239566*^9, 3.849229526199629*^9}, 
   3.8492295572766533`*^9, 3.849229602198738*^9, {3.849229713728821*^9, 
   3.849229809425975*^9}, {3.849229839825973*^9, 3.849229847639196*^9}, 
   3.85070139198013*^9, 3.851905068608096*^9, 3.851936737119659*^9, 
   3.852099773101906*^9, 3.852099844440209*^9, 3.8521002310849657`*^9, 
   3.8521006563025827`*^9, {3.8521027361950502`*^9, 3.852102747275936*^9}, 
   3.856790504814085*^9, 3.857306011990404*^9, 3.857316793604648*^9, 
   3.857472553168241*^9, {3.857472671177698*^9, 3.857472694964941*^9}, 
   3.85748040408543*^9, 3.8575010949746637`*^9, 3.857516850323882*^9, 
   3.8575760513957233`*^9, 3.857655544593607*^9, 3.858277810007402*^9, 
   3.8593168416440353`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"5e308794-3c86-41ee-abf0-059fde509178"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"errb", "=", " ", 
  RowBox[{
   RowBox[{"1", "/", "xi"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"maxSVPhi", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"minSVPhi", "^", "4"}], "*", 
         RowBox[{"minSVDm", "^", "2.5"}]}], ")"}]}], "*", 
      RowBox[{"Norm", "[", "P", "]"}], "*", "eta"}], " ", "+", " ", 
     RowBox[{"Norm", "[", 
      RowBox[{"projV", "-", "V"}], "]"}]}], " ", ")"}]}]}]], "Input",
 CellChangeTimes->{{3.849229182412328*^9, 3.849229310227316*^9}, {
  3.849229356684517*^9, 3.84922936114217*^9}, {3.849229424573689*^9, 
  3.8492294336208076`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"3f95c447-6a5a-4413-805c-24c87a2d4941"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.00016144745952430403`", "\[VeryThinSpace]", "+", 
   RowBox[{"37.97718532677118`", " ", "eta"}]}], "xi"]], "Output",
 CellChangeTimes->{{3.849229227278161*^9, 3.8492292553713293`*^9}, {
   3.849229426405964*^9, 3.849229435571239*^9}, 3.8492298853098803`*^9, 
   3.850701392721384*^9, 3.8519050700286694`*^9, 3.851936738668301*^9, 
   3.8520997731361523`*^9, 3.852099844476409*^9, 3.8521002311188087`*^9, 
   3.852100656349221*^9, 3.852102747301917*^9, 3.856790504849345*^9, 
   3.8573060120132723`*^9, 3.857316793623885*^9, 3.857472553284799*^9, {
   3.857472671198724*^9, 3.857472694993876*^9}, 3.8574804040998*^9, 
   3.857501094999814*^9, 3.8575168503577013`*^9, 3.857576051432226*^9, 
   3.857655544635811*^9, 3.858277810036289*^9, 3.859316841659939*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"c22a6dda-2852-4ef8-9727-68e95c77b2b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", " ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"C0", " ", "/.", " ", "worstp"}], " ", "/.", 
      RowBox[{"{", 
       RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ")"}], ">=", "normPhi"}],
    ",", " ", "eta"}], "]"}]], "Input",
 CellChangeTimes->{{3.849230258480338*^9, 3.8492302764955683`*^9}, {
   3.849231000250201*^9, 3.8492310845939083`*^9}, 3.849234489503236*^9, {
   3.8492347399243813`*^9, 3.849234767867324*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"31d28856-4785-4108-ae0e-f42d1a5e45f2"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 77, 40, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.849230301517528*^9, {3.849231005140409*^9, 3.849231085004921*^9}, 
   3.8492344902295*^9, {3.8492347519856157`*^9, 3.849234768180916*^9}, 
   3.8519050720869093`*^9, 3.851936740311975*^9, 3.852099773171507*^9, 
   3.852099844514086*^9, 3.852100231152742*^9, 3.852100656396842*^9, 
   3.852102747331308*^9, 3.856790504885697*^9, 3.857306012036401*^9, 
   3.8573167936466312`*^9, 3.85747255333005*^9, {3.8574726712325287`*^9, 
   3.8574726950355177`*^9}, 3.857480404127358*^9, 3.85750109511279*^9, 
   3.85751685039813*^9, 3.857576051487412*^9, 3.857655544678494*^9, 
   3.8582778100703287`*^9, 3.8593168416851254`*^9},
 CellLabel->
  "During evaluation of \
In[77]:=",ExpressionUUID->"242d2fa6-39d2-424d-8232-47320a0db514"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xi", "<", "1.`"}], "&&", 
  RowBox[{"eta", "\[GreaterEqual]", 
   FractionBox["3.874611272331307`*^20", 
    RowBox[{"7.247940436962634`*^21", "-", 
     RowBox[{"1.4495880873925268`*^22", " ", "xi"}], "+", 
     RowBox[{"7.247940436962634`*^21", " ", 
      SuperscriptBox["xi", "2"]}]}]]}]}]], "Output",
 CellChangeTimes->{
  3.849230301527418*^9, {3.8492310051537333`*^9, 3.849231085012735*^9}, 
   3.849234490240834*^9, {3.849234751994648*^9, 3.8492347681922398`*^9}, 
   3.851905072093389*^9, 3.851936740320527*^9, 3.852099773178564*^9, 
   3.8520998445227118`*^9, 3.852100231161499*^9, 3.852100656405707*^9, 
   3.852102747337605*^9, 3.856790504903079*^9, 3.857306012046563*^9, 
   3.857316793654413*^9, 3.8574725533426943`*^9, {3.8574726712467623`*^9, 
   3.857472695048624*^9}, 3.857480404135168*^9, 3.857501095127005*^9, 
   3.857516850412294*^9, 3.857576051502797*^9, 3.857655544692482*^9, 
   3.8582778100811777`*^9, 3.859316841691966*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"9c244b45-4e32-4e73-9388-d2663cbfc367"]
}, Open  ]],

Cell["Choosing the smallest value of eta:", "Text",
 CellChangeTimes->{{3.849235359326292*^9, 
  3.849235370408292*^9}},ExpressionUUID->"9bdf138b-750f-4bae-848c-\
3e9cf02c6e7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"etax", "=", 
  RowBox[{"5.69683066388115`*^30", "/", 
   RowBox[{"(", 
    RowBox[{"1.0548697178146854`*^32", "-", 
     RowBox[{"2.1097394356293708`*^32", " ", "xi"}], "+", 
     RowBox[{"1.0548697178146854`*^32", " ", 
      SuperscriptBox["xi", "2"]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.849234686880335*^9, 3.849234687967502*^9}, {
  3.849234720057695*^9, 3.8492347267524023`*^9}, {3.84923486459081*^9, 
  3.849234882531021*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"b19100a4-ae51-4436-afca-432893e2c7d9"],

Cell[BoxData[
 FractionBox["5.69683066388115`*^30", 
  RowBox[{"1.0548697178146854`*^32", "-", 
   RowBox[{"2.1097394356293708`*^32", " ", "xi"}], "+", 
   RowBox[{"1.0548697178146854`*^32", " ", 
    SuperscriptBox["xi", "2"]}]}]]], "Output",
 CellChangeTimes->{
  3.849234883013234*^9, 3.850701395373053*^9, 3.8519050740259438`*^9, 
   3.851936741759397*^9, 3.852099773208694*^9, 3.852099844554016*^9, 
   3.852100231189898*^9, 3.852100656430299*^9, 3.852102747366025*^9, 
   3.856790504927621*^9, 3.857306012066476*^9, 3.857316793673764*^9, 
   3.857472553364936*^9, {3.857472671262344*^9, 3.85747269507117*^9}, 
   3.857480404159494*^9, 3.857501095151938*^9, 3.857516850449095*^9, 
   3.857576051538171*^9, 3.857655544734275*^9, 3.858277810109744*^9, 
   3.8593168417081842`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"566aa2a8-82f1-4b1d-86c7-df558b5e7532"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"etax", ",", 
   RowBox[{"{", 
    RowBox[{"xi", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.849236426274413*^9, 3.849236438107893*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"907fe905-1c20-4aa5-88c8-69d8328e246c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVU3k4lAsfZUooWUIMH0XpykWuRIrO27V0K13SXkiWkqLIklTiU9lJJddS
qa5tLMkSaUFCqGEw4trCzLyz1Ni7lvh8f/ye85w/znnOeZ7z03C5YO9OERER
yVi8/+Med7K1intoR5xboH1sJg1LLVQu9lONQH/ofJKVS8PmR8lpxVRLKEl6
+e4opGHvp84X6dSD+NfYNG/8JQ1H3H68SaS64UxibqDnRxp6N922iKX6YdK8
oixSQMNjRdtbUdRwhIjFaN7ZnIdQieJfIqn3oP9QJYJZm4ejxzIKR0afYTM3
9Jm1TAFWLIQ67FIvhId7fJPt0UJo7f9Ovo8uwXzwBoI88hyBn02RPFGBWU3P
Iz/Vi6BUItcnKvoOf3Nczw6xilA2aNFMN6vB3LKH3eqfXqDGM131mKAWnvGH
Gx5UF2Nyg7lMvlc9dlYoOzPKSkCZpsmqajUih5J781JHKYwXnMsOFDSjO0Wr
P3KqDM3hRp/rdOh4cHpM3Uq7HGsS+NM531vgY63x+4f4CvB/9Pd1GDCgyLPu
JuZe4RmvslE6rg0F6W3x7bmvIa2WJRwebsfe8ulHvKC3iDlbevrxeibyt/9N
bttYhSmCNuwR0onjUWqKKb9Xw8+wtmT1+y+YeVQ1MO5ag/6C2uhWjW4Y7ugX
1r19j1nP9tSNV/5B8pkAwYTpB/y6U3z+dGUPtJJP/RP+vg67nmicKVLqg7nN
OD/mcQMC1U5qfnXox4yzzqfue43QFRxa0blvAFf//djlX9kMeZkRidqZAWSJ
uJwgT9Kx9F1q4bq0r7iqFPj0hlIrzhlVdknuHYQV71pbLJMB2m6Xx2+nBpHb
LspLbGvHJF9Flp00hOQrlIinM0yUHti15J7lMPSq3NpyyroQ8sfNRyXsYZwc
8pA4sJiT4eThYMAdxp8Dc12GDT1Y77+XmscfhhWj/KBqRw8aM+TuPh0ZBl22
yW2ZsAcKs+m3EmeGMTG1pclqXS+y88u8LkqzYOVxLP9ibC9aVpHbdY1Z8B6d
iHnu0QeN3j1fnt5kgd9EZLqqDyCqZnvhoQgW7thEWhVtGMBYlu4t8WgWdvh/
sxPbNIAaX2mjcwkspLom1VVhAG4SjHjDVBaiX+pyb54aQPbmY7uqn7MQpWy7
zDZzAPpRZ8r6/mHBblfOYektX7HNJPwe1ZCNR4NpjkKPQTBdqMbpRmxI/tq/
3s13EJfiCjrXmrCRQllnMhA8iDzWFxVtMzYCbaqOf48bhPo9vQxjazYuR5K+
rqWDoIwy8w8cZ0N1xCjv5ZIhNOVurI8NY6P8wbtIInMIDur0adE2NsaGk/Nf
LWVBmupbWtmxqC8qqjeTY6FaXtHH/wsbvbMhMo1qLGyQPEGSvWwofMl2XGbC
gnCczaSTbBirhnqLe7IQ9nG+OH2ejQPRxGUTBgvZfvrepjocDPSUEyU0NiYb
YwcvhnLQSaeZJ90i0bOiw2Puvxxkqz5cZ3ufRI3Nf4S3b3GQWrjWVvEZiYTP
ubMPoznIH2sp+1hNQodRr/DpPgdnfqPEtf8k4dQlumtjLgduRsrMG5e5qOP4
074yOAj1yxjJu8xDnvab37w6OBA0b3XfFMnD3bNLy//t5IB+OMau+i8enPmJ
tTK9HDTt7PsiX8nDzPfCXnMOB8N7FDr853nYNMWVSZnloFvPQxIRfCQvdfKz
X0/ijW1JWFC2APOuSltaN5CI9Wbpl74SwO19y6TtRhIFsga7KJ8EMAizCNyn
TyJAUlWxdVSAhgXtK39sJXFw+Fi6hdk3/JgZD9lhQ0LNzSghof0bDo9GRuv4
LfaqjXO7JC/EazsLm5wAEhVy3KDl2kJoPp+T0g4i4RHdIFVmJsR37wtxWtdJ
yDK1lfeeFuKm4OCdtREktALZjRdeCVHCWfNgdRqJbwGNhk6bRyDfV/qEUkvi
uiT9MJUcQZzUtWsv60gYiF/trpsYwfLtlkfPf1zMG7o6M0x0FJRkxkrmZxJR
d7XPaamOYmy/8HJOF4k89g5ZFdtRtHzQtrUTkgj3GTrXVjGKmPzU2XQVLrya
NIp0U8cg0ePCtFfjQljVrdiSM4bw5TpF4mu5UBd9XR9ePobgM+WnfbS4yFjr
cUOTOQZPjY5WSwMu5EfcbQ1XjeOP+9LZfCsu1AJWnn8dOw6xa6EHTX24GI31
UrC9O4GSUcH0u0tctOcFyxs+nYDb6aOPrAO46Hr8I+SX4gnU2m7iHQjmQpKT
Kr+nbQLhmr0h3je52FoTau+jMImlDVtpT//iwo3PtHdJmQRFfkRUuoYL1wSX
OVrpFF7cPpF1r5aLtiC6j3LDFFzm6mxU67lYX9J2IrV7CjWs9AfazVwYBK1d
y1qYQlj5Xj0LJhd2a4qDY/b+gKhT1tHLvMVdKl+SsuH8gEiOU+HgKh6+x97g
0H6bRp2g0/uRIg+PH6QaU3ZPI8Zgv76DMg+T9FeiQc7TUCq3yO9Q4+HDlM58
Q/w09Ou1aQ3aPHgfHdk3LZyGA2sss2AHD6ZrzNXaymZQoXH74RVPHqzN7YL3
OM/huruIk4kXD+eCVPoMrs7BMidIbeICDyvix64QyXNoMTif5uXPg5OEWk5P
yxxI7E9xvsHDzfNKI3KWP7HaSTXJOomHJwU9TysN5+GbUhi7qmbxj2xT5Zqo
IsTLuZTbNbU8MNK6qMd1RIg5p1uhvvU8mFzJeUXZLkLcXufoz2jm4WvGj78y
HESItLzljomdPGTEeVSoZogQH9666676xsOWzvJnhptECeUh1SY5ZT56ksyO
3TtFIRytxD9UqyxyrwWjBn8K8SRr7K2PGh8nLdJ81KIohO75jy9aNflY0Bgx
0iumEDsnA1Lu6PHx5e8FLd6yJYSnOOOsnAUfJllK4eqlS4g3v0ZIyHnzIdJy
prxeX4wwblf6lHiRjxpqtpmytRjx/GrWHYVLfGSTwwfiHcWIJ5/qVJQv89HH
crwzFiNGRFwQ01sTxscDey4z6ZsYYV8ctl8viY/OnJ+bM8uWEZxt11J2v+VD
2ztw+X1PCcJ5SOpkUxUf2+bEBy7eliC6o9PW7XvPx1U99s+QZxJEc09lnl0D
HxH0/8ya9ksQL67PvD3C4MM9nJ6lc0SSuFoTOOTO5oP5PUHFZ/9yQm6Pr26Y
tACH83RUgi9JEY+rZVZskxOg7aOCUW+KFGFgms8dlReAEc60uVMjRfypTWae
ogpAbxVKj69aSUQtc9LYuV4Av7bJxLKXK4ml73evFtkmwLW83IDVq2SIu9s4
Ey/NBBDnF+Yshwyh+SK87QIW/Uakip3PyxBExruEfksBdru+emfcIENcC9my
4p2tAAGO5n6Hfpclyh0MzSwPCZD52fzQaz9Z4n9QGRap
       "]]},
     Annotation[#, "Charting`Private`Tag$1578640#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 4.113999683282293}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.849236438891378*^9, 3.851905076269887*^9, 3.851936743317471*^9, 
   3.852099773252726*^9, 3.852099844602803*^9, 3.85210023123549*^9, 
   3.852100656469409*^9, 3.852102747417308*^9, 3.85679050498892*^9, 
   3.8573060121093187`*^9, 3.857316793710235*^9, 3.857472553401716*^9, {
   3.857472671300621*^9, 3.857472695117725*^9}, 3.857480404203925*^9, 
   3.857501095199849*^9, 3.85751685050653*^9, 3.857576051596274*^9, 
   3.8576555448508997`*^9, 3.858277810154089*^9, 3.859316841767015*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"4a4edfa3-9532-4157-80c5-9b61ce6c0d28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rb2", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{"eta", " ", "->", " ", "etax"}], "}"}]}], " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{"xi", "->", "0.5"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8492349339866333`*^9, 3.849234953760371*^9}, {
  3.849234986419565*^9, 3.849234991288494*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"89d93b94-7d4c-47dc-83e9-7a9cbb329804"],

Cell[BoxData["0.5881268599609144`"], "Output",
 CellChangeTimes->{
  3.849234954257453*^9, 3.849234991771347*^9, 3.851905078735067*^9, 
   3.851936746937923*^9, 3.852099773389716*^9, 3.852099844615193*^9, 
   3.852100231248005*^9, 3.852100656483189*^9, 3.8521027474324493`*^9, 
   3.85679050500051*^9, 3.857306012123742*^9, 3.857316793724793*^9, 
   3.857472553412586*^9, {3.857472671313854*^9, 3.857472695141054*^9}, 
   3.85748040421836*^9, 3.8575010952178993`*^9, 3.857516850534466*^9, 
   3.857576051625345*^9, 3.857655544877557*^9, 3.858277810177971*^9, 
   3.859316841780053*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"9b17c476-5c99-484a-8b59-6edfa044f38e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{
         RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", " ", 
       "worstp"}], "/.", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eta", "->", "etax"}], ",", " ", 
        RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"xi", "<", "1"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"xi", ",", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.849234999878007*^9, 3.849235063107074*^9}, {
  3.849235101437149*^9, 3.849235116921464*^9}, {3.849235150685328*^9, 
  3.849235197887665*^9}, {3.8492352321125097`*^9, 3.849235276260251*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"928d5bc1-c3f8-4eac-9088-547a70eeba1c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl6F2Yhccb67Q+2O/QNS/rUuyxR7Gb+TY
rN4pOQXOj4hcuP7DxyVwPvf/xhh3ufVwvmrguxeHu7fA+eXnLO1nfNkJ54tv
EbzHyLgfzt/2yPnMeZtDcP6hrLnSkW+OwPlf1Wz51+Yeh/OZfq4WkFY9Beeb
/U/YFrzuDJx/psXk3DGt83C+/ITXP1e+uwDnv/5+/95Vg0tw/pJXu0/x9V2G
8/lkl79/8uQKnN+TuTVtgco1OP+bw+onGfXX4fwSoyNbxA7fgPPvrzvSfVHx
Fpz/O+vKbM2q23C+tiP7v7Tdd+B890WK6RvF7yHCSzZe6WHMfThf500o93Xf
B3C+MP8HjiO/EHyW/bPXK895COdnm+y+yen9CM5f7Zm0YN83BP/raymBZ9Me
w/lbg92Zp7g8gfPrPVrnb3mG4Cve9bqxuPUpnG9l3jJF0ugZnB8jd/4n42UE
/+up3kcFjc/h/BkscSVBKi8Q7r+3dRHTEQSftbYxxLLwJZzPsDJu/SOhV3B+
0az1vUKHEPy92h0cgnmv4XxBryKdJr43cP4d3QuXK/cg+Bvm2as8iXsL58eu
NxOU/YfgN7QubLyz6h2cv/aF7Gw+n/dwvlKLiAf7MgR/ujz31///EXwAuSSn
bw==
       "]]},
     Annotation[#, "Charting`Private`Tag$1578692#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 3.5227829907617076`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.856790507551106*^9, 3.8573060149249287`*^9, 3.8573167962543697`*^9, 
   3.8574725547325277`*^9, {3.857472672705474*^9, 3.857472696497402*^9}, 
   3.857480404588168*^9, 3.857501095599319*^9, 3.857516850951284*^9, 
   3.857576052074192*^9, 3.8576555452650557`*^9, 3.858277810556682*^9, 
   3.859316842143773*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"b45007ce-5fdc-479b-8b65-d41fa9e0a2d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd0HlYzfkXB/BL0UZ1E+aiISotIjFZolOjabVMokS0TEi/yERDDRKVlIRf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       "]]},
     Annotation[#, "Charting`Private`Tag$45454#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1.7607324254820458`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {1.7607324254820418`, 1.7613914953808538`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Input",
 CellChangeTimes->{{3.8521027698436737`*^9, 3.852102775665656*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"4bc72e86-9996-41a5-9715-731663700b6f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd0HlYzfkXB/BL0UZ1E+aiISotIjFZolOjabVMokS0TEi/yERDDRKVlIRf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       "]]},
     Annotation[#, "Charting`Private`Tag$45454#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1.7607324254820458`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {1.7607324254820418`, 1.7613914953808538`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8567905076558332`*^9, 3.857306014964801*^9, 3.8573167964092712`*^9, 
   3.857472554790656*^9, {3.857472672734786*^9, 3.857472696600274*^9}, 
   3.85748040462181*^9, 3.857501095630251*^9, 3.857516850996625*^9, 
   3.857576052126214*^9, 3.85765554531422*^9, 3.858277810657962*^9, 
   3.85931684218265*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"cdc86ca2-4b30-42c3-a4fa-d71cac109753"]
}, Open  ]],

Cell["\<\
We observe the same holds true across all values of xi.
\
\>", "Text",
 CellChangeTimes->{{3.8492352960141983`*^9, 
  3.849235332770989*^9}},ExpressionUUID->"d4e1b6d0-b59d-4d00-a4b3-\
8a4ea9a0e3b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"errb", " ", "/.", " ", "worstp"}], "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"eta", "->", "etax"}], ",", " ", 
      RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"xi", "<", "1"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.849241330205942*^9, 3.8492413317052097`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"3bfefe6d-d3f1-4163-a312-79e5b11bb407"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.00016144745952430403`", "\[VeryThinSpace]", "+", 
   FractionBox["2.1634959389744733`*^32", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1.0270685068751186`*^16", "-", 
       RowBox[{"1.0270685068751186`*^16", " ", "xi"}]}], ")"}], "2"]]}], 
  "xi"]], "Output",
 CellChangeTimes->{
  3.8492354563305492`*^9, 3.849241332211994*^9, 3.849241674679549*^9, 
   3.8519050824620123`*^9, 3.851936752262665*^9, 3.852099775624551*^9, 
   3.852099846571683*^9, 3.852100233319542*^9, 3.8521006586772842`*^9, 
   3.852102749662962*^9, 3.856790507669785*^9, 3.8573060149817953`*^9, 
   3.857316796429327*^9, 3.8574725548422337`*^9, {3.857472672782641*^9, 
   3.857472696653335*^9}, 3.857480404713204*^9, 3.857501095654777*^9, 
   3.85751685103071*^9, 3.8575760521713047`*^9, 3.857655545346916*^9, 
   3.858277810683138*^9, 3.8593168422043123`*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"c0de850e-3965-4517-8142-bae265d280e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"errb", " ", "/.", " ", "worstp"}], "/.", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eta", "->", "etax"}], ",", " ", 
         RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], ",", 
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{"xi", "<", "1"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"xi", ",", "0", ",", " ", "1"}], "}"}]}], "]"}], " "}]], "Input",\

 CellChangeTimes->{{3.849235384974339*^9, 3.849235425127812*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"b7ccc45b-dd3d-45a2-a6e4-d4299026d2a2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJw92nk8lN/3APBIpZRSEgqR+tCMQbYSnWMnlDUUkq1sKVlSStmTrUiIFpVQ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       "]]},
     Annotation[#, "Charting`Private`Tag$1578748#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 234.47701395277966`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.849235425664065*^9, 3.849235479973617*^9, 3.8519050842634773`*^9, 
   3.851936753699648*^9, 3.8520997756735907`*^9, 3.8520998466612453`*^9, 
   3.85210023337234*^9, 3.852100659092348*^9, 3.852102749706216*^9, 
   3.8567905077237873`*^9, 3.857306015042799*^9, 3.857316796481718*^9, 
   3.857472555565572*^9, {3.85747267349365*^9, 3.857472697411757*^9}, 
   3.8574804047543573`*^9, 3.857501095714559*^9, 3.8575168510979757`*^9, 
   3.857576052243411*^9, 3.857655545422185*^9, 3.858277810746241*^9, 
   3.859316842256772*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"858dd6d1-86dc-4fd6-b5fe-4aabdaba8497"]
}, Open  ]],

Cell["The minimum point is far larger than :", "Text",
 CellChangeTimes->{{3.849235485439364*^9, 3.8492354918072453`*^9}, {
  3.849236326225554*^9, 
  3.849236348755104*^9}},ExpressionUUID->"87c50419-d53e-47e1-9746-\
b670bda61ebb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"errb", " ", "/.", " ", "worstp"}], "/.", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eta", "->", "etax"}], ",", " ", 
         RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], ",", 
      RowBox[{"xi", ">", "0"}], ",", 
      RowBox[{"xi", "<", "1"}]}], "}"}], ",", "xi"}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.849235414054384*^9, 3.849235435703828*^9}, {
  3.849235498606791*^9, 3.8492356057786493`*^9}, {3.849235733805238*^9, 
  3.849235737680059*^9}, {3.849235769795548*^9, 3.849235816969952*^9}, {
  3.84923585858228*^9, 3.849235958155237*^9}, {3.8492360227842903`*^9, 
  3.849236027770672*^9}, {3.84923614341813*^9, 3.849236150454089*^9}, {
  3.849236187358982*^9, 3.849236236718905*^9}, {3.84923627683813*^9, 
  3.849236277262858*^9}, {3.849236307878079*^9, 3.849236335424588*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"5b6deb89-7faf-4296-9a1f-65777e68d1eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13.844466528513454`", ",", 
   RowBox[{"{", 
    RowBox[{"xi", "\[Rule]", "0.33334110604197786`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.849236238521689*^9, 3.849236281009281*^9, {3.849236319222187*^9, 
   3.849236335830426*^9}, 3.851905085674046*^9, 3.851936757120006*^9, 
   3.852099775816597*^9, 3.852099846707198*^9, 3.8521002334201593`*^9, 
   3.852100660921069*^9, 3.852102749771287*^9, 3.856790507855384*^9, 
   3.857306015113525*^9, 3.857316796607327*^9, 3.8574725556203117`*^9, {
   3.857472673543303*^9, 3.857472697465498*^9}, 3.857480405954381*^9, 
   3.857501095837322*^9, 3.857516851177642*^9, 3.8575760523302183`*^9, 
   3.857655545522455*^9, 3.858277810888867*^9, 3.859316842325946*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"ad93b93c-1bdb-4102-80e8-caa53b27953a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"etax", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"xi", "->", "0.333345"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.849241867750848*^9, 3.8492418794190893`*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"4ac9720d-97af-4d98-af67-f18740e1f712"],

Cell[BoxData["0.12151564704577028`"], "Output",
 CellChangeTimes->{{3.849241869025056*^9, 3.84924188008086*^9}, 
   3.8519050873105164`*^9, 3.8519367588790073`*^9, 3.852099775847864*^9, 
   3.852099846736361*^9, 3.852100233447206*^9, 3.852100661030016*^9, 
   3.852102749780987*^9, 3.856790507876581*^9, 3.85730601513389*^9, 
   3.857316796629355*^9, 3.857472555657349*^9, {3.857472673575988*^9, 
   3.8574726975024567`*^9}, 3.857480406103738*^9, 3.857501095870716*^9, 
   3.857516851209879*^9, 3.857576052377069*^9, 3.857655545564476*^9, 
   3.8582778109179*^9, 3.859316842344523*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"0d35b7de-68ad-426f-9232-490cda2f7e01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"errb", " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"xi", "->", "0.333345"}], ",", 
    RowBox[{"eta", "->", "0.121516"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8492419717023277`*^9, 3.849241993872089*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"b8aa1fb3-50fd-4537-ae23-d9c8470aa750"],

Cell[BoxData["13.844506741146411`"], "Output",
 CellChangeTimes->{
  3.849241994514045*^9, 3.851905088928833*^9, 3.851936760098473*^9, 
   3.8520997758807783`*^9, 3.852099846772152*^9, 3.852100233481089*^9, 
   3.852100661064701*^9, 3.852102749804454*^9, 3.856790507908101*^9, 
   3.85730601515371*^9, 3.857316796652844*^9, 3.857472555687261*^9, {
   3.857472673597913*^9, 3.85747269752883*^9}, 3.857480406132072*^9, 
   3.8575010959025717`*^9, 3.857516851282284*^9, 3.857576052413727*^9, 
   3.8576555456075172`*^9, 3.8582778109463873`*^9, 3.8593168423624687`*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"479d7a6f-3819-4c8f-8166-42e73c746939"]
}, Open  ]],

Cell["Checking that the true error is within the bounds:", "Text",
 CellChangeTimes->{{3.849242506486959*^9, 
  3.849242520601495*^9}},ExpressionUUID->"525b9682-ad3c-49e6-ae82-\
91af7a80c6a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
   "worstp"}], " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"epsilon", "->", "0.0001"}], ",", 
    RowBox[{"eta", "->", "0.121516"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.849242188202347*^9, 3.849242247885602*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"48f19b41-54fa-45e4-9e4f-caaf6689ca28"],

Cell[BoxData["1.7613914953808538`"], "Output",
 CellChangeTimes->{{3.849242189478546*^9, 3.8492422482556562`*^9}, 
   3.851905090564391*^9, 3.851936762833976*^9, 3.852099775914996*^9, 
   3.852099846810546*^9, 3.852100233514434*^9, 3.852100661096487*^9, 
   3.8521027498424797`*^9, 3.856790507949731*^9, 3.857306015185718*^9, 
   3.8573167966781054`*^9, 3.857472555735744*^9, {3.857472673639907*^9, 
   3.8574726976041193`*^9}, 3.8574804061643343`*^9, 3.857501095930687*^9, 
   3.857516851313806*^9, 3.857576052450961*^9, 3.857655545648033*^9, 
   3.858277810975356*^9, 3.859316842381832*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"a4948909-b603-4787-9957-1c9e768b866b"]
}, Open  ]],

Cell["Computing the value of wstar at this point:", "Text",
 CellChangeTimes->{{3.849242523145047*^9, 
  3.849242541716934*^9}},ExpressionUUID->"340e2303-a225-442e-ae40-\
a484f9250a5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", "wstar", "]"}], " ", "/.", "worstp"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"epsilon", "->", "0.0001"}], ",", 
    RowBox[{"eta", "->", "0.121516"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.849242499643175*^9, 3.849242500792622*^9}, {
  3.84924254484623*^9, 3.849242578921781*^9}, {3.849242671150135*^9, 
  3.849242676302492*^9}, {3.84924316380066*^9, 3.8492431697425623`*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"65eb187f-3005-4aa4-ad59-20c47f5a5391"],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{
  3.849242501253055*^9, {3.84924256237712*^9, 3.849242579466682*^9}, 
   3.849242676766467*^9, 3.849243170712391*^9, 3.8519050925047197`*^9, 
   3.851936764975441*^9, 3.852099775948189*^9, 3.8520998468484697`*^9, 
   3.852100233548725*^9, 3.852100661126699*^9, 3.852102749865055*^9, 
   3.856790507974325*^9, 3.8573060152056*^9, 3.8573167967001467`*^9, 
   3.857472555775588*^9, {3.857472673675202*^9, 3.857472697644774*^9}, 
   3.85748040617985*^9, 3.857501095956705*^9, 3.857516851344776*^9, 
   3.857576052489831*^9, 3.857655545688208*^9, 3.858277811004307*^9, 
   3.859316842402062*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"5256c272-3460-4a0d-8e7e-bf0b0ffab3f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rb2", " ", "/.", "worstp"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"epsilon", "->", "0.0001"}], ",", 
    RowBox[{"eta", "->", "0.121516"}], ",", " ", 
    RowBox[{"xi", "->", "0.333345"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8492426783703623`*^9, 3.849242699607204*^9}, {
  3.849243033544669*^9, 3.849243069466497*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"e31ab67a-f49d-4b73-aecc-c5a0bf6e2072"],

Cell[BoxData["0.8428992109661921`"], "Output",
 CellChangeTimes->{{3.8492426863307343`*^9, 3.849242700068234*^9}, 
   3.849243038472756*^9, 3.849243070315218*^9, 3.8519050940927*^9, 
   3.8519367665809803`*^9, 3.8520997759818707`*^9, 3.8520998468847237`*^9, 
   3.85210023358254*^9, 3.852100661155102*^9, 3.852102749893694*^9, 
   3.856790508006935*^9, 3.8573060152257547`*^9, 3.8573167967210217`*^9, 
   3.857472555838752*^9, {3.857472673709457*^9, 3.857472697687626*^9}, 
   3.857480406191044*^9, 3.857501095981656*^9, 3.857516851374949*^9, 
   3.857576052531892*^9, 3.8576555457254267`*^9, 3.8582778110329027`*^9, 
   3.859316842419149*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"53d794a6-8f94-4849-aca1-e219961090ca"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Understanding the looseness of the bounds", "Section",
 CellChangeTimes->{{3.850702221814774*^9, 
  3.8507022312817802`*^9}},ExpressionUUID->"c4a245ff-adb1-4243-9c92-\
6ba6de028642"],

Cell["\<\
We wish to understand why the bounds are so loose. The possible sources of \
looseness are
  (1) Representation error, (already excluded)
  (2) Large condition number of Phi, (affects bound in Thm. 2)
  (3) Smallest singular value of D is too small (affects bound in Thm. 2)
  (4) Poor choice of xi, (already excluded -- we choose xi that minimizes the \
bound)\
\>", "Text",
 CellChangeTimes->{{3.850701465857026*^9, 3.850701523431078*^9}, {
  3.850701812395013*^9, 3.85070187560406*^9}, {3.850701957693836*^9, 
  3.850701995153556*^9}, {3.8507020387504597`*^9, 3.850702062004599*^9}, {
  3.850702149730598*^9, 3.850702207634408*^9}, {3.850702519609345*^9, 
  3.850702569501753*^9}, {3.850704775071114*^9, 
  3.850704781927808*^9}},ExpressionUUID->"18c0b454-9ea3-4bf3-b579-\
69a40aeff206"],

Cell["Considering number (2):125", "Text",
 CellChangeTimes->{{3.850702210511484*^9, 3.850702236096148*^9}, 
   3.852102766932116*^9},ExpressionUUID->"976faf57-9699-40ac-97c6-\
ece891658997"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", 
  RowBox[{"Phi", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{"epsilon", "->", " ", "0.0001"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8507022392556133`*^9, 3.850702255861908*^9}, {
  3.850702296027088*^9, 3.850702305117766*^9}, {3.850702375801091*^9, 
  3.850702380121752*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"b4a642f4-d603-4278-9695-e10161449974"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.2455761799263823`", ",", "1.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.850702242549231*^9, 3.850702256400847*^9}, 
   3.850702380726747*^9, 3.85190509702195*^9, 3.8519369454316883`*^9, 
   3.852099776012848*^9, 3.8520998469203444`*^9, 3.852100233616399*^9, 
   3.852100661182802*^9, 3.8521027499193277`*^9, 3.8567905080396147`*^9, 
   3.8573060152464437`*^9, 3.8573167967420387`*^9, 3.857472555854464*^9, {
   3.857472673727294*^9, 3.8574726977060843`*^9}, 3.8574804061995687`*^9, 
   3.8575010960068502`*^9, 3.857516851406529*^9, 3.857576052578024*^9, 
   3.8576555457625837`*^9, 3.858277811062014*^9, 3.859316842439258*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"7423e32a-78c9-460d-ae9c-767f78987f21"]
}, Open  ]],

Cell["\<\
The condition number (in l2) is the ratio of the largest singular value to \
the smallest, which is 1.25:1. That contributes this fraction of the bound:\
\>", "Text",
 CellChangeTimes->{{3.8507023861674232`*^9, 3.85070241575951*^9}, {
  3.850702492612681*^9, 3.850702497673465*^9}, {3.8507025896440363`*^9, 
  3.8507026114646673`*^9}},ExpressionUUID->"4d237a51-9f14-4a44-be8c-\
bba1aa480276"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1.24558", "^", "2"}], " ", "*", " ", 
    RowBox[{"eta", " ", "/", "xi"}]}], ")"}], " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"xi", "->", "0.333345"}], ",", 
    RowBox[{"eta", "->", "0.121516"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.850702613461516*^9, 3.850702663150834*^9}, 
   3.852001054885633*^9},
 CellLabel->"In[92]:=",ExpressionUUID->"347c0a10-2037-4c2e-b64d-f0f35bf22c10"],

Cell[BoxData["0.5655653217692852`"], "Output",
 CellChangeTimes->{{3.850702629237588*^9, 3.850702663757963*^9}, 
   3.8519369470904818`*^9, 3.8520010551304073`*^9, 3.8520997760418253`*^9, 
   3.8520998469562683`*^9, 3.8521002336501827`*^9, 3.852100661210856*^9, 
   3.852102749948991*^9, 3.856790508072205*^9, 3.857306015269431*^9, 
   3.857316796762938*^9, 3.857472555881186*^9, {3.8574726737584248`*^9, 
   3.857472697730998*^9}, 3.8574804062213717`*^9, 3.857501096032267*^9, 
   3.8575168514378767`*^9, 3.857576052615844*^9, 3.8576555457998037`*^9, 
   3.858277811090461*^9, 3.8593168424586477`*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"6009379c-fb09-4072-a6a4-4a5913f63193"]
}, Open  ]],

Cell["Considering number (3):", "Text",
 CellChangeTimes->{{3.85070268857626*^9, 
  3.850702706132852*^9}},ExpressionUUID->"81b8e646-6d39-4382-8923-\
f98d160e4afe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eta", "/", 
    RowBox[{"minSVDm", "^", "2.5"}]}], "/", "xi"}], " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"xi", "->", "0.333345"}], ",", 
    RowBox[{"eta", "->", "0.121516"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.850702881361603*^9, 3.850702923784547*^9}, {
  3.8507047363341427`*^9, 3.85070473695156*^9}, {3.8507051334669247`*^9, 
  3.8507051401778316`*^9}, {3.8507051862955227`*^9, 3.850705205657653*^9}, {
  3.852001041918292*^9, 3.8520010494121447`*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"77456338-5120-437f-bc3f-7448e056b4f4"],

Cell[BoxData["8.412894523318009`"], "Output",
 CellChangeTimes->{{3.85070289229979*^9, 3.850702924480813*^9}, {
   3.850705133835446*^9, 3.850705143634749*^9}, {3.850705187477655*^9, 
   3.8507052068427973`*^9}, 3.8519369486774073`*^9, {3.852001042571854*^9, 
   3.852001049904314*^9}, 3.852099776070541*^9, 3.852099846991531*^9, 
   3.8521002336841097`*^9, 3.852100661240478*^9, 3.852102749977563*^9, 
   3.856790508104459*^9, 3.857306015293439*^9, 3.857316796784301*^9, 
   3.857472555904004*^9, {3.857472673774576*^9, 3.857472697758919*^9}, 
   3.857480406255028*^9, 3.857501096101856*^9, 3.8575168514692698`*^9, 
   3.857576052651207*^9, 3.857655545836972*^9, 3.858277811119247*^9, 
   3.85931684247862*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"fa4bc030-ab8d-48eb-a14d-0875e4cfe64f"]
}, Open  ]],

Cell["\<\
Its clear that this is indeed the largest contributor to the looseness of the \
bound.\
\>", "Text",
 CellChangeTimes->{{3.850705218802034*^9, 
  3.850705250343314*^9}},ExpressionUUID->"c91c4384-ea6a-4c63-aa0d-\
27b14e875c4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"SingularValueList", "[", "Dm", "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8507056627190332`*^9, 3.850705760360077*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"0f4b9ba3-d935-487f-9e74-e0d46274bdf2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwt1X9cTXccx/EbjSZS2bKbyiKjhFatNTXvFEq/rB+kCUmqhS3UmAetrJvm
V1ESFbUKad3b1u3OaGrVMlf0454jhnutzuHSrRtj0UY7Hvv8cR7Px+vxPZ/z
PY/H93Eexzbmi9ANo0Qi0U7heq3/Bm1n48PlC/538QJDH8skjdgV/2sHl1MF
RbXiRaQrAq51/1gsDicXISJ26Jcj4lgyHHfn7fU5KE4mY1Hy9rLMfeIMMhnp
RrUzvxXnkRlYGVkqG3xcTubBeCQ9ytdGRp7CjJABbfN+OVmO7dc/QsHTn8lK
TJabqQ0MGkgZFD0+be2eTeSPaEosnhKpayHlePbexxOrN18mf8KoF1WmU2Yo
yQtwG4lWhEnbyHq0Zbheb3VoJxswNafvReVAB9mIviGNmnXqIptQ/uii0uSQ
imyGifUZPccxZAsOfFYXV2J3g2zF315VXMLX3eRlJDu3yC2ab5K/QyNt2d9p
+wepxD+JTKH9ztvkVcxeOPZV3MU7ZBt8v7ON/2GymryO7dZrp/0ZpSHb4ahb
btwddI/swKSJg0Ytw/fIDhg2FMqmF/1JdmKj68Vbbwb0kF2oWhpTcunvHrIL
z/osTe/n95Iq1IX5js5bxJEMsgLOS6x8OZJBlI+9UcVSjmQwysV4giKYIxkE
m7db3FzJkQy0HSscrDZzJAPL4LiQ8qMcyaB/cbfKsYAjGTR+7Lei7gRHMoib
47Cq9RRHMqgdPxCrreRIBoFXU3Y4XuJIBl/7SU7J73Mkg641CVFODzmSgV1K
gPj7Po5koCw1yy0b5EgGb/1TnHlkmCMZnK1WbE4y4UkWw83HHXSmPMki6I9d
D+In8SSLJ2N81q19hydZeEa3hwdP40kWHeZaD0c3nmQxzf7q8zPuPMkiBdK6
6R48ycJyU/K8KV48yWLTnghdvjdPsmgomF9pvpgnWcT+Jpo+zp8nWShu92ok
gTzJ4s0nrUUGy3iSRZTRucjdITzJQmpz0OJFGE+yEH2QpEpewUOUPzXSQuiw
gLCcwZU8Pv0sUmMTzOL0OregTat4yD1zN8xcyuL5dvE47WoepqbX+uYtYuF/
6N/W9dHC+/aO2eoOFsXlmm80MTxaFV7Pveaz8O6seHkjnseu1XLDUCcWBxyc
H/+2hYf2XKF1shUL27v+N8skPC4tTlx2/imDfU0esuVZPHQ7s0rD9QyenHHM
HLufh1XN6b8GhfNt2mriujFHeJ5l7zF7DYNYo65s50Ie7vpV905cEc7TJdL3
1xoeNQVBW3afZDB3X7xCfZtHeZ9Trrcfg/kfZuSJne/jwOGhG22FKkTZtL8w
UN2HX/O68f9GCt+L8mBPUvoDWCRy821edqDAcE1yqJ0WJf175yo+b8ckdd13
o1q0kO+dlfJM34Y3dqeHf7TlIXTGw9WWHkqIKtfIeswfQRQl8U6RX8bWE7KD
5k2P4J6/8ErdUAt+mZ1lZPZ5H8aHaO5e9G2Cmf9Wxz0mOuyQbS4a2N+AO3M6
VF/V6/Du4dR171tdQM1J2HFr+pE2brRabVSH1TI3M+tX/XhH4v/l5Ik1SJOU
pt85NwDR2Qf8h6EVqNZaF5oE6hH9yLvIMTUfWcWSaHWwHqJlgXoXu3zEhvbP
kIbokVa73NtDeRRW9fU1QRFC70rQLrU4in3Zq1oPxOjRaHLINV6aiwS344/H
fSXMu9xqK1XnYFrGW35jTwv3D6mH56Rm4pX7rgndZ4VufFziqZTgVn9v1+kq
Yf5bQ98ACwlyImpXL/lBmLdyyE2QfoMRh9Btkno9vLxSZpep03CnM/vkaJWw
bj75vFPqlzifObRexQpd7mkYbJGCPI+19mU3hXaL+WSjdBsCKubKvdXCfp9W
ayvUSbiw49qV9IfC+pK9zm6pccif80F2iE7oxC5lknQ9tvQUhdvqhc62Xl+l
jsaswE2axqdC18TPXJi6AoYGTHnOkNDPX0Yo1J/gXp1HYvSw0GmzzCJSl6A+
sWye00uh3z3H7Ul1w7Gpxs9GRoQWibpe/5f/AzoAu+I=
       "]]},
     Annotation[#, "Charting`Private`Tag$1578818#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.3332503051974339}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.850705664848712*^9, 3.8507057610060463`*^9}, 
   3.851936950582356*^9, 3.852099776147423*^9, 3.8520998470394707`*^9, 
   3.852100233732781*^9, 3.8521006612861547`*^9, 3.852102750020898*^9, 
   3.856790508150625*^9, 3.85730601533116*^9, 3.857316796823345*^9, 
   3.857472555946068*^9, {3.8574726738100863`*^9, 3.857472697802847*^9}, 
   3.8574804063056498`*^9, 3.8575010961511927`*^9, 3.857516851520193*^9, 
   3.857576052709097*^9, 3.8576555458931704`*^9, 3.858277811165949*^9, 
   3.859316842563896*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"4d72a09a-b11f-4da0-a753-65c58ace9f48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"worstp", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"epsilon", "->", " ", "0.0001"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8507057912548*^9, 3.850705811558704*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"0e8bf7ae-8225-4ecd-95d3-0ffff2464f75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", "\[Rule]", "0.7150834805401997`"}], "}"}]], "Output",
 CellChangeTimes->{{3.850705792601428*^9, 3.850705811978163*^9}, 
   3.851936956998887*^9, 3.852099776181439*^9, 3.852099847053092*^9, 
   3.852100233745884*^9, 3.852100661298875*^9, 3.852102750033743*^9, 
   3.856790508164402*^9, 3.8573060153415947`*^9, 3.8573167968365517`*^9, 
   3.857472555957749*^9, {3.857472673822895*^9, 3.8574726978166533`*^9}, 
   3.8574804063181562`*^9, 3.857501096174869*^9, 3.857516851545376*^9, 
   3.857576052736279*^9, 3.8576555459191236`*^9, 3.858277811189962*^9, 
   3.859316842578247*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"aeab3b7a-e997-4d66-bc21-83f5b558518f"]
}, Open  ]],

Cell["\<\
We note that we select the p close to the highest value, and therefore with \
the smallest error.\
\>", "Text",
 CellChangeTimes->{{3.85070583549219*^9, 3.8507058626300583`*^9}, {
  3.850705936312693*^9, 
  3.850705981987569*^9}},ExpressionUUID->"05aa8c02-bea7-4a20-bd14-\
cfef7d3cc096"],

Cell["\<\
The ultimate source of the looseness of the error bound is Equation 24 in the \
paper, where the distance between the ridge-regularized projection \
$\\Pi^eta_{D_\\mu}$ and the unregularized projection $\\Pi_{D_\\mu}$ has \
bounds proportional to 1/(minSVDm^2.5). The large power associated with it \
comes from the matrix inversion inherent in the projection, which suggests \
that it is fundamental to the problem.\
\>", "Text",
 CellChangeTimes->{{3.850777409362114*^9, 3.850777424583817*^9}, {
  3.8507775827931623`*^9, 3.850777602434703*^9}, {3.8507776405834312`*^9, 
  3.850777819238703*^9}, {3.850777854532762*^9, 
  3.8507779469297323`*^9}},ExpressionUUID->"18bf51f9-6049-42a6-bcc8-\
506eaebb1484"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking against bounds in Kolter (2011)", "Section",
 CellChangeTimes->{{3.851903445897932*^9, 
  3.851903481738948*^9}},ExpressionUUID->"3eeb6e0f-64f2-4960-a3bd-\
9ec3c55da956"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Fmat", " ", "=", 
   RowBox[{"ArrayFlatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], ",", " ", 
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "P", ".", "Phi"}]}],
        "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", 
         RowBox[{"P", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], ",", 
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}]}], " ", 
       "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851907928479828*^9, 3.851907929147293*^9}, {
   3.85190824732447*^9, 3.8519082665662746`*^9}, {3.8519082995251637`*^9, 
   3.851908383027412*^9}, {3.851908457336536*^9, 3.851908474640737*^9}, 
   3.8519100979872417`*^9},
 CellLabel->"In[96]:=",ExpressionUUID->"596bc87a-22e9-47da-8189-83189b18c546"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fmat", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.851908486053336*^9, 3.851908496445801*^9}, {
  3.851908533161276*^9, 3.851908540901367*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"6dcf7e24-835f-4fbb-9e4c-dfd4127d8860"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"0.27573001`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       FractionBox["p", "2"]}], 
      RowBox[{
       RowBox[{"-", "0.27573001`"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"0.131275`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.26255`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}], "+", 
          RowBox[{"0.25`", " ", "p"}], "+", "0.`"}], ")"}]}], "+", 
       RowBox[{"0.125`", " ", "p"}], "+", "0.`"}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"0.131275`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}]}], "-", 
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.26255`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}], "+", 
          RowBox[{"0.25`", " ", "p"}], "+", "0.`"}], ")"}]}], "-", 
       RowBox[{"0.125`", " ", "p"}], "+", "0.`"}]},
     {
      RowBox[{
       RowBox[{"-", "0.27573001`"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"0.27573001`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       FractionBox["p", "2"]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"0.131275`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}]}], "+", 
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"0.26255`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}]}], "-", 
          RowBox[{"0.25`", " ", "p"}], "+", "0.`"}], ")"}]}], "-", 
       RowBox[{"0.125`", " ", "p"}], "+", "0.`"}], 
      RowBox[{
       RowBox[{"0.131275`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "-", 
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"0.26255`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}]}], "-", 
          RowBox[{"0.25`", " ", "p"}], "+", "0.`"}], ")"}]}], "+", 
       RowBox[{"0.125`", " ", "p"}], "+", "0.`"}]},
     {
      RowBox[{
       RowBox[{"0.269140005`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       RowBox[{"0.25627500000000003`", " ", "p"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"0.269140005`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}]}], "-", 
       RowBox[{"0.25627500000000003`", " ", "p"}]}], 
      RowBox[{
       RowBox[{"0.27573001`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       FractionBox["p", "2"]}], 
      RowBox[{
       RowBox[{"-", "0.27573001`"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"0.269140005`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}]}], "-", 
       RowBox[{"0.25627500000000003`", " ", "p"}]}], 
      RowBox[{
       RowBox[{"0.269140005`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       RowBox[{"0.25627500000000003`", " ", "p"}]}], 
      RowBox[{
       RowBox[{"-", "0.27573001`"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"0.27573001`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       FractionBox["p", "2"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.851908541193987*^9, 3.851910107507758*^9, 3.8519369723331833`*^9, 
   3.852099776246019*^9, 3.852099847133726*^9, 3.8521002338041286`*^9, 
   3.852100661353634*^9, 3.852102750089155*^9, 3.85679050822218*^9, 
   3.857306015401305*^9, 3.85731679689213*^9, 3.857472556022698*^9, {
   3.857472673871038*^9, 3.8574726978687267`*^9}, 3.857480406390361*^9, 
   3.857501096242548*^9, 3.857516851612905*^9, 3.857576052809784*^9, 
   3.8576555459974623`*^9, 3.858277811256933*^9, 3.859316842648398*^9},
 CellLabel->
  "Out[97]//TraditionalForm=",ExpressionUUID->"c8ca11fb-1bb8-4c2a-9852-\
83a4b6340267"]
}, Open  ]],

Cell["\<\
We use Sylvester\[CloseCurlyQuote]s criterion to find the region where the \
matrix is positive semi-definite. That is, we constrain the each leading \
principal minor to be non-negative: \
\>", "Text",
 CellChangeTimes->{{3.851909549583057*^9, 
  3.8519096181646547`*^9}},ExpressionUUID->"507c7550-1154-4d01-8be8-\
e71dbb3778df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "1"}], ",", 
          RowBox[{";;", "1"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "2"}], ",", 
          RowBox[{";;", "2"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "3"}], ",", 
          RowBox[{";;", "3"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "4"}], ",", 
          RowBox[{";;", "4"}]}], "]"}], "]"}], "]"}], ">=", "0"}]}], " ", "/.",
     " ", 
    RowBox[{"{", 
     RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ",", "p"}], "]"}]], "Input",\

 CellChangeTimes->{{3.852099934583878*^9, 3.852099941016217*^9}, {
  3.852102928568318*^9, 3.852102959833034*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"e4b08763-e472-41a6-89a5-892d80934eb1"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 98, 41, 21870497865953294483, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.8520999272229433`*^9, 3.852099944987948*^9}, 
   3.8521006613834743`*^9, 3.852102750116304*^9, {3.85210292488595*^9, 
   3.8521029606875763`*^9}, 3.8567905082835073`*^9, 3.857306015422822*^9, 
   3.8573167969179697`*^9, 3.857472556064418*^9, {3.8574726738946447`*^9, 
   3.857472697894055*^9}, 3.857480406413065*^9, 3.857501096275928*^9, 
   3.8575168516462507`*^9, 3.857576052849169*^9, 3.857655546038665*^9, 
   3.858277811291802*^9, 3.85931684267174*^9},
 CellLabel->
  "During evaluation of \
In[98]:=",ExpressionUUID->"e8149ff4-2e0d-425a-af60-d11e1b07d534"],

Cell[BoxData[
 RowBox[{"0", "\[LessEqual]", "p", "\[LessEqual]", 
  "0.5122427080284853`"}]], "Output",
 CellChangeTimes->{{3.852099927233952*^9, 3.8520999449934*^9}, 
   3.8521006613910637`*^9, 3.852102750123952*^9, {3.852102924895791*^9, 
   3.852102960697146*^9}, 3.85679050829634*^9, 3.857306015430421*^9, 
   3.857316796925297*^9, 3.857472556075935*^9, {3.85747267390047*^9, 
   3.8574726979028797`*^9}, 3.85748040642944*^9, 3.857501096288095*^9, 
   3.857516851658486*^9, 3.8575760528624*^9, 3.857655546050724*^9, 
   3.858277811302992*^9, 3.859316842681286*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"38353483-0039-4cd2-9fab-f5f8ce2fcfbf"]
}, Open  ]],

Cell["For comparison, we plot the error w.r.t. p:", "Text",
 CellChangeTimes->{{3.8519094188402977`*^9, 3.851909427078348*^9}, {
  3.851910915013558*^9, 3.851910925175963*^9}, {3.8519112883258038`*^9, 
  3.8519112915489407`*^9}},ExpressionUUID->"371e25ae-fd82-40ba-9f0d-\
fe959c3d4165"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"eta", "->", "0"}], ",", 
       RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851911293764407*^9, 3.851911409894691*^9}, 
   3.852103571023707*^9, 3.85210467306042*^9},
 CellLabel->"In[99]:=",ExpressionUUID->"329abe1e-5604-4965-87cb-94e24f5bd0fa"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVkmk0lQ0bhUuTUpKkjgZRx9RRCpUMu0LmKRRHGQuRoUNJSikzyStR5jrJ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       "]], LineBox[CompressedData["
1:eJwVk2k8lIsCxocUF3FJlK6KUkPRnO5JpY6naFFpsdw4HcRIyhWJihCJZuxj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       "]]},
     Annotation[#, "Charting`Private`Tag$1579037#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.041210946039941035`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{{3.851911321137301*^9, 3.851911412330983*^9}, 
   3.85193699074058*^9, 3.852099777260872*^9, 3.852099848110265*^9, 
   3.852100662234961*^9, 3.852102751056322*^9, 3.856790509271617*^9, 
   3.857306016501822*^9, 3.857316797883383*^9, 3.857472557030307*^9, {
   3.857472674861455*^9, 3.857472698885537*^9}, 3.8574804073895493`*^9, 
   3.85750109727466*^9, 3.8575168527488422`*^9, 3.8575760539524918`*^9, 
   3.857655547024604*^9, 3.85827781227661*^9, 3.859316843652584*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"821d2fdc-ca1d-4be3-9c85-d4e23ac093be"]
}, Open  ]],

Cell["\<\
This only includes the minimum point, and the area left of that.\
\>", "Text",
 CellChangeTimes->{{3.8519114216778183`*^9, 3.85191143645469*^9}, {
  3.851911482599098*^9, 3.851911501859661*^9}, {3.851937030837261*^9, 
  3.8519370543485107`*^9}, {3.85193761157966*^9, 
  3.851937613691976*^9}},ExpressionUUID->"dee46983-8aae-4533-af17-\
9e52795e31a3"]
}, Open  ]]
},
WindowSize->{756.3302752293578, 909.5779816513761},
WindowMargins->{{Automatic, 0.6605504587159885}, {
  18.32727272727277, Automatic}},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
Magnification->1.25,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"bb1490c5-5f3c-4cf8-9165-862e192eebb6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 485, 9, 71, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1068, 33, 3065, 87, 246, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[4136, 122, 847, 19, 51, "Output",ExpressionUUID->"5104f187-4e19-4e7f-8d43-44b4fce29d91"]
}, Open  ]],
Cell[4998, 144, 292, 5, 49, "Text",ExpressionUUID->"812d4f2f-d057-4141-99e9-0041d5ad4212"],
Cell[CellGroupData[{
Cell[5315, 153, 543, 12, 37, "Input",ExpressionUUID->"faa6cd96-61f9-4282-9bec-90ba810909ff"],
Cell[5861, 167, 1156, 20, 37, "Output",ExpressionUUID->"4c1ab01e-852f-4478-88d3-657a44b89120"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7054, 192, 281, 5, 28, "Text",ExpressionUUID->"0a5d41cb-08ef-4253-a74f-02384f62cb6a",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[7338, 199, 1081, 28, 107, "Input",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[8456, 232, 547, 15, 37, "Input",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],
Cell[9006, 249, 9661, 182, 304, "Output",ExpressionUUID->"abeec288-9a8a-49d1-b4c5-f6e379dec4c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18704, 436, 649, 17, 37, "Input",ExpressionUUID->"bcd75a85-a5a4-42fd-9cb7-137e413fd55f"],
Cell[19356, 455, 9247, 175, 283, "Output",ExpressionUUID->"15e46176-b6c2-4e4d-9735-6e5ba7c554a6"]
}, Open  ]],
Cell[28618, 633, 340, 7, 28, "Text",ExpressionUUID->"b68473c4-7500-40f5-b4cd-595e5657a2dd"],
Cell[CellGroupData[{
Cell[28983, 644, 450, 11, 37, "Input",ExpressionUUID->"dc5f2a33-f75d-4a97-b344-9c8f80707cd0"],
Cell[29436, 657, 1002, 23, 73, "Output",ExpressionUUID->"d21f7f3e-bde5-459c-83c1-e33c11085e6b"]
}, Open  ]],
Cell[30453, 683, 255, 6, 28, "Text",ExpressionUUID->"7033b8f7-5c56-45a1-9020-9cdc55035473"],
Cell[CellGroupData[{
Cell[30733, 693, 350, 8, 37, "Input",ExpressionUUID->"5bdad5e4-c535-41d4-86e1-438f5689798c"],
Cell[31086, 703, 5686, 142, 103, "Output",ExpressionUUID->"11d09330-7b64-44ea-9fec-816e429b50a8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36809, 850, 367, 9, 37, "Input",ExpressionUUID->"cd232872-1c0d-44f6-aeee-561c0d321f77"],
Cell[37179, 861, 2771, 74, 170, "Output",ExpressionUUID->"e3a3b6eb-4c1a-4808-b9da-94ee36385de3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39987, 940, 1418, 29, 84, "Input",ExpressionUUID->"ddc36145-3b67-4d74-862c-95c1485d4026"],
Cell[41408, 971, 2176, 48, 178, "Output",ExpressionUUID->"2fe555b3-bf64-408a-a4c4-1eb5b31b95d2"],
Cell[43587, 1021, 1102, 20, 55, "Message",ExpressionUUID->"1c729c7c-ee46-4e58-83a7-f1d8ca12b4df"],
Cell[44692, 1043, 3786, 83, 318, "Output",ExpressionUUID->"09a04cc5-4d22-4607-8112-d4072e364892"]
}, Open  ]],
Cell[48493, 1129, 626, 13, 29, "Text",ExpressionUUID->"68c02927-8995-4ff2-92f1-c3cf67351e08"],
Cell[CellGroupData[{
Cell[49144, 1146, 659, 15, 61, "Input",ExpressionUUID->"98262dbf-eb8f-4284-aeb0-7c6af0f34498"],
Cell[49806, 1163, 628, 11, 53, "Output",ExpressionUUID->"24f257ba-57b7-4f5b-825c-6089ae016a3e"]
}, Open  ]],
Cell[50449, 1177, 868, 15, 115, "Text",ExpressionUUID->"9372a6dc-d936-421c-a5b9-5b04ef5a2f28"],
Cell[CellGroupData[{
Cell[51342, 1196, 506, 10, 38, "Input",ExpressionUUID->"7a43fd6e-68fa-4ee0-ac0d-fd5668523f9b"],
Cell[51851, 1208, 865, 16, 55, "Message",ExpressionUUID->"c822cd98-16a2-4322-8e19-d0c849e7a5c6"],
Cell[52719, 1226, 662, 11, 37, "Output",ExpressionUUID->"987318d7-f790-4978-8b72-d33c1385f466"]
}, Open  ]],
Cell[53396, 1240, 269, 6, 28, "Text",ExpressionUUID->"640ca592-4f91-4a0e-a020-a72d3c17f606"],
Cell[CellGroupData[{
Cell[53690, 1250, 778, 18, 84, "Input",ExpressionUUID->"9ef8b13c-0cc5-455d-85aa-c449a64815f3"],
Cell[54471, 1270, 1181, 27, 80, "Output",ExpressionUUID->"434fa76b-1518-458d-b757-e9963d627c3e"],
Cell[55655, 1299, 598, 10, 53, "Output",ExpressionUUID->"c49eb9d6-6618-40c5-b49f-a2f5a01cc6eb"],
Cell[56256, 1311, 460, 6, 37, "Output",ExpressionUUID->"aa2c6828-a0a5-433a-8dde-eff140d5dcf4"]
}, Open  ]],
Cell[56731, 1320, 393, 8, 49, "Text",ExpressionUUID->"c5775ce9-1967-48e3-b4b7-1c3a68a8ead7"],
Cell[57127, 1330, 526, 10, 49, "Text",ExpressionUUID->"42e9981b-fe7f-47ca-8f02-72f01b84a7a6"],
Cell[CellGroupData[{
Cell[57678, 1344, 608, 14, 38, "Input",ExpressionUUID->"384975c1-82cb-4a73-ade9-f8ea171c33c5"],
Cell[58289, 1360, 3204, 77, 296, "Output",ExpressionUUID->"46817831-7006-4e04-b7f9-66a1f146339d"]
}, Open  ]],
Cell[61508, 1440, 227, 4, 28, "Text",ExpressionUUID->"fa7e48b4-31c0-4ef7-8927-a72b5e29cc3f"],
Cell[CellGroupData[{
Cell[61760, 1448, 798, 20, 61, "Input",ExpressionUUID->"4fa96cd1-2514-44b9-bc6e-64062f085508"],
Cell[62561, 1470, 12880, 232, 311, "Output",ExpressionUUID->"57998cf1-acd1-4a2f-80b5-5a0cd8f6736e"]
}, Open  ]],
Cell[75456, 1705, 387, 11, 29, "Text",ExpressionUUID->"0fce6435-269f-44f5-a0ab-dc5822fc0f10"],
Cell[CellGroupData[{
Cell[75868, 1720, 3961, 103, 246, "Input",ExpressionUUID->"dcfc786d-e210-46d1-a6e2-b7e71e847257"],
Cell[79832, 1825, 940, 14, 53, "Output",ExpressionUUID->"19e3e3c7-8189-42f1-9e1d-7e4de2356f6e"],
Cell[80775, 1841, 1088, 19, 55, "Message",ExpressionUUID->"92a4e997-a22d-4770-ad16-58986a8bc154"],
Cell[81866, 1862, 948, 14, 53, "Output",ExpressionUUID->"5529f149-df68-4f52-979f-00d8be1a36ac"],
Cell[82817, 1878, 12875, 231, 327, "Output",ExpressionUUID->"5f127c35-9a11-44fa-be37-160864e59197"],
Cell[95695, 2111, 12302, 222, 327, "Output",ExpressionUUID->"7fdc8b23-e349-4166-8d03-d8bdb5c71519"],
Cell[108000, 2335, 11348, 207, 316, "Output",ExpressionUUID->"8278a118-a202-4b07-b015-8a929c58b094"],
Cell[119351, 2544, 1652, 31, 109, "Output",ExpressionUUID->"c40e0421-3b3a-4fd5-98fe-3b3f85a67122"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121040, 2580, 348, 8, 38, "Input",ExpressionUUID->"b8da7614-51a0-4295-877a-3330f052b662"],
Cell[121391, 2590, 552, 12, 72, "Output",ExpressionUUID->"4ae9b890-1bb6-4227-b81b-f532e9164e5b"]
}, Open  ]],
Cell[121958, 2605, 307, 7, 49, "Text",ExpressionUUID->"046262f0-01d2-4dcd-8f82-de4ad9c95510"],
Cell[CellGroupData[{
Cell[122290, 2616, 1394, 33, 84, "Input",ExpressionUUID->"b388b0a9-680b-416b-a4ee-21e7861e7fc7"],
Cell[123687, 2651, 935, 21, 73, "Output",ExpressionUUID->"fc407a8a-98c4-4a41-8c49-8a99cf14e0c0"],
Cell[124625, 2674, 916, 22, 73, "Output",ExpressionUUID->"dda6527b-7506-4a59-b285-19745e5d1ab2"],
Cell[125544, 2698, 914, 22, 56, "Output",ExpressionUUID->"9302b5c6-e50f-4396-8d57-f41e96c21e71"]
}, Open  ]],
Cell[126473, 2723, 472, 12, 29, "Text",ExpressionUUID->"82694172-691a-45ef-b3f2-050eb48b1aea"],
Cell[CellGroupData[{
Cell[126970, 2739, 1207, 27, 61, "Input",ExpressionUUID->"e2aeaa24-e9ec-4214-858a-b0cab089b336"],
Cell[128180, 2768, 16398, 290, 327, "Output",ExpressionUUID->"4bdae7db-50a2-4f39-b445-9b7f7b9ba4e6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144615, 3063, 1039, 28, 61, "Input",ExpressionUUID->"8ba7b55c-6bc5-42ff-941e-99eae180a407"],
Cell[145657, 3093, 16089, 286, 327, "Output",ExpressionUUID->"f2756c09-33ad-4bdb-85a1-7f471b8ad37b"]
}, Open  ]],
Cell[161761, 3382, 172, 3, 28, "Text",ExpressionUUID->"dceee5c9-9f4f-4425-9f9d-811608577820"],
Cell[CellGroupData[{
Cell[161958, 3389, 718, 20, 61, "Input",ExpressionUUID->"3185ff6b-1caf-43bf-83ee-f8c764f824c6"],
Cell[162679, 3411, 18948, 351, 317, "Output",ExpressionUUID->"354c55fd-7890-4946-b82f-dc2e2d11d3e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181664, 3767, 957, 21, 84, "Input",ExpressionUUID->"913cd1ef-cd42-4142-a01a-9c5f5f9b0225"],
Cell[182624, 3790, 768, 15, 53, "Output",ExpressionUUID->"38a6ebfc-04a7-410b-a06c-045d410a456a"],
Cell[183395, 3807, 563, 8, 53, "Output",ExpressionUUID->"9ae23d40-57af-4659-8a8f-e2b61c5666ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183995, 3820, 589, 15, 61, "Input",ExpressionUUID->"e64992ff-23f2-4c4c-8790-5bdcc40f629a"],
Cell[184587, 3837, 709, 16, 72, "Output",ExpressionUUID->"ed1f15a6-8195-4b70-a039-c4b9e9ea2c44"],
Cell[185299, 3855, 507, 10, 53, "Output",ExpressionUUID->"319dfb53-fd23-42b7-89d4-ea19c9f4196f"]
}, Open  ]],
Cell[185821, 3868, 225, 5, 28, "Text",ExpressionUUID->"b387144a-fa38-495a-84e7-0adea06e3cc1"],
Cell[CellGroupData[{
Cell[186071, 3877, 1606, 44, 107, "Input",ExpressionUUID->"d7d198d5-3780-4b3a-8e6c-874468bcc587"],
Cell[187680, 3923, 539, 13, 54, "Output",ExpressionUUID->"8b1298a2-b676-489f-8f9e-9545aa3673d6"],
Cell[188222, 3938, 759, 23, 70, "Output",ExpressionUUID->"fc738786-9a49-4672-aeda-76771316cf53"],
Cell[188984, 3963, 677, 14, 55, "Message",ExpressionUUID->"a41e32a8-85e8-44bd-a891-b5559025595c"],
Cell[189664, 3979, 555, 14, 52, "Output",ExpressionUUID->"02de44f6-582c-41f4-aaad-731c1f6f4dd3"],
Cell[190222, 3995, 677, 14, 55, "Message",ExpressionUUID->"0792d6dc-d98e-4645-9d21-9bbace21cc99"],
Cell[190902, 4011, 1149, 27, 143, "Output",ExpressionUUID->"67a1e9f1-0a6e-4489-8b73-d3ce996ff3eb"]
}, Open  ]],
Cell[192066, 4041, 216, 5, 28, "Text",ExpressionUUID->"daf54fcd-116a-4333-965b-bdf1a7aa5ce1"],
Cell[CellGroupData[{
Cell[192307, 4050, 396, 9, 38, "Input",ExpressionUUID->"62276a82-738f-46df-8c9e-da238329b5bb"],
Cell[192706, 4061, 597, 12, 55, "Message",ExpressionUUID->"d19e451b-9efc-48e1-b0e3-3522337ace75"],
Cell[193306, 4075, 367, 6, 37, "Output",ExpressionUUID->"47eea5e7-ac86-4783-b317-881e27df7216"]
}, Open  ]],
Cell[193688, 4084, 177, 3, 28, "Text",ExpressionUUID->"72bb22e3-e21f-4252-a9c7-3dd94e5a6927"],
Cell[CellGroupData[{
Cell[193890, 4091, 433, 11, 37, "Input",ExpressionUUID->"defa34e2-02ba-46a6-81f1-574096315a82"],
Cell[194326, 4104, 518, 12, 53, "Output",ExpressionUUID->"090ed8ae-bf3a-440d-a3ab-02cc965e8a46"]
}, Open  ]],
Cell[194859, 4119, 230, 4, 36, "Text",ExpressionUUID->"430e8ff4-2c04-4ca9-9dfa-ef23b9af9df1"],
Cell[195092, 4125, 179, 3, 28, "Text",ExpressionUUID->"26abb32c-0fc0-4bd3-9ca1-afc027ee4d50"],
Cell[195274, 4130, 324, 5, 37, "Input",ExpressionUUID->"30533d03-ccdc-4c44-bf5b-838871dfa93d"],
Cell[CellGroupData[{
Cell[195623, 4139, 1175, 29, 84, "Input",ExpressionUUID->"af416148-ef11-45ec-a84d-a81779c1b9e7"],
Cell[196801, 4170, 550, 11, 55, "Message",ExpressionUUID->"19f0ff85-d76c-4011-800e-e30a8ea2f5f1"],
Cell[197354, 4183, 864, 18, 94, "Output",ExpressionUUID->"a882a40b-899d-4b8b-bd81-03db13bfdc87"],
Cell[198221, 4203, 5599, 115, 290, "Output",ExpressionUUID->"8ea96b97-b5d9-4a13-ae66-62f95d3c4af2"]
}, Open  ]],
Cell[203835, 4321, 105, 1, 37, "Input",ExpressionUUID->"93bbeacc-e1e6-4552-98f8-49e8c5b7ebc2"],
Cell[203943, 4324, 270, 5, 36, "Text",ExpressionUUID->"49e5a37e-0169-45ff-a08f-72bee4e298bf"],
Cell[CellGroupData[{
Cell[204238, 4333, 1143, 27, 107, "Input",ExpressionUUID->"84cf486f-8b3e-48ac-b439-2c66440e3cee"],
Cell[205384, 4362, 1097, 23, 83, "Output",ExpressionUUID->"06bfe972-b7df-4511-89b0-aad1890dc543"],
Cell[206484, 4387, 1018, 23, 64, "Output",ExpressionUUID->"53c767ca-96f7-432d-beb0-d92004ddff53"]
}, Open  ]],
Cell[207517, 4413, 240, 4, 36, "Text",ExpressionUUID->"ebccddd3-a133-4ec4-82ee-730372b879bf"],
Cell[CellGroupData[{
Cell[207782, 4421, 1799, 42, 177, "Input",ExpressionUUID->"18227f70-8084-43ae-bd5c-abf6004faa64"],
Cell[209584, 4465, 683, 10, 53, "Output",ExpressionUUID->"d1adf2f1-6517-440d-b4e8-74843ebdd658"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210304, 4480, 180, 3, 63, "Section",ExpressionUUID->"24d22338-4f57-408e-9bc5-fd8119da790b"],
Cell[210487, 4485, 250, 6, 28, "Text",ExpressionUUID->"3fd1be11-f9e6-48ba-b827-bfb37d630993"],
Cell[CellGroupData[{
Cell[210762, 4495, 570, 12, 38, "Input",ExpressionUUID->"92b9c95a-053c-4f01-83dd-6c1a947d5ff7"],
Cell[211335, 4509, 755, 11, 53, "Output",ExpressionUUID->"a984b11b-e8e6-4c02-a14d-c2633426321e"]
}, Open  ]],
Cell[212105, 4523, 240, 4, 37, "Input",ExpressionUUID->"f9a538a1-0268-4d4c-8829-b1097f2db9f8"],
Cell[CellGroupData[{
Cell[212370, 4531, 247, 3, 37, "Input",ExpressionUUID->"4d5b34d1-6cb7-4fca-95c6-9425240f2d62"],
Cell[212620, 4536, 722, 12, 53, "Output",ExpressionUUID->"8373b94f-1c31-4bbb-80d8-3f02e11437b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[213379, 4553, 507, 12, 40, "Input",ExpressionUUID->"f70fc1ec-1064-4f8d-abc0-239fc9f6147e"],
Cell[213889, 4567, 831, 14, 53, "Output",ExpressionUUID->"fb89c733-b1c8-449e-94b4-11b660e4474c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214757, 4586, 428, 11, 40, "Input",ExpressionUUID->"85ef7205-228e-415f-b9bf-18221a3da00d"],
Cell[215188, 4599, 756, 14, 74, "Output",ExpressionUUID->"e14845a8-9d56-4bb5-ba6d-62f626e52741"]
}, Open  ]],
Cell[215959, 4616, 606, 11, 71, "Text",ExpressionUUID->"5c884862-9353-4457-865d-a8ace985d6ac"],
Cell[CellGroupData[{
Cell[216590, 4631, 354, 7, 37, "Input",ExpressionUUID->"b08801e0-da32-42f5-97da-a57412192e06"],
Cell[216947, 4640, 722, 10, 53, "Output",ExpressionUUID->"33608974-900c-415b-9eab-8e1a797aafd9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217706, 4655, 325, 7, 37, "Input",ExpressionUUID->"ef94ac2f-459e-4752-ad59-fb91f21b3fd6"],
Cell[218034, 4664, 854, 14, 53, "Output",ExpressionUUID->"bb8c812f-1896-4bd5-ba80-1a4b5aed7a3f"]
}, Open  ]],
Cell[218903, 4681, 374, 9, 28, "Text",ExpressionUUID->"9f6f2e5f-2b8b-4c87-b438-bcc0dc6cdd25"],
Cell[CellGroupData[{
Cell[219302, 4694, 543, 13, 37, "Input",ExpressionUUID->"d9ca7456-dafb-4375-8cb1-bef6d37ec507"],
Cell[219848, 4709, 1035, 18, 55, "Message",ExpressionUUID->"c7e2cb04-b7ea-4a36-9812-7e4cfc0b1edf"],
Cell[220886, 4729, 1036, 18, 60, "Output",ExpressionUUID->"fbfd1877-eaa5-4e3e-ba3e-458b07bf3bc4"]
}, Open  ]],
Cell[221937, 4750, 269, 6, 28, "Text",ExpressionUUID->"dad3cd92-997e-4fbe-8efc-d56e1b0252c8"],
Cell[CellGroupData[{
Cell[222231, 4760, 204, 3, 37, "Input",ExpressionUUID->"219f834b-b303-4139-82f9-3921202d44db"],
Cell[222438, 4765, 757, 14, 74, "Output",ExpressionUUID->"cf8dfd67-f97c-4f6b-8a03-e9f480c86818"]
}, Open  ]],
Cell[CellGroupData[{
Cell[223232, 4784, 283, 5, 37, "Input",ExpressionUUID->"b617c962-f870-4641-b9c3-42869806c20c"],
Cell[223518, 4791, 848, 14, 74, "Output",ExpressionUUID->"1f7baee8-f016-4013-9334-8f3a05973f48"]
}, Open  ]],
Cell[224381, 4808, 188, 3, 28, "Text",ExpressionUUID->"c2177907-e778-4596-bdb2-268e3c25552e"],
Cell[CellGroupData[{
Cell[224594, 4815, 391, 8, 38, "Input",ExpressionUUID->"1768a9d6-241b-40fd-8f7a-c2c99874b032"],
Cell[224988, 4825, 694, 9, 53, "Output",ExpressionUUID->"949dec18-a5c6-409f-b8ba-461b4b456ddc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[225719, 4839, 481, 11, 38, "Input",ExpressionUUID->"a6fa4b06-5a3c-45cd-948d-e764a93beb88"],
Cell[226203, 4852, 684, 10, 53, "Output",ExpressionUUID->"33febf6d-664c-4ab2-9ab3-41afbdf7deda"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226924, 4867, 404, 9, 38, "Input",ExpressionUUID->"4a28e982-bf4d-4b2f-b7a6-0d36ad56c406"],
Cell[227331, 4878, 692, 9, 53, "Output",ExpressionUUID->"0d083e57-500c-40a2-9ad3-a3b686463da3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228060, 4892, 636, 15, 37, "Input",ExpressionUUID->"55b3056c-0c14-4d51-addf-f6aa92e23008"],
Cell[228699, 4909, 1028, 17, 53, "Output",ExpressionUUID->"5e308794-3c86-41ee-abf0-059fde509178"]
}, Open  ]],
Cell[CellGroupData[{
Cell[229764, 4931, 745, 19, 84, "Input",ExpressionUUID->"3f95c447-6a5a-4413-805c-24c87a2d4941"],
Cell[230512, 4952, 878, 13, 70, "Output",ExpressionUUID->"c22a6dda-2852-4ef8-9727-68e95c77b2b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[231427, 4970, 570, 13, 37, "Input",ExpressionUUID->"31d28856-4785-4108-ae0e-f42d1a5e45f2"],
Cell[232000, 4985, 1053, 19, 55, "Message",ExpressionUUID->"242d2fa6-39d2-424d-8232-47320a0db514"],
Cell[233056, 5006, 1064, 19, 60, "Output",ExpressionUUID->"9c244b45-4e32-4e73-9388-d2663cbfc367"]
}, Open  ]],
Cell[234135, 5028, 177, 3, 28, "Text",ExpressionUUID->"9bdf138b-750f-4bae-848c-3e9cf02c6e7d"],
Cell[CellGroupData[{
Cell[234337, 5035, 546, 11, 91, "Input",ExpressionUUID->"b19100a4-ae51-4436-afca-432893e2c7d9"],
Cell[234886, 5048, 862, 15, 76, "Output",ExpressionUUID->"566aa2a8-82f1-4b1d-86c7-df558b5e7532"]
}, Open  ]],
Cell[CellGroupData[{
Cell[235785, 5068, 288, 6, 37, "Input",ExpressionUUID->"907fe905-1c20-4aa5-88c8-69d8328e246c"],
Cell[236076, 5076, 5881, 119, 299, "Output",ExpressionUUID->"4a4edfa3-9532-4157-80c5-9b61ce6c0d28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[241994, 5200, 408, 9, 37, "Input",ExpressionUUID->"89d93b94-7d4c-47dc-83e9-7a9cbb329804"],
Cell[242405, 5211, 664, 10, 53, "Output",ExpressionUUID->"9b17c476-5c99-484a-8b59-6edfa044f38e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243106, 5226, 887, 22, 84, "Input",ExpressionUUID->"928d5bc1-c3f8-4eac-9088-547a70eeba1c"],
Cell[243996, 5250, 2982, 73, 292, "Output",ExpressionUUID->"b45007ce-5fdc-479b-8b65-d41fa9e0a2d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[247015, 5328, 4425, 91, 284, "Input",ExpressionUUID->"4bc72e86-9996-41a5-9715-731663700b6f"],
Cell[251443, 5421, 4686, 96, 284, "Output",ExpressionUUID->"cdc86ca2-4b30-42c3-a4fa-d71cac109753"]
}, Open  ]],
Cell[256144, 5520, 208, 6, 49, "Text",ExpressionUUID->"d4e1b6d0-b59d-4d00-a4b3-8a4ea9a0e3b5"],
Cell[CellGroupData[{
Cell[256377, 5530, 499, 12, 61, "Input",ExpressionUUID->"3bfefe6d-d3f1-4163-a312-79e5b11bb407"],
Cell[256879, 5544, 964, 18, 93, "Output",ExpressionUUID->"c0de850e-3965-4517-8142-bae265d280e6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[257880, 5567, 668, 18, 61, "Input",ExpressionUUID->"b7ccc45b-dd3d-45a2-a6e4-d4299026d2a2"],
Cell[258551, 5587, 13490, 244, 290, "Output",ExpressionUUID->"858dd6d1-86dc-4fd6-b5fe-4aabdaba8497"]
}, Open  ]],
Cell[272056, 5834, 231, 4, 28, "Text",ExpressionUUID->"87c50419-d53e-47e1-9746-b670bda61ebb"],
Cell[CellGroupData[{
Cell[272312, 5842, 1019, 21, 61, "Input",ExpressionUUID->"5b6deb89-7faf-4296-9a1f-65777e68d1eb"],
Cell[273334, 5865, 837, 15, 53, "Output",ExpressionUUID->"ad93b93c-1bdb-4102-80e8-caa53b27953a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[274208, 5885, 261, 5, 37, "Input",ExpressionUUID->"4ac9720d-97af-4d98-af67-f18740e1f712"],
Cell[274472, 5892, 664, 9, 53, "Output",ExpressionUUID->"0d35b7de-68ad-426f-9232-490cda2f7e01"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275173, 5906, 321, 7, 37, "Input",ExpressionUUID->"b8aa1fb3-50fd-4537-ae23-d9c8470aa750"],
Cell[275497, 5915, 644, 9, 53, "Output",ExpressionUUID->"479d7a6f-3819-4c8f-8166-42e73c746939"]
}, Open  ]],
Cell[276156, 5927, 192, 3, 28, "Text",ExpressionUUID->"525b9682-ad3c-49e6-ae82-91af7a80c6a2"],
Cell[CellGroupData[{
Cell[276373, 5934, 456, 12, 37, "Input",ExpressionUUID->"48f19b41-54fa-45e4-9e4f-caaf6689ca28"],
Cell[276832, 5948, 671, 9, 53, "Output",ExpressionUUID->"a4948909-b603-4787-9957-1c9e768b866b"]
}, Open  ]],
Cell[277518, 5960, 185, 3, 28, "Text",ExpressionUUID->"340e2303-a225-442e-ae40-a484f9250a5f"],
Cell[CellGroupData[{
Cell[277728, 5967, 528, 11, 37, "Input",ExpressionUUID->"65eb187f-3005-4aa4-ad59-20c47f5a5391"],
Cell[278259, 5980, 720, 11, 53, "Output",ExpressionUUID->"5256c272-3460-4a0d-8e7e-bf0b0ffab3f8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[279016, 5996, 450, 10, 37, "Input",ExpressionUUID->"e31ab67a-f49d-4b73-aecc-c5a0bf6e2072"],
Cell[279469, 6008, 722, 10, 53, "Output",ExpressionUUID->"53d794a6-8f94-4849-aca1-e219961090ca"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[280240, 6024, 188, 3, 63, "Section",ExpressionUUID->"c4a245ff-adb1-4243-9c92-6ba6de028642"],
Cell[280431, 6029, 800, 15, 115, "Text",ExpressionUUID->"18c0b454-9ea3-4bf3-b579-69a40aeff206"],
Cell[281234, 6046, 191, 3, 28, "Text",ExpressionUUID->"976faf57-9699-40ac-97c6-ece891658997"],
Cell[CellGroupData[{
Cell[281450, 6053, 417, 8, 38, "Input",ExpressionUUID->"b4a642f4-d603-4278-9695-e10161449974"],
Cell[281870, 6063, 749, 11, 53, "Output",ExpressionUUID->"7423e32a-78c9-460d-ae9c-767f78987f21"]
}, Open  ]],
Cell[282634, 6077, 402, 7, 28, "Text",ExpressionUUID->"4d237a51-9f14-4a44-be8c-bba1aa480276"],
Cell[CellGroupData[{
Cell[283061, 6088, 468, 12, 37, "Input",ExpressionUUID->"347c0a10-2037-4c2e-b64d-f0f35bf22c10"],
Cell[283532, 6102, 681, 9, 53, "Output",ExpressionUUID->"6009379c-fb09-4072-a6a4-4a5913f63193"]
}, Open  ]],
Cell[284228, 6114, 164, 3, 28, "Text",ExpressionUUID->"81b8e646-6d39-4382-8923-f98d160e4afe"],
Cell[CellGroupData[{
Cell[284417, 6121, 606, 13, 37, "Input",ExpressionUUID->"77456338-5120-437f-bc3f-7448e056b4f4"],
Cell[285026, 6136, 790, 11, 53, "Output",ExpressionUUID->"fa4bc030-ab8d-48eb-a14d-0875e4cfe64f"]
}, Open  ]],
Cell[285831, 6150, 236, 6, 28, "Text",ExpressionUUID->"c91c4384-ea6a-4c63-aa0d-27b14e875c4a"],
Cell[CellGroupData[{
Cell[286092, 6160, 469, 11, 38, "Input",ExpressionUUID->"0f4b9ba3-d935-487f-9e74-e0d46274bdf2"],
Cell[286564, 6173, 4555, 97, 294, "Output",ExpressionUUID->"4d72a09a-b11f-4da0-a753-65c58ace9f48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[291156, 6275, 267, 5, 37, "Input",ExpressionUUID->"0e8bf7ae-8225-4ecd-95d3-0ffff2464f75"],
Cell[291426, 6282, 700, 11, 53, "Output",ExpressionUUID->"aeab3b7a-e997-4d66-bc21-83f5b558518f"]
}, Open  ]],
Cell[292141, 6296, 297, 7, 28, "Text",ExpressionUUID->"05aa8c02-bea7-4a20-bd14-cfef7d3cc096"],
Cell[292441, 6305, 716, 12, 49, "Text",ExpressionUUID->"18bf51f9-6049-42a6-bcc8-506eaebb1484"]
}, Open  ]],
Cell[CellGroupData[{
Cell[293194, 6322, 185, 3, 63, "Section",ExpressionUUID->"3eeb6e0f-64f2-4960-a3bd-9ec3c55da956"],
Cell[293382, 6327, 1005, 25, 53, "Input",ExpressionUUID->"596bc87a-22e9-47da-8189-83189b18c546"],
Cell[CellGroupData[{
Cell[294412, 6356, 369, 8, 37, "Input",ExpressionUUID->"6dcf7e24-835f-4fbb-9e4c-dfd4127d8860"],
Cell[294784, 6366, 4738, 136, 151, "Output",ExpressionUUID->"c8ca11fb-1bb8-4c2a-9852-83a4b6340267"]
}, Open  ]],
Cell[299537, 6505, 340, 7, 28, "Text",ExpressionUUID->"507c7550-1154-4d01-8be8-e71dbb3778df"],
Cell[CellGroupData[{
Cell[299902, 6516, 1269, 39, 107, "Input",ExpressionUUID->"e4b08763-e472-41a6-89a5-892d80934eb1"],
Cell[301174, 6557, 891, 16, 55, "Message",ExpressionUUID->"e8149ff4-2e0d-425a-af60-d11e1b07d534"],
Cell[302068, 6575, 647, 10, 37, "Output",ExpressionUUID->"38353483-0039-4cd2-9fab-f5f8ce2fcfbf"]
}, Open  ]],
Cell[302730, 6588, 286, 4, 28, "Text",ExpressionUUID->"371e25ae-fd82-40ba-9f0d-fe959c3d4165"],
Cell[CellGroupData[{
Cell[303041, 6596, 603, 16, 37, "Input",ExpressionUUID->"329abe1e-5604-4965-87cb-94e24f5bd0fa"],
Cell[303647, 6614, 9560, 180, 288, "Output",ExpressionUUID->"821d2fdc-ca1d-4be3-9c85-d4e23ac093be"]
}, Open  ]],
Cell[313222, 6797, 360, 7, 28, "Text",ExpressionUUID->"dee46983-8aae-4533-af17-9e52795e31a3"]
}, Open  ]]
}
]
*)

