(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    137761,       3024]
NotebookOptionsPosition[    129086,       2881]
NotebookOutlinePosition[    129903,       2907]
CellTagsIndexPosition[    129860,       2904]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
We follow the derivation in Kolter (2011) with the aim of constructing a \
fixed-point counterexample with n=3 states and k=2 feature space, where w* is \
near [1, -1]
We achieve this by splitting the left state into two equal states.\
\>", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
  3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
  3.8489105216064568`*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"1", "+", "param"}], ",", " ", "1.05"}], "}"}], "}"}], 
    "\[Transpose]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
      RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"epsilon", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "param"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1.05", "+", "epsilon"}], ")"}], "/", "2"}], ",", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1.05", "+", "epsilon"}], ")"}]}], "/", "2"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dm", " ", "=", " ", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}]}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}], 
      RowBox[{"(", "p", ")"}]}], ",", "q"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"what", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"LeastSquares", "[", 
      RowBox[{
       RowBox[{"Refine", "[", 
        RowBox[{"Phi", ",", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"epsilon", "==", "0.0001"}]}]}], "]"}], ",", "V"}], "]"}], 
     ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"param", "\[Element]", "Reals"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"what", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"param", "->", "2"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"Phi", ".", "what"}], "-", "V"}], "]"}], "<", "0.0001"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"param", "->", "2"}], ",", 
    RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dm", "//", "Total"}], "//", "Total"}], "//", 
  "Simplify"}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936641725163*^9, {
   3.852099656777422*^9, 3.852099660756007*^9}, {3.8520998283982353`*^9, 
   3.8520998330051622`*^9}, {3.852100643443104*^9, 3.852100647045465*^9}, {
   3.857312621661829*^9, 3.857312691960071*^9}, {3.857316711815258*^9, 
   3.85731676509906*^9}, {3.85765391359242*^9, 3.857653919307899*^9}, 
   3.857653970095665*^9, {3.85989693288984*^9, 3.859896944490634*^9}, {
   3.859897496931375*^9, 3.8598975945161552`*^9}, {3.859897902003407*^9, 
   3.8598979206232347`*^9}, {3.859898432342708*^9, 3.859898538002281*^9}, {
   3.85989857821306*^9, 3.859898582607389*^9}, {3.859898733660108*^9, 
   3.859898739319944*^9}, {3.859898922338215*^9, 3.859898927499708*^9}, 
   3.8599089226791687`*^9, {3.859976797797181*^9, 3.859976832973092*^9}, {
   3.859977124610374*^9, 3.859977129792815*^9}, 3.859977256340473*^9, {
   3.859977293909544*^9, 3.859977303975683*^9}, {3.859979542759618*^9, 
   3.859979551035636*^9}, {3.85997977767616*^9, 3.85997983483222*^9}, {
   3.8600696420253077`*^9, 3.860069679266094*^9}, 3.86009438417838*^9, 
   3.8600946899753304`*^9, {3.8600948466189938`*^9, 3.8600948787968493`*^9}, {
   3.860095501593268*^9, 3.860095525596113*^9}},
 CellLabel->
  "In[343]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"p", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "q"}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "q"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526147727*^9}},
 CellLabel->
  "Out[351]=",ExpressionUUID->"e5122073-5450-4c80-8137-9b809fb722df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.9999598065796963`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.9999955340644108`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526164139*^9}},
 CellLabel->
  "Out[353]=",ExpressionUUID->"c435e542-7fbc-4876-8c5f-32ae87ee1b8e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526166691*^9}},
 CellLabel->
  "Out[354]=",ExpressionUUID->"8277b709-02fb-4376-adad-e337a6e7e09c"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.859908893857658*^9, 3.859908925124405*^9, 3.859975691047621*^9, {
   3.859976809419084*^9, 3.859976833263359*^9}, 3.859977137884857*^9, 
   3.85997725934177*^9, 3.859977305320374*^9, 3.859979552204364*^9, {
   3.859979792654595*^9, 3.859979835369123*^9}, 3.860069328347806*^9, {
   3.860069650491766*^9, 3.860069679579013*^9}, 3.8600897404731627`*^9, 
   3.86009443676361*^9, 3.8600946903854237`*^9, {3.8600955117812567`*^9, 
   3.860095526168944*^9}},
 CellLabel->
  "Out[355]=",ExpressionUUID->"a2209abf-70bc-48e2-bbb2-7969cc2bccbc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the fixed point w_star:", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{{3.848570432944818*^9, 3.8485704485407467`*^9}, {
  3.848570915714424*^9, 
  3.848570984363884*^9}},ExpressionUUID->"0a5d41cb-08ef-4253-a74f-\
02384f62cb6a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sA", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sb", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sA", "]"}], ".", "sb"}]}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.},
 CellChangeTimes->{
  3.848570984364477*^9, 3.848571676353101*^9, {3.848913024643092*^9, 
   3.84891305207668*^9}, {3.848913722679961*^9, 3.848913736469101*^9}, {
   3.857312703508958*^9, 3.8573127254150143`*^9}, 3.8598985463718767`*^9},
 CellLabel->
  "In[272]:=",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}], ",", 
      RowBox[{"param", "->", "1.2"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0.", ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851991153216415*^9, 3.851991186354488*^9}, {
   3.859897604498384*^9, 3.859897667449603*^9}, 3.8598977068231173`*^9, {
   3.859898770173263*^9, 3.859898811920697*^9}, {3.859898900650683*^9, 
   3.8598989076267014`*^9}, {3.859977170380211*^9, 3.8599772094073343`*^9}, 
   3.85997727963168*^9, {3.859977312311514*^9, 3.8599773537170477`*^9}},
 CellLabel->
  "In[258]:=",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{{3.851991175596321*^9, 3.851991188156067*^9}, 
   3.852099769026505*^9, 3.852099840152269*^9, 3.852100226701511*^9, 
   3.8521006529204493`*^9, 3.852102744002846*^9, 3.856790500789186*^9, 
   3.857306002990883*^9, 3.857311947626852*^9, 3.857312736106235*^9, 
   3.85731678740065*^9, 3.857472550671721*^9, {3.857472669108161*^9, 
   3.857472692148705*^9}, 3.857480400691743*^9, 3.857501084918508*^9, 
   3.85751684082974*^9, 3.857576042248208*^9, 3.8576555356399508`*^9, 
   3.858008094574027*^9, {3.8582777871859407`*^9, 3.858277792462254*^9}, 
   3.8593168251313963`*^9, 3.8598927620429153`*^9, 3.859896952499642*^9, {
   3.85989759928612*^9, 3.859897675141019*^9}, 3.85989771447301*^9, 
   3.8598980000631723`*^9, 3.859898714540739*^9, {3.8598987700434933`*^9, 
   3.859898787797167*^9}, {3.859898894951852*^9, 3.859898976089574*^9}, 
   3.8599088975038*^9, 3.859908933455188*^9, 3.859975691534268*^9, {
   3.859976813379868*^9, 3.859976835442383*^9}, {3.8599771660336437`*^9, 
   3.859977210213913*^9}, 3.8599772873210373`*^9, 3.859977341859164*^9, 
   3.859977375981565*^9, 3.859979582659725*^9, 3.859979865050913*^9, 
   3.86006970787919*^9, 3.860089747980875*^9, 3.8600944454515057`*^9},
 CellLabel->
  "Out[258]=",ExpressionUUID->"804f9a2e-bd07-4464-9695-0e3b883656f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example without RR", "Subsection",
 CellChangeTimes->{{3.8600692918775682`*^9, 
  3.8600692953343763`*^9}},ExpressionUUID->"392c3468-009e-44ad-9c2a-\
a546d20d6ec1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"q", "->", "0.44"}], ",", 
      RowBox[{"param", "->", "1.2"}], ",", 
      RowBox[{"eta", "->", "0"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dm", "/.", 
   RowBox[{"{", 
    RowBox[{"q", "->", "0.44"}], "}"}]}], " ", "//", 
  "Total"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.860069405536934*^9, 3.860069442802802*^9}, {
  3.860069595037928*^9, 3.860069608572097*^9}, {3.860095801483552*^9, 
  3.860095816757351*^9}, {3.860095883209629*^9, 3.860095890068159*^9}},
 CellLabel->
  "In[380]:=",ExpressionUUID->"5ab2d7e0-3534-4f14-a5e8-3326ab1c7f5c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.56`", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}]}], ",", 
   RowBox[{"0.56`", " ", "p"}], ",", "0.44`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.860069443496619*^9, 3.86006960893928*^9, 3.860069710114056*^9, 
   3.860089749858287*^9, 3.860094695248518*^9, {3.860095802262464*^9, 
   3.8600958170833063`*^9}, {3.860095885884515*^9, 3.860095890335595*^9}},
 CellLabel->
  "Out[381]=",ExpressionUUID->"52c98295-dcf4-4ea2-8d3d-d946370533e6"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVkGs4FIgChj2tQhfhuDSOy2Zpj1PJRrKKL7eYi7kad3IYWVSjJ0qIRiGV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       "]], LineBox[CompressedData["
1:eJw92nc8Vf8fB3CkQaKkMstKVkb2fN17CRllh4yiJEVlVSKyUpqibGknoaIk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       "]], LineBox[CompressedData["
1:eJwVjmk8lAsDxScUUTTMFdKCVLbLvaFCnZvkZTYzYydR0iKJutIilCxJUYmi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       "]]},
     Annotation[#, "Charting`Private`Tag$126225#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.0016802347120117315`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.860069443496619*^9, 3.86006960893928*^9, 3.860069710114056*^9, 
   3.860089749858287*^9, 3.860094695248518*^9, {3.860095802262464*^9, 
   3.8600958170833063`*^9}, {3.860095885884515*^9, 3.8600958903916883`*^9}},
 CellLabel->
  "Out[382]=",ExpressionUUID->"62f70d2c-9557-463b-a6b6-320e76f2b434"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"divergingqs", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Det", "[", "sA", "]"}], "==", "0"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "->", "0.44"}], ",", 
      RowBox[{"param", "->", "1.2"}], ",", 
      RowBox[{"eta", "->", "0"}], ",", " ", 
      RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8600693204781837`*^9, 3.860069388882617*^9}, {
  3.860069454088532*^9, 3.86006948181675*^9}, {3.86008972554793*^9, 
  3.860089815718712*^9}, {3.860089846301094*^9, 3.8600898824182453`*^9}, {
  3.860090010471567*^9, 3.8600900160737333`*^9}, {3.8600901417518263`*^9, 
  3.8600902069984093`*^9}, {3.860090270324855*^9, 3.860090294179895*^9}, {
  3.860090374943475*^9, 3.8600904531180058`*^9}, {3.860095902184469*^9, 
  3.8600959033553*^9}},
 CellLabel->
  "In[383]:=",ExpressionUUID->"c56b9e37-437b-422e-a30e-166f285df79a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "\[Rule]", "0.10263096798496074`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", "\[Rule]", "0.8072553456218825`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.8600904385645723`*^9, 3.860090453474337*^9}, 
   3.8600946981038523`*^9, 3.860095903692333*^9},
 CellLabel->
  "Out[383]=",ExpressionUUID->"4438b07a-1f00-4d3b-8fee-c3f7860b37d0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vacuous example with RR", "Subsection",
 CellChangeTimes->{{3.86007042093302*^9, 
  3.8600704260049133`*^9}},ExpressionUUID->"81c795fb-2099-456a-94aa-\
2650a32156f4"],

Cell["\<\
Example of vacuous example with RR. We find the point when eta = 0 and then \
check that the solution remains vacuous for all eta:\
\>", "Text",
 CellChangeTimes->{{3.860069299944767*^9, 3.860069307859617*^9}, {
  3.860070387467526*^9, 
  3.8600704135964413`*^9}},ExpressionUUID->"64f07ecb-e4bf-4a69-aecf-\
ed2061176501"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}], ",", 
      RowBox[{"param", "->", "1.2"}], ",", 
      RowBox[{"q", "->", "0.44"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tmp", ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dm", "/.", 
   RowBox[{"{", 
    RowBox[{"q", "->", "0.44"}], "}"}]}], "//", "Total"}]}], "Input",
 CellChangeTimes->{{3.85997900439428*^9, 3.8599790959643707`*^9}, 
   3.859979176201169*^9, {3.8600955349580917`*^9, 3.8600955351830063`*^9}},
 CellLabel->
  "In[356]:=",ExpressionUUID->"cbb700c9-903c-4b75-ac3e-0e9c9622c628"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwVkGs4FIgChj2tQhfhuDSOy2Zpj1PJRrKKL7eYi7kad3IYWVSjJ0qIRiGV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       "]], LineBox[CompressedData["
1:eJw92nc8Vf8fB3CkQaKkMstKVkb2fN17CRllh4yiJEVlVSKyUpqibGknoaIk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       "]], LineBox[CompressedData["
1:eJwVjmk8lAsDxScUUTTMFdKCVLbLvaFCnZvkZTYzYydR0iKJutIilCxJUYmi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       "]]},
     Annotation[#, "Charting`Private`Tag$123233#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.0016802347120117315`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8599790191385*^9, {3.8599790517144203`*^9, 3.859979096467621*^9}, 
   3.859979176499426*^9, 3.859979582766142*^9, 3.859979865159339*^9, 
   3.860069715837981*^9, 3.8600697957429123`*^9, 3.860094699893985*^9, 
   3.860095538324773*^9},
 CellLabel->
  "Out[357]=",ExpressionUUID->"147bbbe0-4570-474e-9038-60223062ed33"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.56`", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}]}], ",", 
   RowBox[{"0.56`", " ", "p"}], ",", "0.44`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8599790191385*^9, {3.8599790517144203`*^9, 3.859979096467621*^9}, 
   3.859979176499426*^9, 3.859979582766142*^9, 3.859979865159339*^9, 
   3.860069715837981*^9, 3.8600697957429123`*^9, 3.860094699893985*^9, 
   3.8600955383381968`*^9},
 CellLabel->
  "Out[358]=",ExpressionUUID->"40bf632a-748d-4f56-92eb-7c604113bdfe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"wstar", "*", "what"}], " ", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"epsilon", "->", "0.0001"}], ",", 
         RowBox[{"q", "->", "0.44"}], ",", 
         RowBox[{"param", "->", "1.2"}], ",", 
         RowBox[{"eta", "->", "eta"}]}], "}"}]}], "//", "Total"}], "//", 
     "Total"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", " ", "//", "Factor"}], "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"tmp", "<=", " ", "0"}], ")"}], "&&", 
   RowBox[{"0", "<", "p", "<", "1"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.859898987023349*^9, 3.85989921572355*^9}, {
   3.859899250090685*^9, 3.859899279801219*^9}, {3.8598993165223417`*^9, 
   3.859899365297201*^9}, 3.859908871655725*^9, {3.859976709524143*^9, 
   3.859976714593574*^9}, {3.859979134111746*^9, 3.859979187775628*^9}, {
   3.859979317147999*^9, 3.859979446704867*^9}, 3.859979494929811*^9, {
   3.860069810612442*^9, 3.860069823474781*^9}, {3.8600935835615597`*^9, 
   3.8600935885246353`*^9}, {3.8600936742194023`*^9, 3.860093675974022*^9}, 
   3.860094778052824*^9, {3.860095305705681*^9, 3.860095318005961*^9}, {
   3.860095698225609*^9, 3.860095719498014*^9}, {3.860096075751629*^9, 
   3.8600960826183157`*^9}, {3.860096286174325*^9, 3.860096290902837*^9}, {
   3.8600963278944407`*^9, 3.860096340356511*^9}},
 CellLabel->
  "In[396]:=",ExpressionUUID->"3994771a-8fca-4fdd-9d46-41c965a7d7b0"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"1.2688882134621149`", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1.`", " ", "eta", " ", "p"}], "-", 
      RowBox[{"0.2328891235615755`", " ", "eta"}], "-", 
      RowBox[{"0.30382355777087044`", " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{"0.27644257657721844`", " ", "p"}], "-", 
      "0.025172640232165186`"}], ")"}]}], 
   RowBox[{
    RowBox[{"1.`", " ", 
     SuperscriptBox["eta", "2"]}], "+", 
    RowBox[{"1.4435233680000004`", " ", "eta", " ", "p"}], "+", 
    RowBox[{"0.21539779811100002`", " ", "eta"}], "-", 
    RowBox[{"0.19270900633600008`", " ", 
     SuperscriptBox["p", "2"]}], "+", 
    RowBox[{"0.17534328737390076`", " ", "p"}], "-", 
    "0.015965825073967984`"}]], TraditionalForm]], "Output",
 CellChangeTimes->{{3.859899012948135*^9, 3.8598991518565607`*^9}, {
   3.8598991907215443`*^9, 3.859899223448545*^9}, {3.859899255205336*^9, 
   3.859899272000023*^9}, {3.859899317130948*^9, 3.859899330536615*^9}, 
   3.859899366308963*^9, {3.859908872076006*^9, 3.859908898831339*^9}, 
   3.859908936938448*^9, 3.859975691560701*^9, 3.859976715568128*^9, 
   3.859976839880146*^9, {3.8599791448082848`*^9, 3.859979188269547*^9}, 
   3.859979335816662*^9, {3.859979383711825*^9, 3.859979447329708*^9}, 
   3.8599794961170797`*^9, 3.859979865517171*^9, 3.8600697207064543`*^9, {
   3.8600698124678173`*^9, 3.860069823804029*^9}, 3.8600935887674723`*^9, 
   3.860093676197874*^9, 3.860094702970028*^9, 3.8600947790625*^9, 
   3.86009533110679*^9, {3.8600956989497223`*^9, 3.860095719814691*^9}, 
   3.860096082916873*^9, {3.860096288013723*^9, 3.8600962916294813`*^9}, {
   3.860096331159687*^9, 3.8600963406700583`*^9}},
 CellLabel->
  "Out[397]//TraditionalForm=",ExpressionUUID->"544a439e-7d7a-43b0-92ec-\
076c35ecfddd"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 398, 70, 21875472668881988173, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.859899255225458*^9, 3.8598992720184393`*^9}, {
   3.859899317149091*^9, 3.859899330556438*^9}, 3.859899366330948*^9, {
   3.8599088720975943`*^9, 3.859908898842255*^9}, 3.8599089370665903`*^9, 
   3.859975692046205*^9, 3.85997671569569*^9, 3.8599768399236403`*^9, {
   3.859979155412715*^9, 3.859979188261301*^9}, 3.8599793358011627`*^9, {
   3.8599793836492434`*^9, 3.859979447314561*^9}, 3.8599794961001787`*^9, 
   3.859979865499621*^9, 3.860069720689907*^9, {3.8600698124521008`*^9, 
   3.860069823788188*^9}, 3.860093588792384*^9, 3.8600936762162657`*^9, 
   3.8600947029894247`*^9, 3.860094779079212*^9, 3.8600953311306334`*^9, {
   3.860095699040894*^9, 3.860095719906535*^9}, 3.860096082997551*^9, {
   3.8600962881705914`*^9, 3.860096291784862*^9}, {3.860096331317129*^9, 
   3.860096340762327*^9}},
 CellLabel->
  "During evaluation of \
In[396]:=",ExpressionUUID->"6680d163-95cb-4579-9a28-4327f770372a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "p", "<", "0.10263583866159073`"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "-", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}], "<", "eta", "\[LessEqual]", 
       FractionBox[
        RowBox[{"9.075776458079458`*^38", "-", 
         RowBox[{"9.966896620182397`*^39", " ", "p"}], "+", 
         RowBox[{"1.0954094078313664`*^40", " ", 
          SuperscriptBox["p", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "8.396614758995832`*^39"}], "+", 
         RowBox[{"3.605413009670149`*^40", " ", "p"}]}]]}], "||", 
      RowBox[{"eta", ">", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "+", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"p", "\[Equal]", "0.10263583866159073`"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.3635532104235886`"}], "<", "eta", "<", 
       RowBox[{"-", "1.819189695495729`*^-6"}]}], "||", 
      RowBox[{"eta", ">", 
       RowBox[{"-", "1.819189695495729`*^-6"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0.10263583866159073`", "<", "p", "<", "0.23288912356157554`"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "-", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}], "<", "eta", "<", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "+", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}]}], "||", 
      RowBox[{"eta", "\[GreaterEqual]", 
       FractionBox[
        RowBox[{"9.075776458079458`*^38", "-", 
         RowBox[{"9.966896620182397`*^39", " ", "p"}], "+", 
         RowBox[{"1.0954094078313664`*^40", " ", 
          SuperscriptBox["p", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "8.396614758995832`*^39"}], "+", 
         RowBox[{"3.605413009670149`*^40", " ", "p"}]}]]}]}], ")"}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"p", "\[Equal]", "0.2328891235615755`"}], "&&", 
    RowBox[{
     RowBox[{"-", "0.524067552018471`"}], "<", "eta", "<", 
     RowBox[{"-", "0.027511138106702665`"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0.23288912356157554`", "<", "p", "<", "0.28120524366859356`"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eta", "\[LessEqual]", 
       FractionBox[
        RowBox[{"9.075776458079458`*^38", "-", 
         RowBox[{"9.966896620182397`*^39", " ", "p"}], "+", 
         RowBox[{"1.0954094078313664`*^40", " ", 
          SuperscriptBox["p", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "8.396614758995832`*^39"}], "+", 
         RowBox[{"3.605413009670149`*^40", " ", "p"}]}]]}], "||", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "-", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}], "<", "eta", "<", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "+", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"p", "\[Equal]", "0.28120524366859356`"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eta", "<", 
       RowBox[{"-", "0.5906764026057967`"}]}], "||", 
      RowBox[{
       RowBox[{"-", "0.5906764026057967`"}], "<", "eta", "<", 
       RowBox[{"-", "0.030647735944952282`"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0.28120524366859356`", "<", "p", "<", "0.807236850730447`"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eta", "<", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "-", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}]}], "||", 
      RowBox[{
       FractionBox[
        RowBox[{"9.075776458079458`*^38", "-", 
         RowBox[{"9.966896620182397`*^39", " ", "p"}], "+", 
         RowBox[{"1.0954094078313664`*^40", " ", 
          SuperscriptBox["p", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "8.396614758995832`*^39"}], "+", 
         RowBox[{"3.605413009670149`*^40", " ", "p"}]}]], "\[LessEqual]", 
       "eta", "<", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "+", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"p", "\[Equal]", "0.807236850730447`"}], "&&", 
    RowBox[{"eta", "<", 
     RowBox[{"-", "1.3806612367339217`"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0.807236850730447`", "<", "p", "<", "1.`"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eta", "<", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "-", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}]}], "||", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2.9997864515368666`*^-16"}], " ", 
         RowBox[{"(", 
          RowBox[{"3.59021886375689`*^14", "+", 
           RowBox[{"2.406043548967372`*^15", " ", "p"}]}], ")"}]}], "+", 
        RowBox[{"2.8609976095991283`*^-30", " ", 
         SqrtBox[
          RowBox[{"3.367604519527714`*^57", "-", 
           RowBox[{"2.4284256042125106`*^57", " ", "p"}], "+", 
           RowBox[{"8.718657794276204`*^58", " ", 
            SuperscriptBox["p", "2"]}]}]]}]}], "<", "eta", "\[LessEqual]", 
       FractionBox[
        RowBox[{"9.075776458079458`*^38", "-", 
         RowBox[{"9.966896620182397`*^39", " ", "p"}], "+", 
         RowBox[{"1.0954094078313664`*^40", " ", 
          SuperscriptBox["p", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "8.396614758995832`*^39"}], "+", 
         RowBox[{"3.605413009670149`*^40", " ", "p"}]}]]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.859899012948135*^9, 3.8598991518565607`*^9}, {
   3.8598991907215443`*^9, 3.859899223448545*^9}, {3.859899255205336*^9, 
   3.859899272000023*^9}, {3.859899317130948*^9, 3.859899330536615*^9}, 
   3.859899366308963*^9, {3.859908872076006*^9, 3.859908898831339*^9}, 
   3.859908936938448*^9, 3.859975691560701*^9, 3.859976715568128*^9, 
   3.859976839880146*^9, {3.8599791448082848`*^9, 3.859979188269547*^9}, 
   3.859979335816662*^9, {3.859979383711825*^9, 3.859979447329708*^9}, 
   3.8599794961170797`*^9, 3.859979865517171*^9, 3.8600697207064543`*^9, {
   3.8600698124678173`*^9, 3.860069823804029*^9}, 3.8600935887674723`*^9, 
   3.860093676197874*^9, 3.860094702970028*^9, 3.8600947790625*^9, 
   3.86009533110679*^9, {3.8600956989497223`*^9, 3.860095719814691*^9}, 
   3.860096082916873*^9, {3.860096288013723*^9, 3.8600962916294813`*^9}, {
   3.860096331159687*^9, 3.860096340782217*^9}},
 CellLabel->
  "Out[398]=",ExpressionUUID->"c46108a1-c334-4002-b380-2443fbfcbeb6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"testp", "=", "0.1026309679849605"}], ";", 
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", "0.0001"}], ",", 
       RowBox[{"q", "->", "0.44"}], ",", 
       RowBox[{"param", "->", "1.2"}], ",", 
       RowBox[{"p", "->", "testp"}]}], "}"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"tmp", ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"eta", ",", "Reals"}], "]"}], "&&", 
       RowBox[{"eta", ">=", "0"}]}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", "^", "2"}], "//", "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"tmp", "^", "2"}], "//", "Numerator"}], "//", "Together"}], "//", 
  "ExpandAll"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "^", "2"}], "//", "Denominator"}], "//", 
  "ExpandAll"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"tmp", "/.", 
    RowBox[{"{", 
     RowBox[{"eta", "->", 
      RowBox[{"10", "^", "etax"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQXcX5rDr40BtHnYW7m0B0/evjM0C0t8LZmSD6WazG
AhB9b4UHmGbb/2AriF5x7yuYLpuWyhACpPcwNIPpLWV7pED0xGReWRD94+4K
SxBtfDjMCkSf+p6QAKJ/bb6XCKI3LkncWQ+kMxmOHwTRER/f3AXRs6r/gOk/
Ynu+g2i2uaY/QLRTx4vQbpA96TZhIFr/Z18KiJY8vi8dROcwB+SA6D079xWD
6JMRmytBtPf8yfUguk61pBVEHzh8sxNEC+TmTQTR2lnWi0H0M/eb90C0m4br
YxDN5nH/WA+QDrI8ewpENxst1ekF+avgjx6ILru4yRpEx/W62oBoidMv3EB0
aamlO4gGAJNoxyA=
  "],
 CellLabel->
  "In[447]:=",ExpressionUUID->"a01ff745-b666-43f8-b696-6e1333ac5b44"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"eta", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"eta", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"eta", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6.942500000000001`", " ", "eta"}], "+", 
             "5.162554279919121`"}], ")"}]}], "+", "1.026961399568269`"}], 
         ")"}]}], "+", "3.737323518965304`*^-6"}], ")"}]}], "+", 
    "3.400253134834138`*^-12"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eta", " ", 
       RowBox[{"(", 
        RowBox[{"eta", "+", "0.3635479986777504`"}], ")"}]}], "+", 
      "3.469446951953614`*^-18"}], ")"}], "2"]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.859979286420108*^9, {3.859979454776904*^9, 3.859979471897004*^9}, 
   3.859979522774479*^9, {3.8599796817590637`*^9, 3.859979696167622*^9}, 
   3.85997986564351*^9, 3.859980292423744*^9, 3.859980521313834*^9, {
   3.859980750112173*^9, 3.8599807573848352`*^9}, {3.8599810596582108`*^9, 
   3.8599810714871597`*^9}, {3.860069831838385*^9, 3.860069902575004*^9}, 
   3.860070128366241*^9, {3.8600936182596617`*^9, 3.860093629191412*^9}, 
   3.860093758800995*^9, {3.860093797250745*^9, 3.860093855150216*^9}, {
   3.860093902981098*^9, 3.8600939492024117`*^9}, {3.860093999734728*^9, 
   3.860094031113935*^9}, {3.8600941085625353`*^9, 3.8600942342166862`*^9}, {
   3.860094712676215*^9, 3.860094746506145*^9}, 3.86009656982493*^9, 
   3.8600966010513163`*^9, {3.8600973832721777`*^9, 3.860097400296768*^9}, {
   3.860097502639399*^9, 3.860097506619907*^9}, 3.860097594109826*^9},
 CellLabel->
  "Out[449]//TraditionalForm=",ExpressionUUID->"b92b3611-287c-412f-9ae8-\
fef68662ab7d"],

Cell[BoxData[
 RowBox[{"3.400253134834138`*^-12", "+", 
  RowBox[{"3.7373235189653035`*^-6", " ", "eta"}], "+", 
  RowBox[{"1.026961399568269`", " ", 
   SuperscriptBox["eta", "2"]}], "+", 
  RowBox[{"5.162554279919121`", " ", 
   SuperscriptBox["eta", "3"]}], "+", 
  RowBox[{"6.942500000000001`", " ", 
   SuperscriptBox["eta", "4"]}]}]], "Output",
 CellChangeTimes->{
  3.859979286420108*^9, {3.859979454776904*^9, 3.859979471897004*^9}, 
   3.859979522774479*^9, {3.8599796817590637`*^9, 3.859979696167622*^9}, 
   3.85997986564351*^9, 3.859980292423744*^9, 3.859980521313834*^9, {
   3.859980750112173*^9, 3.8599807573848352`*^9}, {3.8599810596582108`*^9, 
   3.8599810714871597`*^9}, {3.860069831838385*^9, 3.860069902575004*^9}, 
   3.860070128366241*^9, {3.8600936182596617`*^9, 3.860093629191412*^9}, 
   3.860093758800995*^9, {3.860093797250745*^9, 3.860093855150216*^9}, {
   3.860093902981098*^9, 3.8600939492024117`*^9}, {3.860093999734728*^9, 
   3.860094031113935*^9}, {3.8600941085625353`*^9, 3.8600942342166862`*^9}, {
   3.860094712676215*^9, 3.860094746506145*^9}, 3.86009656982493*^9, 
   3.8600966010513163`*^9, {3.8600973832721777`*^9, 3.860097400296768*^9}, {
   3.860097502639399*^9, 3.860097506619907*^9}, 3.86009759411378*^9},
 CellLabel->
  "Out[450]=",ExpressionUUID->"eccc8b45-948b-4d29-9ff6-76ff2e5dd84a"],

Cell[BoxData[
 RowBox[{"1.2037062152420224`*^-35", "+", 
  RowBox[{"2.5226209918027153`*^-18", " ", "eta"}], "+", 
  RowBox[{"0.1321671473425976`", " ", 
   SuperscriptBox["eta", "2"]}], "+", 
  RowBox[{"0.7270959973555008`", " ", 
   SuperscriptBox["eta", "3"]}], "+", 
  SuperscriptBox["eta", "4"]}]], "Output",
 CellChangeTimes->{
  3.859979286420108*^9, {3.859979454776904*^9, 3.859979471897004*^9}, 
   3.859979522774479*^9, {3.8599796817590637`*^9, 3.859979696167622*^9}, 
   3.85997986564351*^9, 3.859980292423744*^9, 3.859980521313834*^9, {
   3.859980750112173*^9, 3.8599807573848352`*^9}, {3.8599810596582108`*^9, 
   3.8599810714871597`*^9}, {3.860069831838385*^9, 3.860069902575004*^9}, 
   3.860070128366241*^9, {3.8600936182596617`*^9, 3.860093629191412*^9}, 
   3.860093758800995*^9, {3.860093797250745*^9, 3.860093855150216*^9}, {
   3.860093902981098*^9, 3.8600939492024117`*^9}, {3.860093999734728*^9, 
   3.860094031113935*^9}, {3.8600941085625353`*^9, 3.8600942342166862`*^9}, {
   3.860094712676215*^9, 3.860094746506145*^9}, 3.86009656982493*^9, 
   3.8600966010513163`*^9, {3.8600973832721777`*^9, 3.860097400296768*^9}, {
   3.860097502639399*^9, 3.860097506619907*^9}, 3.860097594117832*^9},
 CellLabel->
  "Out[451]=",ExpressionUUID->"a64d18b2-8163-4731-b6c4-790b5e0fe8bc"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJwl13c8Ve8fAHDrnmtz7VH2JgrZnE+IBtmzkNWQr6TICA0kUUkp0iTJKFEq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       "]]},
     Annotation[#, "Charting`Private`Tag$139078#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-10, 10}, {0., 43.89776913338595}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic},
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.859979286420108*^9, {3.859979454776904*^9, 3.859979471897004*^9}, 
   3.859979522774479*^9, {3.8599796817590637`*^9, 3.859979696167622*^9}, 
   3.85997986564351*^9, 3.859980292423744*^9, 3.859980521313834*^9, {
   3.859980750112173*^9, 3.8599807573848352`*^9}, {3.8599810596582108`*^9, 
   3.8599810714871597`*^9}, {3.860069831838385*^9, 3.860069902575004*^9}, 
   3.860070128366241*^9, {3.8600936182596617`*^9, 3.860093629191412*^9}, 
   3.860093758800995*^9, {3.860093797250745*^9, 3.860093855150216*^9}, {
   3.860093902981098*^9, 3.8600939492024117`*^9}, {3.860093999734728*^9, 
   3.860094031113935*^9}, {3.8600941085625353`*^9, 3.8600942342166862`*^9}, {
   3.860094712676215*^9, 3.860094746506145*^9}, 3.86009656982493*^9, 
   3.8600966010513163`*^9, {3.8600973832721777`*^9, 3.860097400296768*^9}, {
   3.860097502639399*^9, 3.860097506619907*^9}, 3.860097594167305*^9},
 CellLabel->
  "Out[452]=",ExpressionUUID->"20965b30-ec17-4e62-b7f4-ecd3c2b05f1c"]
}, Open  ]],

Cell["\<\
Extract the various parts of the numerator for the paper. We drop the 10^-18 \
and 10^-12 factors because they are due to numerical error. We can check that \
by evaluating  wstar*what at {eta->0} and watching how these terms vanish.\
\>", "Text",
 CellChangeTimes->{{3.860098422111086*^9, 
  3.860098521042143*^9}},ExpressionUUID->"ab0dc3b1-98d9-4898-a477-\
0af311278b89"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"1.026961399568269`", " ", 
     RowBox[{"eta", "^", "2"}]}], "+", 
    RowBox[{"5.162554279919121`", " ", 
     RowBox[{"eta", "^", "3"}]}], "+", 
    RowBox[{"6.942500000000001`", " ", 
     RowBox[{"eta", "^", "4"}]}]}], "//", "Factor"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"0.14792386021869194`", "\[VeryThinSpace]", "+", 
   RowBox[{"0.7436160287964163`", " ", "eta"}], "+", 
   RowBox[{"1.`", " ", 
    RowBox[{"eta", "^", "2"}]}]}], "//", "Factor"}]}], "Input",
 CellChangeTimes->{{3.86009685488605*^9, 3.8600968827366533`*^9}, {
  3.8600969558613167`*^9, 3.860096996572214*^9}, {3.860097061143511*^9, 
  3.860097077030224*^9}},
 CellLabel->
  "In[418]:=",ExpressionUUID->"b1d53c6b-9aea-4f8a-a779-b42747b4f5bb"],

Cell[BoxData[
 RowBox[{"6.942500000000002`", " ", 
  SuperscriptBox["eta", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"0.14792386021869194`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.7436160287964163`", " ", "eta"}], "+", 
    RowBox[{"1.`", " ", 
     SuperscriptBox["eta", "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.860096856465209*^9, 3.8600968840327597`*^9}, {
  3.8600969826418247`*^9, 3.8600969967765417`*^9}, {3.86009706475133*^9, 
  3.860097077443913*^9}},
 CellLabel->
  "Out[418]=",ExpressionUUID->"8afa1632-50fe-4939-9288-1eb76272ad76"],

Cell[BoxData[
 RowBox[{"1.`", " ", 
  RowBox[{"(", 
   RowBox[{"0.14792386021869194`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.7436160287964163`", " ", "eta"}], "+", 
    RowBox[{"1.`", " ", 
     SuperscriptBox["eta", "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.860096856465209*^9, 3.8600968840327597`*^9}, {
  3.8600969826418247`*^9, 3.8600969967765417`*^9}, {3.86009706475133*^9, 
  3.8600970774473267`*^9}},
 CellLabel->
  "Out[419]=",ExpressionUUID->"59bce137-824e-42d9-9de1-8dd8406a8c22"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Breaking the Deadly Triad", "Section",
 CellChangeTimes->{{3.860098529105335*^9, 
  3.860098536314917*^9}},ExpressionUUID->"ec0d335b-fb2b-40e8-a0ab-\
dcabb0e310b8"],

Cell[TextData[{
 "We analyze ",
 StyleBox["Breaking the Deadly Triad",
  FontSlant->"Italic"],
 " here, showing how the bounds are vacuous. Note that a key factor \
controlling the tightness of the bounds is the condition number of Phi, which \
is NOT minimal in this example. Check three_state_bonus_example.nb and/or the \
appendix for an analysis of an example with a smaller condition number."
}], "Text",
 CellChangeTimes->{{3.860098539112932*^9, 
  3.860098677182569*^9}},ExpressionUUID->"1dfb32c9-9410-4f8d-91e7-\
51ec1ada1cbd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"PDmag", "=", 
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"P", "\[Transpose]"}], ".", "Dm", ".", "P"}], "]"}], ",", " ", 
     
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "p"}], "&&", 
       RowBox[{"0", "<=", "q"}]}]}]}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C0", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", "xi"}], ")"}], "*", 
      RowBox[{"\[Sqrt]", "eta"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"gamma", " ", "*", " ", "PDmag"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", "R", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "xi", "*", 
       RowBox[{"\[Sqrt]", "eta"}]}], ")"}]}], " ", "+", " ", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"normPhi", "=", 
   RowBox[{"Norm", "[", 
    RowBox[{"Phi", " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"epsilon", "->", " ", "0.0001"}], ",", " ", 
       RowBox[{"param", "->", "1.2"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"C0", " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "->", "worstp"}], ",", 
    RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.860146357976467*^9, 3.860146383288048*^9}, {
  3.8601464192210083`*^9, 3.8601465412770863`*^9}},
 CellLabel->
  "In[495]:=",ExpressionUUID->"c4ce82ab-3180-47ed-9211-a31949bf1182"],

Cell[BoxData["0.375`"], "Output",
 CellChangeTimes->{{3.860146413548478*^9, 3.860146439408141*^9}, {
   3.860146474518424*^9, 3.860146509540717*^9}, 3.860146541731763*^9},
 CellLabel->
  "Out[495]=",ExpressionUUID->"6b1c9d10-71dc-4ac8-b9a6-c558292f4507"],

Cell[BoxData[
 RowBox[{"5.3872053872053876`", " ", 
  SqrtBox["eta"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "xi"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.860146413548478*^9, 3.860146439408141*^9}, {
   3.860146474518424*^9, 3.860146509540717*^9}, 3.860146541735737*^9},
 CellLabel->
  "Out[500]=",ExpressionUUID->"668480c1-a41b-4c7c-b39f-52a444839794"]
}, Open  ]],

Cell[TextData[{
 "According to the argument in the paper, the solution at convergence (using \
their update rule) is the same as wstar that we computed earlier. We observe \
how their bounds affect the solution we obtain.\nWe begin by characterizing \
the norm of Phi and checking if it is less than C0. This means that any value \
of xi imposes a ",
 StyleBox["minimum",
  FontSlant->"Italic"],
 " corresponding value of eta:"
}], "Text",
 CellChangeTimes->{{3.860146402511549*^9, 
  3.860146403271744*^9}},ExpressionUUID->"5f4fda42-e9eb-4cda-969c-\
eb1e5df33d1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", " ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"C0", " ", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"p", "->", "worstp"}], ",", 
         RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], ")"}], ">=", 
     "normPhi"}], " ", "&&", " ", 
    RowBox[{"0", "<", "xi", "<", "1"}]}], ",", " ", "eta"}], "]"}]], "Input",
 CellChangeTimes->{
  3.860146410636833*^9, {3.860146559335251*^9, 3.860146593550577*^9}},
 CellLabel->
  "In[502]:=",ExpressionUUID->"3bd4ae5c-aa51-4012-b477-379aa7f7e088"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 502, 81, 21875472668881988173, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8601465620134573`*^9, 3.860146594091367*^9},
 CellLabel->
  "During evaluation of \
In[502]:=",ExpressionUUID->"09e41251-8212-407e-8b0d-dca2d41e5a69"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "xi", "<", "1.`"}], "&&", 
  RowBox[{"eta", "\[GreaterEqual]", 
   RowBox[{"1.9478572030457207`*^20", "/", 
    RowBox[{"(", 
     RowBox[{"1.1008106857414758`*^21", "-", 
      RowBox[{"2.2016213714829516`*^21", " ", "xi"}], "+", 
      RowBox[{"1.1008106857414758`*^21", " ", 
       SuperscriptBox["xi", "2"]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.860146562028221*^9, 3.8601465941015882`*^9},
 CellLabel->
  "Out[502]=",ExpressionUUID->"7dd2785d-ad76-46e3-8962-d7e7ff1ae48d"]
}, Open  ]],

Cell["\<\
We select the smallest Rb1 and Rb2 that are consistent with Theorem 2:\
\>", "Text",ExpressionUUID->"a94bf84e-691a-405d-8fae-0cf67a5083fb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Rb1", "=", " ", "C1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rb2", " ", "=", " ", 
   RowBox[{"Rb1", "-", "xi"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8601466178792*^9, 3.860146625359336*^9}},
 CellLabel->
  "In[503]:=",ExpressionUUID->"01891cfb-7533-4b4f-acdc-5d80c479af59"],

Cell[TextData[{
 "Compute the error bounds offered by Theorem 2 in ",
 StyleBox["Breaking the Deadly Triad",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellChangeTimes->{{3.860146654712219*^9, 
  3.860146658816497*^9}},ExpressionUUID->"8ec22628-eb66-4b46-920f-\
26db4605d64e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"maxSVPhi", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Phi", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", 
     "SingularValueList"}], "//", "Max"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minSVPhi", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Phi", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"param", "->", "1.2"}]}], "}"}]}], "//", 
     "SingularValueList"}], "//", "Min"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minSVDm", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Dm", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"epsilon", "->", "0.0001"}], ",", 
        RowBox[{"q", "->", "0.44"}], ",", 
        RowBox[{"p", "->", "testp"}]}], "}"}]}], "//", "SingularValueList"}], 
    "//", "Min"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"projV", "=", 
   RowBox[{
    RowBox[{"Phi", ".", 
     RowBox[{"Inverse", "[", 
      RowBox[{
       RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], "]"}], ".", 
     RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "V"}], "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"p", "->", "testp"}], ",", 
      RowBox[{"q", "->", "0.44"}], ",", 
      RowBox[{"param", "->", "1.2"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errb", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "xi"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"maxSVPhi", "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"minSVPhi", "^", "4"}], "*", 
           RowBox[{"minSVDm", "^", "2.5"}]}], ")"}]}], "*", 
        RowBox[{"Norm", "[", "P", "]"}], "*", "eta"}], " ", "+", " ", 
       RowBox[{"Norm", "[", 
        RowBox[{"projV", "-", "V"}], "]"}]}], " ", ")"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"param", "->", "1.2"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"errb", "//", "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{"Reduce", " ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"C0", "/.", 
      RowBox[{"{", 
       RowBox[{"epsilon", "->", "0.0001"}], "}"}]}], ")"}], ">=", "normPhi"}],
    ",", " ", "eta"}], "]"}]}], "Input",
 CellChangeTimes->{{3.860146666257938*^9, 3.860146902476053*^9}, 
   3.860150671333001*^9},
 CellLabel->
  "In[551]:=",ExpressionUUID->"7aee745c-cba8-4528-83f9-e7e5981a3cbb"],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"4360.247897539064`", " ", "eta"}], "+", 
    "0.0001271583175132765`"}], "xi"], TraditionalForm]], "Output",
 CellChangeTimes->{{3.860146789247221*^9, 3.860146879403*^9}, 
   3.86015067165829*^9},
 CellLabel->
  "Out[556]//TraditionalForm=",ExpressionUUID->"cd0fb9da-bf5c-4988-bb7f-\
c794fb0eca65"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 557, 87, 21875472668881988173, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.860150671680174*^9},
 CellLabel->
  "During evaluation of \
In[551]:=",ExpressionUUID->"3db4a55a-70c5-41a0-9c65-3a8091bd27ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xi", "<", "1.`"}], "&&", 
  RowBox[{"eta", "\[GreaterEqual]", 
   FractionBox["1.9478572030457207`*^20", 
    RowBox[{"1.1008106857414758`*^21", "-", 
     RowBox[{"2.2016213714829516`*^21", " ", "xi"}], "+", 
     RowBox[{"1.1008106857414758`*^21", " ", 
      SuperscriptBox["xi", "2"]}]}]]}]}]], "Output",
 CellChangeTimes->{{3.860146789247221*^9, 3.860146879403*^9}, 
   3.8601506716901493`*^9},
 CellLabel->
  "Out[557]=",ExpressionUUID->"85ccee0b-1980-43dc-a8f1-cc01c676b6d4"]
}, Open  ]],

Cell["Set reference eta to the minimum allowable:", "Text",
 CellChangeTimes->{{3.860150821695902*^9, 3.860150836616461*^9}, {
  3.8601508762136374`*^9, 
  3.860150881814365*^9}},ExpressionUUID->"0ce18bec-8ece-4bf6-a76a-\
cd119f911e73"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"etabound", "=", 
   RowBox[{"1.94786", "*", 
    RowBox[{
     RowBox[{"10", "^", "20"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1.10081", "*", 
        RowBox[{"10", "^", "21"}]}], "-", 
       RowBox[{"2.20162", "*", 
        RowBox[{"10", "^", "21"}], " ", "xi"}], "+", 
       RowBox[{"1.10081", "*", 
        RowBox[{"10", "^", "21"}], " ", 
        RowBox[{"xi", "^", "2"}]}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"etabound", "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.8601508876717052`*^9, 3.860150901952873*^9}, {
  3.860154802115119*^9, 3.860154807269779*^9}},
 CellLabel->
  "In[587]:=",ExpressionUUID->"0cce7aca-f8dd-4c5f-ba77-585c821310a5"],

Cell[BoxData[
 FractionBox["0.17694788383099716`", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", "xi"}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.860154803391737*^9, 3.860154807475058*^9}},
 CellLabel->
  "Out[588]=",ExpressionUUID->"3b672642-6d02-4d73-9218-a20093006377"]
}, Open  ]],

Cell["Use this to select the xi that minimizes the error bound:", "Text",
 CellChangeTimes->{{3.860150915052876*^9, 
  3.860150927081564*^9}},ExpressionUUID->"e8e6016a-c042-4ffd-a836-\
c5a7a919393b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"minimalerrb", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"errb", " ", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "->", "testp"}], ",", 
        RowBox[{"eta", "->", "etabound"}], ",", " ", 
        RowBox[{"epsilon", "->", "0.0001"}]}], "}"}]}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", "<", "xi", "<", "1"}]}]}], "]"}], "//", 
   "Together"}]}]], "Input",
 CellChangeTimes->{{3.860150930956012*^9, 3.860150978360236*^9}},
 CellLabel->
  "In[562]:=",ExpressionUUID->"6f545547-2d4b-4c0c-a6ee-f098427ea960"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.0001271583175132765`", " ", 
   RowBox[{"(", 
    RowBox[{"6.067528893859844`*^6", "-", 
     RowBox[{"2.`", " ", "xi"}], "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["xi", "2"]}]}], ")"}]}], 
  RowBox[{"xi", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1.`"}], "+", 
      RowBox[{"1.`", " ", "xi"}]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.860150948130712*^9, 3.86015097907062*^9}},
 CellLabel->
  "Out[562]=",ExpressionUUID->"a4424ff3-9fbf-494e-b26d-5bd21976702f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LogPlot", "[", 
  RowBox[{"minimalerrb", ",", 
   RowBox[{"{", 
    RowBox[{"xi", ",", "0", ",", " ", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"minerrbactual", " ", "=", " ", 
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"minimalerrb", " ", ",", 
      RowBox[{"xi", ">", "0"}], ",", 
      RowBox[{"xi", "<", "1"}]}], "}"}], ",", "xi"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"First", "[", "minerrbactual", "]"}], "/", 
   RowBox[{"Norm", "[", "V", "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{"param", "->", "1.2"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.860150984960414*^9, 3.8601509900251617`*^9}, {
   3.860152513089628*^9, 3.860152532929096*^9}, 3.860152632685055*^9, {
   3.8601526627008133`*^9, 3.860152662927422*^9}, {3.860152888440029*^9, 
   3.860152896398397*^9}, {3.860155028349015*^9, 3.860155056769858*^9}},
 CellLabel->
  "In[598]:=",ExpressionUUID->"979335e8-b5c7-4086-bb8c-a56ea0bdae6c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], Dashing[{}], CapForm[
      "Butt"], LineBox[CompressedData["
1:eJw92Xc81d8fB3ChKJlJiPjcaaVNNN6nKCMaKA1kpaJCJCMZSSqjkCRKskf2
yIhkZY97rxVKknEv+Vaiot/xz++v+3g+7udxHudzzuuc8z6PD2HtaHSOm4uL
6/kyLq6l31vWh0rMnE1hhxNX7/2LSogSLJv0T+4UbOr/VnNeSwn91bd5bEWz
gOWX/5ieHVVEEwGMGqsoKyCNDB5491gRmdr+qgiXsoVMV533hcaKqEZLuvhd
rB3cW3vyWsk6RbSZvCfnh9xF6N6iYLluWAHFclumUV86gJSC3LOnuQqIf9g/
4QTtCry5kBl79rYCKv3Y2fLOxAnOC73mLTRTQE5HbfXNopzhvXLtMXF1BTSw
6Y5WiJQrCAgqFpl+p6PI55JV1DPXoNnmktkzBh3pC6fvfhPrBt28Tacziumo
aKp5x7ScBzwwvmZyxp+OLllY5N2x8oQb+4Z25V6kI1LrtKr8Sy8gj1UUbTai
o9AsMYVjtJsg/d+9qQM0Ojogm5g4ft4HgGVxPEeUjm7WxYi8NfEFouRCInuB
hrarqYScivKDqysfG8f10FD82iOB96QC4O37eyW3HtGQV8vjmhOlAUCfuJ6w
JpCGTtz+yE0+cxtc2nkX1l+nodU/nX3KYgMhjOGW5XmahtwZke5subvgVFRw
sJVKQ8bBA0UlVXdhbeJ1VS8pGlLVpv0MsLoHqqHh690EaWgkv9hZ9uV9oL5N
eawzS0XHIvrsD9NCobibLrisiYpUDpHTpOtDwZcWJFRTRUX8PJe+jp4PA3cb
z5yKIio6+3oxt9LkARjavj9i8JKK1io+UD0Z9RBe9Q/3vbhJRX78+fS7UpFQ
YZvxpXM3FSnpPAzKc4oEvUATWvh2Kuq87TjeXx8JeXSu1msqVEThUclQdXsE
xUzd5CQZKqpbSFRldEYBU2Ty7d1FClr9PWqHXPATmM4pfhdTT0GFW65F6X5+
AssmTYdV3lKQhZPxL2fNGPj853Ahs5SCsjnCr2vGYsA5Q5h+8RUFGY0F7bY/
EAuax7ZuDYqioOgBT63CxWfQIhczs8eegvbJnEocPP4cGuj+w/9sKWjitPpy
/qzn8HTnd5OOsxS0ge1hk7UxHsJHDa68OE5BjhfVqFwf4mGxx7CTs4+CxGyz
U5N2JgAjPK5hXoaCTp56kf1tJhEaqhoKj/ST0XS/yaoE6SQ4Gy79tLabjAIt
+M8ZayWBI2X9r/0MMsq3cZQuikwCpQXLBOMWMhK6sue2l3oyuC286XxfSUa1
/r2nV3ingMiffMb3JDLamim6QoY/HXbc4h9KdSOj96q1li2b02FCXr/gowsZ
Wea6l908lQ5c78ptZZ3JKKRoyOlTejrcP79cJsmBjMaqsvqTDTPg+4SDCduS
jJ4x9XK3RGSCVUaDxmEDMhL452emsyEbJNbcPSRII6Poi6YWKgezwfE+l28X
mYwoDBVL0SvZwHTJ+RtLkNHetG6b/ops8Or/kqUhS0av06IKi1VzQKb9vsgT
cTLiGLPLD7XmgPQ4bfc4DxkdT33c5CKYB9vP/4h6PkJCseb+BnZEHkR3r+ZU
DZPQsNjllpM78uD39vVFIx9JyNF7f9se8zzYweQJ3jZAQneNOJ18WXkQrkMu
5jBJqOLv/r6nBvkwrXypqq2ehKjHpsbe3S8Arp8R+spZJCTto6N5/kUBpNs5
HHbMICGRrPj7q4oLwLaFGlqYRkK/+Y1Vjw0XwH3xf690k0movarYZXBnITjJ
us8HPSchz81+i3NfCmHv88XZy+Ek1CosLq6KioE8f2zPKw8Serfn8rmO48Vg
fHczc4s7CZU41BW5OhQDqYqqWuxGQi/r3U+VRRWD08V8iXoXEnL3GXimyymG
g169Dn8ukxBpOlnRJqYEggX1QvKtSeh6qwZE/3gNhoFpzocNSUhItfDLe/5S
kIwbiZE2IKHEkM3Bf2RKIfC3KNeYPgl1GNB7LQ6UQpj7oFugLgkpN4m7UKNK
YfPTC587tEhoqH46OU+9DMZy51RfaJKQztskoRbPclgo2ycooUhCg/JE4WJo
OXDEkf0KBRJy9Y09s/llOXzYcKztF42EXkBEakRTOYg1iWYOUEjoT4Xv/tMy
FfAgxuduoTwJZZeecftaUQF8iuzUSEkSWlcgOrhsWSVUnrmYybeShMyC/5iM
SFRC/rSyDTc/CSXYfmmqU6mEb0dNiMUVJKSy9vXr+ycrwU3W6NUcLwntd7N8
tDanEueJ98s8FwmpxZomR26qAtnWW8+U5wlkZZFsnjpYBapVjEitCQIVDWs1
t+2uhhjbmDy+NgKxdP1mQnSq4c4R39y9rQSaffVGwsCoGrqCBR3cWgik7qVh
1XC+GiBkYtVYE4FK1myarQqvhiTrR1+7Ggj0WltaPm+sGlKpVhdaqglUnvzN
JTLyHbBLzC7uLyZQtX3c+lPsGlh3p/SgcAKB8scdHCxma0By+CjF8wWBEi9o
ltlw1cIyiU8+X+IJdNuu+/QV8Vr4smlndsVzAulai8bc2l0LbPbnYZc4ArWd
ui35KrgW/iVq7fsVTaAPupfX8mysA8dkEVHTBwT6SdsjnHW5HpQXjZztfAm0
d3h//T33euD473v22YdAgXG6Phdu1YNJ34KWFbaEuMk0+Uk9ZF8ymTO/SSC1
ZQ5tMTX1cDSlbt7sBoHc+6PDgtY3QIQqW8DZnUB/w34I275vgONU9/EpJwJx
z2eIrKc2Ao+A6KyqDYHWt+z/Dpsa4busjlurNYG2v+hl2mo0Qu1OH8Mr2Of0
+J6+MmyEcl0RrmwrAjU8sabud2sEnV2+jtstCRSmKaV5sb4RhBsaDh4xJ5DM
jUCb4otNoPZx3PydKYF2HJU9+MGlCewP7zW5jH2YUqCw7GYTDN35GrMO26f5
E0c/vAlITVclL58g0LDMHvfB0ibwkBNrW3+cQGkV34OXr26GQ19OcgUZ4ff9
Z1lk/KoZdGePbYwxJJCBYZX/gZJm+K3jZHQE2+ap3BH16mZIa1Kv5MV+oD74
VZrVDHEbCEcnAwKNO56RGl5oBvunC+RDhwgU+/H4DSfDFtiieLVSUI9Ay6r1
94ewWyBs+mFenTaBJEXShXxmWyB5+Ue/AGxVi5X9TlytEH1XNnI/9unf9S4m
4q3wRqrPt1KLQAVbDySt390KZrpB18v3E8juJfCn32+F5FtpZdWIQM0B21vr
lNpgwnqg8N9uAmkKN3E/3NEG9Z1xBVXYqU+s1M+gNrAI1l/ww771KjR++ngb
rPBocli+9HzP2FVJvzYQ30Z/LbwLP68ct86+uw2UtxR+36JBoP3j/jkr9rfD
r6zDIxk7COSh2trooNMOfGvvdF/DznGR+tJu0A7fLEVFEPaGxWypp6btoNcb
fpS5nUDzYgP+my63g+5YhAAPds5u9eMno9vhu7i5gcNWAsk9mJxPm2qHXdaf
JK5sItAbK5+0vO/twLB08tXCtti25lTZXDsIew6SpLBjWZolzdwd4Cr4S7RW
FY+n7D23aYkO6LvrHiWHLZau8H07dMC2aG7KkAqBltecY1eGdUDDka05d5Tw
ens0/7QhsgPs7lzlt8XWPh9yqONJBwRoFkchbP9VhenDLzsgNH7O5LcigRaP
8l5cXtIB9/5becIJe24g4Yv+xw4oH5U7aadAoMlfQ4PMzZ2Q/Uui1YOG95fz
YdX6ap3wQr3u6Gls3+69yZW7OqEjeFZ4F7ZEcdzltIOd4HHdU2uBisfX7czf
G2adsPDD9UYAdswPlhQlqBOCNxYSzyh4vdgGLkSHdEJ4nL2VP/Zmxo5PghGd
EPhC5YMddl1+ZOqvuE6YSrnhvxl75qqRelN+JwzXDITVkfH+MdNicnWoE050
eMYskAi0xsp759eRTlj5LNn3C/Zgu4qM2UQnFLzzj2/Bds25//nAz064vmMu
+Bn2c0e9q1ICXbDv7EMJLexZTk1YlVoX2AhG9EURBHpr7uqyY3cXVL2VNfLH
Dm4hm6bv64KUg2u4r2CTsvw3RBp0wf0T31YdxDa8hLLOW3eBj6bRmzl5PB8T
ZY1CoV2QUT4bcwH7yuMjZPuILkjd7zxkiq2u/dmrNroLdh+mndLBboxbtfHG
yy44Fft7koY9c/RU2HhJF5xIsg8ZkyNQ6QL7q/abLnhn1+3Rix2Q7ovi33WB
IOtnTCO2JG/qzInWLghN5/XKwt5bPGtc87kLdIOic65h89vey5Qb7wLLx1Xo
AnanyIblXlNdkPh77fIz2OfsDxRtme+CrkE+pX3YwbKRks+FGJDXeuCzMHbv
rS0DHhoM4Js5srx4A4ESNtfuYO5lgFkyqz0T+9LAydDN2gzImQ5tS8DmUveF
r4cZMPrY1C4MmzbR+sLElgHntBJ/2WN/i7L+nX2RAWuUxM5YY5dqzRoJODLg
8qLGzClswzhZ3moPBjS33ijUw3Y9esluUxgDWmV2xipj71349+ZeJAO0hQcj
KNh86RHrRp8wwEinsUIWO4anrCE2kQG2A7tTRbBtcw4Tc2kMiF+dcmEVtqr5
sIdxNgNqyXJneLHfFq1UXlXKAK7jy1hzsgS6ZxN361wlA2pKj1h8xzYR2fKh
qoYBBc9dJaewxy6eDLnexoCvFAHSCHaeBPtLJ4MBz+5aOQ9he73z2avaxwCT
WdP/+rCFZFOmR0YY0CA+HdSJjU7cGvg8jvuz2+1jK/bVsLNNw1MMoAnOWzdh
s5ZJpnycY4DF67qxGmz+XT8ihxYYoK/xd/IttqZru/8gNxN00rmlK7GfjQZZ
fFjNhF75k7Ovsdvlzhn0izLBhRSeWIzNfWqfZp8EE8QFXbwLsbeHyyr0rmfC
mMc333xsu6b5tT3yTBhdzZWdix3Ny+LppjKhyfUxXw524568GaYSE9Y4ZN57
hf3XLXSIsYkJ4/nbd2Zhq+bYt3RtZwJ9A00kE9ty/GBZpwYT9G65iWVgh5PI
aR17mWBTvx7SsWvO/Itq12LChl6BqDTs2cj+gDZdJmTm7l63ZIXW4quthkyo
MkmsTsU+zRdp2WLEhMD2ndFLDkZOh5tNmRC759vjJb/xMNjdZMYE/sqqt0v+
lqeg1GjFhC3+8WuX2iOxeSXf2zGh+83tiCWbUD8tb3BggkCx3a6l/gRaVHyv
c2ICtVhDcKm/JY+ffKq9xoTKtT/5l95nov1aW40nE7K2hakuva/MKqOKdz5M
mPFa9F4aD0Mt1YzqACaU2Gj8ysa+eWPVk7d3mXDUXi1maTxzCkcDq0KZQEix
7ZbGe3iq2rUyggmJPMfMl+ZDXOG59ZtoJpjVn/Femq+DVl5HK+KY0C7AU780
n+4xpnvLE5jg679Hsxz7w2oR6dJMJhgvHoxbyoPQQTbf61wmSEfzhCzlBfk0
/CwuYsLJENXkeuzEGd+OwiomfJLLMFnKG0vJvLKglgne8RPjHUv5stXIym9k
AknLNZWJfYk1E5TLwPmS3/9iYClfwq1uOb1M6Lvv2v9pKV+66bbZg0wI9mrZ
O7qUpzJrlDXGhBP5bb7TS/l43vUr9S8THm0iZniW1ltv9peUZSxoIke4rMS2
FAvuSl7BgmLl0Q3C2DUB2tmJIixYcBb8Jo0dfLHQLp7CgoPVrl7bsSdQVpCA
Egucp5t6dmHrSCalu21iwSbqxDktbO76yCkDTRbsrDkmbIztQXF1mz/CAiPd
jDhXbNYfh2jb4ywo71nn7o29vcumtO00C/zZc36BS/uRn/Fi0jkWZOl+Iz/B
thvaGmjkxYKUTbHPq5b6V6SUWuHLAoGPkT8asUmhpEaFQNx+ap47E3tgt5jQ
vwcsOJ+nJjSJbRIz8ygjmQV7M40vS+L9c9/xnCTeThYUnY7/7oX9TCW13rGb
BRTKdbW72H954sf7PrCgeetAShR2SV7YxtyvLKg5sE0iD1tVxLHQfIEFrHYh
+UlsmaaNtUUK3ZBo8eXjOXxeeCZQvxKq3TAdE8nvht3tIbsyZFs3vBjQtQjE
DlcQNLTZ2w1XHJ9HpGCvDGQzhE26gViUo7KxZ1HGyAWfbqhwvPTBG59n5YmT
T68HdMOjuU8xYdj+/CrGgXe7YV0Wl98LbKH2zLcvI7rhGUe+phabdvbVs8GU
buAe3EcVwefpCe/ckybt3XBNpcEwE7vwdXEzED2wxzVamBuf556yc7cO03rg
ehezWBIb+e3cZa7cA6r/lt/ZhN2s+zrNc0cPmP+nGGOOPdJdGlio1wPI7lt4
Gbb4bAVSvtoDs+0ijTdxfeG6taZA4l0P/EiZUCHR8fxtl49/2NADB9hdvwD7
pNqN+6tbe2DTdM20OfYuze3W3L09kHs21S4Gm3t/ovDUVA8wjgw6rsX1T9ix
APta6V7Q5naeXIPro3QnbXnXq704H9dttyrjeu1qvMD09V5Qm/esO44d4vp3
9qJ3LzzmjJt4YDu5F7ScDeoFSd+52SpsdV+K16FnvSB/xvqIEa7fasJ4WaTG
Xrg8yzL03kigoVc19zuIPui3DbL7gevBdg4veyu9D9I1tcJkNhOoSuWAQaRK
H3ibnRnWxo5Pr11tqt4HD70e80VhWyfXhXww6AOLdLah5hYCjcY1hH293gdp
cw/q7+F6lBPcHLHQ0gdi/g/MDuF69o8946miZz/kWhg/0sf1sYma+UNVn34I
Pczq88DOXDYauC2gHxYsa7XTsC2ifznvCe0HH8uR2/y4vn5bK617LKEfpBWE
Khqw78hb/XBv7IcJabvFI3txPcbiGDRIf4D7G382eOwjkPI+vkW7sg9gUSJw
RVMXr98E4nzuukFIYVtv6zpJoOuyZ0mfzIYgt8f7wFt7Aqmwjwt0G36E7JzV
dSn4/rZG+Bt/ze+PoBUfdnkiikC8lU+zybGfIJRRcpOeQyCH7WW9Kw8Ng9ON
iSAPfN/N0LOOfzM7DGuMn/RenMb3x0lpkdGoz5Acn/ieLkpChcY6PJHaI3B7
3X9b9DVIyEf39vOC0RFYpT1vaGZNQsSAfs/L21+gIFzE+VgoCWmqB0RKbR2F
10fd5KOq8X1+Q9v8sq5R0FslUEyaI6GfjSHDTn5f4fOgmLrETjI+Py1cjShj
MBo4pEr2JKM1g4UJ3DVj8FdmaF3tWzJa7u1nouE8DnryR+7dlqQgrjSL7GGx
CfC5/sMoxYWCrsZkh4hVT0DoCcqtlSMUVKEcxC96ZRKuJST3N9pQkRpjXUu4
0yS0H9a1bT1HRTk3Uh6Ku0yCYUAires8FSW01ElLuk/CptmP5h8dqCjIcflG
Of9JaOnaUb7SlYqM8v2PbYyaBB/tHVeeBFDRV03vGL03k7DC6AezKJmKRPWv
qvgLsaHWflJEe5qK4t8KC2iKsoG1RuUQc4aKNmtkjc+sYUOXm6PLhR9UdFhh
LNlKig3SRrHRkfNUdG+FBbGPwoZ/SMqPl5eGeN/pSXBpssG8flHjgBQNze4i
uG6eY8ON6U+rzx6goQ8b27s8ytngI942kJtIQ88nRb15KtnwKDxXPCGFhqzT
jGkhb9lgvdf5TWQ6DY1Tut3j69iw1r3Vwy8Ht7d+ULa+nQ0/Hk78dS+nIdFV
7PPiX9jwkCVY9plBQwdH+f6+EuRA3539tnV8dLQyUS9ppwgH/P2K1gkK0FGz
1f3D1WIcWH2kvumEEB0ZDwi9YK7jgFL3ff3v4nRkyVh78C/BgaTfGurHSHTk
VU1+oKfGgRwn4kXSHjrKeQaUEQsOiGzlC+tzo6Pvnt/5rKw4kGalPOLhSUdq
pimTAzYcCJd52CNzk47KhIXzuy9wYOpDdenl23RU5zu4r+kqB0LfPVTaHUlH
/dbeZ/MCOVDzu1w5PI+OVtDLYnxfcYAmbi915j860uNxvLmQwwHR1M0W3rN0
FDxEsvbM58AN/tJDib/pSDT6nqJrCQdkSn31uHgUkMzK0yXnqzkwy036b2aN
Ato6Occ8zOJA5rV571o1BWSerSYqu8iBs4sCbX6+Cqjo9JxQO9cU6BJCOiW3
FZDQitLVt3im4KekrtjsPQVUZbaHf5x/Clxyzf+780gBkVZp/ytYMwVqxlvX
82UooFHbYxwDxSmQUWcfDOxWQFekL72/YTIFe54+/KmmrojqajfWbzKdAm+b
XZW39ygiOefpmuFTUzD4BUhDWoqovf5qle7ZKZjRFkR5RxXR1msexeL2U9A3
d6prwF4R/WoLTMr0wf3Jynh06YUi8r39wu9D+hQkTLId0ySVkOB1Pn2rrCk4
9KhxhYS8Eoq5cFlsNHsKLLR4SA/pSij/kMbL6YIp+DOsVpevpoRGRTtquCvx
/3asbbnHldCEpI+3Qu3U/7/v/A/qPLhs
       "]]},
     Annotation[#, "Charting`Private`Tag$172179#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 8.557926891399624},
  AxesStyle->GrayLevel[0],
  BaseStyle->{FontFamily -> "Times"},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  FrameTicksStyle->GrayLevel[0],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Helvetica", 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {8.557926891399624, 13.206145077994828`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {Automatic, {{8.517193191416238, 
       FormBox["5000", TraditionalForm], {0.01, 0.}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
          
          TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {10.819778284410283`, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "5", 
          
          TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {11.512925464970229`, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "1", 
          
          TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {13.122363377404328`, 
       FormBox[
        TemplateBox[{"\[Times]", "\"\[Times]\"", "5", 
          
          TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {0.01, 
       0.}}, {6.907755278982137, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.006367567650246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.294049640102028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.699514748210191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.85366542803745, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      8.987196820661973, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.104979856318357, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      9.903487552536127, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.308952660644293`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      10.596634733096073`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.002099841204238`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.156250521031495`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.289781913656018`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      11.407564949312402`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.206072645530174`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.611537753638338`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      12.89921982609012, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.304684934198283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.458835614025542`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.592367006650065`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.710150042306449`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.815510557964274`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.9108207377686, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      13.997832114758229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}],
  TicksStyle->GrayLevel[0]]], "Output",
 CellChangeTimes->{
  3.8601509911075563`*^9, {3.860152520936846*^9, 3.8601525335128403`*^9}, {
   3.8601526334655533`*^9, 3.860152663319441*^9}, 3.860152897033271*^9, {
   3.860155040199839*^9, 3.8601550571322737`*^9}},
 CellLabel->
  "Out[598]=",ExpressionUUID->"ef4a440a-db1b-4922-a813-8fb1a5230fab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5207.872690999563`", ",", 
   RowBox[{"{", 
    RowBox[{"xi", "\[Rule]", "0.33333334961103767`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8601509911075563`*^9, {3.860152520936846*^9, 3.8601525335128403`*^9}, {
   3.8601526334655533`*^9, 3.860152663319441*^9}, 3.860152897033271*^9, {
   3.860155040199839*^9, 3.860155057217874*^9}},
 CellLabel->
  "Out[599]=",ExpressionUUID->"1f5549d1-e935-4a85-945a-885a5cdeb76d"],

Cell[BoxData["1976.5254690681988`"], "Output",
 CellChangeTimes->{
  3.8601509911075563`*^9, {3.860152520936846*^9, 3.8601525335128403`*^9}, {
   3.8601526334655533`*^9, 3.860152663319441*^9}, 3.860152897033271*^9, {
   3.860155040199839*^9, 3.860155057227951*^9}},
 CellLabel->
  "Out[600]=",ExpressionUUID->"5fe5c140-1da2-4bb9-ad38-1244f0f7c30c"]
}, Open  ]],

Cell["At this bound, the corresponding eta is:", "Text",
 CellChangeTimes->{{3.860152655989725*^9, 
  3.860152676707818*^9}},ExpressionUUID->"d92f3fba-10ab-401f-a47b-\
abcd7c8b2462"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"etaboundactual", "=", 
  RowBox[{"etabound", "/.", 
   RowBox[{"{", 
    RowBox[{"xi", "\[Rule]", "0.33333334961103767"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.860152679737913*^9, 3.860152711975593*^9}, {
  3.860152917276434*^9, 3.860152920513184*^9}},
 CellLabel->
  "In[576]:=",ExpressionUUID->"b4524a2e-a453-4d96-814b-57036101fa10"],

Cell[BoxData["0.3981327580618054`"], "Output",
 CellChangeTimes->{3.860152712246578*^9, 3.860152921391355*^9},
 CellLabel->
  "Out[576]=",ExpressionUUID->"c9ee7112-23a9-4452-b41f-7e51ad2383ee"]
}, Open  ]],

Cell["\<\
A sanity check is that our counterexample is vacuous at this point:\
\>", "Text",
 CellChangeTimes->{{3.860153016067616*^9, 
  3.860153028869134*^9}},ExpressionUUID->"3d2fab4e-82ed-4f23-b436-\
3a194cb1e705"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"epsilon", "->", "0.0001"}], ",", 
    RowBox[{"eta", "->", "etaboundactual"}], ",", 
    RowBox[{"param", "->", "1.2"}], ",", 
    RowBox[{"q", "->", "0.44"}], ",", 
    RowBox[{"p", "->", "testp"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], ">=", 
   RowBox[{"Norm", "[", "V", "]"}]}], " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"epsilon", "->", "0.0001"}], ",", 
    RowBox[{"eta", "->", "etaboundactual"}], ",", 
    RowBox[{"param", "->", "1.2"}], ",", 
    RowBox[{"q", "->", "0.44"}], ",", 
    RowBox[{"p", "->", "testp"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Norm", "[", "V", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"param", "->", "1.2"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.860152876363989*^9, 3.860152880125874*^9}, {
  3.860152923878778*^9, 3.8601530064468117`*^9}, {3.860155002541849*^9, 
  3.86015501206047*^9}},
 CellLabel->
  "In[592]:=",ExpressionUUID->"ebce07ea-2ade-48b9-8db4-2885bb13a8e6"],

Cell[BoxData["2.685102651003554`"], "Output",
 CellChangeTimes->{{3.860152943293912*^9, 3.86015300680751*^9}, {
  3.860155005247788*^9, 3.860155012441413*^9}},
 CellLabel->
  "Out[592]=",ExpressionUUID->"b2d9044e-281d-4c63-8f9c-b836d7a80ebe"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.860152943293912*^9, 3.86015300680751*^9}, {
  3.860155005247788*^9, 3.8601550124705667`*^9}},
 CellLabel->
  "Out[593]=",ExpressionUUID->"868c2b1e-2741-4f13-819e-9339d0bcda64"],

Cell[BoxData["2.6348624252510797`"], "Output",
 CellChangeTimes->{{3.860152943293912*^9, 3.86015300680751*^9}, {
  3.860155005247788*^9, 3.860155012477707*^9}},
 CellLabel->
  "Out[594]=",ExpressionUUID->"799076bf-f693-4eeb-819a-0abc0124b160"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Small-Eta Divergence", "Section",
 CellChangeTimes->{{3.860156328302794*^9, 
  3.860156333592606*^9}},ExpressionUUID->"a8d39928-191b-4a4f-9a64-\
0ec795635a2f"],

Cell["\<\
We find some distribution where a positive eta can induce sA to be \
ill-conditioned:\
\>", "Text",
 CellChangeTimes->{{3.8601568425230837`*^9, 
  3.860156880245364*^9}},ExpressionUUID->"a2a800fb-33d2-4064-8ba7-\
1a21f716d560"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Dm", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"q", "->", "0.9"}], ",", 
     RowBox[{"p", "->", "0.5"}]}], "}"}]}], "//", 
  "Total"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"Det", "[", "sA", "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"epsilon", "->", "0.0001"}], ",", 
     RowBox[{"param", "->", "1.2"}], ",", 
     RowBox[{"q", "->", "0.9"}], ",", 
     RowBox[{"p", "->", "0.5"}]}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"tmp", "==", "0"}], "]"}]}], "Input",
 CellChangeTimes->{{3.860156645496879*^9, 3.860156653970847*^9}, {
   3.860156748450734*^9, 3.860156841084313*^9}, {3.860156888825714*^9, 
   3.860156907344554*^9}, 3.860156938078071*^9},
 CellLabel->
  "In[614]:=",ExpressionUUID->"afacf9f1-e858-4cb9-a7eb-0c950e5fd565"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04999999999999999`", ",", "0.04999999999999999`", ",", "0.9`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.860156781521316*^9, 3.860156825904728*^9}, 
   3.860156907731862*^9, 3.860156938431787*^9},
 CellLabel->
  "Out[614]=",ExpressionUUID->"baf86ddf-1730-41ef-ab06-870920bbd27d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.007466907718310101`"}], "+", 
  RowBox[{"0.054481249772499796`", " ", "eta"}], "+", 
  SuperscriptBox["eta", "2"]}]], "Output",
 CellChangeTimes->{{3.860156781521316*^9, 3.860156825904728*^9}, 
   3.860156907731862*^9, 3.860156938439046*^9},
 CellLabel->
  "Out[615]=",ExpressionUUID->"85453bb1-d46e-45da-85c1-a72bc3afdaa7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", 
     RowBox[{"-", "0.11784393256595593`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", "\[Rule]", "0.06336268279345614`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.860156781521316*^9, 3.860156825904728*^9}, 
   3.860156907731862*^9, 3.860156938445963*^9},
 CellLabel->
  "Out[616]=",ExpressionUUID->"8f893f56-bb45-4a35-a35a-5488cd7ae7f0"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1372.6238532110092`, 909.5779816513761},
WindowMargins->{{Automatic, 0.6605504587159885}, {
  18.32727272727277, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{Automatic, Automatic},
"PostScriptOutputFile"->"/home/gauravmm/print.pdf"},
TaggingRules-><|"TryRealOnly" -> False|>,
CellContext->Notebook,
Magnification->1.25,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"edb60e67-8447-428f-bf83-9bc5b3088beb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 485, 9, 49, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1068, 33, 4492, 119, 332, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[5563, 154, 1037, 26, 53, "Output",ExpressionUUID->"e5122073-5450-4c80-8137-9b809fb722df"],
Cell[6603, 182, 737, 15, 53, "Output",ExpressionUUID->"c435e542-7fbc-4876-8c5f-32ae87ee1b8e"],
Cell[7343, 199, 591, 10, 53, "Output",ExpressionUUID->"8277b709-02fb-4376-adad-e337a6e7e09c"],
Cell[7937, 211, 588, 10, 53, "Output",ExpressionUUID->"a2209abf-70bc-48e2-bbb2-7969cc2bccbc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8562, 226, 281, 5, 28, "Text",ExpressionUUID->"0a5d41cb-08ef-4253-a74f-02384f62cb6a",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}],
Cell[8846, 233, 1109, 29, 100, "Input",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56",
 CellGroupingRules->{"GroupTogetherGrouping", 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[9992, 267, 966, 23, 53, "Input",ExpressionUUID->"5c741a9b-2f35-4603-8157-51a0429cf235"],
Cell[10961, 292, 1331, 19, 53, "Output",ExpressionUUID->"804f9a2e-bd07-4464-9695-0e3b883656f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12329, 316, 170, 3, 44, "Subsection",ExpressionUUID->"392c3468-009e-44ad-9c2a-a546d20d6ec1"],
Cell[CellGroupData[{
Cell[12524, 323, 969, 26, 100, "Input",ExpressionUUID->"5ab2d7e0-3534-4f14-a5e8-3326ab1c7f5c"],
Cell[13496, 351, 511, 12, 53, "Output",ExpressionUUID->"52c98295-dcf4-4ea2-8d3d-d946370533e6"],
Cell[14010, 365, 18685, 332, 295, "Output",ExpressionUUID->"62f70d2c-9557-463b-a6b6-320e76f2b434"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32732, 702, 929, 20, 54, "Input",ExpressionUUID->"c56b9e37-437b-422e-a30e-166f285df79a"],
Cell[33664, 724, 423, 11, 53, "Output",ExpressionUUID->"4438b07a-1f00-4d3b-8fee-c3f7860b37d0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34136, 741, 172, 3, 44, "Subsection",ExpressionUUID->"81c795fb-2099-456a-94aa-2650a32156f4"],
Cell[34311, 746, 331, 7, 28, "Text",ExpressionUUID->"64f07ecb-e4bf-4a69-aecf-ed2061176501"],
Cell[CellGroupData[{
Cell[34667, 757, 926, 27, 100, "Input",ExpressionUUID->"cbb700c9-903c-4b75-ac3e-0e9c9622c628"],
Cell[35596, 786, 18708, 333, 295, "Output",ExpressionUUID->"147bbbe0-4570-474e-9038-60223062ed33"],
Cell[54307, 1121, 538, 13, 53, "Output",ExpressionUUID->"40bf632a-748d-4f56-92eb-7c604113bdfe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54882, 1139, 1606, 35, 100, "Input",ExpressionUUID->"3994771a-8fca-4fdd-9d46-41c965a7d7b0"],
Cell[56491, 1176, 1820, 36, 80, "Output",ExpressionUUID->"544a439e-7d7a-43b0-92ec-076c35ecfddd"],
Cell[58314, 1214, 1244, 21, 35, "Message",ExpressionUUID->"6680d163-95cb-4579-9a28-4327f770372a"],
Cell[59561, 1237, 10302, 245, 790, "Output",ExpressionUUID->"c46108a1-c334-4002-b380-2443fbfcbeb6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69900, 1487, 1966, 56, 170, "Input",ExpressionUUID->"a01ff745-b666-43f8-b696-6e1333ac5b44"],
Cell[71869, 1545, 1743, 39, 82, "Output",ExpressionUUID->"b92b3611-287c-412f-9ae8-fef68662ab7d"],
Cell[73615, 1586, 1335, 23, 53, "Output",ExpressionUUID->"eccc8b45-948b-4d29-9ff6-76ff2e5dd84a"],
Cell[74953, 1611, 1299, 22, 53, "Output",ExpressionUUID->"a64d18b2-8163-4731-b6c4-790b5e0fe8bc"],
Cell[76255, 1635, 15497, 276, 316, "Output",ExpressionUUID->"20965b30-ec17-4e62-b7f4-ecd3c2b05f1c"]
}, Open  ]],
Cell[91767, 1914, 383, 7, 49, "Text",ExpressionUUID->"ab0dc3b1-98d9-4898-a477-0af311278b89"],
Cell[CellGroupData[{
Cell[92175, 1925, 797, 20, 77, "Input",ExpressionUUID->"b1d53c6b-9aea-4f8a-a779-b42747b4f5bb"],
Cell[92975, 1947, 552, 12, 56, "Output",ExpressionUUID->"8afa1632-50fe-4939-9288-1eb76272ad76"],
Cell[93530, 1961, 503, 11, 56, "Output",ExpressionUUID->"59bce137-824e-42d9-9de1-8dd8406a8c22"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94082, 1978, 170, 3, 63, "Section",ExpressionUUID->"ec0d335b-fb2b-40e8-a0ab-dcabb0e310b8"],
Cell[94255, 1983, 535, 11, 49, "Text",ExpressionUUID->"1dfb32c9-9410-4f8d-91e7-51ec1ada1cbd"],
Cell[CellGroupData[{
Cell[94815, 1998, 1690, 53, 175, "Input",ExpressionUUID->"c4ce82ab-3180-47ed-9211-a31949bf1182"],
Cell[96508, 2053, 254, 4, 53, "Output",ExpressionUUID->"6b1c9d10-71dc-4ac8-b9a6-c558292f4507"],
Cell[96765, 2059, 361, 8, 53, "Output",ExpressionUUID->"668480c1-a41b-4c7c-b39f-52a444839794"]
}, Open  ]],
Cell[97141, 2070, 565, 12, 71, "Text",ExpressionUUID->"5f4fda42-e9eb-4cda-969c-eb1e5df33d1d"],
Cell[CellGroupData[{
Cell[97731, 2086, 572, 16, 53, "Input",ExpressionUUID->"3bd4ae5c-aa51-4012-b477-379aa7f7e088"],
Cell[98306, 2104, 479, 10, 35, "Message",ExpressionUUID->"09e41251-8212-407e-8b0d-dca2d41e5a69"],
Cell[98788, 2116, 533, 12, 56, "Output",ExpressionUUID->"7dd2785d-ad76-46e3-8962-d7e7ff1ae48d"]
}, Open  ]],
Cell[99336, 2131, 149, 2, 28, "Text",ExpressionUUID->"a94bf84e-691a-405d-8fae-0cf67a5083fb"],
Cell[99488, 2135, 331, 8, 77, "Input",ExpressionUUID->"01891cfb-7533-4b4f-acdc-5d80c479af59"],
Cell[99822, 2145, 275, 8, 28, "Text",ExpressionUUID->"8ec22628-eb66-4b46-920f-26db4605d64e"],
Cell[CellGroupData[{
Cell[100122, 2157, 2636, 79, 193, "Input",ExpressionUUID->"7aee745c-cba8-4528-83f9-e7e5981a3cbb"],
Cell[102761, 2238, 362, 10, 70, "Output",ExpressionUUID->"cd0fb9da-bf5c-4988-bb7f-c794fb0eca65"],
Cell[103126, 2250, 455, 10, 35, "Message",ExpressionUUID->"3db4a55a-70c5-41a0-9c65-3a8091bd27ed"],
Cell[103584, 2262, 517, 12, 76, "Output",ExpressionUUID->"85ccee0b-1980-43dc-a8f1-cc01c676b6d4"]
}, Open  ]],
Cell[104116, 2277, 236, 4, 28, "Text",ExpressionUUID->"0ce18bec-8ece-4bf6-a76a-cd119f911e73"],
Cell[CellGroupData[{
Cell[104377, 2285, 736, 20, 77, "Input",ExpressionUUID->"0cce7aca-f8dd-4c5f-ba77-585c821310a5"],
Cell[105116, 2307, 340, 8, 74, "Output",ExpressionUUID->"3b672642-6d02-4d73-9218-a20093006377"]
}, Open  ]],
Cell[105471, 2318, 199, 3, 28, "Text",ExpressionUUID->"e8e6016a-c042-4ffd-a836-c5a7a919393b"],
Cell[CellGroupData[{
Cell[105695, 2325, 603, 16, 54, "Input",ExpressionUUID->"6f545547-2d4b-4c0c-a6ee-f098427ea960"],
Cell[106301, 2343, 559, 16, 80, "Output",ExpressionUUID->"a4424ff3-9fbf-494e-b26d-5bd21976702f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106897, 2364, 1007, 25, 100, "Input",ExpressionUUID->"979335e8-b5c7-4086-bb8c-a56ea0bdae6c"],
Cell[107907, 2391, 14846, 302, 295, "Output",ExpressionUUID->"ef4a440a-db1b-4922-a813-8fb1a5230fab"],
Cell[122756, 2695, 470, 11, 53, "Output",ExpressionUUID->"1f5549d1-e935-4a85-945a-885a5cdeb76d"],
Cell[123229, 2708, 348, 6, 53, "Output",ExpressionUUID->"5fe5c140-1da2-4bb9-ad38-1244f0f7c30c"]
}, Open  ]],
Cell[123592, 2717, 182, 3, 28, "Text",ExpressionUUID->"d92f3fba-10ab-401f-a47b-abcd7c8b2462"],
Cell[CellGroupData[{
Cell[123799, 2724, 365, 8, 53, "Input",ExpressionUUID->"b4524a2e-a453-4d96-814b-57036101fa10"],
Cell[124167, 2734, 193, 3, 53, "Output",ExpressionUUID->"c9ee7112-23a9-4452-b41f-7e51ad2383ee"]
}, Open  ]],
Cell[124375, 2740, 217, 5, 28, "Text",ExpressionUUID->"3d2fab4e-82ed-4f23-b436-3a194cb1e705"],
Cell[CellGroupData[{
Cell[124617, 2749, 1240, 33, 100, "Input",ExpressionUUID->"ebce07ea-2ade-48b9-8db4-2885bb13a8e6"],
Cell[125860, 2784, 242, 4, 53, "Output",ExpressionUUID->"b2d9044e-281d-4c63-8f9c-b836d7a80ebe"],
Cell[126105, 2790, 230, 4, 53, "Output",ExpressionUUID->"868c2b1e-2741-4f13-819e-9339d0bcda64"],
Cell[126338, 2796, 243, 4, 53, "Output",ExpressionUUID->"799076bf-f693-4eeb-819a-0abc0124b160"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126630, 2806, 165, 3, 63, "Section",ExpressionUUID->"a8d39928-191b-4a4f-9a64-0ec795635a2f"],
Cell[126798, 2811, 237, 6, 28, "Text",ExpressionUUID->"a2a800fb-33d2-4064-8ba7-1a21f716d560"],
Cell[CellGroupData[{
Cell[127060, 2821, 853, 23, 100, "Input",ExpressionUUID->"afacf9f1-e858-4cb9-a7eb-0c950e5fd565"],
Cell[127916, 2846, 324, 7, 53, "Output",ExpressionUUID->"baf86ddf-1730-41ef-ab06-870920bbd27d"],
Cell[128243, 2855, 366, 8, 53, "Output",ExpressionUUID->"85453bb1-d46e-45da-85c1-a72bc3afdaa7"],
Cell[128612, 2865, 446, 12, 100, "Output",ExpressionUUID->"8f893f56-bb45-4a35-a35a-5488cd7ae7f0"]
}, Open  ]]
}, Open  ]]
}
]
*)

