(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    163929,       3312]
NotebookOptionsPosition[    159207,       3231]
NotebookOutlinePosition[    159713,       3250]
CellTagsIndexPosition[    159670,       3247]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This continues the work in _grm2.nb, computing the observed function from \
following the effective distribution.
(NOTE: Don\[CloseCurlyQuote]t run this notebook after the first without first \
killing the kernel.)\
\>", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
   3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
   3.8489105216064568`*^9}, {3.852182157755045*^9, 3.8521821732750072`*^9}, 
   3.852182774969989*^9, 3.852183376610733*^9, {3.8521844410125713`*^9, 
   3.852184486288433*^9}, {3.852184610397197*^9, 
   3.852184627994417*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"param", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"1", "+", "param"}], ",", " ", "1.05"}], "}"}], "}"}], 
    "\[Transpose]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
      RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"epsilon", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Phi", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "param"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1.05", "/", "2"}], "+", "epsilon"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.05"}], "/", "2"}], "-", "epsilon"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dm", " ", "=", " ", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}], "/", "2"}], ",", " ", 
     RowBox[{
      RowBox[{"(", "p", ")"}], "/", "2"}], ",", " ", "0.5"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"what", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"LeastSquares", "[", 
      RowBox[{
       RowBox[{"Refine", "[", 
        RowBox[{"Phi", ",", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"epsilon", "==", "0.0001"}]}]}], "]"}], ",", "V"}], "]"}], 
     ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"param", "\[Element]", "Reals"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"what", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"param", "->", "2"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936641725163*^9, {
   3.852099656777422*^9, 3.852099660756007*^9}, {3.8520998283982353`*^9, 
   3.8520998330051622`*^9}, {3.852100643443104*^9, 3.852100647045465*^9}, {
   3.852184559017645*^9, 3.852184594733262*^9}, {3.8521846309145117`*^9, 
   3.852184631798915*^9}, {3.852184671151087*^9, 3.8521846779886208`*^9}, {
   3.852186550072678*^9, 3.852186567675721*^9}, {3.85218663096141*^9, 
   3.852186635214932*^9}, {3.852186999445942*^9, 3.852186999499004*^9}, {
   3.8521870334183807`*^9, 3.852187095579505*^9}, {3.852187125726162*^9, 
   3.852187185294456*^9}, {3.8521872227301273`*^9, 3.8521872924704514`*^9}, {
   3.8521876989567423`*^9, 3.8521878353236723`*^9}, {3.852188554543179*^9, 
   3.8521885607243843`*^9}, 3.852188595646064*^9, {3.8521886477643013`*^9, 
   3.852188663512547*^9}, {3.852362875362027*^9, 3.852362881606214*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", "p"}], "2"], ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     FractionBox["p", "2"], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.5`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.852184632660098*^9, 3.852184681977067*^9, 3.8521865680870037`*^9, 
   3.852186635885386*^9, 3.852187001238021*^9, {3.8521870461815987`*^9, 
   3.8521870960632133`*^9}, 3.85218712662519*^9, {3.852187156886901*^9, 
   3.8521871919689283`*^9}, {3.852187223226549*^9, 3.852187292892172*^9}, {
   3.8521876993334923`*^9, 3.8521877210556507`*^9}, 3.8521877563097773`*^9, 
   3.852187829937704*^9, 3.852188395722127*^9, 3.852188561755715*^9, 
   3.8521886697911377`*^9, 3.852189675847537*^9, 3.852362875712575*^9, 
   3.8591348277226562`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"f702bc94-ad3c-416c-9130-77f9b81f7fba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.9999196090946085`", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.9999910676771787`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.852184632660098*^9, 3.852184681977067*^9, 3.8521865680870037`*^9, 
   3.852186635885386*^9, 3.852187001238021*^9, {3.8521870461815987`*^9, 
   3.8521870960632133`*^9}, 3.85218712662519*^9, {3.852187156886901*^9, 
   3.8521871919689283`*^9}, {3.852187223226549*^9, 3.852187292892172*^9}, {
   3.8521876993334923`*^9, 3.8521877210556507`*^9}, 3.8521877563097773`*^9, 
   3.852187829937704*^9, 3.852188395722127*^9, 3.852188561755715*^9, 
   3.8521886697911377`*^9, 3.852189675847537*^9, 3.852362875712575*^9, 
   3.859134827741735*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"8e1a1c96-2be6-4eab-9b5f-c6c115c10b9f"]
}, Open  ]],

Cell[TextData[StyleBox["Compute the correct value of w, to show it can be \
expressed by the function. Computing the fixed point w_star:", "Text"]], \
"Text",
 CellChangeTimes->{{3.848912947646468*^9, 3.848912977322949*^9}, {
  3.8521846434065228`*^9, 3.852184652202084*^9}, {3.852187227937739*^9, 
  3.852187229019517*^9}},ExpressionUUID->"812d4f2f-d057-4141-99e9-\
0041d5ad4212"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sA", " ", "=", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "3", "]"}], " ", "-", " ", 
        RowBox[{"gamma", "*", "P"}]}], ")"}], ".", "Phi"}], " ", "+", " ", 
     RowBox[{"eta", "*", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sb", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "R"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "sA", "]"}], ".", "sb"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.848570984364477*^9, 3.848571676353101*^9, {3.848913024643092*^9, 
   3.84891305207668*^9}, {3.848913722679961*^9, 3.848913736469101*^9}, {
   3.85218468971636*^9, 3.852184719910483*^9}, {3.8521871152271347`*^9, 
   3.852187115843882*^9}, {3.852187303575212*^9, 3.852187308540443*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"],

Cell["Find the value of param that maximizes the error:", "Text",
 CellChangeTimes->{{3.85218731006135*^9, 
  3.852187328839323*^9}},ExpressionUUID->"95836cf1-3dc9-4433-aed0-\
478a4bd2329d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], " ", "/.", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}], ",", 
      RowBox[{"param", "->", "1.2"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.852187373194769*^9, 3.852187378250699*^9}, 
   3.852187709222268*^9, 3.8521878439440536`*^9, {3.8521885088203382`*^9, 
   3.852188528495462*^9}, {3.852188617497257*^9, 3.852188636095563*^9}, {
   3.852188682329093*^9, 3.8521886983199043`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"31e215e2-c46b-49dd-b302-fcc49093543e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxXk8FIgCB3DXK1ckqUhauRLGkShPfuuI3ClkDmPGjCu5lqSwOowjUmHR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       "]], 
      LineBox[CompressedData["
1:eJw92nk0Vd/7B3BDZUgUUqQkKnMyh7zN052MKaGiZM7UqKJEyFSkSUmGCqGB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       "]], LineBox[CompressedData["
1:eJwVj3k4lQkDxYXSyNKlxYRvxhaSUk2Kpk6mklJC9cnd3M2+J5NsSWhPIY0l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       "]]},
     Annotation[#, "Charting`Private`Tag$228410#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.004375712996410933}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.851991175596321*^9, 3.851991188156067*^9}, 
   3.852099769026505*^9, 3.852099840152269*^9, 3.852100226701511*^9, 
   3.8521006529204493`*^9, 3.852102744002846*^9, 3.852184727417592*^9, {
   3.8521851908376637`*^9, 3.852185198999359*^9}, 3.852186576403285*^9, 
   3.8521866459119587`*^9, 3.8521870109601*^9, {3.852187066780424*^9, 
   3.852187086712613*^9}, 3.852187118468927*^9, 3.852187196924858*^9, {
   3.8521872332085533`*^9, 3.852187277861628*^9}, 3.852187381855117*^9, 
   3.8521877071428347`*^9, 3.852187765210782*^9, {3.852187848888199*^9, 
   3.8521878559560537`*^9}, 3.852188402790943*^9, {3.85218851682064*^9, 
   3.852188533904443*^9}, 3.85218856872884*^9, {3.852188619748975*^9, 
   3.8521886385508842`*^9}, {3.852188692499628*^9, 3.8521887038050213`*^9}, 
   3.852189681015677*^9, 3.859134838529722*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"db97ecdd-14bd-495e-a758-593f7834f796"]
}, Open  ]],

Cell["\<\
From the previous notebook, we can induce the distribution \
{0.440443,0.0595574,0.5}. We find the value of param that maximizes the error \
at that value:\
\>", "Text",
 CellChangeTimes->{{3.8519975285014353`*^9, 3.851997532739789*^9}, {
  3.852186671910448*^9, 3.8521867117935143`*^9}, {3.852186806700679*^9, 
  3.852186812094138*^9}, {3.852187393667666*^9, 3.852187402976541*^9}, {
  3.8521898070273533`*^9, 
  3.852189812376088*^9}},ExpressionUUID->"ee80c5c1-e570-43f3-8345-\
11d8e913fbdb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"inducedp", "=", 
   RowBox[{"2", "*", "0.0595574"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"imposedeta", "=", "0.0002"}], "\[IndentingNewLine]", 
 RowBox[{"maxerr", " ", "=", " ", 
  RowBox[{"FindMaximum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{
         RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"epsilon", "->", "0.0001"}], ",", 
         RowBox[{"eta", "->", "0."}], ",", 
         RowBox[{"p", "->", "inducedp"}]}], "}"}]}], ",", " ", 
      RowBox[{"param", "\[Element]", "Reals"}], ",", 
      RowBox[{"1", "<", "param", "<", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"param", ",", " ", "1.25"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"worstparam", " ", "=", 
   RowBox[{"First", "[", 
    RowBox[{"First", "[", 
     RowBox[{"Rest", "[", "maxerr", "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"epsilon", "->", "0.0001"}], ",", 
    RowBox[{"eta", "->", "imposedeta"}], ",", 
    RowBox[{"p", "->", "inducedp"}], ",", "worstparam"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.852187330194907*^9, 3.852187361871079*^9}, {
   3.852187407572674*^9, 3.852187422781452*^9}, {3.852187457101253*^9, 
   3.852187497527769*^9}, {3.8521875321176233`*^9, 3.852187577747641*^9}, {
   3.8521876129600687`*^9, 3.85218768092803*^9}, {3.852187862802319*^9, 
   3.8521879653357973`*^9}, {3.852188042408544*^9, 3.852188139390051*^9}, {
   3.852188188322722*^9, 3.852188209143127*^9}, {3.852188735113446*^9, 
   3.852188735648448*^9}, {3.852189886712549*^9, 3.85218992997838*^9}, {
   3.852190005707123*^9, 3.85219002080803*^9}, 3.8591358479930067`*^9, {
   3.85913641324986*^9, 3.859136415919895*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"ca30ea3c-eab1-4746-9772-aae4a1a73aba"],

Cell[BoxData["0.0002`"], "Output",
 CellChangeTimes->{
  3.852187423677525*^9, {3.852187458755307*^9, 3.852187478449977*^9}, {
   3.8521875661634502`*^9, 3.852187578274872*^9}, {3.852187613385559*^9, 
   3.852187636590931*^9}, {3.852187671533461*^9, 3.852187681322043*^9}, {
   3.852187864401375*^9, 3.8521879097450037`*^9}, {3.8521879418719177`*^9, 
   3.852187966791111*^9}, {3.852188057936049*^9, 3.852188139789815*^9}, 
   3.852188209771143*^9, 3.852188403018611*^9, {3.8521887095998907`*^9, 
   3.852188736038479*^9}, 3.852189681086254*^9, 3.8521898139846077`*^9, 
   3.852189887452876*^9, 3.8521899377412987`*^9, 3.8521900210495167`*^9, 
   3.8591364162490807`*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"c4b0c95f-7422-42b7-a69e-0f1748748c10"],

Cell[BoxData[
 TemplateBox[{
  "FindMaximum", "cvmit", 
   "\"Failed to converge to the requested accuracy or precision within \\!\\(\
\\*RowBox[{\\\"500\\\"}]\\) iterations.\"", 2, 27, 85, 21867634733056847443, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8521898874365892`*^9, 3.85218993807628*^9, 
  3.852190021378599*^9, 3.85913641660226*^9},
 CellLabel->
  "During evaluation of \
In[25]:=",ExpressionUUID->"f148ef59-c8fb-4ef1-b7e3-782de5aedb9a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"418.6006945531442`", ",", 
   RowBox[{"{", 
    RowBox[{"param", "\[Rule]", "1.6880748913968529`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852187423677525*^9, {3.852187458755307*^9, 3.852187478449977*^9}, {
   3.8521875661634502`*^9, 3.852187578274872*^9}, {3.852187613385559*^9, 
   3.852187636590931*^9}, {3.852187671533461*^9, 3.852187681322043*^9}, {
   3.852187864401375*^9, 3.8521879097450037`*^9}, {3.8521879418719177`*^9, 
   3.852187966791111*^9}, {3.852188057936049*^9, 3.852188139789815*^9}, 
   3.852188209771143*^9, 3.852188403018611*^9, {3.8521887095998907`*^9, 
   3.852188736038479*^9}, 3.852189681086254*^9, 3.8521898139846077`*^9, 
   3.852189887452876*^9, 3.8521899377412987`*^9, 3.8521900210495167`*^9, 
   3.859136416618103*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"f6c3f20e-80ee-4988-b50f-0acc018be6dc"],

Cell[BoxData["3.006254358536125`"], "Output",
 CellChangeTimes->{
  3.852187423677525*^9, {3.852187458755307*^9, 3.852187478449977*^9}, {
   3.8521875661634502`*^9, 3.852187578274872*^9}, {3.852187613385559*^9, 
   3.852187636590931*^9}, {3.852187671533461*^9, 3.852187681322043*^9}, {
   3.852187864401375*^9, 3.8521879097450037`*^9}, {3.8521879418719177`*^9, 
   3.852187966791111*^9}, {3.852188057936049*^9, 3.852188139789815*^9}, 
   3.852188209771143*^9, 3.852188403018611*^9, {3.8521887095998907`*^9, 
   3.852188736038479*^9}, 3.852189681086254*^9, 3.8521898139846077`*^9, 
   3.852189887452876*^9, 3.8521899377412987`*^9, 3.8521900210495167`*^9, 
   3.85913641662877*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"d31b139f-7c95-4142-91ff-ff48d9795aaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], "]"}], " ",
     "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "0."}], ",", " ", "worstparam"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], " ", "-", " ", "V"}], "]"}], "]"}], " ",
     "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", 
      RowBox[{"eta", "->", "imposedeta"}], ",", " ", "worstparam"}], "}"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.852187989034215*^9, 3.852188029686318*^9}, {
  3.85218815839635*^9, 3.852188160401474*^9}, {3.852189841903491*^9, 
  3.852189860019979*^9}, {3.852189945062582*^9, 3.8521899656433067`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"c7f9047e-0a17-4563-b99b-caedc94416ec"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0Xs4lIkXB3CNMCndNDPv+2ZJkR/ayZZCpVNYktQil4RVkq1ZsUwll7Ch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       "]], LineBox[CompressedData["
1:eJw92mk4lU8bAHAkCVGKLM9ZrKmESmS9JWRPZS1J8teKkhSSFJIKlYQSSoul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       "]], LineBox[CompressedData["
1:eJwV1Hs0lVkfB3C3kIQj55zneZDcChPpncil1y+5TOUojKGL3EJGokw1uigM
1VSYJE2HaGpyqTkcxaiIX5IklUuRkmkoPc+5TlQqJu/z/rHXXp+19/ru/V17
rW0enRwUq6aiolLIjv/PXg8fRCTY01Bm/Y47KDRCx0yvH/0daLgdtsjS+bwR
tk/b7F3pQsM2k0aOhcIIHSKG3e660aAQn0wfmDbCgqaiSZ//0uCc4cQx5nAx
Mk0vzWsFDXu9Ox8E/IeLE5/HD3oIaKhpHKxS387FsA2i5TfXsF6rWXXsABdb
rsepLgukoW92qXPzcS7mpg5kuobQ8Lf2p21OFVyc/6Epe0kkDR1JnBDRcy6G
vP35mN1O9vwg8co+Zx42BngJKnfT8KvrK7GvJw8txFO6NntoyBB8cjrkx0NF
UnKu9QEa7vuorUuN4GG2LPjEvCM0dOsu1lyTzUOJn15Q6VEaPNVnPg3L5WHA
5buGc3NoMGrYOeR9mocmCW4Fxvk0WOprVf9ewcPaN2anecU0bK64varpHg+p
bwZCT5XQwBnd+bGmm4fpZfmE0W80dNbIXA4N8FAQO0PIKaOh8fr2rF6ah6+G
JcW6YhqWzzwQz9Xk45yhuvNqrTTMHc0pbXXnY65uWlp9Gw3cTGvbMyv4qOPu
vS7xHg1vQN07eBUf1X7tmd33kIYlc5anp4fwcSxQmVo5wPb1dfwWk/nYdcdm
bYCShtIsglhdwkfBO6XtjDEaniq+rmu9wMd2i3qNG+9o+O4nXqR9JR+bD/rc
sPxMw5FQa/+Oq3ysco22ntBgQLWhadK9nY/HRUWTZykGDllkzfdS8FF7MLov
yJQBW3vsbB3jY5aOXY3WPAZ2iHYvc53g474t1+J2WDPwsK5ny+Q0HxPMn3R7
OzIweivfTmpA4MpTehVSHwaup7dOX3QkcEZaRrDrDgbqbI7NvBlPYO1b2afm
HxhYvHju6aatBMbErSv13c3AUmmu//UkAlvXLpJ8u4+BkJ7QAuFOArMsXhxM
ymYgs36Rrn46gRrtLpcvnGHA40pdbM8pNm/Z7wF2xQx0CJZ1b/+VzavR/yAu
YUAStrl2ZhGbJxxd3nSBgT15f9l8dY7An7YV9D0VMeBtducPh0sEqs35R1Wv
hYFJxsvH9yaBVw5vLC9oZcDKYER+spnA6Kk2gfFdBkbitGe9uEVgy+uzp206
GUhcnzgQ1UZg5jU/e68+Buad93ZZ+ohA1fDydakSBiqns4eNXxKoUhlePWwo
gUBLFFHTBLbJ+pNKuRL4XtevwkiVxOOOgQ5hhARcHLijOuok8q95iZ6YSkCr
fG6ITJNEh7s2l9tt2P255nZZeiSGvR4rq/KQAGdewRIDUxKvmx8u2ZsggRSr
8Yj+pSQeiFUJX7pNAt/sjGnd6kqid+Ue03fJEvjboPbgv24kdjkmFm/bJQFi
Gc0lPUikIVAYmS4Bn7pdqYu9SeSFGxf6FkrAPaohR7aWxBRhdY5hiwS27310
5WosifVTwsMtrRIYa3y072MciVPhhzJS7kpAcE4W4R5P4mHLTbt6OiUwXp1y
tCGBxOI/dDbl90uAa3dp8GIyiXeaYhcayiUg/qSUW+8hkRgxvs8hpLBaNrFc
fpTETT5ad25RUlj/S3HH1DESz5ePNe0wlYJQ8vRvnRwSFybeu9JtIYUN/m9a
LfJI9Hy/W3jCXgqHieVVnidJTNDq+Z7jJYVPL3v2eRSRePOrI9qcJCksDdb+
4nOJROfH/Af526XwjHPig8llEsX7y08Y/SCF/d9rjI+xPv+gjSJSpVAUkfel
SETikeQZ9maZUkj6szBvWExi0NXMQPtCKRhcrNfyqifxjVuacFWTFETz+DPC
bpMYOaIbcR+lsGyYd4zXSuKzY8WW/relQOa5+3Sx7hxs+COgXQry9xYbPdtI
vHLgc1NojxRGzMjF1D0S97f8OBI7KoV/Er8Wlj8kkbM6ZWGmngzeLzRNdx0g
8dwt/VluHBkUW46ekbB2dBUxb+fI4KXjAqXwGYlrbOiyKFIGa56bB356TuJR
zXBzTysZ+569XNEQiRq3V/FU3GSgzlsgfjtC4gd3c5UDsTLISkWjCTmJg/Zd
vXsaZfBz7JKbdioUlko5aerNMgh6ycy7xDq68tv5ObdkcMM/3sBWlULGqj/1
XBubF7DklLUahR+Mh0zvdsng2ZPPvqQGhRwd2Raj1zLwaBc8kmpR6DuqNVU1
Ww41Rw3DPfUpFJeA1atwOXTk3u/sMKFwfO+4VlSUHF5duxa6yJRC59By6YvN
cjBrEZ04ybpBX/9qf7wcgsnFRhvnUtiWPuR5P0UO1fWa4aNmFD6PTou4ckgO
Y9rfhSgsKNRc0CBMr5LD43jRN202FG6qduaYfpHDweoFE+VfU/jnho96XSoK
GJM+k6suoVBP84buT+oKcC+nizeyxrD/ajPaCtiyPsZaz4lCCx3v6do5Cjj7
YpxOdqZwNCZQLrBVQN38nIz5rhQmUYn39gcr4IbpDiLag8L07N8yBi8pgB6f
mWSxksLZP2qtjhIpoFD8rGsLa2H8NsPRagX06pzUELG+6ud6QVmrgNCHu/9y
XsXmc7pb1ZoV0O5tEb9yNYV+JSratr0KaNBTlUcLKOTVR+TumlRAxplTH3cH
UCiiTYv0BEqIc1BVt1pH4ZGz2ZFDa5QwPz6sLZZ1TJDcuipQCTOSz24sZ23S
2Cj2D1VC11DulO16Co/mbWw7Hq0ETn6Qqf0GCuOdz7zV2aOEx79VqH0VxvbP
MlqpVaZk/8+d+ZqRFH5x2T+7v0IJ/lXvmRWsB+QjPWWXleCS9pQ4yPqX0Kub
fGuUYKgV/e8H1tN2QT9kNyqhqvrF61dRFA5255Wo97L3c8oPub6ZwmuHJjb3
PlFCjOtx53HWBe4RtheeKqFja9A/C2PY/hcdalcMKaF5b//bUtY3Uh/cy2CU
4NdwxzErlsJCe6e8QJkSXm6wGmlkvWO4ONhcqQST5JTt71nbCBL/wndKqDXY
ahIXR6GG6uPff5lg1wVh7iWsX9a5J0R+VsLkmg6nPtaNCRcWOf7L9n3TP0tv
C4WnzWa9n55m+9LlN31Y/w8msJT8
       "]]},
     Annotation[#, "Charting`Private`Tag$23362#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, -4.959949940223482},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {-8.594274601124518, -5.151230185534052}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.852188000802411*^9, 3.8521880316830606`*^9, 3.852188162414085*^9, 
   3.8521884045107527`*^9, 3.852188741269431*^9, 3.852189681579545*^9, {
   3.852189821093192*^9, 3.852189865572694*^9}, 3.8521899006168957`*^9, 
   3.8521899463862343`*^9, 3.8521899801499*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"4353d729-6344-4f7a-8fb6-ff2b1f893cb9"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVz3081AccwPHzdB3HdXdJnaT0IiUd1UxafAtRHqaSOVo37SQVncpoNdO1
daisiWSFY4dQ13HuHPfQ70uj9YARCtHUmIxRoodDa398Xu+/PzZf83fu0yeR
SNyP/a/fvqFWfBHiQY+PUC15yURDL8u4p6xPIKOMOqMYZeI6UU5uFcsbXFyK
eH7DTPRveiTLY+2C9yTIjH3OxNDIN9qLrEiQ2ya55XUwsdcpxSudFQ+deXOS
RLVMLJgfJDzL+hH6Ku6IF59iooBSZZ/GyoIZs2FlOJmJDr4ZqbK4LFincxXS
9JnYdob/oudOFtStP+1OzDDQ1sDxOjvhEmwK5u1cMMnAxpkidntbNgR1oKDw
OQNNJ7Jdlpz/BQSfcFaxkIE5vSe8FLP54Ch3XBSTwMDNVmFFfSEimJEcHKk8
wsDhcFcjikQEYoOi5xMxDLQe+ZYnWV0AnMDB5TE8BvIPfGpHelIAmlfTTqu3
M5AZKS0tXv8rfBB/993wCgZywgql4y+LIGCsMMziER3HenaZ/GpZDAE+rb84
tNFRyKXsC/YqBtuIybQNTXSs4vEtq7OKIeHe2tDA23SkHXY/c9K1BG7XW113
l9Kx4XRXODnpGuwY8iBvFtJx7Q0G2YpSDi+8TnDOOtPxLrshosm5HBbJJdF6
q+gYUXlc/X1YOXg0DD48akfH9Oqncf3l5SB8lyf0tqTjEEp6SgKvQ9YUo7/Q
gI75Hdsq12TegMSW2d/45XOR+kHwpa+1FJp8bljWD9Iw50Ao19FHCmsqRQ3+
3TS0bXeMYByWwpSTQU5jEw09yh7xerRSWJ7IZ16Q07C2LFuhZFeA/+Wv2qME
NBwNHtH4N1dAYi9n3GQhDUNKL98/ZiaDzrrBtw2uZpi753RAlI0MLrYJAxau
NMNnzNgmjosMGg+T14VYmiE/ybPFfY8MajXVovRpU0zbOdo2RyIDczVPN06Y
onbas/tqQBWkdzb3bfQ0Rbsd/w7dPicHUvvlCt5aKlom+27YXyiHI9d+8nhs
TUW6pOCciVIObltWWNlRqfieEsze8UwOK+073ns/N8E/UHmsb70CVuXliFMz
TPCEs2D27YACbOmfJUYPGCOf2x2Uq1PAQYrAyKDFGCPPrysERjVECr9fFl1j
jEFDA17CjdUg5mJR+lljtC3wS5uXWQ0eTjss7ByNsXmuuTl7kxIqtxaac3kU
vO0eu681RAktC7wNjbdRsOZQY3X8ISVYRjHmR7MpKL5zPEydrQQif5nNZ2/n
4PHk3vyto0rIb+sXTqfMwWVjJSt5V2pg7sp5nf2XyLhgMekkuaIG3lgsbav/
hoym/mEPyhpq4PcjkmKnEDK+KaHyx8drQFutSM9nkvEBN06e5FsLLqH7VbwU
I0xsdoOc17VQ/5B05cAuQ6SxFQN3KSqYifRbVLva8OOU83mdlQr2B0p14WRD
bA2w7+JuUUGXVJd6UmGAq+6bH7PLVkGuzNhhr4kB1jv8zAotV4Hd7PF5ib36
yDlLxdRbKlj4Q+8mkVQfz2zTNxsZVMGlEfKwbrs+Pr0zViJzVUMQnVBmCPUw
wf5Q4F/+alhuHfpgaLsemqYMTsyPUEPg44LcQZYeuvn0bvo2VQ2KoTKvc9dI
+Ecx5+/yXDVc/oZxgRJDwiij9vQnFWpo8aqy6WKTMPO3e93QpYbc2O6bFtwP
hIOtj+DIqBrsd1XVRz6eJfCHOnuxngaMH3pXxX4+S4x61sSTHTSwdfxWY7Lj
DOFbV0xrOqGBvSejvv6i5D3Rt9RGMfuTBqyn60oCXr8j4k/l7nYWa4BIce1L
3vCOKITM0sz7Gtjt8mog78YbYr2IFtTwVAM6jUZJdE4RzbNpk1MTGriweMnj
5MlJQqc95RlupQUDRbB3NPU1cXHx9NA5Zy1YlTpnOH14RaxISryg9dbCM/bm
z2/++ZK49eSVyxhHCypDt2OrJeNEyMbDT5bGauHnif4tefX/EiNXX5zeKdCC
aE1pgvjlP4SnyWuL+FQtPLBoPTrVPUz8B8yL4ZU=
       "]], LineBox[CompressedData["
1:eJw92Xk01N8bB3BrGNtMSXYhKglFZH3kixDaKAoVUpE1tNBiCUlpUVkSiZRU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       "]], LineBox[CompressedData["
1:eJwVkGs8lIkegGeYaTTG1CshscqlRZHz280Ju/5Jdq07+UXCWqE9tghpRZM4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       "]]},
     Annotation[#, "Charting`Private`Tag$23414#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, -0.6227708577389698},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {-4.735472595345541, -0.839228843928788}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.852188000802411*^9, 3.8521880316830606`*^9, 3.852188162414085*^9, 
   3.8521884045107527`*^9, 3.852188741269431*^9, 3.852189681579545*^9, {
   3.852189821093192*^9, 3.852189865572694*^9}, 3.8521899006168957`*^9, 
   3.8521899463862343`*^9, 3.852189983569351*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"7a8d2bf6-e7e3-472e-9fc7-8a7fa4c733e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking against bounds in Kolter (2011)", "Section",
 CellChangeTimes->{{3.851903445897932*^9, 
  3.851903481738948*^9}},ExpressionUUID->"3eeb6e0f-64f2-4960-a3bd-\
9ec3c55da956"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Fmat", " ", "=", 
   RowBox[{
    RowBox[{"ArrayFlatten", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], ",", " ", 
         
         RowBox[{
          RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "P", ".", 
          "Phi"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Phi", "\[Transpose]"}], ".", 
          RowBox[{"P", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], ",", 
         RowBox[{
          RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}]}], " ", 
        "}"}]}], "}"}], "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", 
      RowBox[{"eta", "->", "imposedeta"}], ",", " ", "worstparam"}], 
     "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851907928479828*^9, 3.851907929147293*^9}, {
   3.85190824732447*^9, 3.8519082665662746`*^9}, {3.8519082995251637`*^9, 
   3.851908383027412*^9}, {3.851908457336536*^9, 3.851908474640737*^9}, 
   3.8519100979872417`*^9, {3.852190135157542*^9, 3.8521901575455427`*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"596bc87a-22e9-47da-8189-83189b18c546"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fmat", "  ", "//", " ", "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.851908486053336*^9, 3.851908496445801*^9}, {
   3.851908533161276*^9, 3.851908540901367*^9}, 3.8521901406172457`*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"6dcf7e24-835f-4fbb-9e4c-dfd4127d8860"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox[
        RowBox[{"1", "-", "p"}], "2"], "+", "0.137865005`"}], 
      RowBox[{"-", "0.137865005`"}], 
      RowBox[{
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.5`", " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"1", "-", "p"}], "2"], "+", "0.`"}], ")"}]}], "+", 
          "0.131275`"}], ")"}]}], "+", 
       RowBox[{"0.25`", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"1", "-", "p"}], "2"], "+", "0.`"}], ")"}]}], "+", 
       "0.0656375`"}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"2.6880748913968526`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0.25`", " ", 
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"1", "-", "p"}], "2"], "+", "0.`"}], ")"}]}], "+", 
           "0.0656375`"}], ")"}]}]}], "-", 
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.5`", " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"1", "-", "p"}], "2"], "+", "0.`"}], ")"}]}], "+", 
          "0.131275`"}], ")"}]}]}]},
     {
      RowBox[{"-", "0.137865005`"}], 
      RowBox[{"0.137865005`", "\[VeryThinSpace]", "-", 
       RowBox[{"2.6880748913968526`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"1.3440374456984263`", " ", "p"}]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.5`", " ", 
           RowBox[{"(", 
            RowBox[{"0.`", "\[VeryThinSpace]", "-", 
             RowBox[{"1.3440374456984263`", " ", "p"}]}], ")"}]}], "-", 
          "0.131275`"}], ")"}]}], "+", 
       RowBox[{"0.25`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"1.3440374456984263`", " ", "p"}]}], ")"}]}], "-", 
       "0.0656375`"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2.6880748913968526`"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.25`", " ", 
           RowBox[{"(", 
            RowBox[{"0.`", "\[VeryThinSpace]", "-", 
             RowBox[{"1.3440374456984263`", " ", "p"}]}], ")"}]}], "-", 
          "0.0656375`"}], ")"}]}], "-", 
       RowBox[{"0.5251`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.5`", " ", 
           RowBox[{"(", 
            RowBox[{"0.`", "\[VeryThinSpace]", "-", 
             RowBox[{"1.3440374456984263`", " ", "p"}]}], ")"}]}], "-", 
          "0.131275`"}], ")"}]}]}]},
     {
      RowBox[{
       RowBox[{"0.25627500000000003`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", "0.1345700025`"}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"2.6880748913968526`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0.25627500000000003`", " ", "p"}], "+", "0.`"}], 
          ")"}]}]}], "-", "0.1345700025`"}], 
      RowBox[{
       FractionBox[
        RowBox[{"1", "-", "p"}], "2"], "+", "0.137865005`"}], 
      RowBox[{"-", "0.137865005`"}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"0.4672843614246066`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}]}], "-", "0.24537101818406093`"}], 
      RowBox[{"0.24537101818406093`", "\[VeryThinSpace]", "-", 
       RowBox[{"2.6880748913968526`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.4672843614246066`", " ", "p"}]}], ")"}]}]}], 
      RowBox[{"-", "0.137865005`"}], 
      RowBox[{"0.137865005`", "\[VeryThinSpace]", "-", 
       RowBox[{"2.6880748913968526`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"1.3440374456984263`", " ", "p"}]}], ")"}]}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.851908541193987*^9, 3.851910107507758*^9, 
  3.8519369723331833`*^9, 3.852099776246019*^9, 3.852099847133726*^9, 
  3.8521002338041286`*^9, 3.852100661353634*^9, 3.852102750089155*^9, 
  3.8521884046544933`*^9, 3.8521896816928787`*^9, 3.852190159576996*^9},
 CellLabel->
  "Out[55]//TraditionalForm=",ExpressionUUID->"9f0651f9-5f09-417c-b979-\
68accbe85b42"]
}, Open  ]],

Cell["\<\
We use Sylvester\[CloseCurlyQuote]s criterion to find the region where the \
matrix is positive semi-definite. That is, we constrain the each leading \
principal minor to be non-negative: \
\>", "Text",
 CellChangeTimes->{{3.851909549583057*^9, 
  3.8519096181646547`*^9}},ExpressionUUID->"507c7550-1154-4d01-8be8-\
e71dbb3778df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "1"}], ",", 
          RowBox[{";;", "1"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "2"}], ",", 
          RowBox[{";;", "2"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "3"}], ",", 
          RowBox[{";;", "3"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"Fmat", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{";;", "4"}], ",", 
          RowBox[{";;", "4"}]}], "]"}], "]"}], "]"}], ">=", "0"}]}], " ", "/.",
     " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"epsilon", "->", "0.0001"}], ",", " ", "worstparam"}], "}"}]}], 
   ",", "p"}], "]"}]], "Input",
 CellChangeTimes->{{3.852099934583878*^9, 3.852099941016217*^9}, {
  3.852102928568318*^9, 3.852102959833034*^9}, {3.852189687317245*^9, 
  3.852189693317955*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"e4b08763-e472-41a6-89a5-892d80934eb1"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 56, 9, 34132411703526938259, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.8520999272229433`*^9, 3.852099944987948*^9}, 
   3.8521006613834743`*^9, 3.852102750116304*^9, {3.85210292488595*^9, 
   3.8521029606875763`*^9}, 3.852188405277032*^9, {3.8521896819945993`*^9, 
   3.8521896937507973`*^9}, 3.852190166654943*^9},
 CellLabel->
  "During evaluation of \
In[56]:=",ExpressionUUID->"97a49447-3208-4f54-b733-7ac7444e3a07"],

Cell[BoxData[
 RowBox[{"0.3381217913697982`", "\[LessEqual]", "p", "\[LessEqual]", 
  "0.6174417857264725`"}]], "Output",
 CellChangeTimes->{{3.852099927233952*^9, 3.8520999449934*^9}, 
   3.8521006613910637`*^9, 3.852102750123952*^9, {3.852102924895791*^9, 
   3.852102960697146*^9}, 3.852188405309708*^9, {3.85218968201015*^9, 
   3.852189693765242*^9}, 3.852190166670857*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"b1d00e10-5f16-4644-a861-4faa9f04cc3b"]
}, Open  ]],

Cell["For comparison, we plot the error w.r.t. p:", "Text",
 CellChangeTimes->{{3.8519094188402977`*^9, 3.851909427078348*^9}, {
  3.851910915013558*^9, 3.851910925175963*^9}, {3.8519112883258038`*^9, 
  3.8519112915489407`*^9}},ExpressionUUID->"371e25ae-fd82-40ba-9f0d-\
fe959c3d4165"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"eta", "->", "0"}], ",", 
       RowBox[{"epsilon", "->", "0.0001"}], ",", "worstparam"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851911293764407*^9, 3.851911409894691*^9}, 
   3.852103571023707*^9, 3.85210467306042*^9, {3.85218971905791*^9, 
   3.8521897222994223`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"329abe1e-5604-4965-87cb-94e24f5bd0fa"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVjWk81IkDh63cWpSj+EyOLYpydRi16TuavyZHSfY3lzGNMVgsw4YmOmiX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       "]], LineBox[CompressedData["
1:eJw92nk4VO/7B3BJC4myVIpUJPuWnbxtWcaMXcpHtlCRJVtpX1EfW5IPKUuL
JCFbEjV22dcZ+z6DQkqJSL/z/ef3z8z1us6Z55xzn+e57/u5rtnr6mvlzsrC
wiJGfPzv+yqfn9l6NirEMv4+OeJ1Gs30xXkqFxWMX3rebpkn8a3SWy5PgIo7
q6l+YVwe4Msd9XwqSkX6yMo2gYduUHlklx4nR4XnvXLFd0YncCy8ceS2BhVr
J4acfvG44lKgrtC5w1RU5h1g27vojGTnoqOnLKjQzulNV5l0QjlZKu7YP8T5
HzmVIzY6YlwttYXkQcVeMW2+erID1u/n36R1lgp+qW0Vu97Yg/xn9fruMCoi
7wVyqTfZwWcqoIw7lgp3kd1VWVeP4F7X5CLLYyp0ojaePWFki4Ly40rfX1Dh
oco9G7jPBrTX7b5jeVRcUc3QOMhtjaVEo1edZVS4cFJ19nFaQTC0lFldR4XB
+Pffc9st4eKYfjxjkIq8rPpc7Rwz3CLtSkycomJebMCcg5eCdJWYzrs/qLD8
y8KbEmGKaa4Lpt4c5fgUvDna/L0xuJZnQx35y9HO7YshbyMoTJyoMN9TjqcF
/Do7FAwR/JGirqhSjuikzn0fGfpIfFURKKJbjqzV947hXXoo/U81l49cjsfX
a7Net+tijd/eA79cynHoSsm0CwMQdYh3nTxTDrPvv/z3SmjD0HhTcs+5ciy7
R40+uqmFiD0/+Uojy1G4kChteUEd2ZyeFq8TyiHt82DvE341tC0O/pv8tBwD
He6sg9Uq+DFuXRudXQ6v2HDLkbvK2NZWx3r9XTkseRW3v3BTgnrZIW3/qnK4
j6ZyGlkfhMPLvJATLeXQkuN7+f2IIq48OFBo01uO+smipDlfBaRdfzR3mFGO
S5q2mvHJ8qjy3iqtOleOk5dYtl+ukQPzWOhJ8eVyRCqQT16+JAt2w+UnAusr
cDrDzzHXSQbSin6DHFsrUNUVLm7tJw2z3QyBlV0VaHS3/qydLYWzHPa2M2IV
2O6e3tK8QwpxC80xgwoV2JKrVNWcLYmiUf3GFq0KXGLf4BTsIwma8fVvkUYV
uLXngFWMrSQWsj9sI1tVwGxgv9ZXJ0ls41/R5DhegZILQVrJdyWhelHdpe5k
Bd5/3Po3uF0SR0eCQ0P9K9D3n9k3XSUpnDcqeGVwmRifx3GoPUsKCa+/tbKG
VyCj82K7sLo0innlFqixFchv2u9uSZNGd8iZXVcfV2C5xaOr8boMFode6hzK
qICVg3G1mros1LJE/31XVgGjCsqDqko5vDPYuSdvsgLHZ2VtpyIV0Jtpd9hv
vgLPhd+GnVtRwO8tDzxlVyuwaqOs+MBLERoD3IWZvJWIDMw4oEc6iJKgdaSn
2pXg3smpvGOtMkrT5wLi4irRXxjhL2ikhn5O2USrlEr8fs5Nk8hUw4q/14ct
mZVwTnAOm96kjkNgboz8WInSs9de/9ugjg/0vse3P1fC/pd9mbqmJj5urK0N
1qlCT6Jez8XBQxj2YZtRMq2CWpe1/F0ZbbB06fLM21ZBeikjJviiNnTSSh18
varQT47KXuYFqOp5307GV6Hpc9LMLkEdVHg+3nVsugrW9Vn3CsR1kT/l5eW4
UIXyfutcYUNdPDul8f4ESzXOzdlISJ3QxW0Pur0PXzW+GKhESzzShbHr1oc3
taqh58Ae8JVdDy3Hbu/IjqjGas7PmjFiPVG7rU/lx1dD+HNewPpZPeTa7Ssu
Tq2GediJjcPr9BFr+9GusqAa3It4XaqkjyOWS/Hd/dVIn3Ba1IzWR7+xN/9a
mRqQVh7v11UzQFOtpvtG1RqolHbk25IN8MGQo3Czbg00KyQrFJwNkGLwwmaH
bQ0cP3X36IcZwFVn5L7M5Rrwv2xxmWg3wKSqLc/Rpho4BV9U63U+jJ9ih7hf
e9ciyyy1SMrBENqjerV3z9ci3ea1W4uXIUIfG189dZNwb+9tk4uG2MZn81Uk
sRYXu75EVSYaQmWNV8vDqlokGnzmH+o0xPm+hOjwXXUgiWiNyhgYgRqfbOQh
VocFCnovWhpho9Wzv/oKdSg2mq7McDRCYl2O71/DOjStr1NLO2+EksIa82D/
Orw32t2845URVqJ/cLt9qoPF968PL3MYw8D0d61uZx2Mjyg8n+Y3RsR6lmvC
Q3XwzY9Y0tlrDKHLm+Z6f9TBL2p3/0NVY2h77mu13PMJlrPUYsETxrhqYBGD
c59w0GHzyONCY7Auvdqya389zkRwvLlKMsGuJr15yNVjPDox8oGVCZTSerrc
1OtRUjF/P8neBO4mG5KyKfUovRdae97TBHWJrvv1gush1x5ueumOCaI1BDRO
19bjx24/lvoqEwheCj3x9nQDqo+UPT+nQIKyhZBhf0ADnnK69/aqkmAmWiC+
5koD3lmxRylqk3C1cWSGFNsActCD4Y8kEkYFD50fLGlAVayViO0JEl6WzUes
42xEhH5qzLVYElT+OhdZZzfic4T06JUpEsgU6o3DxY3IP/v6ddgsCSeShM1V
Kxpha71BJnyehBjVwYmdtEZMMDMi/f6QMOX7j8Don0bkdlsWD28xxaNh20t+
lCb08ivvo6iYYk0FSS9yugmLyVufUy+aYseWTK6rC004QC9OGLxqCllH9j4/
lmZMVQnsXrhpCvvftQE2fM3wzXvKzUPUpwLFw893aTXjpv/AyGqSKTyeYmPm
v82wRN3FohJTNN5Saq6RbEGeV4vV1LwpNLgbWO8pt8DIaHo14ZcpMhJdVP/R
acHEWZVXesumuJkdlfrVtgWGlwQUb7GSodE96b/jegsU1CcUy7eQkSH1eLsn
vQXvmb98pKXJ0Ju6kbterxWhPk5vNzuRESLbXO9l1IoqqtKNra5k5AYIMFrJ
rdCo+jdsizsZu1dzBJLsWuHI0+TK4kXGEs/ADTnvVmwLuaSdEUycr6VqezSh
FRf1ZpyFI8kQjvmy9HK2FXtY5fQGi8j44HL1Zd58K+yXS3Nk3pHheJD32PvF
Vlxh2VQW8p6MRzSN4kbWNrxFSf0GKhk7hO4Gf93WBt6oIY2VOjJ4MsXnldCG
jiJ6NKmXjHVV7tMfo9twi1tj+6PfZDx7sJRUF9eGpjKxY+ErZBicjDRtS2wD
F7m05uwqGTc4CjNHn7Yh+Qu3khYrBasWbKfXFbdBSn7gYw47BYsDTxik4Tac
GifX8u2g4MuvocEu+XZYVL86N6tIQdHJ6AqSSjsmJa1kXypRcI2unf5Rsx0m
8iVbXFQo2Pb2sfdLw3bQ3lafrFOnQC/4n5VLDu1gX1NZHaRDwcMfNAHR8Hb8
mi1wMqNQYPytycZ/qB2J0/lXuNwp4HW5rDYx3o5DXTccgzwoGGyVFnT43I7I
1eqOnpMUBOb+O3b4Zzt8WYXvJnlSkOJr4i+wqQMpGWJBrH4ULMxURVNVOtDR
MfnS+QIFzz6/r+eKIlziluQXSYHPf+Yinvc70B4dxX83igJVg7GL1QkdsPFZ
vpMWTUH9Yw6ZS087QDNi9ay/R8E3i2PRU8UdmHuZosMWT4H22wXrqrEOyJpk
se9MpmCj290s4akOZGSf2cWXQkH7lt3rLs52oFdUwYgzlQJ3z8NFCksdKP4q
+2MhjYIIobgdKVydaJPcRi98TkHPTYWBEPVOdLrdpfRlUfBEvlq5S7sTXr0h
tLevKTgzcDRK3qATNzrPPYjNpoBF9RomzDqhOClVqpdLgdjn5jQbt06onI/q
icwn4mNxxkMuuhN9OcN5re8o4BJ68XV8vBOP2H6r8FZToHPk5sDYVCc05t3J
2YT9o50aRmc7MZ//d9mohgLamh0vhhc70X1nSOZcLQXJzHDHfs4uOBWMLFZ9
okA217OpQ6kLTTZKHMLNFDhPGb5vV+/CMImq8Yxw7D6Rl23aXRhckuEXbyHe
R1zfrRbjLmjIuDRItVLwIYSs1eDQhQNrLx4RaaeAoi/7quJWFxiqbVkdXRRc
ucSRWH6nC67tlkx9GgW5hcxQalQX4o6n0/MI84mnuH5I6ILH582MCDqF6Be2
7CzJ6sIRUVK5Qg8RL9q38DedXajNVpJFP3H/3M3BuT1dCAi6oZ9EuNU40y1n
sAvbny0LLhBWeu+q83qyC+FCZsIZAxSspHT8yljpwmqMRdCfQeJ9nS70SBWl
gePGFIvPCAWfdV6Hb5KkYXzOqKqUsNGO55nBcjQ0+v3ewzFKAWtt3CxZg4Zj
0g9ephIOEQ0MXjKnIbO5a3PZGBHfZa8EN1sagp148ljGiet3nChpsafBrH3y
px7huevWq8/daUjxdHOqJOwxpBhqdZGGPi+V5nwGBVVFkhll12jYHfb95jTh
fVH76sVDaRjWERwSYVIwoMXD9TeGhn0lt8OjCGvwcch7xtMg8H1/dznhhC9r
rLqSaFhdWmiZJ2zz8NuDV+k0XEmhl1hPUJB3durttiwapv21cq4T5jYZ6bn+
hgZ9ofNm2YTrf7UKHS2lYTBiU8zaSQp0bXOfs7XT0HTTWSGZcLJ0Rq0vnQbz
+8ZR5YRX1qZO9fbT8EuDI2mMcHFetMybCeL6QpdqRKaIfHE3zFxwhoZ0A3um
LuEAl6tnw77TwL7jTLEjYdktvoXH/9DgaH4+KI5wxIQHvY6VDtUdcS6vCX/+
4Lh0cCMde4wOsFYTNo4/sitlMx0LKR/s+gg/9zY7xMFLx2sWpuscYdbDhk5B
O+iYsjogyvaZmL+C2teHhegom970aBthwQaZ6iJxOgJKaG9UCV94sn9irywd
G9XqLAwJ00OE2CMP0qFyxzfDmrCSJb/UohodfuZm75wIx4pvppzQpoPvHuOm
J+G5v2y+zfp0dCy82RhI2Iy+EqNuQofzKwXjS4Szsn/kPTOjg+47rHeTMHvo
dCe3DR2HDdWWwgl7HB9fuHCMDkHXN16RhKuU+ncwHemotKh6GEN4H2enhqUb
cX4yMzSW8LWxBofS03SMy0fK3yc8WFJ55YAvHZaRkgn/O64Z+z41NpCO4VaF
D//7fcLp/Io/IXTcf8vz9H/jL+i8Gj91lY4Qw0NGdwiXPvuSdO4WHU2JVL5b
hG9slLYOvUPHuUNxDZcJG585w/Egio4Z9S1ngglztWaVP71Px+rhuwvehDsP
zpzPS6BDVOiYlxvhh//JyJc/pkPtR3P9sf/Ff9l7ouUJHV73dPjNCIs5ZScP
vqBjcHiVpEt4umLWdiaLjm/FDmcOEs4Tk9u88oaOldqMEFHC5+/6VnG8pWP9
NqUAPsLaszkXBUrpsBMyPbaWMJvVnKJ4OR0vXLSkvxHvv75Q/rNKDR2uBTbT
A4SPXH5z1KaVDp7gfcoFhAVHvnGf6KLjjIn3h8eERw0Ua8/20vGVZZ1KKGEf
znzl6HE6GlkOfbMmrOQ3P/14ik6s71PK6oR/dxx8ljVLhz/l9ykhwqFJBTz1
i3Rs3emUMkrMf/LfH5+6/9Cx+3DRk0rCPCeUr0+wdkNmzeX4p/9bP5JFX9k2
d6PTxM7CmXDhu7eN2NsNScp6viZi/V0QWrxpJtaNoPGnac8J61xX0zwu1Q1S
Sfzey4Qbjd+9vKDcjdpfx5fECY/TS0ILTbpRLXqaK5BY75may4eqzLohK5qj
ZEDYL0XzZ7t1N6zTf5rxEl7xKD0xd7wb5ypMnLOJ/MK3UKYj5d+NDD2tZTqR
j3qPrf5SP9cNr+WymhTCqWXaOcaXulHGlx/mQVj69kchj9Bu8FxI/jxH5DsD
vvLfqQ+70SE8rbZE5MNAxaqCbZXdcHCa3N49TMxvpT2p9+q64VyqInWH8FGV
S/9yNndDfJ3SRnXCmhpKrqw93bBfaBB+MESsX71n3LOzxP18Ff2kTeTnaMtb
ntU7e+C9bL77aB8x/62HbXX29CDwk1Dfz16ivtlq6b7f34OeXrsTsYSPHPux
/Y18D/bq2tNqiXoh6OJW/ciwB+nDJGPRbiI+fgZ7Av170HB+jcfTTgoe+adu
+nquB3+tC4ZkCEcGriycvtwD4aCA/W87iPidL2hyCu9B/A5e/hqinqleE71o
mtyDKtqLW11EvauKZqPtq+/Bb5+ZlJJGCoayq/5t29uLNd3mbo8riXo0wzat
eKAXsXbt+9kIU6UPk+Oke+F97k7p6QoivpnVnHaqvTCw5TmtUE6Ba3pNZD+5
F/r8zSV5HyhgPq6LnjjXixL5WOHLRL2fiWi8/6epF0YiFjlyRL8w2MD5w7Gj
l+hPP1X7Ef1EMwfFhtrdi/GmW69yiX4jO7yJ7+ZYL/zrysakXxHPc6v5wcal
XtDW//y7LYOCHxdb/+MV7YNn2KbMN0T/suzZmSRxoQ8irlFPV+8T9UPl+D3Z
q334qKV1U5xw1hpm6MFbfaDLslpaxlLgmPDr7KGoPkR9TSpMiaGgvHqnseWT
PmzZrvZQjujHwva4/Dhf3wfX2J6wXaFE/0ebIdft7IdmgOa1veeIep4WrNck
3A++XeEXxIOJeJ75q9ou2o8g6ct2skEUBK/dKtIv24+jpu/fqgQQ/ZS80tJX
vX6cotau0/Al+sN/Lzzf7tUP95unz3EQ/aOU7oZVj/f9iE80uNRiS/QXma8O
dFP78ThlU1eiDbGe+SwsTWr60VLS0+hqTYHWRMIzqbZ+2GsOxM9ZEPk7UtJ0
jtmPgh/nry+bEvOrh5IQwjMAbwlDvmZdCt6djVOMOD2AovzfrC7SRD7qU3P4
4zOAxKfztD+SFFQYDNz2CRxADNuMQqIEkY+2i/VYXB3A++8XQxrEiH6m7O1V
/gcDMAzYrbp7L9HvcfQ1JlMHwPWG9uIiP9FvPNl78s32QWgptE5y/yFDKYFL
rEZwEL7uh9/GL5OxJ2p5vHfvILblrBcRJPYDv0O6XNmkB9F9d33Lvl9kvLa8
42inMwjqm3ln4W9k8K75Zvvn1CAqVZtfdI6TMeRENTApGUSf+KK1RAMZ54Sc
9o04DKGwTvG73n0yXC3kj/S7DGFubGOH/z0yzG6uuUv3GEL64a/CadFkiE09
/dbkNwRDU/LS4r9kdBZMUktuDeFS+uk7D26RIU/2d4rLGoJf9nee60FkTF64
/choZQidacmcAkfIkJ623USnDKOO1ziAhYeMYhvyx7sWw2D5eVsihpsM/TK9
AG3rYWwRTEsS2kyGfZRc3/Ojw2h8uJSpsJGMO/LsrwJPDOMaZbOG9qopmIGl
JJ6QYaD9o8zElClS/+y7S3k2jH/3h5mf+mgKXu65jVW/h/Hm6RQ90dUU7WV3
w0z+DKMsWE2nxMkUsWf2r2/5O4xHsnzC3Q6m4Km3X9vLNoKUv+IqnHaEb1f/
+co1gu6wH9dsTU2xZfnh910iI0j3Y1X2PGgKzonD/QGmI4j9VB0fvobYzz4Y
tl+ijKDIeW2Y1SoJEQYXe65YjEDT3u++wDIJm57k0u7YjiAX//xI/kECx/Fd
bSlOI8T+Y+xy6AQJGzvmqhsCRhBxT7u3upEEto9JOSKPRqDUJv19Jo6EXi0D
46HkEdSNNaVsuEdCTsn08MO0EVy9Eu0hFEmCfdEhHp4XI2hdtyh16DYJb14P
BbLkjUBRanYTJYgEx0ciGgO1xP3VOeW8tCGhOORVVfz8CE4n8K9X2EJC1C/r
41YLxPP7zBRWbiLhRNDKz81LI7jxvLDVcgMJXGcpB26vjmC88J6s86oJ3E99
vRPAPorCA7YDBtMm4LE7aG4hPIr8kNc+4rUm8FJ638NuOopa9nfrJEJMQG3t
yiqmjCL4+8LcwUAT8HvPXT1pMQq3necfq/ua4OPz/WLVtqPwe1knqOxuAt7t
Mf7XnEdRdXPz2BcLE7xfctv0K2gUfY8iWy0PmGDTR65D46mj6ORdv6GmxRjO
/0hsuf90FF+zR3IE6o1R+Et/TDd9FIOc67ecrDKGk3zInZRXo+iKPN46W2yM
/LSxLvuiUbzlNjF4k2aMf24V+7Q1jMKgSsd86awxXpm4pn5YGMXwf+Fa5M3G
UJLeq42lUWJf5l91cIMxPnAN931cHsU6pdZMvjXGaO04vr2cZQzyDVxeFT+M
8OP4sahKjjHcVJdMbuwzgra/xaW63WNIO/UwOzbDCK0PtY+2G44h5fQ3xn9a
Rjh2+c9PKxPi9za2tvHKRhh1Kr3fYUqc//LzuwhZYjxRjZZOizF4MDjkXPYY
QSBH2ZBuP4ZLtq+PvVhrBNdKaaV+nzH8jGShP6ozxM8vO7cw48fQIPDEpdbU
EHGPJ2ofJY6ht0jfcknPEAfNC65aPxqDs053irCGIc7mUb5S08bQHm+w1kTc
EDPnrzUnZY0h/ppjCCebIRjrmBGWFWPYeubvbr13h9El/Ia9bGYMMtl5HKUC
hxHYdrk8YG4MlRf2vzLlPgzem6QQyfkxhOj33WpkOwxL5tjkf4tj+CHB8E77
aoCmrG11/mvHcTzNpT6uygDV6pdCxQXGcYBxxyTUywCF1kZr4wzG4dl5/vOL
LH2EmxbfFjQaR8fxMyd/purDQV9i43OTcZy+tUdP8YE+WA9u2lxkNo7ZVfOI
kMv6MONp2dZ9dByLpIsVGhR9TLYekRT0HkeoDdeu01N62GnmYfnswTiOkirK
fHj1MHOY3iGdMI6N9z+fd1mnB+oh4yOFD8cRXTtZq/1LFx4ykv8QjRE868t9
i3t1kc856zb5chz5x5Z/PknVBbkh6Lz0h3Ei/27klRbXxVXj2ykFzHF83yn9
pEBUB+2Opxzkp8axdHmv6DyvDkSDTAWyvozjq1gf1/a1OqhP23r/6dw4OGUf
PxKsAPiWH4fG/h5H7Yt1gadVgYzXRd5+XAzcaB/Z77FdG608k5rSKgysvRPG
sTVTE/skGhZfqDEQ/M2savd1TQQhu1BEkwErT9eyz3aa2HkmUG6XDgPfrl1R
KmXThFs1iwgHiQETyYNeh/7RwOI5AY7J4wzE7Y25eWdZDXsHSN1PbzNQnlI2
dYRdBXcrNHNswxlQblhfQu9QxvcX0qEb/mUgT2hobGuyMir8uZS8YhjgX9y8
UqygDLeN7dGKSQxEcbsrcR5RQsbBY0bluQyISLkGeD5QxBYB0u6AfAZ62j/8
+uSgiJBVjZ+iRQyM1JzSEhJVBOmT4NPw9wzocWWuL81TwBfH4VXzGgYqeGWW
6lvlIXv3ZNFgHwNbRYxYVpVkEe97NDJmkAHdWQMb50YZ/LUxcdMbYSBJZ0zL
3V0GrcJSPOlMBqzZbbn3PpaG2jrBKbspBnSemSoZakkj9TMnlX2agdFk/uzP
A1I4Wzjr7f2NgQBrjZViCSn0PhwyEP7BwNDo2iy/TknoXWvd1bbAQJ2snXfl
DUlkupd/v7FEjM+mY86qLAke07xPSisMuBiIat34IoEL8k9TmasMbD9a8yEp
XQJj/HHnEtYwcY1qkZPpIQHy8i0zEhsTqUbsNZulJVAwHLR/ZT0TvqvrecR+
iUOwxmPlNTsTa8NXrY7UieP2K7sOJ04m2KXEVFhTxTEbY5y5lZuJk+eWz0Ve
EceRYPXrlVuZGFvKn7F3E8eHfySPBvExoXzq6MUGS3GI6e6SO7CdCR334RUt
I3FEiXGu7xFgwpVxQZL9sDh+bfrTf1eQiYoFveu3TMXh/G0mX0uYiXPO/2n8
sRdHHW3w7uxeJhZY/R1KAsQhX9rikirKhIxhxPTvB+JISKOqWR1g4tW1JbOf
5eJgCXvDzSbJxMfwVRqNeJ7TZ54wC6WZcHfRj6pUlUC75f2yk3JMSKjsU6Jd
l4CG6q04AUUmpvZHBuyhSYDmKqDyWImJO2vjWdlkJREQlU3fo8rEz/y1R7ui
JLGlRD/kmToT2T+Cq6MXJZHF6N4prsXEE8aW+xJeUjDe6lP6SpuJe96zaXFM
KTC01jrK6TLhc7WZ/6OnNHbHyaSpGDKxIfIq10qEDEo+VuiVGDNRnxwjMigp
C7svduOHTJkoFxj/Ldwmixi9GwcOWzDhr6D4XGqXPFi/0V5b2zPxIVlfxj5X
AcmCZ8zpDkw0Ugf/OAgrQtN4zTd7JyZqmxPMZGIVEZgipeTqxkTuST513psH
waRcK/HzYSIhd0VC454yboTwO/zwY2LoeiTLpJAKhJ9n/jkXwESPWDtVPVsF
R1c6da6eZ+K5x8yG+h5VNGRK1EbeYAJHnBQZDho4RftwauttJuTdRZK/rdcE
G6sNx4MwJljOj8WWF2hC+9gVyqMIJrbGn2Bv23UIuRs6OjLjmZD+r6A1mFMH
5IOngmQTmTCVLt5+4KwOphz/bMtLYoL+uUJ1mq6DfUUH7N+lMvF2b9Lv7le6
iHO7NFybSVzP09LqqI8+5GO23jB9TdxPHNmpdlwfTe/TRVpymJhZST/x5LgB
1vO2edAKmOhPc3jSceQwzpfvnxn/wETYmENH4ykj8M2URJ0qZ8JZ301Yl6in
b3ZYyE9XMrHNSfnNkxvG+Ox7IWC+jon0qUO2lzNM4LC7ZWlNBxH/79U+33eS
wSXgX/i+i4nZ/Tl1Gs1klPPynw3qZiLjjUhiy20KxNj/mZwcYKIhSU7Aj9Uc
X+eZtJZJYn7wqqks7rTEk9k7sXe+MNHOyC/5HWYJmylpM/1ZJsaNEw60/LJE
8aB/ddE8MZ7J4tyxYSvc+LSa/3iVeJ78+UmdbhsoVaX52q2ZwDXnoe+8TraY
+GAgtZVtAse7v995P2ULcsHdJ7fYJ5BY3Rcmu8kOq9kyjtqcE2hPCRGyfmKH
3JetAotcE1jWOL60eugo+FO23fPim0DFu4S6spvHUJf4jrx/+wTEfFau6sra
40Kcw8YhgQk4jueGyQ7aY/DOk6tWwhPY/lnkobm5AzICZX3UJScgvYOu8feK
E+x92yTmpScgxKN88aasMzZ7BjKy5CZQNuzXeCfNGf5OJQ57lCeQ73Th5/U4
F4jaH9/RqzqB2ITGojk+V9BsWDrvaxDHo6/HOTx0hSbJ0HSDzgQ+eL/MdSw8
gVmDqfXlehNEXXZSTjZ1QyoiKi4cnoC6j22B7KQb2JTb1WdJE/AfyciZUvZA
kVzQzxeUCbAFf7f5O+GB05I73rhYTOD87hEf7Scn0SzsKN5lO0Hsh5yPxiic
RmPEvNy9IxP//3+S/wMUuXvi
       "]], LineBox[CompressedData["
1:eJwVkmk4lQkDhqWGsgsV5kwRopBvvhml1BMhZYnUezbnHOfYhSwjZSlZypgm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       "]]},
     Annotation[#, "Charting`Private`Tag$27484#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 0.003102940761881906}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.851911321137301*^9, 3.851911412330983*^9}, 
   3.85193699074058*^9, 3.852099777260872*^9, 3.852099848110265*^9, 
   3.852100662234961*^9, 3.852102751056322*^9, 3.852188405648685*^9, 
   3.852189682389312*^9, 3.852189727251072*^9, 3.852190174397155*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"26e98ba7-a3f2-44e6-ae6e-d56361b0e3e3"]
}, Open  ]],

Cell["This only includes a small part in the central basin.", "Text",
 CellChangeTimes->{{3.8519114216778183`*^9, 3.85191143645469*^9}, {
  3.851911482599098*^9, 3.851911501859661*^9}, {3.851937030837261*^9, 
  3.8519370543485107`*^9}, {3.85193761157966*^9, 3.851937613691976*^9}, {
  3.852189738420361*^9, 
  3.852189745152623*^9}},ExpressionUUID->"dee46983-8aae-4533-af17-\
9e52795e31a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot for paper", "Section",
 CellChangeTimes->{{3.8521903272024193`*^9, 3.852190355553831*^9}, {
  3.859134875272914*^9, 
  3.859134876947136*^9}},ExpressionUUID->"17707d76-2d34-4f74-81cd-\
ad6ff539a0a4"],

Cell["\<\
To plot the relationship between eta and error here, we import the \
relationship between the first element of nAD and eta from the _2 notebook. \
\>", "Text",
 CellChangeTimes->{{3.852190371043285*^9, 3.852190390480916*^9}, {
  3.852190550984365*^9, 3.852190553601614*^9}, {3.852190738166459*^9, 
  3.852190801489458*^9}, {3.8521908693153067`*^9, 3.852190909523581*^9}, {
  3.8521909597104073`*^9, 3.852190968850416*^9}, {3.852191811694306*^9, 
  3.852191818900926*^9}, {3.8521919449562063`*^9, 3.852191975940309*^9}, {
  3.8521922849739847`*^9, 3.852192288926529*^9}, {3.859136095297484*^9, 
  3.859136148688951*^9}},ExpressionUUID->"7eafb474-e8d5-4d62-ab95-\
28a5fe70843e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eta", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nAD", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.01", " ", 
      RowBox[{"(", 
       RowBox[{"0.", "+", 
        RowBox[{"0.25", " ", 
         RowBox[{"(", 
          RowBox[{"0.", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"0.001152", " ", "eta"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3.54201", "*", 
               RowBox[{"10", "^", 
                RowBox[{"-", "8"}]}]}], "+", 
              RowBox[{"0.4", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1.39475", "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "40"}]}]}], "-", 
                 RowBox[{"7.41549", "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "20"}]}], " ", "eta"}]}], ")"}]}], "+", 
              RowBox[{"0.01024", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4.1097", "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "7"}]}]}], "+", 
                 RowBox[{"0.446014", " ", "eta"}]}], ")"}]}], "+", 
              RowBox[{"0.16", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "5.36013"}], "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "24"}]}]}], "+", 
                 RowBox[{"0.00626799", " ", "eta"}], "+", 
                 RowBox[{"0.64", " ", 
                  RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
              RowBox[{"0.0256", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "3.98153"}], "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "6"}]}]}], "+", 
                 RowBox[{"0.627693", " ", "eta"}], "+", 
                 RowBox[{"1.", " ", 
                  RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
              RowBox[{"0.064", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"9.79275", "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "7"}]}]}], "+", 
                 RowBox[{"0.224541", " ", "eta"}], "+", 
                 RowBox[{"1.6", " ", 
                  RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"0.00416306", "/", 
            RowBox[{"(", 
             RowBox[{"0.004096", "+", 
              RowBox[{"0.4", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1.6129", "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "35"}]}]}], "-", 
                 RowBox[{"8.57531", "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "15"}]}], " ", "eta"}]}], ")"}]}], "+", 
              RowBox[{"0.01024", " ", 
               RowBox[{"(", 
                RowBox[{"0.0475248", "+", 
                 RowBox[{"51577.2", " ", "eta"}]}], ")"}]}], "+", 
              RowBox[{"0.16", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "6.19848"}], "*", 
                  RowBox[{"10", "^", 
                   RowBox[{"-", "19"}]}]}], "+", 
                 RowBox[{"724.833", " ", "eta"}], "+", 
                 RowBox[{"74009.9", " ", 
                  RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
              RowBox[{"0.0256", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "0.460425"}], "+", 
                 RowBox[{"72586.7", " ", "eta"}], "+", 
                 RowBox[{"115640.", " ", 
                  RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
              RowBox[{"0.064", " ", 
               RowBox[{"(", 
                RowBox[{"0.113244", "+", 
                 RowBox[{"25966.", " ", "eta"}], "+", 
                 RowBox[{"185025.", " ", 
                  RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.000025", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"0.", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"0.00001152", " ", "eta"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3.54201", "*", 
             RowBox[{"10", "^", 
              RowBox[{"-", "8"}]}]}], "+", 
            RowBox[{"0.4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1.39475", "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "40"}]}]}], "-", 
               RowBox[{"7.41549", "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "20"}]}], " ", "eta"}]}], ")"}]}], "+", 
            RowBox[{"0.01024", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4.1097", "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "7"}]}]}], "+", 
               RowBox[{"0.446014", " ", "eta"}]}], ")"}]}], "+", 
            RowBox[{"0.16", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "5.36013"}], "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "24"}]}]}], "+", 
               RowBox[{"0.00626799", " ", "eta"}], "+", 
               RowBox[{"0.64", " ", 
                RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
            RowBox[{"0.0256", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3.98153"}], "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "6"}]}]}], "+", 
               RowBox[{"0.627693", " ", "eta"}], "+", 
               RowBox[{"1.", " ", 
                RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
            RowBox[{"0.064", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9.79275", "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "7"}]}]}], "+", 
               RowBox[{"0.224541", " ", "eta"}], "+", 
               RowBox[{"1.6", " ", 
                RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"0.416306", "/", 
          RowBox[{"(", 
           RowBox[{"0.004096", "+", 
            RowBox[{"0.4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1.6129", "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "35"}]}]}], "-", 
               RowBox[{"8.57531", "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "15"}]}], " ", "eta"}]}], ")"}]}], "+", 
            RowBox[{"0.01024", " ", 
             RowBox[{"(", 
              RowBox[{"0.0475248", "+", 
               RowBox[{"51577.2", " ", "eta"}]}], ")"}]}], "+", 
            RowBox[{"0.16", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "6.19848"}], "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "19"}]}]}], "+", 
               RowBox[{"724.833", " ", "eta"}], "+", 
               RowBox[{"74009.9", " ", 
                RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
            RowBox[{"0.0256", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "0.460425"}], "+", 
               RowBox[{"72586.7", " ", "eta"}], "+", 
               RowBox[{"115640.", " ", 
                RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
            RowBox[{"0.064", " ", 
             RowBox[{"(", 
              RowBox[{"0.113244", "+", 
               RowBox[{"25966.", " ", "eta"}], "+", 
               RowBox[{"185025.", " ", 
                RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}]}], "]"}]}], 
      "+", 
      RowBox[{"0.01", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"0.", "+", 
         RowBox[{"0.25", " ", 
          RowBox[{"(", 
           RowBox[{"0.", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"0.001152", " ", "eta"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3.54201", "*", 
                RowBox[{"10", "^", 
                 RowBox[{"-", "8"}]}]}], "+", 
               RowBox[{"0.4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1.39475", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "40"}]}]}], "-", 
                  RowBox[{"7.41549", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "20"}]}], " ", "eta"}]}], ")"}]}], "+", 
               RowBox[{"0.01024", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4.1097", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "7"}]}]}], "+", 
                  RowBox[{"0.446014", " ", "eta"}]}], ")"}]}], "+", 
               RowBox[{"0.16", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "5.36013"}], "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "24"}]}]}], "+", 
                  RowBox[{"0.00626799", " ", "eta"}], "+", 
                  RowBox[{"0.64", " ", 
                   RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
               RowBox[{"0.0256", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "3.98153"}], "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "6"}]}]}], "+", 
                  RowBox[{"0.627693", " ", "eta"}], "+", 
                  RowBox[{"1.", " ", 
                   RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
               RowBox[{"0.064", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9.79275", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "7"}]}]}], "+", 
                  RowBox[{"0.224541", " ", "eta"}], "+", 
                  RowBox[{"1.6", " ", 
                   RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"0.00416306", "/", 
             RowBox[{"(", 
              RowBox[{"0.004096", "+", 
               RowBox[{"0.4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1.6129", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "35"}]}]}], "-", 
                  RowBox[{"8.57531", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "15"}]}], " ", "eta"}]}], ")"}]}], "+", 
               RowBox[{"0.01024", " ", 
                RowBox[{"(", 
                 RowBox[{"0.0475248", "+", 
                  RowBox[{"51577.2", " ", "eta"}]}], ")"}]}], "+", 
               RowBox[{"0.16", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "6.19848"}], "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "19"}]}]}], "+", 
                  RowBox[{"724.833", " ", "eta"}], "+", 
                  RowBox[{"74009.9", " ", 
                   RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
               RowBox[{"0.0256", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "0.460425"}], "+", 
                  RowBox[{"72586.7", " ", "eta"}], "+", 
                  RowBox[{"115640.", " ", 
                   RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
               RowBox[{"0.064", " ", 
                RowBox[{"(", 
                 RowBox[{"0.113244", "+", 
                  RowBox[{"25966.", " ", "eta"}], "+", 
                  RowBox[{"185025.", " ", 
                   RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], "]"}]}], "+", 
      RowBox[{"0.01", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"0.", "+", 
         RowBox[{"0.6", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "0.00416667"}], " ", 
             RowBox[{"(", 
              RowBox[{"0.", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"0.00001152", " ", "eta"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"3.54201", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "8"}]}]}], "+", 
                  RowBox[{"0.4", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1.39475", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "40"}]}]}], "-", 
                    RowBox[{"7.41549", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "20"}]}], " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.01024", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4.1097", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "7"}]}]}], "+", 
                    RowBox[{"0.446014", " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.16", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "5.36013"}], "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "24"}]}]}], "+", 
                    RowBox[{"0.00626799", " ", "eta"}], "+", 
                    RowBox[{"0.64", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.0256", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "3.98153"}], "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "6"}]}]}], "+", 
                    RowBox[{"0.627693", " ", "eta"}], "+", 
                    RowBox[{"1.", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.064", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"9.79275", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "7"}]}]}], "+", 
                    RowBox[{"0.224541", " ", "eta"}], "+", 
                    RowBox[{"1.6", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}], "-", 
               RowBox[{"0.416306", "/", 
                RowBox[{"(", 
                 RowBox[{"0.004096", "+", 
                  RowBox[{"0.4", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1.6129", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "35"}]}]}], "-", 
                    RowBox[{"8.57531", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "15"}]}], " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.01024", " ", 
                   RowBox[{"(", 
                    RowBox[{"0.0475248", "+", 
                    RowBox[{"51577.2", " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.16", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "6.19848"}], "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "19"}]}]}], "+", 
                    RowBox[{"724.833", " ", "eta"}], "+", 
                    RowBox[{"74009.9", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.0256", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "0.460425"}], "+", 
                    RowBox[{"72586.7", " ", "eta"}], "+", 
                    RowBox[{"115640.", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.064", " ", 
                   RowBox[{"(", 
                    RowBox[{"0.113244", "+", 
                    RowBox[{"25966.", " ", "eta"}], "+", 
                    RowBox[{"185025.", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"0.416667", " ", 
             RowBox[{"(", 
              RowBox[{"0.", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"0.001152", " ", "eta"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"3.54201", "*", 
                   RowBox[{"10", "^", 
                    RowBox[{"-", "8"}]}]}], "+", 
                  RowBox[{"0.4", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1.39475", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "40"}]}]}], "-", 
                    RowBox[{"7.41549", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "20"}]}], " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.01024", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4.1097", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "7"}]}]}], "+", 
                    RowBox[{"0.446014", " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.16", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "5.36013"}], "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "24"}]}]}], "+", 
                    RowBox[{"0.00626799", " ", "eta"}], "+", 
                    RowBox[{"0.64", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.0256", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "3.98153"}], "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "6"}]}]}], "+", 
                    RowBox[{"0.627693", " ", "eta"}], "+", 
                    RowBox[{"1.", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.064", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"9.79275", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "7"}]}]}], "+", 
                    RowBox[{"0.224541", " ", "eta"}], "+", 
                    RowBox[{"1.6", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"0.00416306", "/", 
                RowBox[{"(", 
                 RowBox[{"0.004096", "+", 
                  RowBox[{"0.4", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1.6129", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "35"}]}]}], "-", 
                    RowBox[{"8.57531", "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "15"}]}], " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.01024", " ", 
                   RowBox[{"(", 
                    RowBox[{"0.0475248", "+", 
                    RowBox[{"51577.2", " ", "eta"}]}], ")"}]}], "+", 
                  RowBox[{"0.16", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "6.19848"}], "*", 
                    RowBox[{"10", "^", 
                    RowBox[{"-", "19"}]}]}], "+", 
                    RowBox[{"724.833", " ", "eta"}], "+", 
                    RowBox[{"74009.9", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.0256", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "0.460425"}], "+", 
                    RowBox[{"72586.7", " ", "eta"}], "+", 
                    RowBox[{"115640.", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "+", 
                  RowBox[{"0.064", " ", 
                   RowBox[{"(", 
                    RowBox[{"0.113244", "+", 
                    RowBox[{"25966.", " ", "eta"}], "+", 
                    RowBox[{"185025.", " ", 
                    RowBox[{"eta", "^", "2"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], "]"}]}]}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.859136179262704*^9, 3.859136191459757*^9}, {
  3.859136598709168*^9, 
  3.8591366029884567`*^9}},ExpressionUUID->"31de7bd4-d38c-4239-aa32-\
6f03c73ef83e"],

Cell["\<\
Now we plot the relationship. Since nAD gives us the value of the first \
element (in range 0-0.5), we map that back to the range for parameter p (0-1).\
\>", "Text",
 CellChangeTimes->{{3.859136208914238*^9, 3.859136214268096*^9}, {
  3.8591367004799128`*^9, 
  3.8591367651187983`*^9}},ExpressionUUID->"386d1381-2fdd-496b-abc9-\
0a5efa9db059"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{
      RowBox[{"Phi", ".", "wstar"}], "-", "V"}], "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"eta", "->", "etaval"}], ",", 
      RowBox[{"epsilon", "->", "0.0001"}], ",", "worstparam"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp", " ", "=", " ", 
   RowBox[{
    RowBox[{"tmp", "/.", 
     RowBox[{"{", 
      RowBox[{"p", "->", 
       RowBox[{"1", "-", 
        RowBox[{"2", "*", "nAD"}]}]}], "}"}]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"eta", "->", "etaemph"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"tmp", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"etaval", "->", "0"}], ",", 
      RowBox[{"etaemph", " ", "->", " ", 
       RowBox[{"10", "^", "etax"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", " ", 
     RowBox[{"-", "7"}], ",", " ", "0"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.859136219276257*^9, 3.8591362419142723`*^9}, {
  3.8591362870569963`*^9, 3.859136378452539*^9}, {3.859136572417418*^9, 
  3.859136573950144*^9}, {3.8591366814594088`*^9, 3.859136685990198*^9}, {
  3.859136894581517*^9, 3.859136923485365*^9}, {3.8591374146082067`*^9, 
  3.859137414896392*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"a20519f7-6924-4f8c-96dd-8644d35bd94b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13k4VN8bAHASaTHLHcyYiZAIJUWK1Mm+3ZsiIkuUpaksFdpkzfIlKVRS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       "]], LineBox[CompressedData["
1:eJwV1Hk4VVsUAHBcXHcokRDJlCFPMhSS2qKQpwnnXvOQscjwlCcpZM6UKUUk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       "]]},
     Annotation[#, "Charting`Private`Tag$240497#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.00020091834980127485`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-7, 0}, {0.00020091834980127442`, 0.0019753264380701976`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.859136383620779*^9, 3.85913647080199*^9, 
  3.8591366221277657`*^9, 3.8591367633925343`*^9, 3.859137010441338*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"7e44fae5-87bb-4422-8740-e78636ff8d81"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"tmp", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"etaval", "->", 
       RowBox[{"10", "^", "etax"}]}], ",", 
      RowBox[{"etaemph", " ", "->", " ", "0.0002"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"etax", ",", " ", 
     RowBox[{"-", "12"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.859136970182178*^9, 3.859136988647387*^9}, {
  3.859137076125773*^9, 3.859137079265128*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"ac320285-012e-427a-8eae-9ff8b8b9042c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13c8lV8YAHAh95rZe7vuRdJChXqPUVKSUVFaZqGsUIqSH4qGyEhDpZJk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       "]]},
     Annotation[#, "Charting`Private`Tag$241445#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-12, 2}, {0., 71.04506935918721}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.859137066979208*^9, 3.859137161804813*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"f4d3fe74-e138-4f40-8fa6-aee08ae723e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"tmp", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"etaval", "->", "0"}], ",", 
        RowBox[{"etaemph", "->", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"etarun", "/", "40"}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "7"}], " ", "*", "40"}], ",", 
       RowBox[{"0", "*", "10"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<emphasis_valerr_etaemph\>\"", ",", "\"\<.dat\>\""}], "]"}], 
   ",", "tbl"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"tmp", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"etaval", "->", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"etarun", "/", "10"}], ")"}]}]}], ",", 
        RowBox[{"etaemph", " ", "->", " ", "0.0002"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "10"}], " ", "*", "10"}], ",", 
       RowBox[{"0", "*", "10"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "\"\<emphasis_valerr_etaemph2x10-4_etaval\>\"", ",", "\"\<.dat\>\""}], 
    "]"}], ",", "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{{3.859137421023179*^9, 3.8591374520578423`*^9}, {
  3.8591375124640303`*^9, 3.859137564421405*^9}, {3.859138086650219*^9, 
  3.859138139899592*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"0e2bfaad-0ecd-4e35-8106-9993a9b4133c"],

Cell[BoxData["\<\"emphasis_valerr_etaemph.dat\"\>"], "Output",
 CellChangeTimes->{3.8591375940016823`*^9, 3.859138155736108*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"795544a7-c2cf-4652-8cc4-63ff38ec2dc1"],

Cell[BoxData["\<\"emphasis_valerr_etaemph2x10-4_etaval.dat\"\>"], "Output",
 CellChangeTimes->{3.8591375940016823`*^9, 3.859138157147938*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"5bb680ae-73d8-46fe-a706-11d01d2c268d"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1134.8256880733945`, 909.5779816513761},
WindowMargins->{{Automatic, 0.6605504587159885}, {
  18.32727272727277, Automatic}},
CellContext->Notebook,
Magnification->1.25,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->"ReverseColor.nb",
ExpressionUUID->"6d7ec3d5-ece1-4926-afd3-3542b844b512"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 665, 12, 66, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1248, 36, 3605, 94, 293, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[4856, 132, 988, 21, 56, "Output",ExpressionUUID->"f702bc94-ad3c-416c-9130-77f9b81f7fba"],
Cell[5847, 155, 814, 15, 58, "Output",ExpressionUUID->"8e1a1c96-2be6-4eab-9b5f-c6c115c10b9f"]
}, Open  ]],
Cell[6676, 173, 381, 6, 40, "Text",ExpressionUUID->"812d4f2f-d057-4141-99e9-0041d5ad4212"],
Cell[7060, 181, 1121, 28, 88, "Input",ExpressionUUID->"dac544c6-b255-4844-84bf-e0609e814e56"],
Cell[8184, 211, 190, 3, 40, "Text",ExpressionUUID->"95836cf1-3dc9-4433-aed0-478a4bd2329d"],
Cell[CellGroupData[{
Cell[8399, 218, 791, 19, 36, "Input",ExpressionUUID->"31e215e2-c46b-49dd-b302-fcc49093543e"],
Cell[9193, 239, 19488, 339, 303, "Output",ExpressionUUID->"db97ecdd-14bd-495e-a758-593f7834f796"]
}, Open  ]],
Cell[28696, 581, 504, 10, 66, "Text",ExpressionUUID->"ee80c5c1-e570-43f3-8345-11d8e913fbdb"],
Cell[CellGroupData[{
Cell[29225, 595, 2067, 48, 191, "Input",ExpressionUUID->"ca30ea3c-eab1-4746-9772-aae4a1a73aba"],
Cell[31295, 645, 750, 11, 58, "Output",ExpressionUUID->"c4b0c95f-7422-42b7-a69e-0f1748748c10"],
Cell[32048, 658, 482, 11, 35, "Message",ExpressionUUID->"f148ef59-c8fb-4ef1-b7e3-782de5aedb9a"],
Cell[32533, 671, 884, 16, 58, "Output",ExpressionUUID->"f6c3f20e-80ee-4988-b50f-0acc018be6dc"],
Cell[33420, 689, 758, 11, 58, "Output",ExpressionUUID->"d31b139f-7c95-4142-91ff-ff48d9795aaa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34215, 705, 1230, 34, 63, "Input",ExpressionUUID->"c7f9047e-0a17-4563-b99b-caedc94416ec"],
Cell[35448, 741, 19200, 335, 291, "Output",ExpressionUUID->"4353d729-6344-4f7a-8fb6-ff2b1f893cb9"],
Cell[54651, 1078, 14819, 263, 294, "Output",ExpressionUUID->"7a8d2bf6-e7e3-472e-9fc7-8a7fa4c733e6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69507, 1346, 185, 3, 83, "Section",ExpressionUUID->"3eeb6e0f-64f2-4960-a3bd-9ec3c55da956"],
Cell[69695, 1351, 1282, 32, 63, "Input",ExpressionUUID->"596bc87a-22e9-47da-8189-83189b18c546"],
Cell[CellGroupData[{
Cell[71002, 1387, 297, 4, 36, "Input",ExpressionUUID->"6dcf7e24-835f-4fbb-9e4c-dfd4127d8860"],
Cell[71302, 1393, 4743, 131, 143, "Output",ExpressionUUID->"9f0651f9-5f09-417c-b979-68accbe85b42"]
}, Open  ]],
Cell[76060, 1527, 340, 7, 66, "Text",ExpressionUUID->"507c7550-1154-4d01-8be8-e71dbb3778df"],
Cell[CellGroupData[{
Cell[76425, 1538, 1361, 41, 63, "Input",ExpressionUUID->"e4b08763-e472-41a6-89a5-892d80934eb1"],
Cell[77789, 1581, 677, 13, 55, "Message",ExpressionUUID->"97a49447-3208-4f54-b733-7ac7444e3a07"],
Cell[78469, 1596, 457, 7, 41, "Output",ExpressionUUID->"b1d00e10-5f16-4644-a861-4faa9f04cc3b"]
}, Open  ]],
Cell[78941, 1606, 286, 4, 40, "Text",ExpressionUUID->"371e25ae-fd82-40ba-9f0d-fe959c3d4165"],
Cell[CellGroupData[{
Cell[79252, 1614, 673, 17, 36, "Input",ExpressionUUID->"329abe1e-5604-4965-87cb-94e24f5bd0fa"],
Cell[79928, 1633, 18639, 326, 282, "Output",ExpressionUUID->"26e98ba7-a3f2-44e6-ae6e-d56361b0e3e3"]
}, Open  ]],
Cell[98582, 1962, 390, 6, 40, "Text",ExpressionUUID->"dee46983-8aae-4533-af17-9e52795e31a3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99009, 1973, 210, 4, 83, "Section",ExpressionUUID->"17707d76-2d34-4f74-81cd-ad6ff539a0a4"],
Cell[99222, 1979, 686, 11, 66, "Text",ExpressionUUID->"7eafb474-e8d5-4d62-ab95-28a5fe70843e"],
Cell[99911, 1992, 20850, 505, 1445, "Input",ExpressionUUID->"31de7bd4-d38c-4239-aa32-6f03c73ef83e"],
Cell[120764, 2499, 355, 7, 66, "Text",ExpressionUUID->"386d1381-2fdd-496b-abc9-0a5efa9db059"],
Cell[CellGroupData[{
Cell[121144, 2510, 1420, 39, 88, "Input",ExpressionUUID->"a20519f7-6924-4f8c-96dd-8644d35bd94b"],
Cell[122567, 2551, 16799, 294, 319, "Output",ExpressionUUID->"7e44fae5-87bb-4422-8740-e78636ff8d81"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139403, 2850, 570, 14, 36, "Input",ExpressionUUID->"ac320285-012e-427a-8eae-9ff8b8b9042c"],
Cell[139976, 2866, 16962, 297, 318, "Output",ExpressionUUID->"f4d3fe74-e138-4f40-8fa6-aee08ae723e8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156975, 3168, 1771, 51, 114, "Input",ExpressionUUID->"0e2bfaad-0ecd-4e35-8106-9993a9b4133c"],
Cell[158749, 3221, 207, 2, 58, "Output",ExpressionUUID->"795544a7-c2cf-4652-8cc4-63ff38ec2dc1"],
Cell[158959, 3225, 220, 2, 102, "Output",ExpressionUUID->"5bb680ae-73d8-46fe-a706-11d01d2c268d"]
}, Open  ]]
}, Open  ]]
}
]
*)

