import os
import sys

HERE = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, HERE)

import torch
import torch.nn as nn
import torch.nn.parallel
import torch.backends.cudnn as cudnn
import torch.optim as optim
import torch.utils.data
from torch.autograd import Variable
import torchvision.utils as vutils
import torch.nn.functional as F


if 'models' in sys.modules :
	sys.modules.pop('models')


if 'models.submodule' in sys.modules :
	sys.modules.pop('models.submodule')
	
from models import __models__

import numpy as np

sys.path.pop(0)

class Bunch(object):
  def __init__(self, adict):
    self.__dict__.update(adict)

def getModel(pretrained, level=-1, model = 'MSNet2D') :

	arguments = {'maxdisp' : 192}

	args = Bunch(arguments)
	
	checkpoint = torch.load(pretrained)
	
	model = __models__[model](args.maxdisp, allLevels = True)
	
	if 'upt_state_dict' in checkpoint:
		model.load_state_dict(checkpoint['upt_state_dict'])
		model = nn.DataParallel(model).cuda()
	else :
		model = nn.DataParallel(model).cuda()
		model.load_state_dict(checkpoint['model'])
	
	model.eval()
	
	return lambda imgLeft, imgRight : model.forward(imgLeft[np.newaxis,...].cuda(), imgRight[np.newaxis,...].cuda())[level]
