# Learning from Label Proportion by Learning from Label Noise
1. Dependencies:
	* download and install Anaconda 
        * create an environment and install the dependencies: `conda env create -f LLP.yml`.  If failed, you may want to install the packages listed in LLP.yml manually.
        * activate the new environment: `conda activate LLP`
2. Generate LLP data:
    * Download the 
    * usage: `python make_data.py loader dataset_name path_to_save_mat path_to_save_binary lower_bound upper_bound train_size test_size [number_of_bags]`
        * to re-generate the Adult and Magic data used in the experiments in appendix and save them to the folder `./experiments/`, run:
            * `python make_data.py load_adult adult0 ./experiments/ ./experiments/ 0 0.5 8192 3000`
            * `python make_data.py load_adult adult1 ./experiments/ ./experiments/ 0.5 1 8192 3000`
            * `python make_data.py load_magic magic0 ./experiments/ ./experiments/ 0 0.5 5120 1400`
            * `python make_data.py load_magic magic1 ./experiments/ ./experiments/ 0.5 1 5120 1400`
        * the created dataset will be named as `[dataset name]_[bag size]_[trial id]`, trial id is an integer from 0 to 4
    * the program samples five subsets with repeatition for each bag size in [8, 16, 32, 64, 128, 256, 512] and saves the created dataset in a binary 
    * the program saves a copy of the created dataset in `.mat` format
3. Reproduce the resuls in table 5:
    * comment/uncomment code on line 252-253 and line 324-325 in models/kernel_model.py to switch between LLPFC-uniform and LLPFC-approx.
    * usage: `python run_experiment.py data_path path_to_save_results`
    * example: `python run_experiment.py ./experiments/adult0_8_0 ./experiments/adult0_8_0_res`
