from utils import *
import numpy as np
import argparse
import matplotlib.pyplot as plt
import random
import scipy.io as sio


def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--iter', default=2000, type=int)
    parser.add_argument('--file_name', default='port4.txt', type=str)
    parser.add_argument('--num', default=98, type=int)
    parser.add_argument('--r', default=0.1, type=float)
    parser.add_argument('--lam', default=10, type=float)
    parser.add_argument('--s2', default=10, type=int)
    parser.add_argument('--q', default=10, type=int)
    parser.add_argument('--k', default=10, type=int)
    parser.add_argument('--miu', default=0.015, type=float)
    parser.add_argument('--eta', default=0.015, type=float)
    return parser.parse_args()

if __name__ == "__main__":
    args = get_args()
    SEED = 2
    random.seed(SEED)
    np.random.seed(SEED)
    mean, std, cov = read_file(args.file_name, args.num)
    x = np.random.dirichlet(np.ones(args.num), size=1)

    x_new = x
    ## Record the iterations and f(x)
    performance_ZOHT = [[0,f(x,cov,mean,args.r, args.lam)]]
    judge = 1
    t = 1
    f_x = np.zeros(args.iter)
    for m in range(args.iter):
        gradient_i = np.zeros((args.q,args.num))
        for i in range(args.q):
            u = generate_u(args.s2, args.num)
            func_1 = f(x, cov, mean, args.r, args.lam)
            func_2 = f(x+args.miu*u, cov, mean, args.r, args.lam)
            gradient_i[i] = args.num/args.miu*(func_2-func_1)*u
        gradient = np.sum(gradient_i,axis=0)/args.q
        x_new = x_new - args.eta * gradient
        # ||x||_0<k
        top_k_idx = np.argsort(-np.abs(x_new))[0:args.k]
        x_temp = np.zeros_like(x)
        x_temp[0, top_k_idx] = x_new[0, top_k_idx]
        x_new = x_temp
        x_new = x_new / np.sum(x_new)
        performance_ZOHT.append([t,f(x_new,cov,mean,args.r, args.lam)])
        judge = f(x_new, cov, mean, args.r, args.lam)
        print('Estimated f(x_k): %f  iters: %d' %
               (judge, t))
        f_x[m] = judge
        t=t+1
    file_name = './port4/ZOHT.mat'
    sio.savemat(file_name, {'f_x': f_x})
    fig, ax = plt.subplots()
    ax.plot(np.array(performance_ZOHT)[:, 0],
            np.array(performance_ZOHT)[:, 1], linewidth=1, label="ZOHT")
    print(np.shape(performance_ZOHT))
    print(performance_ZOHT)
    plt.xlabel('Function Evaluations')
    plt.ylabel('f(x)')
    leg = ax.legend()
    plt.show()





