"""Configurations for the gradient descent experiments."""
from scripts.synthetic.gradient_descent import Config


CONFIGS = {
    'test': Config(
        name='test',
        m_gen=12,
        m_train=12,
        d=4,
        lr=1e-3,
        n_steps=200_000,
    )
}


def add_cfg(suffix: str, *, m_gen: int, m_train: int, lr: float, d: int, n_steps: int):
    name = f'mg{m_gen}_mt{m_train}_d{d}_ns{n_steps}{suffix}'
    cfg = Config(
        name=name,
        m_gen=m_gen,
        m_train=m_train,
        d=d,
        lr=lr,
        n_steps=n_steps,
    )
    CONFIGS[cfg.name] = cfg


_LR = 1e-3
_N_STEPS = 400_000

_D = [4, 8, 16, 32]
_M_GEN_FACTOR = [0.5, 1, 2]
_M_TRAIN_FACTOR = [1, 3 / 2, 2, 4, 8]


for d in _D:
    for m_gen_factor in _M_GEN_FACTOR:
        m_gen = int(d * m_gen_factor)
        for m_train_factor in _M_TRAIN_FACTOR:
            m_train = m_train_factor * m_gen
            add_cfg(
                '_lr1e3',
                m_gen=int(m_gen),
                m_train=int(m_train),
                d=d,
                lr=_LR,
                n_steps=_N_STEPS,
            )

