{
  description = "MGS flake";

  inputs = {
    nixpkgs.url = "nixpkgs/nixos-21.11";
  };

  outputs = { self, nixpkgs }:
    let
      system = "x86_64-linux";

      pkgs = import nixpkgs {
        inherit system;
        config = { allowUnfree = true; };
      };
    in
      {
        devShells."${system}" = {
          "cuda" = import ./shell.nix { inherit pkgs; cuda = true; };
          "cpu" = import ./shell.nix { inherit pkgs; cuda = false; };
        };
      };
}
