import psutil
import time
import os
from subprocess import Popen
from datetime import datetime


# Control variables
infile = 'sbm_exp.py'
outfile = 'sbm_exp_temp'
curr_idx = 0
changes = dict()
nodes = [500, 1000, 2000, 3000]
clusters = [2, 4, 5, 8]
groups = [0.01, 0.1, 0.2, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9]
ranks = groups
for num_nodes in nodes:
    for num_cluster in clusters:
        changes[curr_idx] = [('\'num_nodes\': 500', '\'num_nodes\': ' + str(num_nodes)),
                             ('use_config = 0', 'use_config = 0'),
                             ('\'num_clusters\': 5', '\'num_clusters\': ' + str(num_cluster))]
        curr_idx += 1

        for val in groups:
            changes[curr_idx] = [('\'num_nodes\': 500', '\'num_nodes\': ' + str(num_nodes)),
                                 ('use_config = 0', 'use_config = 2'),
                                 ('\'num_clusters\': 5', '\'num_clusters\': ' + str(num_cluster)),
                                 ('{\'num_groups\': 5}', '{\'num_groups\': ' + str(int(val * num_nodes)) + '}')]
            curr_idx += 1

        for val in ranks:
            changes[curr_idx] = [('\'num_nodes\': 500', '\'num_nodes\': ' + str(num_nodes)),
                                 ('use_config = 0', 'use_config = 3'),
                                 ('\'num_clusters\': 5', '\'num_clusters\': ' + str(num_cluster)),
                                 ('{\'rank\': 5}', '{\'rank\': ' + str(int(val * num_nodes)) + '}')]
            curr_idx += 1


with open(infile) as f:
    content = f.read()

idx = 0
for key in changes:

    count = 0
    while count < 5:
        count = count + 1 if (psutil.cpu_percent(0.1) < 75 and psutil.virtual_memory().percent < 80) else 0
        time.sleep(0.2)

    new_content = content[:]
    for old, new in changes[key]:
        new_content = new_content.replace(old, new)

    curr_time = datetime.now()
    exp_name = 'SBM-' + str(curr_time.month) + '-' + str(curr_time.day) + '-' + str(curr_time.hour) + '-' + \
               str(curr_time.minute) + '-' + str(curr_time.second)
    new_content = new_content.replace('name = \'default\'', 'name = \'' + exp_name + '\'')

    curr_file = outfile + '_' + str(key) + '.py'
    with open(curr_file, 'w') as f:
        f.write(new_content)

    process = Popen(['python', curr_file])
    idx += 1
    print('Started:', idx, 'of', len(changes))

    time.sleep(1)
    os.remove(curr_file)

time.sleep(60)
