# NOMAD
## Nonlinear Manifold Decoders for Operator Learning

## Contents of supplemental file

The repository contains three folders: one for each example presented in the manuscript, namely the Antiderivative, the Advection and the Shallow Water
folders. 

Each example folder should contain 4 subfolders,

a) "Train_model": containing the python file that can be used for training the model
b) "Error_Vectors": containing the error vectors resulting from multiple model runs used to generate the figures in the manuscript
c) "Data": containing the data sets used for training and testing the model (the Antiderivative does not contain a folder like that
   because the data sets are created before training)
d) "Plot_results": containing the python scripts that can be used in order to reproduce the figures presented in the paper.

a) and d) can be found in the zip folder in the NeurIPS supplemental material portal and contain only python script files.

b) and c) can be downloaded from the following direct Google Drive link

https://drive.google.com/uc?export=download&id=1hshM_vtS4hU9Q6JbnY74DyQUiGKcdMNu

After the zip file is downloaded from the direct link and unzip-ed, the "Error_Vectors" and "Data" folders need to be moved to the inside of each example folder, i.e. the "Data" folder for the Shallow Water Equations examples found in NeurIPS2022.zip need to be moved to the "Shallow Water" folder of the "NOMAD" folder found in the supplemental material.

## Code usage

For training the advection model you need to run the file in the "Train_model" folder with arguments n, the size of the latent dimension, and the type of the decoder, "linear" or "nonlinear". For example if you run "python train_advection 10 nonlinear" you will train the model for the advection case using a solution manifold latent dimension of size 10 and a nonlinear decoder. If you run "python train_advection 10 linear" you will repeat the process using a linear decoder.

For the Antiderivative case, you can run the file in the "Train_model" folder in the same manner, i.e. "python train_antiderivative 10 nonlinear". For the Shallow Water Equations, the same logic applies. So, you can run "python train_SW.py 10 nonlinear" in the "Train_model" folder.

For making plots you need to run the python files in the "Plot_results" folders without any arguments, i.e. for the advection case "python analytic_solution.py". 

