import numpy as np
import pandas as pd
import random
from scipy.stats import norm
import xgboost as xgb
from sklearn.linear_model import LogisticRegression
from sklearn.linear_model import LinearRegression
from sklearn.linear_model import Ridge

from sklearn.ensemble import RandomForestClassifier
from sklearn.ensemble import RandomForestRegressor
from sklearn.ensemble import GradientBoostingRegressor

from sklearn.tree import DecisionTreeRegressor
from sklearn.neighbors import KNeighborsClassifier
from sklearn.neighbors import KNeighborsRegressor
from sklearn import svm
import sklearn.model_selection as sk_ms
from sklearn.model_selection import train_test_split

def get_model_params(name, seed, obj='reg:squarederror'):
    # returns model instance + fine tuning grid for gridsearch
    if name == 'Decision Tree Regression':
        params = {'max_depth':[1,2,3,5,10]}
        model = DecisionTreeRegressor(random_state=seed)
        
    if name == 'Random Forrest Regression':
        params = {'max_depth':[1,2,3,4,5,6,7,8,9,10,11,12,13,15,20]}
        model = RandomForestRegressor(random_state=seed)
        
    if name == 'XGBoost':
        params = {'max_depth':[1,2,3,4,5,6],
                 'min_child_weight':[1,2,3]}
        if (obj == 'binary:logistic'):
            model = xgb.XGBRegressor(objective=obj, random_state=seed, eval_metric='logloss')
        else:
            model = xgb.XGBRegressor(objective=obj, random_state=seed)

    if name == 'Gradient Boosting Regressor':
        params = {'max_depth':[1,2,3,4,5,6,7,8,9,10,11,12,13,15,20]}
        model = GradientBoostingRegressor()
        
    if name == 'Ridge':
        params = {'alpha': np.arange(0, 1, 0.1)}
        model = Ridge(random_state=seed)
        
    if name == 'knn_classifier':
        params = None
        model = KNeighborsClassifier()
        
    if name == 'knn_regression':
        params = {'n_neighbors':[1,2,3,5,10], 'weights':['uniform', 'distance']}
        model = KNeighborsRegressor()
        
    if name == 'svm kernel':
        params = {'C': [0.1,1,10,100], 'gamma': [1,0.1,0.01,0.001],
                  'kernel': ['rbf', 'poly', 'sigmoid']}
        model = svm.SVR()
        
    return model, params

def gridsearch(X, Y, name, seed, obj='reg:squarederror', score='neg_mean_squared_error'):
    # if we are doing regression without regularization, no need to fine tune
    if name == 'Regression':
        return LinearRegression().fit(X, Y) 
    
    model, params = get_model_params(name, seed+5, obj)
    trained_tree = sk_ms.GridSearchCV(estimator  = model,
                                      param_grid = params,
                                      scoring    = score,
                                      cv = 3,
                                      refit      = True).fit(X, Y)
    return trained_tree 
