# -*- coding: utf-8 -*-
"""512feature_google_balanced_xent_imbalance_224_fairness_water_bird.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1ZNXafR95avJjT3FpvSpYR5k6BTi-vrQ1

#dir
"""

import os
from google.colab import drive
drive.mount('/content/drive')

path = "/content/drive/My Drive/long_tail"

os.chdir(path)
os.listdir(path)

import csv
import numpy as np
import random
import torch
from PIL import Image
from torch.utils.data import DataLoader,TensorDataset
from torchvision.transforms import Compose, RandomCrop, Pad, RandomHorizontalFlip, Resize, RandomAffine,RandomResizedCrop,CenterCrop
from torchvision.transforms import ToTensor, Normalize,transforms
from PIL.Image import BICUBIC
import scipy.io as sio

def load_img(data_dir,img_filename,index,transform):
  img_split = []
  img_filename_split = np.array(img_filename)[index]
  for i in range(np.shape(img_filename_split)[0]):
    #if i >= size and size!=0:
    #  break
    img_filename = os.path.join(
    data_dir,
    img_filename_split[i])
    img = Image.open(img_filename).convert('RGB')
    img = transform(img)
    image_array = np.asarray(img)
    #img = transform(img)
    #image_array = np.array(img)
    '''
    img = Image.open(img_filename).convert('RGB')
    img = transform(img)
    img = transforms.ToPILImage()(img)
    image_array = np.asarray(img)
    '''
    img_split.append(image_array)
    if i%100 == 0:
      print(i)
  return img_split

image_size=(224, 224)
scale = 256.0/224.0
target_resolution = (224,224)
batch_size=128
num_workers=4
path='./waterbirds/'

train_size = 0
val_size = 0
test_size = 0

random_seed = 25

random.seed(random_seed)

csv_path = os.path.join(path,"metadata.csv")
    csvFile = open(csv_path, "r")
    reader = csv.reader(csvFile)
    img_id = []
    img_filename = []
    y = []
    split = []
    place = []
    place_name = []
    result = {}
    for item in reader:
        if reader.line_num == 1:
            continue
        result[item[0]] = item[1:]
        img_id.append(item[0])
        img_filename.append(item[1])
        y.append(int(item[2]))
        split.append(item[3])
        place.append(int(item[4]))
        place_name.append(item[5])

    csvFile.close()

    train_index = np.where(np.array(split) == "0")
    train_index = np.array(train_index).reshape((-1,))
    val_index = np.where(np.array(split) == "1")
    val_index = np.array(val_index).reshape((-1,))
    test_index = np.where(np.array(split) == "2")
    test_index = np.array(test_index).reshape((-1,))

    train_transform = Compose([
          RandomResizedCrop(target_resolution,scale=(0.7, 1.0),ratio=(0.75, 1.3333333333333333),interpolation=2),
          #RandomAffine(degrees=2, translate=(0.02, 0.02), scale=(0.98, 1.02), shear=2, fillcolor=(124,117,104)),
          RandomHorizontalFlip(),
          ToTensor(),
          Normalize([0.485, 0.456, 0.406], [0.229, 0.224, 0.225])
      ])

    test_transform = Compose([
          Resize(target_resolution),
          CenterCrop(target_resolution),
          ToTensor(),
          Normalize([0.485, 0.456, 0.406], [0.229, 0.224, 0.225])
      ])

    random.shuffle(train_index)

    train_img = load_img(path,img_filename,train_index,train_transform)
    train_y = np.array(y)[train_index]
    train_place = np.array(place)[train_index]
    train_label = np.vstack((train_y,train_place))
    train_label_tolist = (train_label.T).tolist()
    train_tensor_x = torch.Tensor(train_img) # transform to torch tensor
    train_tensor_y = torch.Tensor(train_label_tolist)
    train_my_dataset = TensorDataset(train_tensor_x,train_tensor_y)
    train_my_dataloader = DataLoader(train_my_dataset,batch_size=batch_size, num_workers=num_workers,shuffle=False, drop_last=False, pin_memory=True)

val_img = load_img(path,img_filename,np.array(val_index)[val_index_balance],train_transform)

random.shuffle(val_index)
#val_index = train_index[0:val_size]

#val_img = load_img(path,img_filename,val_index,train_transform) 
val_y = np.array(y)[val_index]
val_place = np.array(place)[val_index]
val_label = np.vstack((val_y,val_place))
val_label_tolist = (val_label.T).tolist()
val_index_balance = []
num_00 = 0
num_10 = 0
num_01 = 0
num_11 = 0
for i in range(np.shape(val_label_tolist)[0]):
  if val_label_tolist[i] == [0,0]:
    num_00 = num_00+1
    if num_00<55:
      val_index_balance.append(i)
  if val_label_tolist[i] == [0,1]:
    num_01 = num_01+1
    if num_01<3:
      val_index_balance.append(i)
  if val_label_tolist[i] == [1,0]:
    num_10 = num_10+1
    if num_10<1:
      val_index_balance.append(i)
  if val_label_tolist[i] == [1,1]:
    num_11 = num_11+1
    if num_11<18:
      val_index_balance.append(i)        
val_label_balance = (np.array(val_label_tolist)[val_index_balance]).tolist()
val_img = load_img(path,img_filename,np.array(val_index)[val_index_balance],train_transform)      
val_tensor_x = torch.Tensor(val_img) # transform to torch tensor
val_tensor_y = torch.Tensor(val_label_balance)
#val_my_dataset = TensorDataset(val_tensor_x,val_tensor_y)
val_my_dataloader = DataLoader(val_my_dataset,batch_size=batch_size, num_workers=num_workers,shuffle=False, drop_last=False, pin_memory=True)

val_test_img = load_img(path,img_filename,np.array(val_index)[val_index_balance],test_transform)      
val_test_tensor_x = torch.Tensor(val_test_img) # transform to torch tensor
val_test_tensor_y = torch.Tensor(val_label_balance)
val_test_my_dataset = TensorDataset(val_test_tensor_x,val_test_tensor_y)
val_test_my_dataloader = DataLoader(val_test_my_dataset,batch_size=batch_size, num_workers=num_workers,shuffle=False, drop_last=False, pin_memory=True)

random.shuffle(test_index)
test_y = np.array(y)[test_index]
test_place = np.array(place)[test_index]
test_label = np.vstack((test_y,test_place))
test_label_tolist = (test_label.T).tolist()
test_index_balance = []
num_00 = 0
num_10 = 0
num_01 = 0
num_11 = 0
for i in range(np.shape(test_label_tolist)[0]):
  if test_label_tolist[i] == [0,0]:
    num_00 = num_00+1
    if num_00<201:
      test_index_balance.append(i)
  if test_label_tolist[i] == [0,1]:
    num_01 = num_01+1
    if num_01<201:
      test_index_balance.append(i)
  if test_label_tolist[i] == [1,0]:
    num_10 = num_10+1
    if num_10<201:
      test_index_balance.append(i)
  if test_label_tolist[i] == [1,1]:
    num_11 = num_11+1
    if num_11<201:
      test_index_balance.append(i)        
test_label_balance = (np.array(test_label_tolist)[test_index_balance]).tolist()
test_img = load_img(path,img_filename,np.array(test_index)[test_index_balance],train_transform)      
test_tensor_x = torch.Tensor(test_img) # transform to torch tensor
test_tensor_y = torch.Tensor(test_label_balance)
test_my_dataset = TensorDataset(test_tensor_x,test_tensor_y)
test_my_dataloader = DataLoader(test_my_dataset,batch_size=batch_size, num_workers=num_workers,shuffle=False, drop_last=False, pin_memory=True)

print(test_label_balance.count([0,0]))
print(test_label_balance.count([0,1]))
print(test_label_balance.count([1,0]))
print(test_label_balance.count([1,1]))

!pip install pytorch-ignite

import torch
import torch.nn as nn
import torch.nn.functional as F

import os
import numpy as np
import random
from numpy.lib.scimath import log
import torch
import ignite
from torch._C import dtype

import matplotlib.pyplot as plt
import torchvision.utils as vutils
#from torch.utils.metrics import print_num_params
#from core.trainer import loss_adjust_cross_entropy,cross_entropy, logit_adjust_ly, train_epoch,eval_epoch
import torch.optim as optim
import torch.nn as nn

assert torch.cuda.is_available()
assert torch.backends.cudnn.enabled
torch.backends.cudnn.benchmark = True
device = "cuda"

# Modified from https://raw.githubusercontent.com/pytorch/vision/master/torchvision/models/resnet.py

import torch
import torch.nn as nn
try:
    from torch.hub import load_state_dict_from_url
except ImportError:
    from torch.utils.model_zoo import load_url as load_state_dict_from_url

__all__ = ['ResNet', 'resnet18', 'resnet34', 'resnet50', 'resnet101',
           'resnet152', 'resnext50_32x4d', 'resnext101_32x8d',
           'wide_resnet50_2', 'wide_resnet101_2']


model_urls = {
    'resnet18': 'https://download.pytorch.org/models/resnet18-5c106cde.pth',
    'resnet34': 'https://download.pytorch.org/models/resnet34-333f7ec4.pth',
    'resnet50': 'https://download.pytorch.org/models/resnet50-19c8e357.pth',
    'resnet101': 'https://download.pytorch.org/models/resnet101-5d3b4d8f.pth',
    'resnet152': 'https://download.pytorch.org/models/resnet152-b121ed2d.pth',
    'resnext50_32x4d': 'https://download.pytorch.org/models/resnext50_32x4d-7cdf4587.pth',
    'resnext101_32x8d': 'https://download.pytorch.org/models/resnext101_32x8d-8ba56ff5.pth',
    'wide_resnet50_2': 'https://download.pytorch.org/models/wide_resnet50_2-95faca4d.pth',
    'wide_resnet101_2': 'https://download.pytorch.org/models/wide_resnet101_2-32ee1156.pth',
}


def conv3x3(in_planes, out_planes, stride=1, groups=1, dilation=1):
    """3x3 convolution with padding"""
    return nn.Conv2d(in_planes, out_planes, kernel_size=3, stride=stride,
                     padding=dilation, groups=groups, bias=False, dilation=dilation)


def conv1x1(in_planes, out_planes, stride=1):
    """1x1 convolution"""
    return nn.Conv2d(in_planes, out_planes, kernel_size=1, stride=stride, bias=False)


class BasicBlock(nn.Module):
    expansion = 1

    def __init__(self, inplanes, planes, stride=1, downsample=None, groups=1,
                 base_width=64, dilation=1, norm_layer=None):
        super(BasicBlock, self).__init__()
        if norm_layer is None:
            norm_layer = nn.BatchNorm2d
        if groups != 1 or base_width != 64:
            raise ValueError('BasicBlock only supports groups=1 and base_width=64')
        if dilation > 1:
            raise NotImplementedError("Dilation > 1 not supported in BasicBlock")
        # Both self.conv1 and self.downsample layers downsample the input when stride != 1
        self.conv1 = conv3x3(inplanes, planes, stride)
        self.bn1 = norm_layer(planes)
        self.relu = nn.ReLU(inplace=True)
        self.conv2 = conv3x3(planes, planes)
        self.bn2 = norm_layer(planes)
        self.downsample = downsample
        self.stride = stride

    def forward(self, x):
        identity = x

        out = self.conv1(x)
        out = self.bn1(out)
        out = self.relu(out)

        out = self.conv2(out)
        out = self.bn2(out)

        if self.downsample is not None:
            identity = self.downsample(x)

        out += identity
        out = self.relu(out)

        return out


class Bottleneck(nn.Module):
    expansion = 4

    def __init__(self, inplanes, planes, stride=1, downsample=None, groups=1,
                 base_width=64, dilation=1, norm_layer=None):
        super(Bottleneck, self).__init__()
        if norm_layer is None:
            norm_layer = nn.BatchNorm2d
        width = int(planes * (base_width / 64.)) * groups
        # Both self.conv2 and self.downsample layers downsample the input when stride != 1
        self.conv1 = conv1x1(inplanes, width)
        self.bn1 = norm_layer(width)
        self.conv2 = conv3x3(width, width, stride, groups, dilation)
        self.bn2 = norm_layer(width)
        self.conv3 = conv1x1(width, planes * self.expansion)
        self.bn3 = norm_layer(planes * self.expansion)
        self.relu = nn.ReLU(inplace=True)
        self.downsample = downsample
        self.stride = stride

    def forward(self, x):
        identity = x

        out = self.conv1(x)
        out = self.bn1(out)
        out = self.relu(out)

        out = self.conv2(out)
        out = self.bn2(out)
        out = self.relu(out)

        out = self.conv3(out)
        out = self.bn3(out)

        if self.downsample is not None:
            identity = self.downsample(x)

        out += identity
        out = self.relu(out)

        return out


class ResNet(nn.Module):

    def __init__(self, block, layers, num_classes=1000, zero_init_residual=False,
                 groups=1, width_per_group=64, replace_stride_with_dilation=None,
                 norm_layer=None,
                 layers_to_extract=None):
        super(ResNet, self).__init__()
        if norm_layer is None:
            norm_layer = nn.BatchNorm2d
        self._norm_layer = norm_layer

        self.inplanes = 64
        self.dilation = 1
        if replace_stride_with_dilation is None:
            # each element in the tuple indicates if we should replace
            # the 2x2 stride with a dilated convolution instead
            replace_stride_with_dilation = [False, False, False]
        if len(replace_stride_with_dilation) != 3:
            raise ValueError("replace_stride_with_dilation should be None "
                             "or a 3-element tuple, got {}".format(replace_stride_with_dilation))
        self.groups = groups
        self.base_width = width_per_group
        self.conv1 = nn.Conv2d(3, self.inplanes, kernel_size=7, stride=2, padding=3,
                               bias=False)
        self.bn1 = norm_layer(self.inplanes)
        self.relu = nn.ReLU(inplace=True)
        self.maxpool = nn.MaxPool2d(kernel_size=3, stride=2, padding=1)
        self.layer1 = self._make_layer(block, 64, layers[0])
        self.layer2 = self._make_layer(block, 128, layers[1], stride=2,
                                       dilate=replace_stride_with_dilation[0])
        self.layer3 = self._make_layer(block, 256, layers[2], stride=2,
                                       dilate=replace_stride_with_dilation[1])
        self.layer4 = self._make_layer(block, 512, layers[3], stride=2,
                                       dilate=replace_stride_with_dilation[2])
        self.avgpool = nn.AdaptiveAvgPool2d((1, 1))
        self.fc = nn.Linear(512 * block.expansion, num_classes)

        for m in self.modules():
            if isinstance(m, nn.Conv2d):
                nn.init.kaiming_normal_(m.weight, mode='fan_out', nonlinearity='relu')
            elif isinstance(m, (nn.BatchNorm2d, nn.GroupNorm)):
                nn.init.constant_(m.weight, 1)
                nn.init.constant_(m.bias, 0)

        # Zero-initialize the last BN in each residual branch,
        # so that the residual branch starts with zeros, and each residual block behaves like an identity.
        # This improves the model by 0.2~0.3% according to https://arxiv.org/abs/1706.02677
        if zero_init_residual:
            for m in self.modules():
                if isinstance(m, Bottleneck):
                    nn.init.constant_(m.bn3.weight, 0)
                elif isinstance(m, BasicBlock):
                    nn.init.constant_(m.bn2.weight, 0)

        self.layers_to_extract = layers_to_extract
        assert self.layers_to_extract in [1, 4]

    def _make_layer(self, block, planes, blocks, stride=1, dilate=False):
        norm_layer = self._norm_layer
        downsample = None
        previous_dilation = self.dilation
        if dilate:
            self.dilation *= stride
            stride = 1
        if stride != 1 or self.inplanes != planes * block.expansion:
            downsample = nn.Sequential(
                conv1x1(self.inplanes, planes * block.expansion, stride),
                norm_layer(planes * block.expansion),
            )

        layers = []
        layers.append(block(self.inplanes, planes, stride, downsample, self.groups,
                            self.base_width, previous_dilation, norm_layer))
        self.inplanes = planes * block.expansion
        for _ in range(1, blocks):
            layers.append(block(self.inplanes, planes, groups=self.groups,
                                base_width=self.base_width, dilation=self.dilation,
                                norm_layer=norm_layer))

        return nn.Sequential(*layers)

    def forward(self, x):
        x = self.conv1(x)
        x = self.bn1(x)
        x = self.relu(x)
        x = self.maxpool(x)

        layer1 = self.layer1(x)
        layer2 = self.layer2(layer1)
        layer3 = self.layer3(layer2)
        layer4 = self.layer4(layer3)

        if self.layers_to_extract == 1:
            x = self.avgpool(layer4)
        elif self.layers_to_extract == 4:
            pooled_layer1 = self.avgpool(layer1)
            pooled_layer2 = self.avgpool(layer2)
            pooled_layer3 = self.avgpool(layer3)
            pooled_layer4 = self.avgpool(layer4)
            x = torch.cat((pooled_layer1, pooled_layer2, pooled_layer3, pooled_layer4), 1)

        # print(x.shape)
        x = x.reshape(x.size(0), -1)
        #x = self.fc(x)

        return x


def _resnet(arch, block, layers, pretrained, progress, **kwargs):
    model = ResNet(block, layers, **kwargs)
    if pretrained:
        state_dict = load_state_dict_from_url(model_urls[arch],
                                              progress=progress)
        model.load_state_dict(state_dict)
    return model


def resnet18(pretrained=False, progress=True, **kwargs):
    r"""ResNet-18 model from
    `"Deep Residual Learning for Image Recognition" <https://arxiv.org/pdf/1512.03385.pdf>'_
    Args:
        pretrained (bool): If True, returns a model pre-trained on ImageNet
        progress (bool): If True, displays a progress bar of the download to stderr
    """
    return _resnet('resnet18', BasicBlock, [2, 2, 2, 2], pretrained, progress,
                   **kwargs)

model = resnet18(pretrained=True,layers_to_extract=1)
model.eval()
model = model.cuda()
'''
#progress=True
arch = 'resnet18'
state_dict = load_state_dict_from_url(model_urls[arch],map_location=torch.device('cpu'))
state_dict.pop('fc.weight')
state_dict.pop('fc.bias')
res = model.load_state_dict(state_dict, strict=False)
assert set(res.missing_keys) == set(['fc.weight', 'fc.bias']), 'issue loading pretrained weights'
'''

from tqdm import tqdm

def save_feature(loader,full_dataset,name,random_seed):
    n = len(full_dataset)
    idx_check = np.empty(n)
    last_batch = False
    start_pos = 0  
    with torch.set_grad_enabled(False):

        for i, (x_batch, y) in enumerate(tqdm(loader)):
            x_batch = x_batch.cuda()

            num_in_batch = list(x_batch.shape)[0]
            assert num_in_batch <= batch_size
            if num_in_batch < batch_size:
                assert last_batch == False
                last_batch = True

            end_pos = start_pos + num_in_batch

            features_batch = model(x_batch).data.cpu().numpy()
            if i == 0:
                d = features_batch.shape[1]
                print(f'Extracting {d} features per example')
                features = np.empty((n, d))
                label = np.empty((n, 1))
                g = np.empty((n, 1))
            features[start_pos:end_pos, :] = features_batch
            label[start_pos:end_pos, :] = np.reshape(y[:,0],(-1,1))
            g[start_pos:end_pos, :] = np.reshape(y[:,1],(-1,1))

            # idx_check[start_pos:end_pos] = idx_batch.data.numpy()
            start_pos = end_pos
    output_path = str(random_seed) + '_preds-on_balance' + name + '.mat'
    sio.savemat(output_path, mdict={'features':features,'label':label,'g':g})
    return features,label,g

features,label,g = save_feature(test_my_dataloader,test_my_dataset,'test',random_seed)

features,label,g = save_feature(train_my_dataloader,train_my_dataset,'train',random_seed)

features,label,g = save_feature(val_my_dataloader,val_my_dataset,'validation',random_seed)

features,label,g = save_feature(val_test_my_dataloader,val_my_dataset,'validation(test)',random_seed)