function Kp = Robustify_Finite_Diff_K(K0,A,B,C,Q,Ru,Rv)

max_iter = 10000;
eta = 0.01;
Kp = K0;

[M,N] = size(K0);

sys_ini = ss((A-B*K0),C,(Q+K0'*Ru*K0)^(1/2),0,[]);
HinfNK_ini = hinfnorm(sys_ini,1e-6);


i = 1;
HinfNK_ini_tt = zeros(max_iter,1);
HinfNK_ini_tt(1) = HinfNK_ini;


while (i <= max_iter) && (HinfNK_ini^2>Rv(1,1))
    est_grad_K = zeros(size(Kp));
    
    for m = 1:M
        for n = 1:N
            % finite diff. gradient
            eps_K = zeros(size(Kp));
            eps_K(m,n) = 1e-6*rand(1);
            eps_K_2 = zeros(size(Kp));
            eps_K_2(m,n) = 1e-6*rand(1);
            
            Kpri1 = Kp+eps_K;
            sys_ini_1 = ss((A-B*Kpri1),C,(Q+Kpri1'*Ru*Kpri1)^(1/2),0,[]);
            HinfNK_ini_1 = hinfnorm(sys_ini_1,1e-6);
            
            
            Kpri2 = Kp-eps_K_2;
            sys_ini_2 = ss((A-B*Kpri2),C,(Q+Kpri2'*Ru*Kpri2)^(1/2),0,[]);
            HinfNK_ini_2 = hinfnorm(sys_ini_2,1e-6);
            
            est_grad_K(m,n) = (HinfNK_ini_1-HinfNK_ini_2)./(eps_K(m,n)+eps_K_2(m,n));
        end
    end
    
    
    Kp = Kp - eta*est_grad_K;
    i = i + 1;
    
    if isnan(Kp(1,1)) || isinf(Kp(1,1))
        pause;
    end
    
    sys_ini = ss((A-B*Kp),C,(Q+Kp'*Ru*Kp)^(1/2),0,[]);
    HinfNK_ini_tt(i) = hinfnorm(sys_ini,1e-6);
    
    if (HinfNK_ini_tt(i)<=sqrt(Rv(1,1))*(1-1e-1))
        break;
    end
    
    
    
end

figure
plot(1:i,HinfNK_ini_tt(1:i)./sqrt(Rv(1,1)),'-*','MarkerSize',15,'LineWidth',2);
set(gca,'FontSize', 24,'FontName', 'Times New Roman');
xlabel('Iterations','Interpreter','Latex')
ylabel('$\|\mathcal{T}(K)\|_\infty$','Interpreter','Latex')






