function S = randskewh(n, N)
% Generates random skew Hermitian matrices with normal entries.
% 
% function S = randskewh(n)
% function S = randskewh(n, N)
%
% S is an n-by-n-by-N array where each slice S(:, :, i) for i = 1..N is a
% random skew-Hermitian matrix formed by
%
%   S = (randskew(n, N) + 1i*randsym(n, N))/sqrt(2);
%
% By default, N = 1.
%
% See also: randherm randskew randunitary randrot randsym

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, June 18, 2019.
% Contributors: 
% Change log: 

    if nargin < 2
        N = 1;
    end

    S = (randskew(n, N) + 1i*randsym(n, N))/sqrt(2);

end
