from sswimlib.quantiles import analytic as analytic_quantiles
from sswimlib.utils.enums import STANDARD_KERNEL


def standard_kernel(sequence, kernel_type=STANDARD_KERNEL.RBF, ls=1.0, ns_type=None, meanshift=None):
    """
    General wrapper for all standard lengthscale based Random Fourier Features
    :param sequence:
    :param kernel_type:
    :param ls:
    :param ns_type:
    :param meanshift:
    :return:
    """
    quantiles_lut = {STANDARD_KERNEL.RBF: analytic_quantiles.normal,
                     STANDARD_KERNEL.M12: analytic_quantiles.matern_12,
                     STANDARD_KERNEL.M32: analytic_quantiles.matern_32,
                     STANDARD_KERNEL.M52: analytic_quantiles.matern_52}
    qf = quantiles_lut[kernel_type]
    if ns_type is None:
        S = qf(sequence.points, ls)
        return S.t()
    elif ns_type == "lebesgue_stieltjes":
        S = [qf(sequence.points, ls[i], meanshift[i]) for i in range(len(ls))]
        return [omega.t() for omega in S]
