dataset=$1
suffix=$2
runs=$3
train_splits=$4

outputfolder=results/$dataset/convergence/knn_squaredl2
mkdir -p $outputfolder

cmd="python lib/estimate.py --method knn --features_train matrices/$dataset/train/features_$suffix.npy --labels_train matrices/$dataset/train/labels_$suffix.npy --features_test matrices/$dataset/test/features_$suffix.npy --labels_test matrices/$dataset/test/labels_$suffix.npy -v 1 --output_file $outputfolder/$suffix.csv --train_subsamples $train_splits --subsamples_runs $runs --knn_subtest 2500 --knn_subtrain 2500"

if [ $# -ge 5 ]; then
    i=1
    until [ $i -gt $5 ]
    do
        cmd="$cmd --knn_k $i"
        ((i=i+1))
    done
fi

echo "Running '$cmd'"
$cmd
echo "Done '$cmd'"
