# TSPNet

**TSPNet: Hierarchical Feature Learning via TemporalSemantic Pyramid for Sign Language Translation**

This anonymized version of the repository contains all source codes and scripts in order to run the experiments. Code is based on **fairseq** repository.
Extracted scales of feature data and pretrained models will be released in the final version.

### Rquirements

* [PyTorch](http://pytorch.org/) version >= 1.4.0
* Python version >= 3.6
* For training new models, you'll also need an NVIDIA GPU and [NCCL](https://github.com/NVIDIA/nccl)

### Install from Source

Install the project from source and develop locally:

```bash
cd fairseq
pip install --editable .
```

### Getting Started

#### Training

Step into the `run_scripts` folder and start training the model by:

```bash
SAVE_DIR=CHECKPOINT_PATH bash run_phoenix_pos_embed_sp_test_3lvl.sh
```

This script run the model reported best performance as in the paper. It feeds the feature pyramid with all 3 scales of features (i.e., with windowing widths of 8, 12, 16). Other scripts for training models with 1 and 2 scales of features are also provided, e.g.,

```bash
SPAN=8 SAVE_DIR=CHECKPOINT_PATH bash run_phoenix_pos_embed_sp_test_1lvl.sh
SCALES=8+12 SAVE_DIR=CHECKPOINT_PATH bash run_phoenix_pos_embed_sp_test_2lvl.sh
```

Two varieties of TSPNet models are available. For the purpose of this anonymized version, we include all files required to run the two varieties of models in place. By default, it runs the `TSPNet-Sequential` model, and you can use the files specified below to replace the corresponding ones to run the `TSPNet-Joint` model:

```txt
fairseq/data/sign_language_pair_dataset.JOINT.py
fairseq/models/transformer_from_sign.JOINT.py
```


#### Testing

To validate the model on the testing test, run the testing script with the checkpoints saved from the training step.
Be sure to pass the path to the checkpoint file not the folder to the parameter `CHECKPOINT`.

```bash
CHECKPOINT=CHECKPOINT_FILE_PATH bash test_phoenix_pos_embed_sp_test_3lvl.sh
```

The scripts report multiple performance results where the last line will show the ROUGE-L and BLEU-{n} as in the paper.


