ridge_results = importdata('ridge_wine_modest_nip_3.mat');
bruckner_results = importdata('bruck_wine_modest_nip_3.mat');
bisect_results = importdata('bisect_wine_modest_nip_3.mat');
% gamma_range = linspace(1e-5, 1.0, 20);
nu_range = [1e-4, 1e-3, 1e-2, 1e-1, 1, 10, 100 ,1000];
gamma_range = linspace(1e-3, 0.2, 15);
gamma_num = size(gamma_range, 2);
nu_num = size(nu_range, 2);
ridge_results = reshape(ridge_results, 10, gamma_num, nu_num);
bruckner_results = reshape(bruckner_results, 10, gamma_num);
bisect_results = reshape(bisect_results, 10, gamma_num);
bisect_means = mean(bisect_results, 1);
bruckner_means = mean(bruckner_results, 1);
ridge_means = mean(ridge_results, 1);
ridge_best_means = max(ridge_means, [], 3);

fig = figure(1);
subplot(1,2, 1)
grid on
hold on
plot(gamma_range, ridge_best_means, 'LineStyle', '-', 'color', 'red');
plot(gamma_range, bruckner_means, 'LineStyle',  '--',  'color', 'blue');
plot(gamma_range, bisect_means,'LineStyle', '-.', 'color', '#77AC30');
legend('Ridge Regression', 'Interior Point', 'Bisection SDP')
xlabel('\gamma');
ylabel('MSE');
hold off

%-----

ridge_results = importdata('ridge_wine_severe_nip_3.mat');
bruckner_results = importdata('bruck_wine_severe_nip_3.mat');
bisect_results = importdata('bisect_wine_severe_nip_3.mat');
%gamma_range = linspace(1e-5, 1.0, 20);
gamma_range = linspace(1e-3, 0.2, 15);
nu_range = [1e-4, 1e-3, 1e-2, 1e-1, 1, 10, 100 ,1000];
gamma_num = size(gamma_range, 2);
nu_num = size(nu_range, 2);
ridge_results = reshape(ridge_results, 10, gamma_num, nu_num);
bruckner_results = reshape(bruckner_results, 10, gamma_num);
bisect_results = reshape(bisect_results, 10, gamma_num);
bisect_means = mean(bisect_results, 1);
bruckner_means = mean(bruckner_results, 1);
ridge_means = mean(ridge_results, 1);
ridge_best_means = max(ridge_means, [], 3);

subplot(1,2,2)
hold on
grid on
plot(gamma_range, ridge_best_means, 'LineStyle', '-', 'color', 'red');
plot(gamma_range, bruckner_means, 'LineStyle',  '--',  'color', 'blue');
plot(gamma_range, bisect_means,'LineStyle', '-.', 'color', '#77AC30');
legend('Ridge Regression', 'Interior Point', 'Bisection SDP')
xlabel('\gamma');
ylabel('MSE');
hold off