""" Run benchmarking fleet for distillation """

import time
from typing import List

from autogluon_utils.setup.fleet_config.fleet import Fleet
from autogluon_utils.setup.instance_config.instance_config import InstanceConfig
from autogluon_utils.setup.instance_config.instance_benchmark_config import InstanceBenchmarkConfig
from autogluon_utils.setup.instance_config.distill_config_defaults import distillbenchmark_default
from autogluon_utils.setup.distillbenchmark import config_defaults, prepare_instances
from autogluon_utils.sandbox.kaggle.aws_info import get_isengard_session


# Set session=get_isengard_session() to run true benchmark. Only do this if you know what you are doing.
# You can also change which datasets / autoML predictors are run below.


if __name__ == '__main__':
    # Args to change each run:
    fleet_name = 'gibs_regress_ami'
    user = 'ANONYMOUS'  # Your EC2 alias

    # Full benchmark:  datasets, profiles, predictors = config_defaults.get_full_benchmark()
    datasets_subset = ['Amazon_employee_access', 'Australian', 'blood-transfusion', 'connect-4', 'Covertype', 'Helena', 'higgs', 'Jannis', 'jasmine', 'jungle_chess_2pcs_raw_endgame_complete', 'mfeat-factors', 'MiniBooNE', 'nomao', 'numerai28.6', 'phoneme', 'sylvine', 'vehicle', 'segment', 'Volkert', 'credit-g', 'adult',   'bostonHousing', 'concrete', 'energy', 'kin8nm', 'naval-propulsion-plant', 'power-plant', 'protein-tertiary-structure', 'wine-quality-red', 'yacht']
    profiles_subset = ['PROFILE_4H_CONSTRAINED',]
    methods_subset = ['FIT', 'ALL_METHODS_GIBBS_SOME'] # 'DISTILL_GIBBS_ALL']
    datasets, profiles, methods = (datasets_subset, profiles_subset, methods_subset)
    # datasets, profiles = config_defaults.get_full_benchmark()  # Use to run full benchmark instead of subsets specified above.
    print("Running Distillation benchmark on:")
    print("datasets: ", datasets)
    print("profiles: ", profiles)
    print("methods: ", methods)

    session = None  # TODO!!  Your boto3 session, can either be standard boto3 or isengard
    session = get_isengard_session()  # TODO!!!  uncomment this to actually run (comment out for safety).

    instance_config_default_params = distillbenchmark_default(fleet_name, user)  # Your config defaults, such as instance type, subnet, etc.
    instance_benchmark_configs: List[InstanceBenchmarkConfig] = prepare_instances.get_configs(datasets=datasets,
                                            profiles=profiles, methods=methods, tag=fleet_name)

    # Your benchmark configs, such as run_command and name_suffix
    instance_configs = []
    for config in instance_benchmark_configs:
        instance_config: InstanceConfig = config.construct_instance_config(**instance_config_default_params)
        instance_configs.append(instance_config)

    for config in instance_configs:
        print(config)

    fleet = Fleet(fleet_name=instance_configs[0].fleet_name, instance_config_list=instance_configs, session=session)
    fleet.print_info()
    fleet.create_fleet()  # creates instances on EC2 for every benchmark
    fleet.print_info()
    print('Sleeping for 300 seconds to give time for instances to initialize...')
    time.sleep(300)
    print('Awakening in 5 seconds...')
    time.sleep(5)
    fleet.run_fleet()  # runs instances on EC2 for every benchmark
    fleet.print_info()
    print('Distillation Benchmark Finished Initialization')
