## Installation

### Requirements

- Linux
- Python 3.7
- PyTorch 1.1 (We only test 1.1, but higher version should be fine.)
- CUDA 9.0+
- NCCL 2+
- GCC 4.9+
- [mmcv](https://github.com/open-mmlab/mmcv)

### Install mmdetection

a. Create a conda virtual environment and activate it. Then install Cython.

```shell
conda create -n reppointsv2 python=3.7 -y
source activate reppointsv2

conda install cython -y
```

b. Install PyTorch. If your CUDA version is not 9.0, please change it to your version.

```shell
conda install pytorch==1.1.0 torchvision==0.3.0 cudatoolkit=9.0 -c pytorch -y
```

c. Install reppoints v2.

```shell
cd path_to_reppoints_v2
# Command `python setup.py build develop` may throw some errors.
# Run this command multiple times could solve this problem.
python setup.py build develop
conda install 'numpy==1.17.4' -y
```

### Prepare COCO dataset.

It is recommended to symlink the dataset root to `$MMDETECTION/data`.

```
mmdetection
├── mmdet
├── tools
├── configs
├── data
│   ├── coco
│   │   ├── annotations
│   │   ├── train2017
│   │   ├── val2017
│   │   ├── test2017
```