# function for generating treatment level exposure by combining base level exposure with boostfactors
GetTreatmentLevelExposure <- function(modelParameters, GetBoostFactors = function(producer, consumer) return(rep(1, length(producer)))){
  exposure <- modelParameters %>% 
    mutate(boostFactors = GetBoostFactors(producer, consumer), treatmentLevelExposure = baseLevelExposure * boostFactors) %>%
    group_by(consumer) %>% mutate(treatmentLevelExposure = treatmentLevelExposure / sum(treatmentLevelExposure)) %>% ungroup()
  return(exposure)
}