GetClusterExperiment <- function(networkWithTreatments,treatmentSet, experimentId, outputPath, seed = sample.int(10000, 1)){
  set.seed(seed * experimentId)
  consumerSet <- unique(networkWithTreatments$consumer)
  producerSet <- unique(networkWithTreatments$producer)
  
  nTreatments <- length(treatmentSet)
  nConsumers <- length(consumerSet)
  nProducers <- length(producerSet)
  
  cat(paste0("Getting design for cluster based experiment ", experimentId, " with ", nTreatments, " treatments, ", 
             nProducers, " producers, ", nConsumers, " consumers and ", nrow(networkWithTreatments), " connections \n"))
  
  consumerDF <- tibble(consumer = consumerSet, consumerInTreatment = rep(0, length(consumerSet)))
  chosenClusterId <- sample.int(nClusters, length(treatmentSet))
  for (i in 1:length(treatmentSet)) {
    idx <- (clusterSize * (chosenClusterId[i] - 1) + 1):(clusterSize * chosenClusterId[i])
    consumerDF$consumerInTreatment[idx] <- i
  }
  
  producerDF <- consumerDF %>% rename(producer = consumer, producerInTreatment = consumerInTreatment)
  producerDF$producerInTreatment[which(producerDF$producerInTreatment == 0)] <- NA
  treatmentAssignment <- networkWithTreatments %>% group_by(consumer) %>% left_join(consumerDF, by = "consumer") %>% 
    ungroup() %>% group_by(producer) %>% left_join(producerDF, by = "producer") %>% ungroup()
  fullDesign <- split(treatmentAssignment, treatmentAssignment$consumerInTreatment)
  fullDesign <- do.call("rbind", lapply(1:length(fullDesign), 
                                        function(i) fullDesign[[i]] %>% mutate(experimentLevelExposure = 
                                                                       unlist(fullDesign[[i]][, c("baseLevelExposure", treatmentSet)[i]]))))
                    
                      
  fullDesign <- fullDesign %>% 
    select(consumer, producer, edgeStrength, producerInTreatment, consumerInTreatment, baseLevelExposure, experimentLevelExposure) %>% 
    filter(!is.na(producerInTreatment) | (consumerInTreatment > 0))
  fileName <- paste0(outputPath, "clusterDesign_ID=", experimentId, ".Rdata")
  save(fullDesign, file = fileName)
  return(fileName)
  
}