%%
% Fig 20 in Sec C.5
% Showing that even there may be a invariant distribution in each potential
% well, the expression for Prop 10 and Rmk 14 still stands when eps->0 and
% then eta->0.
% Please change eta to get each subfigure



%%
k=5;        % parameter in f_0
eta=0.02;
epsilon=0.00001;    % eps need to be adjust to keep eps<<eta
f_0=@(x)k*(x.^2-1).^2;
f_1=@(x)epsilon*sin(x/epsilon);
f=@(x)f_0(x)+f_1(x);
grad_0=@(x)k*4*x.*(x.^2-1); % gradient of f_0
grad_1=@(x)cos(x/epsilon);          % gradient of f_1,eps

pdf=@(x)exp(-16*k*(x-1).^2);% theoretical density in the right potential well (after rescaling by sqrt(eta))
int_pdf=integral(pdf,-inf,inf); % for normalization

pts_init=1.2:0.00001:1.3;   % distribution of initial ensemble
pts=pts_init;
MAX=10000;                  % number of steps for evolving the ensemble
%% evolving
for i=1:MAX
    pts=pts-eta*grad_0(pts)-eta*grad_1(pts);
end
%% plot the result
xbins=0.4:0.01:1.6;
histogram(1+(pts-1)/sqrt(eta),xbins,'Normalization','pdf'); % histogram is also rescaled by sqrt(eta)
hold on;
plot(xbins,pdf(xbins)/int_pdf); % theoretial pdf
set(gca,'FontSize',16);
xlabel('x')
ylabel('Density');
ylim([0,6]);
set(gcf,'Position',[400 300 800 600]);