%%
% Fig 15 in Sec C.3.3
% Dependence of Lyap Exp on eta in 2-dim
% f_0 is Matyas function and f_1 is periodic, same as that in C.2
% f_0 is Matyas function
% f_1,eps is periodic
%%
epsilon=0.0001; % fixed epsilon
MAX=10000;      % number of steps for iteration then estimating Lyap exp

f_0=@(x)0.26*(x(1,:).^2+x(2,:).^2)+0.48*x(2,:).*x(1,:); % Matyas function
f_1=@(x)epsilon*(sin(x(1,:)/epsilon)+cos(x(2,:)/epsilon));

x=[0.5;0.5];
H=[0.52,0.48;0.48,0.52];    % Hessian matrix of Matyas function
eta_range=0.002:0.001:0.1;  % range of eta to be tested
memory=zeros(1,length(eta_range));
%%
for j=1:length(eta_range)
    eta=eta_range(j);
    lnL=0;
    for i=1:MAX
        % evolving
        x=x-eta*[0.52*x(1)+0.48*x(2)+cos(x(1)/epsilon);0.52*x(2)+0.48*x(1)-sin(x(2)/epsilon)];
        % calsulte the sum of ln(phi'')
        lnL=lnL+log(norm((H+[sin(x(1)/epsilon)/epsilon,0;0,cos(x(2)/epsilon)/epsilon])*eta,2));
    end
    memory(j)=lnL/MAX;  % This is Lyap exp
end
%% plot the result
figure
plot(eta_range,memory)
xlabel('\eta')
ylabel('Lyap Exp')
set(gca,'FontSize',16);
set(gcf,'Position',[400 300 800 600]);

figure
plot(eta_range,memory-log(eta_range/epsilon))
xlabel('\eta')
ylabel('Lyap Exp-ln(\eta/\epsilon)')
set(gca,'FontSize',16);
set(gcf,'Position',[400 300 800 600]);