import os
os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
os.environ["CUDA_VISIBLE_DEVICES"] = ""
os.environ['KERAS_BACKEND'] = 'tensorflow'

import numpy as np
from PIL import Image
import tensorflow as tf
import keras
import skimage.exposure

import opts as opt
from dataset import Dataset
from pair_model import Pair_Model

if __name__ == "__main__":
    for dataset in ["train", "test1", "test2", "test3", "test4"]:
        layers = ["conv1_1", "conv2_1", "conv3_1", "conv4_1", "conv5_1"]
        datapath = "./COOS7_images/" + dataset + "/"

        for layer in layers:
            print ("Loading the model...")
            model = Pair_Model().create_model((opt.im_h, opt.im_w, 2), (opt.im_h, opt.im_w, 1))
            model.load_weights(opt.checkpoint_path + "model_weights_30.h5")
            intermediate_model = tf.keras.Model(inputs=model.get_layer("x_in").input,
                                            outputs=model.get_layer(layer).output)

            print ("Evaluating images...")
            for dir in os.listdir(datapath):
                for image in os.listdir(datapath + dir):
                    if "_protein.tif" in image:
                        print ("Evaluating", image)
                        name = image.rsplit("_", 1)[0]
                        gfp = np.array(Image.open(datapath + dir + "/" + image)).astype(np.float32)
                        rfp = np.array(Image.open(datapath + dir + "/" + image.replace("_protein", "_nucleus"))).astype(np.float32)

                        gfp = skimage.exposure.rescale_intensity(gfp, out_range=(0, 1))
                        rfp = skimage.exposure.rescale_intensity(rfp, out_range=(0, 1))
   
                        x_in = np.stack((gfp, rfp), axis=-1)
                        x_in = np.expand_dims(x_in, axis=0)

                        prediction = intermediate_model.predict([x_in], batch_size=1)

                        prediction = np.squeeze(prediction)
                        prediction = np.max(prediction, axis=(0, 1))

                        if not os.path.exists ("./COOS7_self_supervised_features/" + layer + "/"):
                            os.makedirs("./COOS7_self_supervised_features/" + layer + "/")

                        outputfile = "./COOS7_self_supervised_features/" + layer + "/" + dataset + ".txt"
                        output = open(outputfile, "a")
                        output.write(dir)
                        output.write("\t")
                        output.write(name)
                        output.write("\t")
                        for feat in prediction:
                            output.write(str(feat))
                            output.write("\t")
                        output.write("\n")
                        output.close()
