# Computing Full Conformal Prediction Set with Approximate Homotopy.

This package implements a computation of conformal prediction set based on approximate solution of empirical risk minimization when the input observations changes sequentially. We develop a new homotopy continuation technique so that only a finite number of computation are needed to approximate infinitely many solution on a given interval [ymin, ymax].

## Installation & Requirements

This package has the following requirements:

- [numpy](http://numpy.org)
- [scipy](http://scipy.org)
- [scikit-learn](http://scikit-learn.org)
- [python-intervals](https://pypi.org/project/python-intervals/)

We recommend to install or update anaconda to the latest version and use Python 3.

## Reproducibility

- Figure 1 is generated by visualization_ridge_conf.py
- Table 1: the left figure is generated by bench_homotopy_time.py and the right figure by benchmark.py with (method = "lasso", dataset = "climate", alpha = 0.1)
- Figure 2 is generated by benchmark.py with the range of coverage level alphas = np.arange(1, 10) / 10. The figure (a) corresponds to (method = "lasso", dataset = "diabetes") and the figure (b) corresponds to (method = "logcosh", dataset = "boston").
- Table 2 is generated with alpha = 0.1 by benchmark.py with (method = "logcosh", dataset = "boston") and (method = "linex", dataset = "diabetes").


