import os
import sys


def append_sys_path():
    root = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

    xrl = os.path.join(root, 'build', 'xrl')
    if xrl not in sys.path:
        sys.path.append(xrl)

    xrl_py = os.path.join(root, 'xrl')
    if xrl_py not in sys.path:
        sys.path.append(xrl_py)

    minirts = os.path.join(root, 'build', 'game')
    if minirts not in sys.path:
        sys.path.append(minirts)

    script = os.path.join(root, 'scripts')
    if script not in sys.path:
        sys.path.append(script)


executor_root = '/private/home/hengyuan/minirts/scripts/behavior_clone/sweep_executor'
best_rnn_executor = os.path.join(
    executor_root, 'model_rnn14_dset3_p5/aod256_cd0.1_pd32_s1', 'best_checkpoint.pt')
best_rnn_nohist_executor = os.path.join(
    executor_root, 'model_rnn14_dset3_p5_2/aod256_uhi0_pd32_s9', 'best_checkpoint.pt')
best_bow_executor = os.path.join(
    executor_root, 'model_bow14_dset3_p5/wed0.25_ihd256_pd16_s1', 'best_checkpoint.pt')
best_zero_executor = os.path.join(
    executor_root, 'model_zero14_dset3_p5/pr1_s3', 'best_checkpoint.pt')


coach_root = '/private/home/hengyuan/minirts/scripts/behavior_clone/sweep_coach'
best_rnn_coach = os.path.join(
    coach_root,
    'coach_rnn10/pcd128_chd128_aod128_chd256_chl2_wed0.25_gd0.5_s9',
    'best_checkpoint.pt')
best_rnn_coach_nofow = os.path.join(
    coach_root,
    'coach_rnn20_nofow_fix_dict',
    'best_checkpoint.pt')


if __name__ == '__main__':
    # import env for testing
    append_sys_path()
    import torch
    import xrl
    import pyxrl
    import minirts
    import behavior_clone
