"""
Following of this script is to make experiments in order to plot a ROC curves.
More precisely a graph:
Grapĥ to show the influence of rho_noise.
"""

import numpy as np
from sklearn.utils import check_random_state

from sgcl.utils import get_sigma_min
from data.artificial import get_data_me

##########################################################################
# name of the expe
name_expe = "expe3"
rng = check_random_state(42)
n_repet_roc_curves = 1

name_dir_raw_res = "raw_results"
# parameters of the problems
# dictionary_type = 'real_me'
dictionary_type = 'Toeplitz'
# list_rho_X = [0.01]
list_rho_X = [0.6]
n_channels = 150
n_times = 100
# n_epochs = 50
n_sources = 500
n_active = 30

noise_type = "Gaussian_multivariate"
# list_SNR = np.arange(1, 0.01, 0.1)
# list_SNR = np.geomspace(1, 0.01, 20)
# list_SNR = np.geomspace(1, 0.0001, 20)
list_SNR = [0.03]
# list_SNR = [0.01, 0.1, 0.5, 1, 2, 5]
# rho_noise = 0.01
list_rho_noise = np.arange(0, 11) / 10
# list_rho_noise =[1.]
list_n_epochs = [20]
# list_n_epochs = [50]

# parameters of the solver SGCL
tol = 1e-2
n_iter = 10 ** 4  # maximum number of iterations
active_set_freq = 15
S_freq = 1

# n_points_roc_auc = 10

# list_pb_name = ["CLaR", "SGCL", "MTL"]
list_pb_name = ["CLaR", "SGCL", "MLER", "MLE", "MRCER", "MTL"]
# list_pb_name = ["CLaR", "SGCL", "MLER", "MLE", "MRCER", "MRCE", "MTLME", "MTL"]
# list_pb_name = ["CLaR", "SGCL", "MTLME", "MTL"]
# list_pb_name = ["MTL"]

n_points_roc_auc = 160
# parameters of the
list_p_alpha = np.geomspace(1, 0.3, n_points_roc_auc)

dict_list_p_alpha = {}
dict_list_p_alpha["CLaR"] = np.geomspace(1, 0.3, n_points_roc_auc)
dict_list_p_alpha["SGCL"] = np.geomspace(1, 0.5, n_points_roc_auc)
dict_list_p_alpha["MLE"] = np.geomspace(1, 0.3, n_points_roc_auc)
dict_list_p_alpha["MLER"] = np.geomspace(1, 0.2, n_points_roc_auc)
dict_list_p_alpha["MRCE"] = np.geomspace(1, 0.5, n_points_roc_auc)
dict_list_p_alpha["MRCER"] = np.geomspace(1, 0.25, n_points_roc_auc)
dict_list_p_alpha["MTLME"] = np.geomspace(1, 0.2, n_points_roc_auc)
dict_list_p_alpha["MTL"] = np.geomspace(1, 0.05, n_points_roc_auc)

dict_tol = {}
dict_tol["CLaR"] = 10 ** -3
dict_tol["SGCL"] = 10 ** -3
dict_tol["MLER"] = 10 ** -3
dict_tol["MLE"] = 10 ** -3
dict_tol["MRCE"] = 10 ** -3
dict_tol["MRCER"] = 10 ** -3
dict_tol["MTLME"] = 10 ** -3
dict_tol["MTL"] = 10 ** -3


dict_gap_freq = {}
dict_gap_freq["CLaR"] = 30
dict_gap_freq["SGCL"] = 30
dict_gap_freq["MLER"] = 30
dict_gap_freq["MLE"] = 30
dict_gap_freq["MRCE"] = 30
dict_gap_freq["MRCER"] = 30
dict_gap_freq["MTLME"] = 30
dict_gap_freq["MTL"] = 30

n_jobs = len(list_pb_name) * len(list_rho_X) * len(list_SNR) * \
            len(list_rho_noise) * n_repet_roc_curves
print("n_jobs = ", n_jobs)
