Supplemental Materials
======================
# Overview
This codebase contains implementations for "Chirality Nets for Human Pose Regression".

- Chiral layers are implemented under ```pose_chiral/chiral_layers```.
- A tutorial on chirality equivaraince is under ```demo/```.
- Test cases are implemented under ```tests/```.

Submitted to 33rd Conference on Neural Information Processing Systems (NeurIPS 2019). Do not distribute.

# Dependencies
- Python 3+
- Pytorch >= 1.0
- unittest

# How to run tests
Run the following in the ```supp_code``` directory.
~~~
nosetests --nocapture
~~~

# Expected results.
```console
Tests batchnorm equivariance at test time.
Difference expected chiral pairs: 0.0

.Tests batchnorm running mean and var updates.
.Test equivariance for conv1d layer, different in/out sym_group.
Difference expected chiral pairs: 1.1701751e-13

.Test equivariance for conv1d layer, sym_group [1,1,1].
Difference expected chiral pairs: 6.711298e-14

.Test equivariance for conv1d layer, sym_group [2,2,1].
Difference expected chiral pairs: 2.1044277e-13

.Tests equivariance on linear layer.
Difference expected chiral pairs: 0.0

.Tests equivariance of GRU.
Difference expected chiral pairs: 2.6402491e-15

.Tests equivariance of LSTM.
Difference expected chiral pairs: 3.608225e-15

.
----------------------------------------------------------------------
Ran 8 tests in 0.225s

OK
```
