function df = get_basis(x,y,z,x_vis)
% precalculate basis matrices

% hyperparameters
SJ=1; SK=1; rJ=4; rK=4;

[x1, x2, y1, y2, z1, z2]=split(x,y,z,.5);

p1=x1(:,1);
t1=x1(:,2);
s1=x1(:,3);

p2=x2(:,1);
t2=x2(:,2);
s2=x2(:,3);

ptest=x_vis(:,1);
ttest=x_vis(:,2);
stest=x_vis(:,3);

df.y1=y1;
df.y2=y2;
df.y=y;

df.X1=[bsplinemat(p1,SJ,rJ) bsplinemat(t1,SJ,rJ) bsplinemat(s1,SJ,rJ)];
df.X2=[bsplinemat(p2,SJ,rJ) bsplinemat(t2,SJ,rJ) bsplinemat(s2,SJ,rJ)];
df.X_vis=[bsplinemat(ptest,SJ,rJ) bsplinemat(ttest,SJ,rJ) bsplinemat(stest,SJ,rJ)];

df.Z1=bsplinemat(z1,SK,rK);
df.Z2=bsplinemat(z2,SK,rK);

end

