clear;
addpath('../aux'); %test;
addpath('../figures');
addpath('../results'); %test;

design='NP'; %NP, SSG, HLLT
[f,sim,x_vis,f_vis]=get_design(design);

% sample size
N=1000;

% simulate data, split into stage 1 and 2 samples
rng('default');
[x,y,z]=sim(f,N);

%% kernel smooth

csvwrite('df_in.csv',[x y z]);
csvwrite('df_vis.csv',x_vis);

% run R script to obtain y_vis
bash_script = fullfile(pwd,'kernelsmoothIV_pred.sh'); 
system(bash_script);
y_vis=csvread('df_out.csv',1,1);

% visualize estimator
plot(x_vis,f_vis,'LineWidth',5);
hold on;
scatter(x,y,36,[.5 .5 .5]);
plot(x_vis,y_vis,'--r','LineWidth',5);
xlabel('x','FontSize',20)
ylabel('y','FontSize',20)
legend({'Structural function','Data','SmoothIV'},'Location','southeast','FontSize',20);
hold off;
saveas(gcf,fullfile('../figures',strcat('kernelsmoothIV_',design)),'epsc');