library(np)
library(tictoc)

df<-read.csv("df_in.csv",sep=",",header=FALSE)
names(df)<-c('x','y','z')

df <- df[order(df$x),]

x<-df[[1]]
y<-df[[2]]
z<-df[[3]]

x_vis<-as.matrix(read.csv("df_vis.csv",sep=",",header=FALSE))

#tic('kernel smoothing IV')
model.iv <- npregiv(y=y,
                    z=x,
                    w=z,
                    x=NULL,
                    zeval=x_vis, #comment out for x
                    xeval=NULL,
                    method="Tikhonov") #p=1 by default, which gives better performance than p=0
#toc()

y_vis <- model.iv$phi.eval

plot(x_vis,y_vis)

write.csv(y_vis,file = "df_out.csv")