clear;
addpath('../aux'); %test;
addpath('../figures');
addpath('../results'); %test;

design='HLLT'; %NP, HLLT
[f,sim,x_vis,f_vis]=get_design(design);

% sample size
N=5000;

% simulate data, split into stage 1 and 2 samples
rng('default');
rho=0.5;
[x,y,z]=sim(f,N,rho);

%% deep

csvwrite('df_in.csv',[x y z]);
csvwrite('df_vis.csv',x_vis);

% run python script to obtain y_vis
python('deepIV_pred.py');
y_vis_biased=csvread('df_out_biased.csv');
y_vis_unbiased=csvread('df_out_unbiased.csv');

disp('mse biased:'); %default training setting for deep IV
disp(mse(y_vis_biased,f_vis));
disp('mse unbiased:'); %better for low-dim domain
disp(mse(y_vis_unbiased,f_vis));