library("rjson")
library("rstudioapi")
library("ggpubr")
library("tidyverse")

current_path = rstudioapi::getActiveDocumentContext()$path 
setwd(dirname(current_path))

files <- list.files("./simplex")

frame <- data.frame(name=c(), epsilon=c(), value=c(), time=c(), algo=c(),
                    dimensions=c(), points=c(), searches=c(), newdim=c(), method=c())
frame2 <- data.frame(name=c(), value=c(), value_rp=c(), time=c(), method=c(), eps=c())
for (file in files) {
  print(file)
  json_data <- fromJSON(file=paste(getwd(), "/simplex/", file, sep=""))
  json_data_frame <- as.data.frame(json_data)

  datanames <- paste(json_data_frame[1, "data.names"], json_data_frame[2, "data.names"])
  eps <- json_data_frame[1, "data.epsilon"]
  methodtime <- json_data_frame[1, "data.methodtime"]
  method <- json_data_frame[1, "data.method"]
  number_points <- c(json_data_frame[1, "data.lengths"], json_data_frame[2, "data.lengths"])
  number_dimensions <- c(json_data_frame[1, "data.dimensions"], json_data_frame[2, "data.dimensions"])
  values <- list(json_data_frame[1, "rp.value"],
                 json_data_frame[1, "nrp.value"])
  times_searches <- list(json_data_frame[1, "rp.rt_s"],
                         json_data_frame[1, "nrp.rt_s"])
  times_bounds <- list(json_data_frame[1, "rp.rt_b"],
                       json_data_frame[1, "nrp.rt_b"])
  number_searches <- list(json_data_frame[1, "rp.n_s"],
                          json_data_frame[1, "nrp.n_s"])
  newdim <- ceiling(2 * 1/(eps*eps) * log(number_points[[1]]+number_points[[2]]))
  #data <- list(datanames, values, times_searches, number_searches, times_bounds, eps)
  key <- paste(datanames, eps)
  print(paste("found data:", key))
  #frame <- rbind(frame, data.frame(name=datanames, eps=0, value=values[[1]],
  #                                 value_rp=values[[2]], time_s=times_searches[[1]]/60,
  #                                 time_b=times_bounds[[1]]/60,
  #                                 searches=number_searches[[1]],
  #                                 algo="parallel",
  #                                 dimensions=number_dimensions,
  #                                 points=number_points, newdim=number_dimensions[[1]]))
  frame <- rbind(frame, data.frame(name=datanames, eps=eps, value=values[[2]],
                                   value_rp=values[[1]], time_s=times_searches[[2]]/60,
                                   time_b=times_bounds[[2]]/60,
                                   searches=number_searches[[2]],
                                   algo="parallel_rp",
                                   dimensions=number_dimensions,
                                   points=number_points, newdim=newdim, method=method))
  frame2 <- rbind(frame2, data.frame(name=datanames, value=values[[2]], value_rp=values[[1]],
                                     time=methodtime, method=method, eps=eps, newdim=newdim))
}

data <- frame2 %>% 
  group_by_at(vars(method, eps)) %>%
  mutate(epsilon=paste(eps, " (", newdim, ")", sep="")) %>%
  mutate(deviation=abs(1-value/value_rp)) #%>%
  #filter(method == "jl")

count <- data %>%
  summarise(n = n())

dataj <- data %>% filter(method == "jl")
datap <- data %>% filter(method =="pca")

ggplot(data, aes(deviation, time, color=method, shape=epsilon)) +
  #labs(subtitle = "PCA vs. JL") +
  theme(legend.position = c(0.72, 0.695), 
        legend.background = element_rect(fill=alpha('blue', 0.0))) +
  scale_x_continuous(name = "empirical relative error") +
  scale_y_continuous(name = "running-time [s]") +
  #scale_fill_brewer(palette = "Set1") +
  geom_point(size=3, alpha=0.75) + 
  #geom_point(data=datap, aes(deviation, time, color=factor(epsilon)), shape = 24) +
  theme(text = element_text(size=20)) +
  scale_shape_discrete(name="input epsilon (corr. #dimensions)")


#ggarrange(pv12, pv13, pv14, pv24, pv25, pv26,
#          pv36, pv45, pvs, ncol = 3, nrow = 3, common.legend = TRUE)
