  library("rjson")
  library("rstudioapi")
  library("ggpubr")
  library("tidyverse")
  
  current_path = rstudioapi::getActiveDocumentContext()$path 
  setwd(dirname(current_path))
  files <- list.files("./additive")
  
  frame <- data.frame(eps=c(), value=c(), dimensions=c(), gamma=c())
  
  for (file in files) {
    print(file)
    json_data <- fromJSON(file=paste(getwd(), "/additive/", file, sep=""))
    json_data_frame <- as.data.frame(json_data)
    
    eps <- json_data_frame[1, "data.epsilon"]
    gamma <- json_data_frame[1, "data.gamma"]
    dimensions <- json_data_frame[1, "data.dimensions"]
    value <- json_data_frame[1, "rp.value"]
    
    frame <- rbind(frame, data.frame(eps=eps,value=value,dimensions=dimensions[[1]],gamma=gamma))
  }
  
  realvalue = sqrt(5)
  
  data <- frame %>%
    group_by_at(vars(eps, gamma)) %>%
    mutate(hasadditive=abs(realvalue-value)-eps*realvalue > 0)
  
  data_a <- data %>%
    filter(hasadditive == T)
  
  data_a2 <- data_a %>% filter(value > 0)
  
  count <- data %>%
    summarise(n = n())
  
  count_a <- data_a %>%
    summarise(m = n())
  
  count_add <- count %>% 
    left_join(count_a)
  
  count_add[is.na(count_add)] <- 0
  
  data2 <- data %>%
    left_join(count) %>%
    left_join(count_a) %>%
    mutate(additive = realvalue/value-1) %>%
    mutate(slack = abs(realvalue-value)-eps*realvalue) %>%
    mutate(epsilon = paste(eps, " (", dimensions, ")", sep = ""))
  
  ggplot(data2, aes(factor(gamma), additive)) + 
    scale_x_discrete(name="alpha") +
    scale_y_continuous(name="empirical relative error") +
    geom_boxplot(aes(color = factor(epsilon)), outlier.alpha=0.5) +
    scale_color_discrete(name="input epsilon (corr. #dimensions)") +
    theme(legend.position = c(0.275, 0.75), 
          legend.background = element_rect(fill=alpha('blue', 0.0))) +
    theme(text = element_text(size=20), axis.text.x = element_text(angle=45, hjust = 1))

  
  #ggplot(count_add, aes(factor(gamma), m/n)) + 
  #  #ggtitle(paste("Distortion")) +
  #  geom_boxplot(aes(color=factor(eps))) +
  #  scale_x_discrete(name="alpha") + 
  #  scale_y_continuous(limits=c(0,1), name="measured probability of additive error") +
  #  scale_color_discrete(name = "input epsilon") +
  #  theme(legend.position = c(0.1, 0.75))