import calc_frechet
import numpy as np
import pandas as pd
import sys
import json
import time
from sklearn import random_projection

if len(sys.argv) < 2:
	epsilon = 0.4
	
else:
	epsilon = float(sys.argv[1])

data1 = np.random.dirichlet((1,) * 6001, 2205) * 1e7
data2 = np.random.dirichlet((1,) * 6001, 2205) * 1e7

data1 = np.delete(data1, data1.shape[len(data1.shape)-1]-1, 1)
data2 = np.delete(data2, data2.shape[len(data2.shape)-1]-1, 1)

d1 = calc_frechet.Curve(data1)
d2 = calc_frechet.Curve(data2)

d = calc_frechet.Curves()

d.add(d1)
d.add(d2)

start = time.clock()

drp = calc_frechet.jl_transform(d, epsilon)

end = time.clock()


distance_rp = calc_frechet.calculate_distance_parallel(drp[0], drp[1])
distance = calc_frechet.calculate_distance_parallel(d[0], d[1])

dump = {
	'data': {
        'method': 'jl',
        'methodtime': end-start,
		'names': ["random simplex", "random simplex"],
		'lengths': [data1.shape[0], data2.shape[0]],
		'dimensions': [data1.shape[1], data2.shape[1]],
		'epsilon': epsilon,
	},
	'rp': {
			'rt_b': distance_rp.time_bounds,
			'rt_s': distance_rp.time_searches,
			'n_s': distance_rp.number_searches,
			'value': distance_rp.value,
    },
    'nrp': {
			'rt_b': distance.time_bounds,
			'rt_s': distance.time_searches,
			'n_s': distance.number_searches,
			'value': distance.value,
    },
}

print(json.dumps(dump))
