import calc_frechet
import numpy as np
import pandas as pd
import sys
import os
import json

if len(sys.argv) < 2:
	epsilon1 = 0.75
else:
	epsilon1 = float(sys.argv[1])

def import_from_txt(path):
    data = pd.read_csv(path, sep=" ", header=None)
    return data

#Import the data

files = os.listdir("../data/ghg_data")

T = calc_frechet.Curves()

for f in files:
	data = import_from_txt("../data/ghg_data/{}".format(f))
	data_np = np.array(data.values, dtype="d")
	t = calc_frechet.Curve(data_np)
	T.add(t)
	
T_rp = calc_frechet.jl_transform(T, epsilon1)
result_rp = calc_frechet.onemedian_exhaustive(T_rp)

dump = {
	'method': 'exact_wrp',
	'data': {
		'name': "ghg_data",
		'lengths': T[0].points,
		'dimension': T[0].dimensions,
		'epsilon1': epsilon1,
		'epsilon2': 0,
	},
	'without_rp': { 
		'value': result_rp.value,
		'centers': result_rp[0],
		'running-time': result_rp.running_time,
	},
	'with_rp': { 
		'value': result_rp.value,
		'centers': result_rp[0],
		'running-time': result_rp.running_time,
	},
}

print(json.dumps(dump))
