numRuns = 1000;
numSamples = 10:10:200;

stringTime = "171030_121354";

for mazeId = 1 : 1
    trueV = importdata("../mazes/"+mazeId+".V.txt");

    V = zeros(size(numSamples, 2), numRuns);
    for i = 1 : size(numSamples, 2)
        V(i,:) = importdata("maze"+mazeId+"."+stringTime+"_"+num2str(i*10)+".v.txt");
    end

    undPr = sum(V < (trueV(1) - 1e-8), 2) / numRuns;
    figure
    plot(numSamples, undPr)
    xlabel("#observations per state-action")
    ylabel("probability of underestimation")
end
