#ifndef HEADER_ALG
#define HEADER_ALG

#include <vector>
#include <eigen3/Eigen/Core>

#include "optimistic.h"

typedef std::vector<double> Data;

class AllocAlgorithm {
  public:
  AllocAlgorithm(uint64_t n, Eigen::MatrixXf nu, double B) {
    this->n = n;
    this->nu = nu;
    this->B = B;

    int K = nu.rows();
    int D = nu.cols();
    /* compute the value of \sqrt{\beta} */
    float delta = 1.0 / (n * K);
    float log_factor = log(3*n/delta) + D*(log(4.0) + 4.0 * log(n) + 2.0 * log(D));
    root_beta = 1 + 3*sqrt((log(2.0) + log_factor + log(log_factor)));
    alpha = (log_factor + log(log_factor) + log(2.0)) / B;

  }

  uint64_t n;
  double B;
  double root_beta;
  double alpha;
  Eigen::MatrixXf nu;

  void alloc_alg(std::vector<Data> &datas, bool gamma_fixed);
  
  private:

  float expected_reward(Eigen::MatrixXf &nu, Eigen::MatrixXf &M);
  int bernoulli(float p);


  OptimismHandler opt_handler;
  std::default_random_engine gen;
};


#endif
