/********************************************************************
A very simple thread pool for easily multi-threading simulations
********************************************************************/


#ifndef HEADER_POOL
#define HEADER_POOL

#include <queue>
#include <functional>
#include <string>
#include <vector>
#include <thread>
#include <iostream>
#include <functional>
#include <chrono>
#include <future>

template<class T> class Pool {
  public:
  unsigned int max_threads;

  Pool(unsigned int max_threads) {
    this->max_threads = max_threads;
  }

  void push(std::function<T()> job) {
    jobs.push(job);
  }

  std::vector<T> run();

  std::queue<std::function<T()>> jobs;
};

template<class T>
std::vector<T> Pool<T>::run() { 
  std::vector<std::future<T>> threads;
  std::vector<T> data;

  std::cout << "running pool with " << jobs.size() << " jobs\n";

  int running = 0;
  
  while (jobs.size() > 0) {
    if (threads.size() < max_threads) {
      running++;
      auto job = jobs.front();
      std::cout << "starting job " << running << "\n";
      jobs.pop();
      threads.push_back(std::async(std::launch::async, [job] {
        return job();
      }));
    }

    for (auto f = threads.begin();f!=threads.end();) {
      auto status = f->wait_for(std::chrono::milliseconds(0));
      if (status == std::future_status::ready) {
        data.push_back(f->get());
        f = threads.erase(f);
      }else {
        ++f;
      }
    }

    std::this_thread::sleep_for(std::chrono::milliseconds(10));

  }

  for (auto &f : threads) {
    data.push_back(f.get());
  }

  return data;
}



#endif
